package cn.ibizlab.eam.core.eam_core.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Map;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.math.BigInteger;

import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ObjectUtils;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Lazy;
import cn.ibizlab.eam.core.eam_core.domain.EMProjectTrack;
import cn.ibizlab.eam.core.eam_core.filter.EMProjectTrackSearchContext;
import cn.ibizlab.eam.core.eam_core.service.IEMProjectTrackService;

import cn.ibizlab.eam.util.helper.CachedBeanCopier;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import cn.ibizlab.eam.core.eam_core.mapper.EMProjectTrackMapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.alibaba.fastjson.JSONObject;
import org.springframework.util.StringUtils;

/**
 * 实体[计划修理项目跟踪表] 服务对象接口实现
 */
@Slf4j
@Service("EMProjectTrackServiceImpl")
public class EMProjectTrackServiceImpl extends ServiceImpl<EMProjectTrackMapper, EMProjectTrack> implements IEMProjectTrackService {

    @Autowired
    @Lazy
    protected cn.ibizlab.eam.core.eam_core.service.IEMPurPlanService empurplanService;
    @Autowired
    @Lazy
    protected cn.ibizlab.eam.core.eam_core.service.IEMServiceService emserviceService;

    protected int batchSize = 500;

    @Override
    @Transactional
    public boolean create(EMProjectTrack et) {
        fillParentData(et);
        if(!this.retBool(this.baseMapper.insert(et)))
            return false;
        CachedBeanCopier.copy(get(et.getEmprojecttrackid()),et);
        return true;
    }

    @Override
    public void createBatch(List<EMProjectTrack> list) {
        list.forEach(item->fillParentData(item));
        this.saveBatch(list,batchSize);
    }

    @Override
    @Transactional
    public boolean update(EMProjectTrack et) {
        fillParentData(et);
        if(!update(et,(Wrapper) et.getUpdateWrapper(true).eq("emprojecttrackid",et.getEmprojecttrackid())))
            return false;
        CachedBeanCopier.copy(get(et.getEmprojecttrackid()),et);
        return true;
    }

    @Override
    public void updateBatch(List<EMProjectTrack> list) {
        list.forEach(item->fillParentData(item));
        updateBatchById(list,batchSize);
    }

    @Override
    @Transactional
    public boolean remove(String key) {
        boolean result=removeById(key);
        return result ;
    }

    @Override
    public void removeBatch(Collection<String> idList) {
        removeByIds(idList);
    }

    @Override
    @Transactional
    public EMProjectTrack get(String key) {
        EMProjectTrack et = getById(key);
        if(et==null){
            et=new EMProjectTrack();
            et.setEmprojecttrackid(key);
        }
        else{
        }
        return et;
    }

    @Override
    public EMProjectTrack getDraft(EMProjectTrack et) {
        fillParentData(et);
        return et;
    }

    @Override
    public boolean checkKey(EMProjectTrack et) {
        return (!ObjectUtils.isEmpty(et.getEmprojecttrackid()))&&(!Objects.isNull(this.getById(et.getEmprojecttrackid())));
    }
    @Override
    @Transactional
    public boolean save(EMProjectTrack et) {
        if(!saveOrUpdate(et))
            return false;
        return true;
    }

    @Override
    @Transactional(
            rollbackFor = {Exception.class}
    )
    public boolean saveOrUpdate(EMProjectTrack et) {
        if (null == et) {
            return false;
        } else {
            return checkKey(et) ? this.update(et) : this.create(et);
        }
    }

    @Override
    public boolean saveBatch(Collection<EMProjectTrack> list) {
        list.forEach(item->fillParentData(item));
        saveOrUpdateBatch(list,batchSize);
        return true;
    }

    @Override
    public void saveBatch(List<EMProjectTrack> list) {
        list.forEach(item->fillParentData(item));
        saveOrUpdateBatch(list,batchSize);
    }


	@Override
    public List<EMProjectTrack> selectByEmpurplanid(String empurplanid) {
        return baseMapper.selectByEmpurplanid(empurplanid);
    }

    @Override
    public void removeByEmpurplanid(String empurplanid) {
        this.remove(new QueryWrapper<EMProjectTrack>().eq("empurplanid",empurplanid));
    }

	@Override
    public List<EMProjectTrack> selectByEmserviceid(String emserviceid) {
        return baseMapper.selectByEmserviceid(emserviceid);
    }

    @Override
    public void removeByEmserviceid(String emserviceid) {
        this.remove(new QueryWrapper<EMProjectTrack>().eq("emserviceid",emserviceid));
    }


    /**
     * 查询集合 DEFAULT
     */
    @Override
    public Page<EMProjectTrack> searchDefault(EMProjectTrackSearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<EMProjectTrack> pages=baseMapper.searchDefault(context.getPages(),context,context.getSelectCond());
        return new PageImpl<EMProjectTrack>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }



    /**
     * 为当前实体填充父数据（外键值文本、外键值附加数据）
     * @param et
     */
    private void fillParentData(EMProjectTrack et){
        //实体关系[DER1N_EMPROJECTTRACK_EMPURPLAN_EMPURPLANID]
        if(!ObjectUtils.isEmpty(et.getEmpurplanid())){
            cn.ibizlab.eam.core.eam_core.domain.EMPurPlan empurplan=et.getEmpurplan();
            if(ObjectUtils.isEmpty(empurplan)){
                cn.ibizlab.eam.core.eam_core.domain.EMPurPlan majorEntity=empurplanService.get(et.getEmpurplanid());
                et.setEmpurplan(majorEntity);
                empurplan=majorEntity;
            }
            et.setEmpurplanname(empurplan.getEmpurplanname());
        }
        //实体关系[DER1N_EMPROJECTTRACK_EMSERVICE_EMSERVICEID]
        if(!ObjectUtils.isEmpty(et.getEmserviceid())){
            cn.ibizlab.eam.core.eam_core.domain.EMService emservice=et.getEmservice();
            if(ObjectUtils.isEmpty(emservice)){
                cn.ibizlab.eam.core.eam_core.domain.EMService majorEntity=emserviceService.get(et.getEmserviceid());
                et.setEmservice(majorEntity);
                emservice=majorEntity;
            }
            et.setEmservicename(emservice.getEmservicename());
        }
    }




    @Override
    public List<JSONObject> select(String sql, Map param){
        return this.baseMapper.selectBySQL(sql,param);
    }

    @Override
    @Transactional
    public boolean execute(String sql , Map param){
        if (sql == null || sql.isEmpty()) {
            return false;
        }
        if (sql.toLowerCase().trim().startsWith("insert")) {
            return this.baseMapper.insertBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("update")) {
            return this.baseMapper.updateBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("delete")) {
            return this.baseMapper.deleteBySQL(sql,param);
        }
        log.warn("暂未支持的SQL语法");
        return true;
    }

    @Override
    public List<EMProjectTrack> getEmprojecttrackByIds(List<String> ids) {
         return this.listByIds(ids);
    }

    @Override
    public List<EMProjectTrack> getEmprojecttrackByEntities(List<EMProjectTrack> entities) {
        List ids =new ArrayList();
        for(EMProjectTrack entity : entities){
            Serializable id=entity.getEmprojecttrackid();
            if(!ObjectUtils.isEmpty(id)){
                ids.add(id);
            }
        }
        if(ids.size()>0)
           return this.listByIds(ids);
        else
           return entities;
    }

}


