package cn.ibizlab.eam.core.eam_core.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Map;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.math.BigInteger;

import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ObjectUtils;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Lazy;
import cn.ibizlab.eam.core.eam_core.domain.EMResService;
import cn.ibizlab.eam.core.eam_core.filter.EMResServiceSearchContext;
import cn.ibizlab.eam.core.eam_core.service.IEMResServiceService;

import cn.ibizlab.eam.util.helper.CachedBeanCopier;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import cn.ibizlab.eam.core.eam_core.mapper.EMResServiceMapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.alibaba.fastjson.JSONObject;
import org.springframework.util.StringUtils;

/**
 * 实体[服务资源] 服务对象接口实现
 */
@Slf4j
@Service("EMResServiceServiceImpl")
public class EMResServiceServiceImpl extends ServiceImpl<EMResServiceMapper, EMResService> implements IEMResServiceService {

    @Autowired
    @Lazy
    protected cn.ibizlab.eam.core.eam_core.service.IEMEquipService emequipService;
    @Autowired
    @Lazy
    protected cn.ibizlab.eam.core.eam_core.service.IEMResRefObjService emresrefobjService;
    @Autowired
    @Lazy
    protected cn.ibizlab.eam.core.eam_core.service.IEMServiceService emserviceService;

    protected int batchSize = 500;

    @Override
    @Transactional
    public boolean create(EMResService et) {
        fillParentData(et);
        if(!this.retBool(this.baseMapper.insert(et)))
            return false;
        CachedBeanCopier.copy(get(et.getEmresserviceid()),et);
        return true;
    }

    @Override
    public void createBatch(List<EMResService> list) {
        list.forEach(item->fillParentData(item));
        this.saveBatch(list,batchSize);
    }

    @Override
    @Transactional
    public boolean update(EMResService et) {
        fillParentData(et);
        if(!update(et,(Wrapper) et.getUpdateWrapper(true).eq("emresserviceid",et.getEmresserviceid())))
            return false;
        CachedBeanCopier.copy(get(et.getEmresserviceid()),et);
        return true;
    }

    @Override
    public void updateBatch(List<EMResService> list) {
        list.forEach(item->fillParentData(item));
        updateBatchById(list,batchSize);
    }

    @Override
    @Transactional
    public boolean remove(String key) {
        boolean result=removeById(key);
        return result ;
    }

    @Override
    public void removeBatch(Collection<String> idList) {
        removeByIds(idList);
    }

    @Override
    @Transactional
    public EMResService get(String key) {
        EMResService et = getById(key);
        if(et==null){
            et=new EMResService();
            et.setEmresserviceid(key);
        }
        else{
        }
        return et;
    }

    @Override
    public EMResService getDraft(EMResService et) {
        fillParentData(et);
        return et;
    }

    @Override
    public boolean checkKey(EMResService et) {
        return (!ObjectUtils.isEmpty(et.getEmresserviceid()))&&(!Objects.isNull(this.getById(et.getEmresserviceid())));
    }
    @Override
    @Transactional
    public boolean save(EMResService et) {
        if(!saveOrUpdate(et))
            return false;
        return true;
    }

    @Override
    @Transactional(
            rollbackFor = {Exception.class}
    )
    public boolean saveOrUpdate(EMResService et) {
        if (null == et) {
            return false;
        } else {
            return checkKey(et) ? this.update(et) : this.create(et);
        }
    }

    @Override
    public boolean saveBatch(Collection<EMResService> list) {
        list.forEach(item->fillParentData(item));
        saveOrUpdateBatch(list,batchSize);
        return true;
    }

    @Override
    public void saveBatch(List<EMResService> list) {
        list.forEach(item->fillParentData(item));
        saveOrUpdateBatch(list,batchSize);
    }


	@Override
    public List<EMResService> selectByEquipid(String emequipid) {
        return baseMapper.selectByEquipid(emequipid);
    }

    @Override
    public void removeByEquipid(String emequipid) {
        this.remove(new QueryWrapper<EMResService>().eq("equipid",emequipid));
    }

	@Override
    public List<EMResService> selectByResrefobjid(String emresrefobjid) {
        return baseMapper.selectByResrefobjid(emresrefobjid);
    }

    @Override
    public void removeByResrefobjid(String emresrefobjid) {
        this.remove(new QueryWrapper<EMResService>().eq("resrefobjid",emresrefobjid));
    }

	@Override
    public List<EMResService> selectByResid(String emserviceid) {
        return baseMapper.selectByResid(emserviceid);
    }

    @Override
    public void removeByResid(String emserviceid) {
        this.remove(new QueryWrapper<EMResService>().eq("resid",emserviceid));
    }


    /**
     * 查询集合 DEFAULT
     */
    @Override
    public Page<EMResService> searchDefault(EMResServiceSearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<EMResService> pages=baseMapper.searchDefault(context.getPages(),context,context.getSelectCond());
        return new PageImpl<EMResService>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }



    /**
     * 为当前实体填充父数据（外键值文本、外键值附加数据）
     * @param et
     */
    private void fillParentData(EMResService et){
        //实体关系[DER1N_EMRESSERVICE_EMEQUIP_EQUIPID]
        if(!ObjectUtils.isEmpty(et.getEquipid())){
            cn.ibizlab.eam.core.eam_core.domain.EMEquip equip=et.getEquip();
            if(ObjectUtils.isEmpty(equip)){
                cn.ibizlab.eam.core.eam_core.domain.EMEquip majorEntity=emequipService.get(et.getEquipid());
                et.setEquip(majorEntity);
                equip=majorEntity;
            }
            et.setEquipname(equip.getEquipinfo());
        }
        //实体关系[DER1N_EMRESSERVICE_EMRESREFOBJ_RESREFOBJID]
        if(!ObjectUtils.isEmpty(et.getResrefobjid())){
            cn.ibizlab.eam.core.eam_core.domain.EMResRefObj resrefobj=et.getResrefobj();
            if(ObjectUtils.isEmpty(resrefobj)){
                cn.ibizlab.eam.core.eam_core.domain.EMResRefObj majorEntity=emresrefobjService.get(et.getResrefobjid());
                et.setResrefobj(majorEntity);
                resrefobj=majorEntity;
            }
            et.setResrefobjname(resrefobj.getEmresrefobjname());
        }
        //实体关系[DER1N_EMRESSERVICE_EMSERVICE_RESID]
        if(!ObjectUtils.isEmpty(et.getResid())){
            cn.ibizlab.eam.core.eam_core.domain.EMService res=et.getRes();
            if(ObjectUtils.isEmpty(res)){
                cn.ibizlab.eam.core.eam_core.domain.EMService majorEntity=emserviceService.get(et.getResid());
                et.setRes(majorEntity);
                res=majorEntity;
            }
            et.setResname(res.getEmservicename());
        }
    }




    @Override
    public List<JSONObject> select(String sql, Map param){
        return this.baseMapper.selectBySQL(sql,param);
    }

    @Override
    @Transactional
    public boolean execute(String sql , Map param){
        if (sql == null || sql.isEmpty()) {
            return false;
        }
        if (sql.toLowerCase().trim().startsWith("insert")) {
            return this.baseMapper.insertBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("update")) {
            return this.baseMapper.updateBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("delete")) {
            return this.baseMapper.deleteBySQL(sql,param);
        }
        log.warn("暂未支持的SQL语法");
        return true;
    }

    @Override
    public List<EMResService> getEmresserviceByIds(List<String> ids) {
         return this.listByIds(ids);
    }

    @Override
    public List<EMResService> getEmresserviceByEntities(List<EMResService> entities) {
        List ids =new ArrayList();
        for(EMResService entity : entities){
            Serializable id=entity.getEmresserviceid();
            if(!ObjectUtils.isEmpty(id)){
                ids.add(id);
            }
        }
        if(ids.size()>0)
           return this.listByIds(ids);
        else
           return entities;
    }

}


