package cn.ibizlab.eam.core.eam_pf.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import cn.ibizlab.eam.util.domain.EntityBase;
import cn.ibizlab.eam.util.annotation.DEField;
import cn.ibizlab.eam.util.enums.DEPredefinedFieldType;
import cn.ibizlab.eam.util.enums.DEFieldDefaultValueType;
import java.io.Serializable;
import lombok.*;
import org.springframework.data.annotation.Transient;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import cn.ibizlab.eam.util.domain.EntityMP;

/**
 * 实体[岗位]
 */
@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "SRFT_PFPOST_BASE",resultMap = "PFPostResultMap")
public class PFPost extends EntityMP implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 更新时间
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEDATE)
    @TableField(value = "updatedate")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;
    /**
     * 更新人
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEMAN)
    @TableField(value = "updateman")
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    private String updateman;
    /**
     * 定员
     */
    @TableField(value = "sumempcnt")
    @JSONField(name = "sumempcnt")
    @JsonProperty("sumempcnt")
    private String sumempcnt;
    /**
     * 组织
     */
    @DEField(defaultValue = "TIP" , preType = DEPredefinedFieldType.ORGID)
    @TableField(value = "orgid")
    @JSONField(name = "orgid")
    @JsonProperty("orgid")
    private String orgid;
    /**
     * 描述
     */
    @TableField(value = "description")
    @JSONField(name = "description")
    @JsonProperty("description")
    private String description;
    /**
     * 岗位代码
     */
    @TableField(value = "postcode")
    @JSONField(name = "postcode")
    @JsonProperty("postcode")
    private String postcode;
    /**
     * 建立人
     */
    @DEField(preType = DEPredefinedFieldType.CREATEMAN)
    @TableField(value = "createman" , fill = FieldFill.INSERT)
    @JSONField(name = "createman")
    @JsonProperty("createman")
    private String createman;
    /**
     * 工资级别
     */
    @TableField(value = "wageslevelid")
    @JSONField(name = "wageslevelid")
    @JsonProperty("wageslevelid")
    private String wageslevelid;
    /**
     * 岗位标识
     */
    @DEField(isKeyField=true)
    @TableId(value= "pfpostid",type=IdType.ASSIGN_UUID)
    @JSONField(name = "pfpostid")
    @JsonProperty("pfpostid")
    private String pfpostid;
    /**
     * 建立时间
     */
    @DEField(preType = DEPredefinedFieldType.CREATEDATE)
    @TableField(value = "createdate" , fill = FieldFill.INSERT)
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;
    /**
     * 岗位层次
     */
    @TableField(value = "postlevel")
    @JSONField(name = "postlevel")
    @JsonProperty("postlevel")
    private Integer postlevel;
    /**
     * 岗位名称
     */
    @TableField(value = "pfpostname")
    @JSONField(name = "pfpostname")
    @JsonProperty("pfpostname")
    private String pfpostname;
    /**
     * 岗位类型
     */
    @TableField(value = "posttypeid")
    @JSONField(name = "posttypeid")
    @JsonProperty("posttypeid")
    private String posttypeid;
    /**
     * 逻辑有效标志
     */
    @DEField(defaultValue = "1" , preType = DEPredefinedFieldType.LOGICVALID, logicval = "1" , logicdelval="0")
    @TableLogic(value= "1",delval="0")
    @TableField(value = "enable")
    @JSONField(name = "enable")
    @JsonProperty("enable")
    private Integer enable;
    /**
     * 岗位信息
     */
    @TableField(exist = false)
    @JSONField(name = "postinfo")
    @JsonProperty("postinfo")
    private String postinfo;



    /**
     * 设置 [定员]
     */
    public void setSumempcnt(String sumempcnt){
        this.sumempcnt = sumempcnt ;
        this.modify("sumempcnt",sumempcnt);
    }

    /**
     * 设置 [描述]
     */
    public void setDescription(String description){
        this.description = description ;
        this.modify("description",description);
    }

    /**
     * 设置 [岗位代码]
     */
    public void setPostcode(String postcode){
        this.postcode = postcode ;
        this.modify("postcode",postcode);
    }

    /**
     * 设置 [工资级别]
     */
    public void setWageslevelid(String wageslevelid){
        this.wageslevelid = wageslevelid ;
        this.modify("wageslevelid",wageslevelid);
    }

    /**
     * 设置 [岗位层次]
     */
    public void setPostlevel(Integer postlevel){
        this.postlevel = postlevel ;
        this.modify("postlevel",postlevel);
    }

    /**
     * 设置 [岗位名称]
     */
    public void setPfpostname(String pfpostname){
        this.pfpostname = pfpostname ;
        this.modify("pfpostname",pfpostname);
    }

    /**
     * 设置 [岗位类型]
     */
    public void setPosttypeid(String posttypeid){
        this.posttypeid = posttypeid ;
        this.modify("posttypeid",posttypeid);
    }


}


