package cn.ibizlab.eam.core.eam_pf.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import cn.ibizlab.eam.util.domain.EntityBase;
import cn.ibizlab.eam.util.annotation.DEField;
import cn.ibizlab.eam.util.enums.DEPredefinedFieldType;
import cn.ibizlab.eam.util.enums.DEFieldDefaultValueType;
import java.io.Serializable;
import lombok.*;
import org.springframework.data.annotation.Transient;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import cn.ibizlab.eam.util.domain.EntityMP;

/**
 * 实体[班组]
 */
@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "SRFT_PFTEAM_BASE",resultMap = "PFTeamResultMap")
public class PFTeam extends EntityMP implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 班组代码
     */
    @TableField(value = "teamcode")
    @JSONField(name = "teamcode")
    @JsonProperty("teamcode")
    private String teamcode;
    /**
     * 逻辑有效标志
     */
    @DEField(defaultValue = "1" , preType = DEPredefinedFieldType.LOGICVALID, logicval = "1" , logicdelval="0")
    @TableLogic(value= "1",delval="0")
    @TableField(value = "enable")
    @JSONField(name = "enable")
    @JsonProperty("enable")
    private Integer enable;
    /**
     * 组织
     */
    @DEField(defaultValue = "TIP" , preType = DEPredefinedFieldType.ORGID)
    @TableField(value = "orgid")
    @JSONField(name = "orgid")
    @JsonProperty("orgid")
    private String orgid;
    /**
     * 班组标识
     */
    @DEField(isKeyField=true)
    @TableId(value= "pfteamid",type=IdType.ASSIGN_UUID)
    @JSONField(name = "pfteamid")
    @JsonProperty("pfteamid")
    private String pfteamid;
    /**
     * 建立人
     */
    @DEField(preType = DEPredefinedFieldType.CREATEMAN)
    @TableField(value = "createman" , fill = FieldFill.INSERT)
    @JSONField(name = "createman")
    @JsonProperty("createman")
    private String createman;
    /**
     * 班组类型
     */
    @TableField(value = "teamtypeid")
    @JSONField(name = "teamtypeid")
    @JsonProperty("teamtypeid")
    private String teamtypeid;
    /**
     * 更新时间
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEDATE)
    @TableField(value = "updatedate")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;
    /**
     * 更新人
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEMAN)
    @TableField(value = "updateman")
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    private String updateman;
    /**
     * 建立时间
     */
    @DEField(preType = DEPredefinedFieldType.CREATEDATE)
    @TableField(value = "createdate" , fill = FieldFill.INSERT)
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;
    /**
     * 描述
     */
    @TableField(value = "description")
    @JSONField(name = "description")
    @JsonProperty("description")
    private String description;
    /**
     * 职能
     */
    @TableField(value = "teamfn")
    @JSONField(name = "teamfn")
    @JsonProperty("teamfn")
    private String teamfn;
    /**
     * 班组名称
     */
    @TableField(value = "pfteamname")
    @JSONField(name = "pfteamname")
    @JsonProperty("pfteamname")
    private String pfteamname;
    /**
     * 班组信息
     */
    @TableField(exist = false)
    @JSONField(name = "teaminfo")
    @JsonProperty("teaminfo")
    private String teaminfo;
    /**
     * 能力
     */
    @TableField(value = "teamcapacity")
    @JSONField(name = "teamcapacity")
    @JsonProperty("teamcapacity")
    private Integer teamcapacity;



    /**
     * 设置 [班组代码]
     */
    public void setTeamcode(String teamcode){
        this.teamcode = teamcode ;
        this.modify("teamcode",teamcode);
    }

    /**
     * 设置 [班组类型]
     */
    public void setTeamtypeid(String teamtypeid){
        this.teamtypeid = teamtypeid ;
        this.modify("teamtypeid",teamtypeid);
    }

    /**
     * 设置 [描述]
     */
    public void setDescription(String description){
        this.description = description ;
        this.modify("description",description);
    }

    /**
     * 设置 [职能]
     */
    public void setTeamfn(String teamfn){
        this.teamfn = teamfn ;
        this.modify("teamfn",teamfn);
    }

    /**
     * 设置 [班组名称]
     */
    public void setPfteamname(String pfteamname){
        this.pfteamname = pfteamname ;
        this.modify("pfteamname",pfteamname);
    }

    /**
     * 设置 [能力]
     */
    public void setTeamcapacity(Integer teamcapacity){
        this.teamcapacity = teamcapacity ;
        this.modify("teamcapacity",teamcapacity);
    }


}


