package cn.ibizlab.eam.webapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;
import cn.ibizlab.eam.util.domain.DTOBase;
import lombok.Data;

/**
 * 服务DTO对象[EMDRWGMapDTO]
 */
@Data
public class EMDRWGMapDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    private String updateman;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;

    /**
     * 属性 [EMDRWGMAPNAME]
     *
     */
    @JSONField(name = "emdrwgmapname")
    @JsonProperty("emdrwgmapname")
    private String emdrwgmapname;

    /**
     * 属性 [DESCRIPTION]
     *
     */
    @JSONField(name = "description")
    @JsonProperty("description")
    private String description;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;

    /**
     * 属性 [EMDRWGMAPID]
     *
     */
    @JSONField(name = "emdrwgmapid")
    @JsonProperty("emdrwgmapid")
    private String emdrwgmapid;

    /**
     * 属性 [ENABLE]
     *
     */
    @JSONField(name = "enable")
    @JsonProperty("enable")
    private Integer enable;

    /**
     * 属性 [ORGID]
     *
     */
    @JSONField(name = "orgid")
    @JsonProperty("orgid")
    private String orgid;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @JSONField(name = "createman")
    @JsonProperty("createman")
    private String createman;

    /**
     * 属性 [REFOBJNAME]
     *
     */
    @JSONField(name = "refobjname")
    @JsonProperty("refobjname")
    private String refobjname;

    /**
     * 属性 [DRWGNAME]
     *
     */
    @JSONField(name = "drwgname")
    @JsonProperty("drwgname")
    private String drwgname;

    /**
     * 属性 [REFOBJID]
     *
     */
    @JSONField(name = "refobjid")
    @JsonProperty("refobjid")
    private String refobjid;

    /**
     * 属性 [DRWGID]
     *
     */
    @JSONField(name = "drwgid")
    @JsonProperty("drwgid")
    private String drwgid;


    /**
     * 设置 [EMDRWGMAPNAME]
     */
    public void setEmdrwgmapname(String  emdrwgmapname){
        this.emdrwgmapname = emdrwgmapname ;
        this.modify("emdrwgmapname",emdrwgmapname);
    }

    /**
     * 设置 [DESCRIPTION]
     */
    public void setDescription(String  description){
        this.description = description ;
        this.modify("description",description);
    }

    /**
     * 设置 [REFOBJID]
     */
    public void setRefobjid(String  refobjid){
        this.refobjid = refobjid ;
        this.modify("refobjid",refobjid);
    }

    /**
     * 设置 [DRWGID]
     */
    public void setDrwgid(String  drwgid){
        this.drwgid = drwgid ;
        this.modify("drwgid",drwgid);
    }


}

