package cn.ibizlab.eam.webapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;
import cn.ibizlab.eam.util.domain.DTOBase;
import lombok.Data;

/**
 * 服务DTO对象[EMEICellDTO]
 */
@Data
public class EMEICellDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [EQMODELCODE]
     *
     */
    @JSONField(name = "eqmodelcode")
    @JsonProperty("eqmodelcode")
    private String eqmodelcode;

    /**
     * 属性 [EISTATE]
     *
     */
    @JSONField(name = "eistate")
    @JsonProperty("eistate")
    private String eistate;

    /**
     * 属性 [EMEICELLNAME]
     *
     */
    @JSONField(name = "emeicellname")
    @JsonProperty("emeicellname")
    private String emeicellname;

    /**
     * 属性 [LYRID]
     *
     */
    @JSONField(name = "lyrid")
    @JsonProperty("lyrid")
    private String lyrid;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    private String updateman;

    /**
     * 属性 [ENABLE]
     *
     */
    @JSONField(name = "enable")
    @JsonProperty("enable")
    private Integer enable;

    /**
     * 属性 [EICAMINFO]
     *
     */
    @JSONField(name = "eicaminfo")
    @JsonProperty("eicaminfo")
    private String eicaminfo;

    /**
     * 属性 [EMPID]
     *
     */
    @JSONField(name = "empid")
    @JsonProperty("empid")
    private String empid;

    /**
     * 属性 [ORGID]
     *
     */
    @JSONField(name = "orgid")
    @JsonProperty("orgid")
    private String orgid;

    /**
     * 属性 [DESCRIPTION]
     *
     */
    @JSONField(name = "description")
    @JsonProperty("description")
    private String description;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @JSONField(name = "createman")
    @JsonProperty("createman")
    private String createman;

    /**
     * 属性 [LYRNAME]
     *
     */
    @JSONField(name = "lyrname")
    @JsonProperty("lyrname")
    private String lyrname;

    /**
     * 属性 [EMEICELLID]
     *
     */
    @JSONField(name = "emeicellid")
    @JsonProperty("emeicellid")
    private String emeicellid;

    /**
     * 属性 [MACADDR]
     *
     */
    @JSONField(name = "macaddr")
    @JsonProperty("macaddr")
    private String macaddr;

    /**
     * 属性 [EMPNAME]
     *
     */
    @JSONField(name = "empname")
    @JsonProperty("empname")
    private String empname;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;

    /**
     * 属性 [DISDESC]
     *
     */
    @JSONField(name = "disdesc")
    @JsonProperty("disdesc")
    private String disdesc;

    /**
     * 属性 [DISDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "disdate" , format="yyyy-MM-dd")
    @JsonProperty("disdate")
    private Timestamp disdate;

    /**
     * 属性 [DEPTID]
     *
     */
    @JSONField(name = "deptid")
    @JsonProperty("deptid")
    private String deptid;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;

    /**
     * 属性 [ITEMPUSENAME]
     *
     */
    @JSONField(name = "itempusename")
    @JsonProperty("itempusename")
    private String itempusename;

    /**
     * 属性 [EQLOCATIONNAME]
     *
     */
    @JSONField(name = "eqlocationname")
    @JsonProperty("eqlocationname")
    private String eqlocationname;

    /**
     * 属性 [EQUIPNAME]
     *
     */
    @JSONField(name = "equipname")
    @JsonProperty("equipname")
    private String equipname;

    /**
     * 属性 [EQUIPID]
     *
     */
    @JSONField(name = "equipid")
    @JsonProperty("equipid")
    private String equipid;

    /**
     * 属性 [ITEMPUSEID]
     *
     */
    @JSONField(name = "itempuseid")
    @JsonProperty("itempuseid")
    private String itempuseid;

    /**
     * 属性 [EQLOCATIONID]
     *
     */
    @JSONField(name = "eqlocationid")
    @JsonProperty("eqlocationid")
    private String eqlocationid;


    /**
     * 设置 [EQMODELCODE]
     */
    public void setEqmodelcode(String  eqmodelcode){
        this.eqmodelcode = eqmodelcode ;
        this.modify("eqmodelcode",eqmodelcode);
    }

    /**
     * 设置 [EISTATE]
     */
    public void setEistate(String  eistate){
        this.eistate = eistate ;
        this.modify("eistate",eistate);
    }

    /**
     * 设置 [EMEICELLNAME]
     */
    public void setEmeicellname(String  emeicellname){
        this.emeicellname = emeicellname ;
        this.modify("emeicellname",emeicellname);
    }

    /**
     * 设置 [LYRID]
     */
    public void setLyrid(String  lyrid){
        this.lyrid = lyrid ;
        this.modify("lyrid",lyrid);
    }

    /**
     * 设置 [EMPID]
     */
    public void setEmpid(String  empid){
        this.empid = empid ;
        this.modify("empid",empid);
    }

    /**
     * 设置 [DESCRIPTION]
     */
    public void setDescription(String  description){
        this.description = description ;
        this.modify("description",description);
    }

    /**
     * 设置 [LYRNAME]
     */
    public void setLyrname(String  lyrname){
        this.lyrname = lyrname ;
        this.modify("lyrname",lyrname);
    }

    /**
     * 设置 [MACADDR]
     */
    public void setMacaddr(String  macaddr){
        this.macaddr = macaddr ;
        this.modify("macaddr",macaddr);
    }

    /**
     * 设置 [EMPNAME]
     */
    public void setEmpname(String  empname){
        this.empname = empname ;
        this.modify("empname",empname);
    }

    /**
     * 设置 [DISDESC]
     */
    public void setDisdesc(String  disdesc){
        this.disdesc = disdesc ;
        this.modify("disdesc",disdesc);
    }

    /**
     * 设置 [DISDATE]
     */
    public void setDisdate(Timestamp  disdate){
        this.disdate = disdate ;
        this.modify("disdate",disdate);
    }

    /**
     * 设置 [EQUIPID]
     */
    public void setEquipid(String  equipid){
        this.equipid = equipid ;
        this.modify("equipid",equipid);
    }

    /**
     * 设置 [ITEMPUSEID]
     */
    public void setItempuseid(String  itempuseid){
        this.itempuseid = itempuseid ;
        this.modify("itempuseid",itempuseid);
    }

    /**
     * 设置 [EQLOCATIONID]
     */
    public void setEqlocationid(String  eqlocationid){
        this.eqlocationid = eqlocationid ;
        this.modify("eqlocationid",eqlocationid);
    }


}

