package cn.ibizlab.eam.webapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;
import cn.ibizlab.eam.util.domain.DTOBase;
import lombok.Data;

/**
 * 服务DTO对象[PFEmpDTO]
 */
@Data
public class PFEmpDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    private String updateman;

    /**
     * 属性 [DESCRIPTION]
     *
     */
    @JSONField(name = "description")
    @JsonProperty("description")
    private String description;

    /**
     * 属性 [TEL]
     *
     */
    @JSONField(name = "tel")
    @JsonProperty("tel")
    private String tel;

    /**
     * 属性 [MAJORDEPTID]
     *
     */
    @JSONField(name = "majordeptid")
    @JsonProperty("majordeptid")
    private String majordeptid;

    /**
     * 属性 [WORKDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "workdate" , format="yyyy-MM-dd")
    @JsonProperty("workdate")
    private Timestamp workdate;

    /**
     * 属性 [PFEMPNAME]
     *
     */
    @JSONField(name = "pfempname")
    @JsonProperty("pfempname")
    private String pfempname;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;

    /**
     * 属性 [RAISEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "raisedate" , format="yyyy-MM-dd")
    @JsonProperty("raisedate")
    private Timestamp raisedate;

    /**
     * 属性 [HOMETEL]
     *
     */
    @JSONField(name = "hometel")
    @JsonProperty("hometel")
    private String hometel;

    /**
     * 属性 [BIRTHDAY]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "birthday" , format="yyyy-MM-dd")
    @JsonProperty("birthday")
    private Timestamp birthday;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;

    /**
     * 属性 [PFEMPID]
     *
     */
    @JSONField(name = "pfempid")
    @JsonProperty("pfempid")
    private String pfempid;

    /**
     * 属性 [HOMEADDR]
     *
     */
    @JSONField(name = "homeaddr")
    @JsonProperty("homeaddr")
    private String homeaddr;

    /**
     * 属性 [EMPINFO]
     *
     */
    @JSONField(name = "empinfo")
    @JsonProperty("empinfo")
    private String empinfo;

    /**
     * 属性 [MAJORDEPTNAME]
     *
     */
    @JSONField(name = "majordeptname")
    @JsonProperty("majordeptname")
    private String majordeptname;

    /**
     * 属性 [DEPTID]
     *
     */
    @JSONField(name = "deptid")
    @JsonProperty("deptid")
    private String deptid;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @JSONField(name = "createman")
    @JsonProperty("createman")
    private String createman;

    /**
     * 属性 [EMPSEX]
     *
     */
    @JSONField(name = "empsex")
    @JsonProperty("empsex")
    private String empsex;

    /**
     * 属性 [CERTCODE]
     *
     */
    @JSONField(name = "certcode")
    @JsonProperty("certcode")
    private String certcode;

    /**
     * 属性 [ORGID]
     *
     */
    @JSONField(name = "orgid")
    @JsonProperty("orgid")
    private String orgid;

    /**
     * 属性 [EMPCODE]
     *
     */
    @JSONField(name = "empcode")
    @JsonProperty("empcode")
    private String empcode;

    /**
     * 属性 [PSW]
     *
     */
    @JSONField(name = "psw")
    @JsonProperty("psw")
    private String psw;

    /**
     * 属性 [TEAMID]
     *
     */
    @JSONField(name = "teamid")
    @JsonProperty("teamid")
    private String teamid;

    /**
     * 属性 [MAINDEPTCODE]
     *
     */
    @JSONField(name = "maindeptcode")
    @JsonProperty("maindeptcode")
    private String maindeptcode;

    /**
     * 属性 [E_MAIL]
     *
     */
    @JSONField(name = "e_mail")
    @JsonProperty("e_mail")
    private String eMail;

    /**
     * 属性 [ENABLE]
     *
     */
    @JSONField(name = "enable")
    @JsonProperty("enable")
    private Integer enable;

    /**
     * 属性 [CELL]
     *
     */
    @JSONField(name = "cell")
    @JsonProperty("cell")
    private String cell;

    /**
     * 属性 [ADDR]
     *
     */
    @JSONField(name = "addr")
    @JsonProperty("addr")
    private String addr;

    /**
     * 属性 [MAJORTEAMNAME]
     *
     */
    @JSONField(name = "majorteamname")
    @JsonProperty("majorteamname")
    private String majorteamname;

    /**
     * 属性 [MAJORTEAMID]
     *
     */
    @JSONField(name = "majorteamid")
    @JsonProperty("majorteamid")
    private String majorteamid;


    /**
     * 设置 [DESCRIPTION]
     */
    public void setDescription(String  description){
        this.description = description ;
        this.modify("description",description);
    }

    /**
     * 设置 [TEL]
     */
    public void setTel(String  tel){
        this.tel = tel ;
        this.modify("tel",tel);
    }

    /**
     * 设置 [MAJORDEPTID]
     */
    public void setMajordeptid(String  majordeptid){
        this.majordeptid = majordeptid ;
        this.modify("majordeptid",majordeptid);
    }

    /**
     * 设置 [WORKDATE]
     */
    public void setWorkdate(Timestamp  workdate){
        this.workdate = workdate ;
        this.modify("workdate",workdate);
    }

    /**
     * 设置 [PFEMPNAME]
     */
    public void setPfempname(String  pfempname){
        this.pfempname = pfempname ;
        this.modify("pfempname",pfempname);
    }

    /**
     * 设置 [RAISEDATE]
     */
    public void setRaisedate(Timestamp  raisedate){
        this.raisedate = raisedate ;
        this.modify("raisedate",raisedate);
    }

    /**
     * 设置 [HOMETEL]
     */
    public void setHometel(String  hometel){
        this.hometel = hometel ;
        this.modify("hometel",hometel);
    }

    /**
     * 设置 [BIRTHDAY]
     */
    public void setBirthday(Timestamp  birthday){
        this.birthday = birthday ;
        this.modify("birthday",birthday);
    }

    /**
     * 设置 [HOMEADDR]
     */
    public void setHomeaddr(String  homeaddr){
        this.homeaddr = homeaddr ;
        this.modify("homeaddr",homeaddr);
    }

    /**
     * 设置 [MAJORDEPTNAME]
     */
    public void setMajordeptname(String  majordeptname){
        this.majordeptname = majordeptname ;
        this.modify("majordeptname",majordeptname);
    }

    /**
     * 设置 [EMPSEX]
     */
    public void setEmpsex(String  empsex){
        this.empsex = empsex ;
        this.modify("empsex",empsex);
    }

    /**
     * 设置 [CERTCODE]
     */
    public void setCertcode(String  certcode){
        this.certcode = certcode ;
        this.modify("certcode",certcode);
    }

    /**
     * 设置 [EMPCODE]
     */
    public void setEmpcode(String  empcode){
        this.empcode = empcode ;
        this.modify("empcode",empcode);
    }

    /**
     * 设置 [PSW]
     */
    public void setPsw(String  psw){
        this.psw = psw ;
        this.modify("psw",psw);
    }

    /**
     * 设置 [MAINDEPTCODE]
     */
    public void setMaindeptcode(String  maindeptcode){
        this.maindeptcode = maindeptcode ;
        this.modify("maindeptcode",maindeptcode);
    }

    /**
     * 设置 [E_MAIL]
     */
    public void setEMail(String  eMail){
        this.eMail = eMail ;
        this.modify("e_mail",eMail);
    }

    /**
     * 设置 [CELL]
     */
    public void setCell(String  cell){
        this.cell = cell ;
        this.modify("cell",cell);
    }

    /**
     * 设置 [ADDR]
     */
    public void setAddr(String  addr){
        this.addr = addr ;
        this.modify("addr",addr);
    }

    /**
     * 设置 [MAJORTEAMID]
     */
    public void setMajorteamid(String  majorteamid){
        this.majorteamid = majorteamid ;
        this.modify("majorteamid",majorteamid);
    }


}

