/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.structs;

import com.anotherbigidea.flash.structs.Color;
import com.anotherbigidea.flash.structs.Matrix;
import com.anotherbigidea.flash.structs.Style;
import com.anotherbigidea.io.OutStream;
import java.io.IOException;

public class FillStyle
implements Style {
    protected int fillType;
    protected Color color;
    protected Matrix matrix;
    protected int[] ratios;
    protected Color[] colors;
    protected int bitmapId;

    public int getType() {
        return this.fillType;
    }

    public Color getSolidColor() {
        return this.color;
    }

    public Matrix getMatrix() {
        return this.matrix;
    }

    public int getImageId() {
        return this.bitmapId;
    }

    public int[] getGradientRatios() {
        return this.ratios;
    }

    public Color[] getGradientColors() {
        return this.colors;
    }

    public FillStyle(Color color) {
        this.fillType = 0;
        this.color = color;
    }

    public FillStyle(Matrix matrix, int[] nArray, Color[] colorArray, boolean bl) {
        this.matrix = matrix;
        this.ratios = nArray;
        this.colors = colorArray;
        this.fillType = bl ? 18 : 16;
    }

    public FillStyle(int n, Matrix matrix, boolean bl) {
        this.matrix = matrix;
        this.bitmapId = n;
        this.fillType = bl ? 65 : 64;
    }

    public void write(OutStream outStream, boolean bl) throws IOException {
        outStream.writeUI8(this.fillType);
        if (this.fillType == 0) {
            if (bl) {
                this.color.writeWithAlpha(outStream);
            } else {
                this.color.writeRGB(outStream);
            }
        } else if (this.fillType == 16 || this.fillType == 18) {
            this.matrix.write(outStream);
            int n = this.ratios.length;
            outStream.writeUI8(n);
            for (int i = 0; i < n; ++i) {
                if (this.colors[i] == null) continue;
                outStream.writeUI8(this.ratios[i]);
                if (bl) {
                    this.colors[i].writeWithAlpha(outStream);
                    continue;
                }
                this.colors[i].writeRGB(outStream);
            }
        } else if (this.fillType == 64 || this.fillType == 65) {
            outStream.writeUI16(this.bitmapId);
            this.matrix.write(outStream);
        }
    }

    public static void writeMorphFillStyle(OutStream outStream, FillStyle fillStyle, FillStyle fillStyle2) throws IOException {
        int n = fillStyle.fillType;
        outStream.writeUI8(n);
        if (n == 0) {
            fillStyle.color.writeWithAlpha(outStream);
            fillStyle2.color.writeWithAlpha(outStream);
        } else if (n == 16 || n == 18) {
            fillStyle.matrix.write(outStream);
            fillStyle2.matrix.write(outStream);
            int n2 = fillStyle.ratios.length;
            outStream.writeUI8(fillStyle.ratios.length);
            for (int i = 0; i < n2; ++i) {
                if (fillStyle.colors[i] == null || fillStyle2.colors[i] == null) continue;
                outStream.writeUI8(fillStyle.ratios[i]);
                fillStyle.colors[i].writeWithAlpha(outStream);
                outStream.writeUI8(fillStyle2.ratios[i]);
                fillStyle2.colors[i].writeWithAlpha(outStream);
            }
        } else if (n == 64 || n == 65) {
            int n3 = fillStyle.bitmapId;
            outStream.writeUI16(n3);
            fillStyle.matrix.write(outStream);
            fillStyle2.matrix.write(outStream);
        }
    }
}

