/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.writers;

import com.anotherbigidea.flash.SWFConstants;
import com.anotherbigidea.flash.interfaces.SWFActionBlock;
import com.anotherbigidea.flash.interfaces.SWFActions;
import com.anotherbigidea.flash.interfaces.SWFFileSignature;
import com.anotherbigidea.flash.interfaces.SWFShape;
import com.anotherbigidea.flash.interfaces.SWFTagTypes;
import com.anotherbigidea.flash.interfaces.SWFTags;
import com.anotherbigidea.flash.interfaces.SWFText;
import com.anotherbigidea.flash.interfaces.SWFVectors;
import com.anotherbigidea.flash.structs.AlphaColor;
import com.anotherbigidea.flash.structs.AlphaTransform;
import com.anotherbigidea.flash.structs.ButtonRecord;
import com.anotherbigidea.flash.structs.ButtonRecord2;
import com.anotherbigidea.flash.structs.Color;
import com.anotherbigidea.flash.structs.ColorTransform;
import com.anotherbigidea.flash.structs.FillStyle;
import com.anotherbigidea.flash.structs.LineStyle;
import com.anotherbigidea.flash.structs.Matrix;
import com.anotherbigidea.flash.structs.Rect;
import com.anotherbigidea.flash.structs.SoundInfo;
import com.anotherbigidea.flash.structs.Style;
import com.anotherbigidea.flash.writers.ActionWriter;
import com.anotherbigidea.io.OutStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.DeflaterOutputStream;

public class TagWriter
implements SWFTagTypes,
SWFConstants,
SWFFileSignature {
    protected SWFTags mTags;
    protected OutStream out;
    protected ByteArrayOutputStream bytes;
    protected int tagType;
    protected boolean longTag;
    protected int version;
    protected String mStringEncoding = "UTF-8";

    public TagWriter(SWFTags sWFTags) {
        this.mTags = sWFTags;
    }

    protected OutStream getOutStream() {
        return this.out;
    }

    protected SWFActions factorySWFActions() {
        return new ActionWriter(this, this.version);
    }

    protected SWFShape factorySWFShape(boolean bl, boolean bl2) {
        return new SWFShapeImpl(this, bl, bl2);
    }

    public void signature(String string) {
        if (this.mTags instanceof SWFFileSignature) {
            ((SWFFileSignature)((Object)this.mTags)).signature(string);
        }
    }

    protected void startTag(int n, boolean bl) {
        this.tagType = n;
        this.longTag = bl;
        this.bytes = new ByteArrayOutputStream(10000);
        this.out = new OutStream(this.bytes);
    }

    protected void startTag(int n, int n2, boolean bl) throws IOException {
        this.startTag(n, bl);
        this.out.writeUI16(n2);
    }

    protected void completeTag() throws IOException {
        this.out.flush();
        byte[] byArray = this.bytes.toByteArray();
        this.out = null;
        this.bytes = null;
        this.mTags.tag(this.tagType, this.longTag, byArray);
    }

    public void tag(int n, boolean bl, byte[] byArray) throws IOException {
        this.mTags.tag(n, bl, byArray);
    }

    public void header(int n, long l, int n2, int n3, int n4, int n5) throws IOException {
        this.version = n;
        this.mTags.header(n, -1L, n2, n3, n4, n5);
        if (n < 6) {
            this.mStringEncoding = "US-ASCII";
        }
    }

    public void tagEnd() throws IOException {
        this.mTags.tag(0, false, null);
    }

    public void tagShowFrame() throws IOException {
        this.mTags.tag(1, false, null);
    }

    public void tagDefineSound(int n, int n2, int n3, boolean bl, boolean bl2, int n4, byte[] byArray) throws IOException {
        this.startTag(14, n, true);
        this.out.writeUBits(4, n2);
        this.out.writeUBits(2, n3);
        this.out.writeUBits(1, bl ? 1L : 0L);
        this.out.writeUBits(1, bl2 ? 1L : 0L);
        this.out.writeUI32(n4);
        this.out.write(byArray);
        this.completeTag();
    }

    public void tagDefineButtonSound(int n, int n2, SoundInfo soundInfo, int n3, SoundInfo soundInfo2, int n4, SoundInfo soundInfo3, int n5, SoundInfo soundInfo4) throws IOException {
        this.startTag(17, n, true);
        this.out.writeUI16(n2);
        if (n2 != 0) {
            soundInfo.write(this.out);
        }
        this.out.writeUI16(n3);
        if (n3 != 0) {
            soundInfo2.write(this.out);
        }
        this.out.writeUI16(n4);
        if (n4 != 0) {
            soundInfo3.write(this.out);
        }
        this.out.writeUI16(n5);
        if (n5 != 0) {
            soundInfo4.write(this.out);
        }
        this.completeTag();
    }

    public void tagStartSound(int n, SoundInfo soundInfo) throws IOException {
        this.startTag(15, n, false);
        soundInfo.write(this.out);
        this.completeTag();
    }

    public void tagSoundStreamHead(int n, boolean bl, boolean bl2, int n2, int n3, boolean bl3, boolean bl4, int n4) throws IOException {
        this.writeSoundStreamHead(18, n, bl, bl2, n2, n3, bl3, bl4, n4);
    }

    public void tagSoundStreamHead2(int n, boolean bl, boolean bl2, int n2, int n3, boolean bl3, boolean bl4, int n4) throws IOException {
        this.writeSoundStreamHead(45, n, bl, bl2, n2, n3, bl3, bl4, n4);
    }

    public void writeSoundStreamHead(int n, int n2, boolean bl, boolean bl2, int n3, int n4, boolean bl3, boolean bl4, int n5) throws IOException {
        this.startTag(n, false);
        this.out.writeUBits(4, 0L);
        this.out.writeUBits(2, n2);
        this.out.writeUBits(1, bl ? 1L : 0L);
        this.out.writeUBits(1, bl2 ? 1L : 0L);
        this.out.writeUBits(4, n3);
        this.out.writeUBits(2, n4);
        this.out.writeUBits(1, bl3 ? 1L : 0L);
        this.out.writeUBits(1, bl4 ? 1L : 0L);
        this.out.writeUI16(n5);
        if (n3 == 2) {
            this.out.writeUI16(0);
        }
        this.completeTag();
    }

    public void tagSoundStreamBlock(byte[] byArray) throws IOException {
        this.startTag(19, true);
        this.out.write(byArray);
        this.completeTag();
    }

    public void tagSerialNumber(String string) throws IOException {
        this.startTag(41, false);
        this.out.writeString(string, this.mStringEncoding);
        this.completeTag();
    }

    public void tagGenerator(byte[] byArray) throws IOException {
        this.startTag(51, false);
        this.out.write(byArray);
        this.completeTag();
    }

    public void tagGeneratorText(byte[] byArray) throws IOException {
        this.startTag(42, false);
        this.out.write(byArray);
        this.completeTag();
    }

    public void tagGeneratorCommand(byte[] byArray) throws IOException {
        this.startTag(49, false);
        this.out.write(byArray);
        this.completeTag();
    }

    public void tagGeneratorFont(byte[] byArray) throws IOException {
        this.startTag(52, false);
        this.out.write(byArray);
        this.completeTag();
    }

    public void tagNameCharacter(byte[] byArray) throws IOException {
        this.startTag(40, false);
        this.out.write(byArray);
        this.completeTag();
    }

    public void tagDefineBits(int n, byte[] byArray) throws IOException {
        this.startTag(6, n, true);
        this.out.write(byArray);
        this.completeTag();
    }

    public void tagJPEGTables(byte[] byArray) throws IOException {
        this.startTag(8, true);
        this.out.write(byArray);
        this.completeTag();
    }

    public void tagDefineBitsJPEG3(int n, byte[] byArray, byte[] byArray2) throws IOException {
        this.startTag(35, n, true);
        this.out.writeUI32(byArray.length);
        this.out.write(byArray);
        this.out.write(byArray2);
        this.completeTag();
    }

    public SWFActions tagDoAction() throws IOException {
        this.startTag(12, true);
        return this.factorySWFActions();
    }

    public SWFActions tagDoInitAction(int n) throws IOException {
        this.startTag(59, n, true);
        return this.factorySWFActions();
    }

    public SWFShape tagDefineShape(int n, Rect rect) throws IOException {
        this.startShape(2, n, rect);
        return this.factorySWFShape(false, true);
    }

    public SWFShape tagDefineShape2(int n, Rect rect) throws IOException {
        this.startShape(22, n, rect);
        return this.factorySWFShape(false, true);
    }

    public SWFShape tagDefineShape3(int n, Rect rect) throws IOException {
        this.startShape(32, n, rect);
        return this.factorySWFShape(true, true);
    }

    public void tagFreeCharacter(int n) throws IOException {
        this.startTag(3, false);
        this.out.writeUI16(n);
        this.completeTag();
    }

    public void tagPlaceObject(int n, int n2, Matrix matrix, AlphaTransform alphaTransform) throws IOException {
        this.startTag(4, false);
        this.out.writeUI16(n);
        this.out.writeUI16(n2);
        matrix.write(this.out);
        if (alphaTransform != null) {
            alphaTransform.write(this.out);
        }
        this.completeTag();
    }

    public SWFActions tagPlaceObject2(boolean bl, int n, int n2, int n3, Matrix matrix, AlphaTransform alphaTransform, int n4, String string, int n5) throws IOException {
        boolean bl2 = n5 != 0;
        this.startTag(26, false);
        this.out.writeUBits(1, bl2 ? 1L : 0L);
        this.out.writeUBits(1, n > 0 ? 1L : 0L);
        this.out.writeUBits(1, string != null ? 1L : 0L);
        this.out.writeUBits(1, n4 >= 0 ? 1L : 0L);
        this.out.writeUBits(1, alphaTransform != null ? 1L : 0L);
        this.out.writeUBits(1, matrix != null ? 1L : 0L);
        this.out.writeUBits(1, n3 > 0 ? 1L : 0L);
        this.out.writeUBits(1, bl ? 1L : 0L);
        this.out.writeUI16(n2);
        if (n3 > 0) {
            this.out.writeUI16(n3);
        }
        if (matrix != null) {
            matrix.write(this.out);
        }
        if (alphaTransform != null) {
            alphaTransform.write(this.out);
        }
        if (n4 >= 0) {
            this.out.writeUI16(n4);
        }
        if (string != null) {
            this.out.writeString(string, this.mStringEncoding);
            this.longTag = true;
        }
        if (n > 0) {
            this.out.writeUI16(n);
        }
        if (bl2) {
            final boolean bl3 = this.version >= 6;
            this.out.writeUI16(0);
            if (bl3) {
                this.out.writeUI32(n5);
            } else {
                this.out.writeUI16(n5);
            }
            return new ActionWriter(this, this.version){
                private int mKeycode = -1;

                public SWFActionBlock start(int n) throws IOException {
                    if (bl3) {
                        this.mTagWriter.out.writeUI32(n);
                    } else {
                        this.mTagWriter.out.writeUI16(n);
                    }
                    return super.start(n);
                }

                public SWFActionBlock start(int n, int n2) throws IOException {
                    this.mKeycode = n2;
                    return this.start(n);
                }

                protected void writeBytes(byte[] byArray) throws IOException {
                    if (this.mKeycode >= 0) {
                        this.mTagWriter.out.writeUI32(byArray.length + 1);
                        this.mTagWriter.out.writeUI8(this.mKeycode);
                    } else {
                        this.mTagWriter.out.writeUI32(byArray.length);
                    }
                    super.writeBytes(byArray);
                }

                public void done() throws IOException {
                    if (bl3) {
                        this.mTagWriter.out.writeUI32(0L);
                    } else {
                        this.mTagWriter.out.writeUI16(0);
                    }
                    super.done();
                }
            };
        }
        this.completeTag();
        return null;
    }

    public void tagRemoveObject(int n, int n2) throws IOException {
        this.startTag(5, false);
        this.out.writeUI16(n);
        this.out.writeUI16(n2);
        this.completeTag();
    }

    public void tagRemoveObject2(int n) throws IOException {
        this.startTag(28, false);
        this.out.writeUI16(n);
        this.completeTag();
    }

    public void tagSetBackgroundColor(Color color) throws IOException {
        this.startTag(9, false);
        color.writeRGB(this.out);
        this.completeTag();
    }

    public void tagFrameLabel(String string) throws IOException {
        this.tagFrameLabel(string, false);
    }

    public void tagFrameLabel(String string, boolean bl) throws IOException {
        this.startTag(43, true);
        this.out.writeString(string, this.mStringEncoding);
        if (bl) {
            this.out.writeUI8(1);
        }
        this.completeTag();
    }

    public SWFTagTypes tagDefineSprite(int n) throws IOException {
        this.startTag(39, n, true);
        this.out.writeUI16(0);
        TagWriter tagWriter = new TagWriter(new SpriteTags());
        tagWriter.version = this.version;
        return tagWriter;
    }

    public void tagProtect(byte[] byArray) throws IOException {
        this.mTags.tag(24, false, byArray);
    }

    public void tagEnableDebug(byte[] byArray) throws IOException {
        this.mTags.tag(58, false, byArray);
    }

    public void tagEnableDebug2(byte[] byArray) throws IOException {
        this.startTag(64, 0, false);
        this.out.write(byArray);
        this.completeTag();
    }

    public SWFVectors tagDefineFont(int n, int n2) throws IOException {
        this.startTag(10, n, true);
        return new SWFShapeImpl(this, n2);
    }

    public void tagDefineFontInfo(int n, String string, int n2, int[] nArray) throws IOException {
        this.startTag(13, true);
        this.out.writeUI16(n);
        byte[] byArray = string.getBytes();
        this.out.writeUI8(byArray.length);
        this.out.write(byArray);
        this.out.writeUI8(n2);
        boolean bl = (n2 & 1) != 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (bl) {
                this.out.writeUI16(nArray[i]);
                continue;
            }
            this.out.writeUI8(nArray[i]);
        }
        this.completeTag();
    }

    public void tagDefineFontInfo2(int n, String string, int n2, int[] nArray, int n3) throws IOException {
        this.startTag(62, true);
        this.out.writeUI16(n);
        byte[] byArray = string.getBytes();
        this.out.writeUI8(byArray.length);
        this.out.write(byArray);
        this.out.writeUI8(n2 |= 1);
        this.out.writeUI8(n3);
        for (int i = 0; i < nArray.length; ++i) {
            this.out.writeUI16(nArray[i]);
        }
        this.completeTag();
    }

    public SWFVectors tagDefineFont2(int n, int n2, String string, int n3, int n4, int n5, int n6, int[] nArray, int[] nArray2, Rect[] rectArray, int[] nArray3, int[] nArray4, int[] nArray5) throws IOException {
        this.startTag(48, n, true);
        this.out.writeUI8(n2);
        this.out.writeUI8(0);
        byte[] byArray = string.getBytes();
        this.out.writeUI8(byArray.length);
        this.out.write(byArray);
        this.out.writeUI16(n3);
        return new Font2ShapeImpl(this, n2, n3, n4, n5, n6, nArray, nArray2, rectArray, nArray3, nArray4, nArray5);
    }

    public void tagDefineTextField(int n, String string, String string2, Rect rect, int n2, AlphaColor alphaColor, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) throws IOException {
        this.startTag(37, n, true);
        rect.write(this.out);
        this.out.writeUI16(n2 |= 0x2005);
        this.out.writeUI16(n4);
        this.out.writeUI16(n5);
        alphaColor.write(this.out);
        if ((n2 & 2) != 0) {
            this.out.writeUI16(n6);
        }
        this.out.writeUI8(n3);
        this.out.writeUI16(n7);
        this.out.writeUI16(n8);
        this.out.writeUI16(n9);
        this.out.writeUI16(n10);
        this.out.writeString(string, this.mStringEncoding);
        if ((n2 & 0x80) != 0) {
            this.out.writeString(string2, this.mStringEncoding);
        }
        this.completeTag();
    }

    public SWFText tagDefineText(int n, Rect rect, Matrix matrix) throws IOException {
        this.startTag(11, n, true);
        return this.defineText(rect, matrix, false);
    }

    public SWFText tagDefineText2(int n, Rect rect, Matrix matrix) throws IOException {
        this.startTag(33, n, true);
        return this.defineText(rect, matrix, true);
    }

    public SWFActions tagDefineButton(int n, Vector vector) throws IOException {
        this.startTag(7, n, true);
        ButtonRecord.write(this.out, vector);
        System.out.println("BUTTON");
        return new ActionWriter(this, this.version);
    }

    public void tagButtonCXForm(int n, ColorTransform colorTransform) throws IOException {
        this.startTag(23, n, false);
        colorTransform.writeWithoutAlpha(this.out);
        this.completeTag();
    }

    public SWFActions tagDefineButton2(int n, boolean bl, Vector vector) throws IOException {
        this.startTag(34, n, true);
        this.out.writeUI8(bl ? 1 : 0);
        return new ButtonActionWriter(this, this.version, vector);
    }

    public void tagExport(String[] stringArray, int[] nArray) throws IOException {
        this.startTag(56, true);
        int n = nArray.length;
        this.out.writeUI16(n);
        for (int i = 0; i < n; ++i) {
            this.out.writeUI16(nArray[i]);
            this.out.writeString(stringArray[i], this.mStringEncoding);
        }
        this.completeTag();
    }

    public void tagImport(String string, String[] stringArray, int[] nArray) throws IOException {
        this.startTag(57, true);
        int n = nArray.length;
        this.out.writeString(string, this.mStringEncoding);
        this.out.writeUI16(n);
        for (int i = 0; i < n; ++i) {
            this.out.writeUI16(nArray[i]);
            this.out.writeString(stringArray[i], this.mStringEncoding);
        }
        this.completeTag();
    }

    public void tagDefineQuickTimeMovie(int n, String string) throws IOException {
        this.startTag(38, n, true);
        this.out.writeString(string, this.mStringEncoding);
        this.completeTag();
    }

    public void tagDefineBitsJPEG2(int n, byte[] byArray) throws IOException {
        this.startTag(21, n, true);
        this.out.write(byArray);
        this.completeTag();
    }

    public void tagDefineBitsLossless(int n, int n2, int n3, int n4, Color[] colorArray, byte[] byArray) throws IOException {
        this.writeBitsLossless(n, n2, n3, n4, colorArray, byArray, false);
    }

    public void tagDefineBitsLossless2(int n, int n2, int n3, int n4, Color[] colorArray, byte[] byArray) throws IOException {
        this.writeBitsLossless(n, n2, n3, n4, colorArray, byArray, true);
    }

    public void writeBitsLossless(int n, int n2, int n3, int n4, Color[] colorArray, byte[] byArray, boolean bl) throws IOException {
        this.startTag(bl ? 36 : 20, n, true);
        this.out.writeUI8(n2);
        this.out.writeUI16(n3);
        this.out.writeUI16(n4);
        switch (n2) {
            case 3: {
                this.out.writeUI8(colorArray.length - 1);
                break;
            }
            case 4: {
                this.out.writeUI16(colorArray.length - 1);
                break;
            }
            case 5: {
                break;
            }
            default: {
                throw new IOException("unknown bitmap format: " + n2);
            }
        }
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(this.bytes);
        OutStream outStream = new OutStream(deflaterOutputStream);
        if (n2 == 3 || n2 == 4) {
            for (int i = 0; i < colorArray.length; ++i) {
                if (bl) {
                    colorArray[i].writeWithAlpha(outStream);
                    continue;
                }
                colorArray[i].writeRGB(outStream);
            }
        }
        outStream.write(byArray);
        outStream.flush();
        deflaterOutputStream.finish();
        this.completeTag();
    }

    public void tagDefineBitsJPEG2(int n, InputStream inputStream) throws IOException {
        this.startTag(21, n, true);
        this.out.writeUI8(255);
        this.out.writeUI8(217);
        this.out.writeUI8(255);
        this.out.writeUI8(216);
        int n2 = 0;
        byte[] byArray = new byte[10000];
        while ((n2 = inputStream.read(byArray)) >= 0) {
            this.out.write(byArray, 0, n2);
        }
        inputStream.close();
        this.completeTag();
    }

    public SWFShape tagDefineMorphShape(int n, Rect rect, Rect rect2) throws IOException {
        this.startTag(46, n, true);
        rect.write(this.out);
        rect2.write(this.out);
        return new MorphShapeImpl(this);
    }

    protected SWFText defineText(Rect rect, Matrix matrix, boolean bl) throws IOException {
        rect.write(this.out);
        matrix.write(this.out);
        return new SWFTextImpl(bl);
    }

    protected void startShape(int n, int n2, Rect rect) throws IOException {
        this.startTag(n, n2, true);
        rect.write(this.out);
    }

    public void tagScriptLimits(int n, int n2) throws IOException {
        this.startTag(65, false);
        this.out.writeUI16(n);
        this.out.writeUI16(n2);
        this.completeTag();
    }

    public void tagTabOrder(int n, int n2) throws IOException {
        this.startTag(66, false);
        this.out.writeUI16(n);
        this.out.writeUI16(n2);
        this.completeTag();
    }

    public void tagDefineVideoStream(int n, int n2, int n3, int n4, int n5, int n6) throws IOException {
        this.startTag(60, n, false);
        this.out.writeUI16(n2);
        this.out.writeUI16(n3);
        this.out.writeUI16(n4);
        this.out.writeUI8(n5);
        this.out.writeUI8(n6);
        this.completeTag();
    }

    public void tagVideoFrame(int n, int n2, int n3, int n4, byte[] byArray) throws IOException {
        this.startTag(61, n, false);
        this.out.writeUI16(n2);
        this.out.write((n3 << 4) + n4);
        this.out.write(byArray);
        this.completeTag();
    }

    protected static class Font2ShapeImpl
    extends SWFShapeImpl {
        protected int flags;
        protected int ascent;
        protected int descent;
        protected int leading;
        protected int[] codes;
        protected int[] advances;
        protected Rect[] bounds;
        protected int[] kernCodes1;
        protected int[] kernCodes2;
        protected int[] kernAdjustments;

        public Font2ShapeImpl(TagWriter tagWriter, int n, int n2, int n3, int n4, int n5, int[] nArray, int[] nArray2, Rect[] rectArray, int[] nArray3, int[] nArray4, int[] nArray5) {
            super(tagWriter, n2);
            this.flags = n;
            this.ascent = n3;
            this.descent = n4;
            this.leading = n5;
            this.codes = nArray;
            this.advances = nArray2;
            this.bounds = rectArray;
            this.kernCodes1 = nArray3;
            this.kernCodes2 = nArray4;
            this.kernAdjustments = nArray5;
        }

        protected void finishFont() throws IOException {
            int n;
            int n2;
            this.out = this.writer.getOutStream();
            int n3 = this.glyphByteArrays.size();
            boolean bl = (this.flags & 8) != 0;
            int n4 = bl ? (n3 + 1) * 4 : (n3 + 1) * 2;
            for (n2 = 0; n2 <= n3; ++n2) {
                if (bl) {
                    this.out.writeUI32(n4);
                } else {
                    this.out.writeUI16(n4);
                }
                if (n2 >= n3) continue;
                n4 += ((byte[])this.glyphByteArrays.elementAt(n2)).length;
            }
            for (n2 = 0; n2 < n3; ++n2) {
                this.out.write((byte[])this.glyphByteArrays.elementAt(n2));
            }
            n2 = (this.flags & 4) != 0 || n3 > 256 ? 1 : 0;
            for (n = 0; n < n3; ++n) {
                if (n2 != 0) {
                    this.out.writeUI16(this.codes[n]);
                    continue;
                }
                this.out.writeUI8(this.codes[n]);
            }
            if ((this.flags & 0x80) != 0) {
                this.out.writeSI16((short)this.ascent);
                this.out.writeSI16((short)this.descent);
                this.out.writeSI16((short)this.leading);
                for (n = 0; n < n3; ++n) {
                    this.out.writeSI16((short)this.advances[n]);
                }
                for (n = 0; n < n3; ++n) {
                    this.bounds[n].write(this.out);
                }
                n = this.kernCodes1 != null ? this.kernCodes1.length : 0;
                this.out.writeUI16(n);
                for (int i = 0; i < n; ++i) {
                    if (n2 != 0) {
                        this.out.writeUI16(this.kernCodes1[i]);
                        this.out.writeUI16(this.kernCodes2[i]);
                        this.out.writeSI16((short)this.kernAdjustments[i]);
                        continue;
                    }
                    this.out.writeUI8(this.kernCodes1[i]);
                    this.out.writeUI8(this.kernCodes2[i]);
                    this.out.writeSI16((short)this.kernAdjustments[i]);
                }
            }
        }
    }

    protected static class MorphShapeImpl
    extends SWFShapeImpl {
        protected int edgeOffsetBase;
        protected int edgeOffsetTarget;
        protected int shapeCount;
        protected int fillBitSize;
        protected int lineBitSize;
        protected int shapeStart;

        public MorphShapeImpl(TagWriter tagWriter) throws IOException {
            super(tagWriter, true, false);
            this.fill0Index = -1;
            this.fill1Index = -1;
            this.lineIndex = -1;
            this.shapeCount = 2;
            this.out = tagWriter.getOutStream();
            this.edgeOffsetBase = this.out.getCount();
            this.out.writeUI32(0L);
        }

        public void done() throws IOException {
            if (!this.initialStyles) {
                this.writeInitialStyles();
                this.initialStyles = true;
            }
            this.out.writeUBits(6, 0L);
            this.out.flushBits();
            if (this.shapeCount == 2) {
                this.edgeOffsetTarget = this.out.getCount();
                this.fill0Index = -1;
                this.fill1Index = -1;
                this.lineIndex = -1;
                this.moveXY = null;
                this.outstandingChanges = true;
                this.initialStyles = false;
                --this.shapeCount;
                return;
            }
            this.out.flush();
            byte[] byArray = this.writer.bytes.toByteArray();
            int n = this.edgeOffsetTarget - this.edgeOffsetBase - 4;
            byte[] byArray2 = OutStream.uintTo4Bytes(n);
            byArray[this.edgeOffsetBase] = byArray2[0];
            byArray[this.edgeOffsetBase + 1] = byArray2[1];
            byArray[this.edgeOffsetBase + 2] = byArray2[2];
            byArray[this.edgeOffsetBase + 3] = byArray2[3];
            this.writer.out = null;
            this.writer.bytes = null;
            this.writer.mTags.tag(this.writer.tagType, this.writer.longTag, byArray);
        }

        protected void writeInitialStyles() throws IOException {
            this.out.flushBits();
            int n = this.fillStyles.size() / 2;
            int n2 = this.lineStyles.size() / 2;
            this.fillBitSize = OutStream.determineUnsignedBitSize(n);
            this.lineBitSize = OutStream.determineUnsignedBitSize(n2);
            if (this.shapeCount == 2) {
                Style style;
                Style style2;
                if (n < 255) {
                    this.out.writeUI8(n);
                } else {
                    this.out.writeUI8(255);
                    this.out.writeUI16(n);
                }
                Enumeration enumeration = this.fillStyles.elements();
                while (enumeration.hasMoreElements()) {
                    style2 = (FillStyle)enumeration.nextElement();
                    style = (FillStyle)enumeration.nextElement();
                    FillStyle.writeMorphFillStyle(this.out, style2, style);
                }
                if (n2 < 255) {
                    this.out.writeUI8(n2);
                } else {
                    this.out.writeUI8(255);
                    this.out.writeUI16(n2);
                }
                enumeration = this.lineStyles.elements();
                while (enumeration.hasMoreElements()) {
                    style2 = (LineStyle)enumeration.nextElement();
                    style = (LineStyle)enumeration.nextElement();
                    LineStyle.writeMorphLineStyle(this.out, (LineStyle)style2, (LineStyle)style);
                }
            }
            if (this.shapeStart == 0) {
                this.shapeStart = this.out.getCount();
            }
            this.out.writeUBits(4, this.fillBitSize);
            this.out.writeUBits(4, this.lineBitSize);
        }

        protected void writeChangeRecord() throws IOException {
            boolean bl;
            boolean bl2 = this.moveXY != null;
            boolean bl3 = this.fill0Index >= 0;
            boolean bl4 = this.fill1Index >= 0;
            boolean bl5 = bl = this.lineIndex >= 0;
            if (bl3 || bl4 || bl || bl2) {
                this.out.writeUBits(1, 0L);
                this.out.writeUBits(1, 0L);
                this.out.writeUBits(1, bl ? 1L : 0L);
                this.out.writeUBits(1, bl4 ? 1L : 0L);
                this.out.writeUBits(1, bl3 ? 1L : 0L);
                this.out.writeUBits(1, bl2 ? 1L : 0L);
                if (bl2) {
                    int n = this.moveXY[0];
                    int n2 = this.moveXY[1];
                    int n3 = OutStream.determineSignedBitSize(n);
                    int n4 = OutStream.determineSignedBitSize(n2);
                    if (n4 > n3) {
                        n3 = n4;
                    }
                    this.out.writeUBits(5, n3);
                    this.out.writeSBits(n3, n);
                    this.out.writeSBits(n3, n2);
                }
                if (bl3) {
                    this.out.writeUBits(this.fillBitSize, this.fill0Index);
                }
                if (bl4) {
                    this.out.writeUBits(this.fillBitSize, this.fill1Index);
                }
                if (bl) {
                    this.out.writeUBits(this.lineBitSize, this.lineIndex);
                }
                this.moveXY = null;
                this.fill0Index = -1;
                this.fill1Index = -1;
                this.lineIndex = -1;
            }
        }
    }

    protected static class SWFShapeImpl
    implements SWFShape {
        protected boolean hasAlpha;
        protected boolean hasStyle;
        protected boolean outstandingChanges = true;
        protected boolean initialStyles = false;
        protected int fill0Index = -1;
        protected int fill1Index = -1;
        protected int lineIndex = -1;
        protected int[] moveXY;
        protected Vector lineStyles = new Vector();
        protected Vector fillStyles = new Vector();
        protected int fillBits;
        protected int lineBits;
        protected int glyphCount = 0;
        protected Vector glyphByteArrays;
        protected OutStream out;
        protected TagWriter writer;
        protected ByteArrayOutputStream bout;

        public SWFShapeImpl(TagWriter tagWriter, boolean bl, boolean bl2) {
            this.hasAlpha = bl;
            this.hasStyle = bl2;
            this.writer = tagWriter;
            this.out = tagWriter.getOutStream();
        }

        public SWFShapeImpl(TagWriter tagWriter, int n) {
            this(tagWriter, false, false);
            this.glyphCount = n;
            this.bout = new ByteArrayOutputStream();
            this.out = new OutStream(this.bout);
            this.glyphByteArrays = new Vector();
            this.fill1Index = 1;
            this.lineIndex = 0;
        }

        public void done() throws IOException {
            if (!this.initialStyles) {
                this.writeInitialStyles();
                this.initialStyles = true;
            }
            this.out.writeUBits(6, 0L);
            this.out.flushBits();
            if (this.bout != null && this.glyphCount > 0) {
                byte[] byArray = this.bout.toByteArray();
                this.glyphByteArrays.addElement(byArray);
            }
            if (this.glyphCount > 1) {
                this.bout = new ByteArrayOutputStream();
                this.out = new OutStream(this.bout);
                --this.glyphCount;
                this.fill1Index = 1;
                this.lineIndex = 0;
                this.outstandingChanges = true;
                this.initialStyles = false;
            } else {
                if (this.bout != null) {
                    this.finishFont();
                }
                this.writer.completeTag();
            }
        }

        protected void finishFont() throws IOException {
            int n;
            this.out = this.writer.getOutStream();
            int n2 = this.glyphByteArrays.size();
            int n3 = n2 * 2;
            this.out.writeUI16(n3);
            for (n = 0; n < n2 - 1; ++n) {
                this.out.writeUI16(n3 += ((byte[])this.glyphByteArrays.elementAt(n)).length);
            }
            for (n = 0; n < n2; ++n) {
                this.out.write((byte[])this.glyphByteArrays.elementAt(n));
            }
        }

        public void setFillStyle0(int n) throws IOException {
            this.fill0Index = n;
            this.outstandingChanges = true;
        }

        public void setFillStyle1(int n) throws IOException {
            this.fill1Index = n;
            this.outstandingChanges = true;
        }

        public void setLineStyle(int n) throws IOException {
            this.lineIndex = n;
            this.outstandingChanges = true;
        }

        public void defineFillStyle(Color color) throws IOException {
            this.fillStyles.addElement(new FillStyle(color));
            this.outstandingChanges = true;
        }

        public void defineFillStyle(Matrix matrix, int[] nArray, Color[] colorArray, boolean bl) throws IOException {
            this.fillStyles.addElement(new FillStyle(matrix, nArray, colorArray, bl));
            this.outstandingChanges = true;
        }

        public void defineFillStyle(int n, Matrix matrix, boolean bl) throws IOException {
            this.fillStyles.addElement(new FillStyle(n, matrix, bl));
            this.outstandingChanges = true;
        }

        public void defineLineStyle(int n, Color color) throws IOException {
            this.lineStyles.addElement(new LineStyle(n, color));
            this.outstandingChanges = true;
        }

        public void line(int n, int n2) throws IOException {
            if (this.outstandingChanges) {
                this.flushChangeRecords();
            }
            int n3 = OutStream.determineSignedBitSize(n);
            int n4 = OutStream.determineSignedBitSize(n2);
            if (n4 > n3) {
                n3 = n4;
            }
            if (n3 < 2) {
                n3 = 2;
            }
            this.out.writeUBits(2, 3L);
            this.out.writeUBits(4, n3 - 2);
            if (n != 0 && n2 != 0) {
                this.out.writeUBits(1, 1L);
                this.out.writeSBits(n3, n);
                this.out.writeSBits(n3, n2);
            } else {
                this.out.writeUBits(1, 0L);
                if (n2 != 0) {
                    this.out.writeUBits(1, 1L);
                    this.out.writeSBits(n3, n2);
                } else {
                    this.out.writeUBits(1, 0L);
                    this.out.writeSBits(n3, n);
                }
            }
        }

        public void curve(int n, int n2, int n3, int n4) throws IOException {
            if (this.outstandingChanges) {
                this.flushChangeRecords();
            }
            int n5 = OutStream.determineSignedBitSize(n);
            int n6 = OutStream.determineSignedBitSize(n2);
            int n7 = OutStream.determineSignedBitSize(n3);
            int n8 = OutStream.determineSignedBitSize(n4);
            if (n6 > n5) {
                n5 = n6;
            }
            if (n7 > n5) {
                n5 = n7;
            }
            if (n8 > n5) {
                n5 = n8;
            }
            if (n5 < 2) {
                n5 = 2;
            }
            this.out.writeUBits(2, 2L);
            this.out.writeUBits(4, n5 - 2);
            this.out.writeSBits(n5, n);
            this.out.writeSBits(n5, n2);
            this.out.writeSBits(n5, n3);
            this.out.writeSBits(n5, n4);
        }

        public void move(int n, int n2) throws IOException {
            this.moveXY = new int[]{n, n2};
            this.outstandingChanges = true;
        }

        protected void flushChangeRecords() throws IOException {
            if (!this.initialStyles) {
                this.writeInitialStyles();
                this.initialStyles = true;
            }
            this.writeChangeRecord();
            this.outstandingChanges = false;
        }

        protected void writeInitialStyles() throws IOException {
            this.out.flushBits();
            this.fillBits = OutStream.determineUnsignedBitSize(this.fillStyles.size());
            this.lineBits = OutStream.determineUnsignedBitSize(this.lineStyles.size());
            if (!this.hasStyle) {
                this.fillBits = 1;
            } else {
                this.writeStyles(this.fillStyles);
                this.writeStyles(this.lineStyles);
                this.out.flushBits();
            }
            this.out.writeUBits(4, this.fillBits);
            this.out.writeUBits(4, this.lineBits);
        }

        protected void writeChangeRecord() throws IOException {
            boolean bl;
            boolean bl2 = this.hasStyle && (this.fillStyles.size() > 0 || this.lineStyles.size() > 0);
            boolean bl3 = this.moveXY != null;
            boolean bl4 = this.fill0Index >= 0;
            boolean bl5 = this.fill1Index >= 0;
            boolean bl6 = bl = this.lineIndex >= 0;
            if (!this.hasStyle && bl4) {
                bl5 = false;
            }
            if (bl2) {
                this.out.writeUBits(1, 0L);
                this.out.writeUBits(1, 1L);
                this.out.writeUBits(1, 1L);
                this.out.writeUBits(1, 1L);
                this.out.writeUBits(1, 1L);
                this.out.writeUBits(1, 1L);
                this.writeMoveXY(0, 0);
                this.out.writeUBits(this.fillBits, 0L);
                this.out.writeUBits(this.fillBits, 0L);
                this.out.writeUBits(this.lineBits, 0L);
                if (this.fill0Index == 0) {
                    this.fill0Index = -1;
                }
                if (this.fill1Index == 0) {
                    this.fill1Index = -1;
                }
                if (this.lineIndex == 0) {
                    this.lineIndex = -1;
                }
                this.fillBits = OutStream.determineUnsignedBitSize(this.fillStyles.size());
                this.lineBits = OutStream.determineUnsignedBitSize(this.lineStyles.size());
                this.writeStyles(this.fillStyles);
                this.writeStyles(this.lineStyles);
                this.out.writeUBits(4, this.fillBits);
                this.out.writeUBits(4, this.lineBits);
                this.writeChangeRecord();
                return;
            }
            if (bl4 || bl5 || bl || bl3) {
                this.out.writeUBits(1, 0L);
                this.out.writeUBits(1, 0L);
                this.out.writeUBits(1, bl ? 1L : 0L);
                this.out.writeUBits(1, bl5 ? 1L : 0L);
                this.out.writeUBits(1, bl4 ? 1L : 0L);
                this.out.writeUBits(1, bl3 ? 1L : 0L);
                if (bl3) {
                    int n = this.moveXY[0];
                    int n2 = this.moveXY[1];
                    this.writeMoveXY(n, n2);
                }
                if (bl4) {
                    this.out.writeUBits(this.fillBits, this.fill0Index);
                }
                if (bl5) {
                    this.out.writeUBits(this.fillBits, this.fill1Index);
                }
                if (bl) {
                    this.out.writeUBits(this.lineBits, this.lineIndex);
                }
                this.moveXY = null;
                this.fill0Index = -1;
                this.fill1Index = -1;
                this.lineIndex = -1;
            }
        }

        protected void writeMoveXY(int n, int n2) throws IOException {
            int n3 = OutStream.determineSignedBitSize(n);
            int n4 = OutStream.determineSignedBitSize(n2);
            if (n4 > n3) {
                n3 = n4;
            }
            this.out.writeUBits(5, n3);
            this.out.writeSBits(n3, n);
            this.out.writeSBits(n3, n2);
        }

        protected void writeStyles(Vector vector) throws IOException {
            int n;
            int n2 = n = vector != null ? vector.size() : 0;
            if (n < 255) {
                this.out.writeUI8(n);
            } else {
                this.out.writeUI8(255);
                this.out.writeUI16(n);
            }
            if (vector != null) {
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    Style style = (Style)enumeration.nextElement();
                    style.write(this.out, this.hasAlpha);
                }
                vector.removeAllElements();
            }
        }
    }

    protected class SpriteTags
    implements SWFTags {
        protected int frameCount = 0;

        protected SpriteTags() {
        }

        public void tag(int n, boolean bl, byte[] byArray) throws IOException {
            int n2 = byArray != null ? byArray.length : 0;
            bl = n2 > 62 || bl;
            int n3 = (n << 6) + (bl ? 63 : n2);
            TagWriter.this.out.writeUI16(n3);
            if (bl) {
                TagWriter.this.out.writeUI32(n2);
            }
            if (byArray != null) {
                TagWriter.this.out.write(byArray);
            }
            if (n == 1) {
                ++this.frameCount;
            }
            if (n == 0) {
                TagWriter.this.out.flush();
                byArray = TagWriter.this.bytes.toByteArray();
                TagWriter.this.out = null;
                TagWriter.this.bytes = null;
                byte[] byArray2 = OutStream.uintTo2Bytes(this.frameCount);
                byArray[2] = byArray2[0];
                byArray[3] = byArray2[1];
                TagWriter.this.mTags.tag(TagWriter.this.tagType, TagWriter.this.longTag, byArray);
            }
        }

        public void header(int n, long l, int n2, int n3, int n4, int n5) throws IOException {
        }
    }

    protected class SWFTextImpl
    implements SWFText {
        protected boolean hasAlpha;
        protected int maxGlyphIndex = 0;
        protected int maxAdvance = 0;
        protected Vector recs = new Vector();
        protected Object[] currentStyleRecord = null;

        public SWFTextImpl(boolean bl) {
            this.hasAlpha = bl;
        }

        protected Object[] getCurrentStyle() {
            if (this.currentStyleRecord == null) {
                this.currentStyleRecord = new Object[4];
                this.recs.addElement(this.currentStyleRecord);
            }
            return this.currentStyleRecord;
        }

        public void font(int n, int n2) throws IOException {
            this.getCurrentStyle()[0] = new int[]{n, n2};
        }

        public void color(Color color) throws IOException {
            this.getCurrentStyle()[3] = color;
        }

        public void setX(int n) throws IOException {
            this.getCurrentStyle()[1] = new int[]{n};
        }

        public void setY(int n) throws IOException {
            this.getCurrentStyle()[2] = new int[]{n};
        }

        public void text(int[] nArray, int[] nArray2) throws IOException {
            this.currentStyleRecord = null;
            this.recs.addElement(new Object[]{nArray, nArray2});
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] > this.maxGlyphIndex) {
                    this.maxGlyphIndex = nArray[i];
                }
                if (nArray2[i] <= this.maxAdvance) continue;
                this.maxAdvance = nArray2[i];
            }
        }

        public void done() throws IOException {
            int n = OutStream.determineUnsignedBitSize(this.maxGlyphIndex);
            int n2 = OutStream.determineSignedBitSize(this.maxAdvance);
            TagWriter.this.out.writeUI8(n);
            TagWriter.this.out.writeUI8(n2);
            Enumeration enumeration = this.recs.elements();
            while (enumeration.hasMoreElements()) {
                int n3;
                Object[] objectArray = (Object[])enumeration.nextElement();
                if (objectArray.length == 4) {
                    boolean bl = objectArray[0] != null;
                    boolean bl2 = objectArray[1] != null;
                    n3 = objectArray[2] != null ? 1 : 0;
                    boolean bl3 = objectArray[3] != null;
                    int n4 = 128;
                    if (bl) {
                        n4 |= 8;
                    }
                    if (bl2) {
                        n4 |= 1;
                    }
                    if (n3 != 0) {
                        n4 |= 2;
                    }
                    if (bl3) {
                        n4 |= 4;
                    }
                    TagWriter.this.out.writeUI8(n4);
                    if (bl) {
                        TagWriter.this.out.writeUI16(((int[])objectArray[0])[0]);
                    }
                    if (bl3) {
                        Color color = (Color)objectArray[3];
                        if (this.hasAlpha) {
                            color.writeWithAlpha(TagWriter.this.out);
                        } else {
                            color.writeRGB(TagWriter.this.out);
                        }
                    }
                    if (bl2) {
                        int n5 = ((int[])objectArray[1])[0];
                        TagWriter.this.out.writeSI16((short)n5);
                    }
                    if (n3 != 0) {
                        int n6 = ((int[])objectArray[2])[0];
                        TagWriter.this.out.writeSI16((short)n6);
                    }
                    if (!bl) continue;
                    TagWriter.this.out.writeUI16(((int[])objectArray[0])[1]);
                    continue;
                }
                int[] nArray = (int[])objectArray[0];
                int[] nArray2 = (int[])objectArray[1];
                TagWriter.this.out.writeUI8(nArray.length);
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    TagWriter.this.out.writeUBits(n, nArray[n3]);
                    TagWriter.this.out.writeSBits(n2, nArray2[n3]);
                }
            }
            TagWriter.this.out.writeUI8(0);
            TagWriter.this.completeTag();
        }
    }

    protected static class ButtonActionWriter
    extends ActionWriter {
        protected Vector offsets = new Vector();
        protected int lastPtr;
        protected OutStream tagout;

        public ButtonActionWriter(TagWriter tagWriter, int n, Vector vector) throws IOException {
            super(tagWriter, n);
            this.tagout = tagWriter.getOutStream();
            this.lastPtr = this.tagout.getCount();
            this.tagout.writeUI16(0);
            ButtonRecord2.write(this.tagout, vector);
        }

        public SWFActionBlock start(int n) throws IOException {
            int n2 = this.tagout.getCount();
            int n3 = n2 - this.lastPtr;
            this.offsets.addElement(new int[]{this.lastPtr, n3});
            this.lastPtr = n2;
            this.tagout.writeUI16(0);
            this.tagout.writeUI16(n);
            return super.start(n);
        }

        public void done() throws IOException {
            this.offsets.addElement(new int[]{this.lastPtr, 0});
            this.tagout.flush();
            byte[] byArray = this.mTagWriter.bytes.toByteArray();
            this.mTagWriter.out = null;
            this.mTagWriter.bytes = null;
            Enumeration enumeration = this.offsets.elements();
            while (enumeration.hasMoreElements()) {
                int[] nArray = (int[])enumeration.nextElement();
                int n = nArray[0];
                int n2 = nArray[1];
                byte[] byArray2 = OutStream.uintTo2Bytes(n2);
                byArray[n] = byArray2[0];
                byArray[n + 1] = byArray2[1];
            }
            this.mTagWriter.mTags.tag(this.mTagWriter.tagType, true, byArray);
        }
    }
}

