/*
 * Decompiled with CFR 0.152.
 */
package org.epistem.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MethodCallRecorder
implements InvocationHandler {
    public final List calls = new ArrayList();

    public final Object implementInterface(Class clazz) throws Exception {
        return Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)this);
    }

    public void replayAllCalls(Object object) throws Exception {
        Iterator iterator = this.calls.iterator();
        while (iterator.hasNext()) {
            Call call = (Call)iterator.next();
            call.replay(object);
        }
    }

    public final Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        Call call = this.recordCall(method, objectArray);
        if (call != null) {
            this.calls.add(call);
            return call.getReturnObject();
        }
        return null;
    }

    protected Call recordCall(Method method, Object[] objectArray) {
        return new Call(method, objectArray);
    }

    public static class Call {
        public final Method method;
        public final Object[] args;
        private MethodCallRecorder recorder;

        public Call(Method method, Object[] objectArray) {
            this.method = method;
            this.args = objectArray;
        }

        public Object getReturnObject() throws Exception {
            Class<?> clazz = this.method.getReturnType();
            if (clazz.isInterface()) {
                this.recorder = new MethodCallRecorder();
                return this.recorder.implementInterface(clazz);
            }
            return null;
        }

        public void replay(Object object) throws Exception {
            Object object2 = this.method.invoke(object, this.args);
            if (object2 != null && this.recorder != null) {
                this.recorder.replayAllCalls(object2);
            }
        }
    }
}

