#### v1.16.2 (2021-01-21)

##### Breaking Changes

*  unescape header navigation originalRoute [breaking] (6cb5888c)
*  allow override of local fns in login controller, 400 instead of 500 for wrong login type [breaking] (1cf0032d)

##### Chores

* **deps:**
  *  update dependency husky to v4.3.8 (a6f5de86)
  *  update dependency eslint to v7.18.0 (afbef95f)
  *  update dependency husky to v4.3.7 (d3e041e2)
*  incrementing version number - v1.16.2-beta.0 (43ff8e41)
*  incrementing version number - v1.16.1 (e3cd7a23)
*  update changelog for v1.16.1 (b6d71710)

##### New Features

*  add filter:email.cancel to allow plugins to cancel sending emails (c2e23706)
*  grant plugins the ability to specify options to the SSO handler (ab11435e)
*  add unread-count badge if navigator contains /flags route (c07e1e16)
*  handle HTTP 429 as a response code (8bbb3208)
*  add write API route for checking login credentials (56f929ed)
*  #8813, faster category search dropdown (072a0e32)
* **api:**  schema definition for new credential checking route (0da28432)

##### Bug Fixes

* **deps:**
  *  update dependency bootbox to v5 (#8751) (b5cb2f8b)
  *  update dependency nodebb-theme-persona to v10.3.19 (f16cdc9f)
  *  update socket.io packages to v3.1.0 (3d1224e1)
  *  update dependency nodebb-theme-slick to v1.3.8 (1901ecb2)
  *  update dependency sortablejs to v1.13.0 (36069da2)
  *  update dependency autoprefixer to v10.2.1 (5b3c48fd)
*  https://github.com/NodeBB/nodebb-plugin-webhooks/issues/3 (c608b0e8)
*  restored sanity checks for post move socket calls (d85ad10d)
*  don't chagne scrollTop if at the top of page (0fa4c11e)
*  #9206, fix double escaped arguments (1590cdf1)
*  regression caused by 77ab46686db62871f149419a368c35628453884e (f5fcd232)
*  don't crash if fullname is not a string (4fb90787)
*  #9204, bypass groupname length check for system group in upgrade script (00ba89b6)
*  add missing await (9938a139)
*  ssoState passed to strategies even if not called for (9b289eca)
*  use max (0a471b76)
*  keep 60 topics minimum on topic list (c30b40ab)
*  access checks for tags and thumbs get route (77ab4668)
*  #9194 global mods unable to pin or unpin topics (c0fb1cb5)
*  #9192, exit after logging error (ef16cd2e)
*  make sure inviter user exists (69419571)
*  #9178 missing language strings (and fallbacks) for post-queue (a407a51d)
*  #9185, fix string boolean values (89e6c75d)
*  test for topicThumbs (e817d5be)
*  #9184 proper relative_path usage in topic thumbs.get (66da6bcd)
*  #9169, re-adding v2-style behaviour so as to not break the API... yet (b742229e)
*  #9177, handled multiple deleted users properly (eaf62d39)
*  broken test caused by errant .pop(), missing await (4ede18ce)
*  missing error message (d83d40cf)
*  test for https://github.com/NodeBB/NodeBB/pull/9180 (8ece64ab)
*  #9176, limit description size (da546970)
*  broken test due to change in response code (9534d956)
*  return a user object, not an array of user objects (in v3 login check route) (97d678fd)
*  bad execution flow in utilities.login (8c86f5bc)
*  missing breadcrumbs in schema (87a7d85e)
*  random loadFiles added by errant vscode autocompletion (53422413)
*  add missing breadcrumb on /user/<slug>/categories (6cbb77af)
*  `--help` usage info (a51c5698)

##### Performance Improvements

*  use only required calls (f0dd302c)

##### Refactors

* **api:**
  *  post move to write API (966c4117)
  *  post diffs to use write API (e118e59c)
*  change var to const (1374e0ee)
*  single remove call (25ab99b9)
*  flags lib to have a separate getFlagIdsWithFilters method (6a1311b4)
*  split out logic dedicated to calculating unread counts, to a separate local method (03a0e72f)

##### Code Style Changes

*  update codeclimate config to be less sensitive to duplicate code blocks (fdf03472)

#### v1.16.1 (2021-01-06)

##### Chores

*  increase test timeout (0d7dfeeb)
*  incrementing version number - v1.16.1-beta.0 (5fcf3ea6)
*  add deprecation notice to topic thumb tpl value (05d8b3c3)
*  minor reordering of lines (8e5a413e)
*  incrementing version number - v1.16.0 (6d01fd50)
*  update changelog for v1.16.0 (1437c62f)
* **deps:**
  *  update dependency eslint to v7.17.0 (18ae7cf7)
  *  update dependency eslint to v7.16.0 (2610dfcf)
  *  update actions/setup-node action to v2 (#9115) (55a55ea2)
* **api:**  add deprecation notices re: #9123 (cdff8d28)

##### New Features

*  #9173, show installed plugin versions in ./nodebb plugins (8c31afae)
*  added note that you can now upload videos (4d6ddf6d)
*  automatically attempt socket.io reconnection on ajaxify (e5edbc6f)
*  #9135, don't try to reconnect forever (c1ecfd1e)
*  add confirmation modal when assigning admin:admins-mods privilege (d90aa958)
*  allow dashes in privilege group names (5b8558e9)
*  allow multiple privileges to be defined for a given admin socket call (3aa5beb8)
*  rename admin middleware header hook (fcc1e24a)
*  explicitly add filter:admin/header.build hook (75b1bbd0)
*  fix more tests, add more routes, update api test suite (cb32e32a)
*  add registration/complete route, fix some other tests (14c51e3c)
*  add missing schemas for various ACP settings routes (9de35ec5)
*  add missing schema for category update and deletion (d6de9253)
*  add schema for api ping routes (d85181e0)
*  normalize paths before comparison (df8d62ba)
*  additional test to ensure any new routes added to express have a corresponding schema doc (dbe85630)
*  update html-to-text closes https://github.com/NodeBB/NodeBB/pull/8810 (a2152dd1)
* **api:**
  *  closes #9123 category and topic routes migrated to Write API (edb8da1e)
  *  #9123, migrate rest of the getObject controllers to Write API (9ecfac9b)
  *  #9123, migrate /api/post/pid/:pid to Write API (e267f295)
  *  group ownership API route, switch client-side to use API route (32e36f7b)
  *  add schema for groups update route (98550d61)
  *  added schema for email unsubscribe token (4fc13377)
* **acp:**
  *  admin tags privilege (223f0a55)
  *  admins-mods privilege (fb46a8d9)
  *  added new admin privilege for groups management (da191341)

##### Bug Fixes

*  #9130, remove timestamp prefix from thumbnail names in API response (171017c3)
*  #9166 missing relative path in topic thumbs modal and topic list (b9ba44ed)
*  #9163, fix total connection count on ACP (1968bf50)
*  genericise .necro-post, bump persona to latest (041d45c3)
*  #9126, skip base64 and long values (33290850)
*   #9127, use assets path (3121215e)
*  inability for admins with setting privilege to save plugin settings (a555f024)
*  #9149, server-side handling of disableChatMessageEditing (895e3d93)
*  #9149, incorrect client-side `disableChatMessageEditing` value for admins/gmods (d27815a8)
*  #9151, dont use service worker for posts requests (20c1b684)
*  #9150, fix selector so it doesn't add img-responsive to profile pics (183cabe9)
*  tests (28740360)
*  dont show deleted posts in navigator (931105e6)
*  bug in api path existence test (501a7b77)
*  #9136, fix move topic/post timeout errors (2ef72a94)
*  bad assignment logic in middleware.renderHeader (34ccabe3)
*  #9113, wrong path separator used in thumbs.get (da4f9118)
*  email testing and settings change from ACP (2be396ff)
*  removing ability to specify deprecated topic 'thumb' on topic creation (713f029d)
*  #9129, event is fired on socket.io (b369dc88)
*  subfolder handling in tests (bbd97ccb)
*  .flat() not defined in v10, added debug router to exclusion list (6062039d)
*  all tests, wrap up work (f416dc17)
*  two more routes (9c2de86a)
*  api tests (b9a61d2d)
*  don't return deleted: 0 for ephemeral groups (600807fb)
*  send fewer items to client-side for ACP settings/email page (438fa5c8)
*  errors in write-api schema (c079051b)
*  broken tests from last round of fixes (990f1077)
*  bad error message for request body api test (a9629357)
*  modify backreference test to not check router.all() calls (7fc329de)
*  add missing token generation route to write api spec (eef052c1)
*  trigger action:posts.edited (b7b588f5)
* **deps:**
  *  update dependency autoprefixer to v10.2.0 (e445ae5a)
  *  update socket.io packages to v3.0.5 (fd045c67)
  *  update dependency nodebb-theme-persona to v10.3.16 (87e333b4)
  *  update dependency benchpressjs to v2.4.0 (4524f825)
  *  update dependency nodebb-theme-persona to v10.3.15 (189be9e0)
  *  update dependency nodebb-widget-essentials to v5.0.2 (1dd1d3b0)
  *  update dependency nodebb-widget-essentials to v5.0.1 (#9144) (f55dddb2)
  *  update dependency nodebb-plugin-composer-default to v6.5.5 (6d980d26)
  *  update dependency sharp to v0.27.0 (4919e596)
  *  update dependency nodebb-theme-persona to v10.3.12 (37b35f7d)
  *  update dependency nodebb-theme-persona to v10.3.11 (db4c6863)
* **tests:**  handle nested allOf blocks (77a5adb6)
* **api:**
  *  failing test due to missing file (3959a7bd)
  *  tests (80ee3dfb)
* **pwa:**  #9127 service-worker.js missing on subfolder installs (b8d4709e)

##### Refactors

* **openapi:**  update TopicObject component to reference TopicObjectSlim in its schema (fb3f3f72)
* **api:**
  *  deprecated groups update socket in favour of API lib (1cd2689c)
  *  update group deletion calls to use write API (e640a41a)
*  schema backreference test to use map instead of reduce, properly check write-api routes (878ee067)

##### Tests

*  changed test a bit to see what is going on (5f038dff)

#### v1.16.0 (2020-12-17)

##### Breaking Changes

*  enable topic thumbnails across the board [breaking] (9342d611)
*  #8808, remove utils.slugify (4a0d8833)

##### Chores

* **deps:**
  *  update dependency husky to v4.3.6 (2371b432)
  *  bump persona to 10.3.9 (91899329)
  *  bump composer to 6.5.1, re: #9067 (228cfa67)
  *  update dependency husky to v4.3.5 (48a31763)
  *  update dependency husky to v4.3.4 (cf5c482d)
  *  update dependency eslint to v7.15.0 (f4c4d671)
  *  update dependency lint-staged to v10.5.3 (3e6f7359)
*  appease codeclimate (9f62df15)
*  add comment for clarification (6037f5ee)
*  incrementing version number - v1.15.5 (57cd1343)
*  update changelog for v1.15.5 (b0299326)
* **i18n:**  fallbacks for new topic thumb keys (15f1a089)

##### New Features

*  add new client side hooks (a15ef53c)
*  remove max age since cache is cleared when thumbs change (ab96f526)
*  show alt text instead of images in teasers (#9107) (d28581eb)
*  migration of old topic thumbs to new format (74d73313)
*  allow plugins to override ACP relogin challenge (4c87f301)
*  add user.email.confirmByUid for sso plugins (80de572a)
*  add thumbs to category data return (24e754d1)
*  broken test for bad topic thumbs logic (ce8057f3)
*  clent-side modal for managing topic thumbs (a30c8ab5)
*  raise maximum thumb size to 512 (37c367d6)
*  associate topic thumbs with post uploads (for the mainPid) (1c5cdb51)
*  helper method to get thumbs by pid (cb7e4cda)
*  closes #9048, tests for topic thumbs routes, write API schema (59506833)
*  tests for topic thumbs (4152aa55)
*  server-side work for #9047 (ef7d6db9)
*  core work for #9042, thumb deletion now accepts uuids (b5d910f5)
*  more work on topic thumbs refactor (90497e3e)
*  expose uploaded thumbnails to client-side via API (1257aa98)
*  server-side routes for handling multiple topic thumbnails (7e9e08f7)
*  allow uploadThumb controller to be called in code (98cd9e35)
*  move upgrade script and make it shorter (60e7de0d)
*  allow clicks on navigator, clean dupe code (74274b60)
*  socket.io 3 changes (#8845) (1c45fa1b)
* **deps:**  update lavender to allow category sections (6d186be0)

##### Bug Fixes

* **deps:**
  *  update dependency nodebb-plugin-composer-default to v6.5.4 (#9120) (fff0cea6)
  *  update dependency nodebb-theme-slick to v1.3.7 (#9112) (30688b1b)
  *  update dependency nodebb-theme-lavender to v5.0.17 (#9111) (877f4673)
  *  update dependency nodebb-theme-vanilla to v11.3.10 (ff18cdfa)
  *  update dependency validator to v13.5.2 (#9094) (5d718348)
  *  update dependency nodebb-theme-vanilla to v11.3.9 (#9091) (f37dbeed)
  *  update dependency nodebb-plugin-composer-default to v6.5.3 (d036408d)
  *  update dependency nodebb-plugin-composer-default to v6.5.2 (b07fb9ab)
  *  bump composer-default to 6.5.0 (0db49121)
  *  update dependency autoprefixer to v10.1.0 (024d1fef)
  *  update dependency nodebb-theme-persona to v10.3.8 (#9084) (25f697b1)
  *  update socket.io packages to v3.0.4 (62463430)
  *  update dependency nodebb-theme-persona to v10.3.7 (c22cdb51)
  *  update dependency nodebb-theme-persona to v10.3.6 (#9077) (5937fbaf)
  *  update dependency nodebb-plugin-mentions to v2.13.6 (#9071) (a535350f)
  *  update dependency nodebb-theme-slick to v1.3.6 (#9072) (19c438c6)
  *  update dependency nodebb-widget-essentials to v5 (#9070) (d7f5efd9)
  *  update dependency nodebb-plugin-markdown to v8.12.4 (8fb814ba)
  *  update dependency nodebb-theme-persona to v10.3.5 (#9060) (0d082280)
  *  update dependency nodebb-theme-persona to v10.3.4 (#9059) (84e4e480)
  *  update dependency nodebb-theme-persona to v10.3.3 (3d7e2e1e)
  *  update dependency nodebb-theme-persona to v10.3.2 (#9056) (f49ce4ad)
  *  update dependency nodebb-theme-persona to v10.3.1 (#9054) (344caf5c)
  *  update dependency nodebb-theme-lavender to v5.0.15 (#9053) (e7d72d8a)
  *  update dependency nodebb-theme-persona to v10.3.0 (#9052) (dcd6fbaf)
*  api usage (feecd665)
*  #9117, lower query before search (4404e32e)
*  #9114, fix client side groups update for memberPostCids (3ed55799)
*  test (2dee3cbe)
*  don't check "select all" if there are no enabled checkboxes (3ba05755)
*  #9074, fix svg uploads (8f938eba)
*  #9100 topic thumbs in OG image tags (ab987408)
*  update version removal comments to 1.17 for some features (378a3a69)
*  postgres is slow:tm: (05dd8597)
*  derp? (f8dff94a)
*  attempted fix for psql test in topic thumbs (9a4ea04a)
*  use getSortedSetRange instead of getSortedSetsMembers (edf67f34)
*  tests (bd5c4a5c)
*  bad topic thumbs logic on local thumb upload (e83baa97)
*  #9092, Topic thumbnails do not work with third-party uploaders (3e54b70c)
*  move topic thumb tests to root level, so they actually get run by mocha (dd448e2b)
*  tests for topic thumbs (9681557f)
*  iteration logic bug (2170c400)
*  spec (ae943974)
*  changes to thumb resizing logic (67cf5e83)
*  use file lib instead of direct fs module access (08736b18)
*  added back missing topic thumb tests that were removed in last commit (c043cfeb)
*  tests (5ec3b3d0)
*  hack uploader to handle a response from v3 write api (41379e27)
*  #9055, non-standard API response from addThumbs route (340387c1)
*  do not allow thumb deletion route to arbitrarily delete other files in uploads folder (c09c238e)
*  missing file added (ef10b6b7)
*  references to since-removed Topics.thumbs.resizeAndUpload (1f0c1cd2)
*  #9041, remove Topics.thumbs.resizeAndUpload() (43dc3e3e)
*  #9040 (708b1c33)
*  spec (1949d20a)
*  #9085, dont prevent admins from deleting other users (0f480be6)
*  show errors when user delete fails (ff2aa17b)
*  dont start logout timer if adminReloginDuration is disabled (dd9ed236)
*  #9045, no post usage info if '/files/' path received (efa4eca0)
*  reconnectin no longer fires on socket.io 3 (13d5a144)
*  default values, clamp postsPerPage/topicsPerPage to max (1f32d387)
*  #9081, load raw settings before merging (9da0ed40)
*  #9068 (86f0f82b)
*  remove old utils.slugify tests (10cfdd4c)
*  dont strip tags (792e9e70)
*  #9065, settings v2/v3 conflict (91c20cec)
*  #9063, missing handler for passwordless accounts in admin.checkPrivileges middleware (970ccb5a)
*  timeago in navigation (a389a31b)
*  navigation fixes (163d1a39)
*  cache some jquery objects (73d2f51d)
*  add ev.cancelable (63d08395)
*  #9046, pretranslate string (790f4e45)
*  redirect external with absolute urls (648f6215)
*  external path for subfolder installs (458bfc0f)
* **spec:**  broken link to status component (d31aae16)

##### Performance Improvements

*  don't load thumbs if disabled globally, cache thumb results (2d5a224b)
*  dont build identical langs (bb6cc49c)

##### Refactors

*  topic thumbs lib to topics.thumbs (4fc9da81)

#### v1.15.5 (2020-12-03)

##### Chores

*  up persona (c111bde1)
*  incrementing version number - v1.15.4 (a1b658d9)
*  update changelog for v1.15.4 (252dddfc)

##### New Features

*  add socket connect/disconnect action hooks (fcb10ebd)
*  allow modifiying browser title on ajaxify (698718f8)

##### Bug Fixes

*  #9032 (64ac483d)
*  sso redirect on /login & /api/login (5d00b089)
*  use file lib instead of directly accessing fs (for Assert.path) (3ea66f84)
*  check uid as well (ef6c3b00)
*  #7597, fix progress bar of cover/profile uploads (7e867cf9)
* **deps:**  update dependency nodebb-plugin-spam-be-gone to v0.7.7 (#9039) (c7f2640a)

#### v1.15.4 (2020-12-02)

##### Chores

*  up persona (dde3171c)
*  fallbacks for nodebb.error (82ca3760)
*  fallbacks for nodebb.topic (5b269bc5)
*  remove test code (07fe959c)
*  incrementing version number - v1.15.3 (d1ae08fa)
*  update changelog for v1.15.3 (cf157c9b)

##### New Features

*  #9005, use timestamp in profile/cover images (5f0f476b)
*  #8983, update pin tooltip in topic (954dc5b7)
*  option to allow auto-joining of groups (optionally skip the "request membership" step) (685f3c6a)
*  user notification settings for group.leave event (c1a7968d)
*  add defaults for composer help (0cba2691)
*  #8900, postQueue setting for category (1eb5fabd)
*  #8960, update view count after merge (14bb0a44)
*  use correct code (557f0f56)
*  #8989, convert widget nav to dropdown (4c650aee)
*  add handler for 501 api response (007a3258)
*  add translation key for pin icon label with expiry (12b3aa0d)
*  add pinExpiry and pinExpiryISO to topic data (ad8e7700)
*  add cancel button to pin expiration modal (e1432caf)

##### Bug Fixes

*  #9032, fix login redirect for sso plugins (6f68f4d2)
*  #8962, dont show null for purged targets (86b7f8a5)
*  selector on hooks page (3488daa1)
*  notification on group.leave incorrectly showing "Guest has left X group" (f7558c60)
*  #9019, add missing lang strings (b46d2f93)
*  #9018 (e45b5cba)
*  #9015, add default value for dailyDigestFreq (0f1fc10f)
*  spec (cfb7b113)
*  #8997, don't send notifications if uids already in group (f7c738de)
*  #9002 ban templates not user friendly (4317cdea)
*  #9010, show rest of info even if clusterMonitor priv is not granted (202dcef4)
*  #9007 revoke old sessions after adding (d46740f8)
*  guests dont always have sid (70073653)
*  allow guests to see their replies immediately (a4fe4d3c)
*  privs headers (92d1b8a6)
*  pwd reset test (f25000cb)
*  #8991, logout on password reset, dont verify email if password expired (5080f357)
*  don't show topic search if no search privilege (8adbf54a)
*  #8998, allow guests to use write api to post/reply (3cd0c9a4)
*  guest handles to user displayname as well (5a137a0d)
*  timestamp in queue, add post queue strings (546f58bf)
*  #8992, set email:confirmed for first admin user (7f5efc3e)
*  typo in upgrade script, closes #8990 (80f0750b)
*  #8984, post-queue ux (1269103f)
*  order (9ab4fb41)
*  #8982, copy color on tag rename, dont copy if target exists (d3c04afb)
*  tests (b596e948)
*  api test (77a6dbac)
*  remove dupe (cbbda451)
*  csv test (3de692cd)
*  spec, remove old tests (4afdf8bc)
*  #8969, export csv to file (6e6a7a8f)
*  spec for /tag (88e5cda5)
*  #8980, fix lang string (f4d217d8)
*  #8979 (bf171adc)
*  #8971, disallow flags of privileged users (mods, gmods, admins) (1e7cf1cb)
*  #8974, with password login for approval queue (dadb2527)
*  #8974, dont show wrong message on register queue (fdca8b16)
*  #8973, fix timestamp on ban modal (5c3deb4b)
*  #8968, don't show topic search if search is not enabled (c8554b78)
*  flicker on tooltips if server call takes long time (4c7374ea)
*  missing select/clear all checkbox added to category privileges template (#8967) (a56a6577)
*  use package.name for theme.id (#8965) (ba3981e2)
*  winston usages (b8cafefc)
*  #8957 (414caac0)
*   dont go back after delete account actions (7e6427bc)
*  error message (47a19d67)
*  #8954, clear purged replies and toPids (#8959) (5bb5ec46)
*  #8955, popstate to purged topic should go to homepage (39dae0aa)
*  'already-deleting' error on subsequent account content deletions (21d6225c)
*  #8949, faster upgrade script (93863bb3)
* **deps:**
  *  update dependency nodebb-theme-vanilla to v11.3.8 (#9031) (18707940)
  *  update dependency nodebb-theme-slick to v1.3.5 (#9030) (4085f3e6)
  *  update dependency nodebb-theme-persona to v10.2.98 (#9029) (f7d60c43)
  *  update dependency nodebb-theme-persona to v10.2.97 (42b23a3b)
  *  update dependency nodebb-plugin-composer-default to v6.4.10 (#9025) (43bbfb67)
  *  update dependency nodebb-theme-vanilla to v11.3.7 (#9024) (3f597a55)
  *  update dependency nodebb-plugin-composer-default to v6.4.9 (#9023) (110186b9)
  *  update dependency nodebb-theme-slick to v1.3.4 (#9022) (8dc1437e)
  *  update dependency nodebb-theme-persona to v10.2.96 (#9021) (2c9cd286)
  *  update dependency nodebb-plugin-composer-default to v6.4.8 (#9017) (1f5f2e1d)
  *  update dependency nodebb-plugin-markdown to v8.12.3 (9004319e)
  *  update dependency validator to v13.5.1 (7b39cf4b)
  *  update dependency nodebb-theme-persona to v10.2.95 (#9001) (4ddab380)
  *  update dependency nodebb-theme-persona to v10.2.94 (#9000) (877d8554)
  *  update dependency nodebb-theme-persona to v10.2.93 (#8999) (c44d9d2f)
  *  update dependency nodebb-theme-persona to v10.2.92 (#8995) (346b91eb)
  *  update dependency nodebb-theme-vanilla to v11.3.6 (#8987) (6c980db1)
  *  update dependency nodebb-theme-persona to v10.2.91 (#8986) (8258536a)
  *  update dependency autoprefixer to v10.0.4 (#8985) (fad2d342)
  *  update dependency nodebb-plugin-markdown to v8.12.2 (f5714452)
  *  update dependency nodebb-theme-persona to v10.2.90 (5664807d)
  *  update dependency nodebb-theme-vanilla to v11.3.5 (19fe2493)
  *  update dependency nodebb-theme-persona to v10.2.89 (ad60bc06)
  *  update dependency autoprefixer to v10.0.3 (b2f0d38f)
  *  update dependency benchpressjs to v2.3.0 (6c316be4)
* **openapi:**
  *  spec for c1a7968d23f0809e7012edfccf49b193749998ec (69864b87)
  *  spec for 685f3c6aa6173383d6c31b87ed51cf8ed0ca44ce (1bb75e76)
* **acp:**
  *  #9008 undefined link for "no users browsing" state on dashboard (54dc449f)
  *  #9009 no-users-browsing untranslated on dashboard (286243cd)
* **spec:**
  *  from 6e6a7a8f8a9a75500ba1f336cabc882234212f88 (acb57666)
  *  breaking tests (88a60473)
  *  broken test due to canFlag addition (1b1205a9)

##### Refactors

*  remove old hack (73746bb4)
*  add TopicObjectSlim common schema (22715d54)
*  pin/lock threadTools to use topicCommand, rewrote topicCommand to match categoryCommand signature (15c6f32c)

#### v1.15.3 (2020-11-26)

##### Chores

*  bump persona (720170a9)
*  remove console.log (6a819944)
*  move topic route schema up two levels as slug and index are optional (ae402e21)
*  move category route schema up two levels as slug and index are optional (b3b501d7)
*  up persona (0ffc091b)
*  up persona (2f2f0ab7)
*  up persona (5c9ff18e)
*  add missing plugin hook deprecation warning (98a05e4d)
*  pin autoprefixer to latest (46eb7701)
*  incrementing version number - v1.15.3-beta.0 (28fa03bd)
*  up persona (81984285)
*  up slick (5f2fe883)
*  incrementing version number - v1.15.2 (5867a5b9)
*  update changelog for v1.15.2 (37965d45)
* **spec:**  replace ugly hack with another hack for optional properties (45a4f136)
* **deps:**
  *  update dependency lint-staged to v10.5.2 (db205e2e)
  *  update dependency eslint to v7.14.0 (80404216)

##### New Features

*  add topicOwnerPost #8778 (c037779f)
*  clear reset tokens on user delete (4f37eddc)
*  select/clear all checkboxes in privilege table (#8941) (00e75de7)
*  show ban reason and expiry in write api responses, if user is banned (afb26bfe)
*  automatically unban users in onSuccessfulLogin (6e5ec3f8)
*  #8925, #8924 (3f337b5d)
*  human readable uptime (672d4da0)
*  allow ACP API access to bearer tokens (3b1c03ed)
*  allow pins to expire (if set) (#8908) (046d0b16)
*  #8637 (903e9d82)
*  add displayname into user obj #8637 (#8909) (9ca44e6f)

##### Bug Fixes

* **deps:**
  *  update dependency nodebb-theme-persona to v10.2.87 (#8946) (167ab3a4)
  *  update dependency nodebb-theme-persona to v10.2.86 (#8945) (5af5cb85)
  *  update dependency nconf to ^0.11.0 (58152606)
  *  update dependency postcss to v8.1.10 (5363ebbb)
  *  update dependency nodebb-theme-persona to v10.2.85 (#8928) (abc32d62)
  *  update dependency postcss to v8.1.9 (d1cb5d48)
  *  update dependency postcss to v8.1.8 (b47a470b)
  *  update dependency nodebb-theme-vanilla to v11.3.4 (#8914) (589f7a56)
  *  update dependency nodebb-theme-persona to v10.2.80 (#8913) (38127b04)
  *  update dependency nodebb-theme-persona to v10.2.79 (#8907) (8e1b2458)
  *  update dependency nodebb-theme-persona to v10.2.75 (b9856179)
*  add topic uid to infinitescroll (6771ca15)
*  #8943, session mismatch modal thrown on login (race condition) (d5845169)
*  #8912 (ac734b83)
*  #8918 (e32cd31e)
*  basepath for r.js modules (3af4d13f)
*  test (61c6a762)
*  move meta.getServerTime call to admin namespace (1c0e8c16)
*  add client side check for userslug #8939 (f20c12ee)
*  #8939, fix username change notification getting filtered out (0ca40af8)
*  #8931, fix lang string (cf903e4e)
*  #8932, fix client side error when updating username (95a3f030)
*  bug with Topics.resizeAndUploadThumb not checking for extension validity (eab4ca71)
*  #8933 (2b73a14e)
*  #8929, fix popular, top rss feed urls (77f0bff5)
*  a derp (5dd3b031)
*  spec (b18e7e31)
*  improper handling of scheme-relative URLs in topic thumb logic (4ca62dc4)
*  https://github.com/NodeBB/NodeBB/pull/8685 (5fa09832)
*  on OP edit, call helper method to upload and resize thumb (f33a9185)
*  https://github.com/NodeBB/NodeBB/pull/8759 (9ee1fb49)
*  spec (c2bb6123)
*  guest displayname (1be08b2e)
*  show messages after app load (46acbfda)
*  restart on js changes in vendor (814771bd)
*  #8915, fix queue not being cleared after firing click events (6ef7e867)
*  spec, only call modifyUser on unique user objects (dbd814c2)
*  setting (ae5d4405)
*  spec (8d060065)
*  group userTitles translation escapes (e9585b9b)
*  remove params from error log (965671a9)
* **spec:**  always show thumb in topic response (493c568a)

##### Refactors

*  remove unused require (db1c140f)
*  move API banned response handler to separate internal method (906d7d73)
*  move plugin hook methods to plugin.hooks.* (6e2da996)
*  remove breaking change in pin expiry (ef3df47a)
*  use categoryCommand local method for pin/lock in category tools (#8917) (00aee84b)

#### v1.15.2 (2020-11-18)

##### Chores

*  incrementing version number - v1.15.2-beta.1 (20c05e80)
*  remove debug log (0a0b4661)
*  incrementing version number - v1.15.2-beta.0 (996174a1)
* **deps:**  update dependency smtp-server to v3.8.0 (5f5f0edb)

##### Documentation Changes

*  openapi schema for user/group exist check, session deletion (bcccb331)

##### New Features

*  #5274 (4e9b10ab)
*  #4456 (fb567a7a)
*  #8475, allow flagging self posts (a6afcfd5)
*  #7550, show message if post is queued when js is disabled (120999bf)
*  #8171, add oldCategory if topic is moved (35f932cd)
*  #8204, separate notification type for group chats (b44ddecd)
*  add test for custom translations (7928036a)
*  https://github.com/NodeBB/NodeBB/issues/8147 (1d6bcbeb)
*  invites regardless of registration type, invite privilege, groups to join on acceptance (#8786) (3ccebf11)
*  add nodejs version to issue template (29c2ca94)
*  allow groups to specify which cids to show member posts from (#8875) (8518404e)
* **api:**  account deletion routes for the Write API (#8881) (a0b7a823)
* **deps:**  benchpressjs@2.2.1 (#8887) (d30ea256)

##### Bug Fixes

*  #6407, fix feeds (fa4177c3)
*  navigation highlight (62b62821)
*  benchpress warnings (a87ccccc)
*  benchpress warnings (dfdc0c42)
*  internal helper method hasGlobalPrivilege, DRY (e1d7c4d8)
*  spec (2f4653a3)
*  #8884, remove header/footer cache (e4d2764d)
*  check tid in event handlers client side (9dac9630)
*  #8883 (f14e42d8)
*  #8872 missing admin/menu language key+fallback (fdab76f8)
*  run every hour, dont show message if average_time is 0 (51b7eca1)
*  add back test timeout for exports (b3e00489)
*  pass length to messaging checkContent hook (dc9668e4)
* **deps:**
  *  update dependency nodebb-theme-persona to v10.2.74 (#8905) (5f6137f0)
  *  update dependency nodebb-theme-persona to v10.2.73 (#8904) (c2019b7b)
  *  update dependency nodebb-plugin-composer-default to v6.4.7 (#8902) (b7b1f203)
  *  update dependency nodebb-theme-persona to v10.2.72 (#8903) (bee8cfe4)
  *  update dependency nodebb-theme-vanilla to v11.3.3 (422aa7f0)
  *  update dependency nodebb-theme-persona to v10.2.71 (3b6e71d5)
  *  update dependency nodebb-theme-persona to v10.2.70 (d6dd1cb6)
  *  update dependency nodebb-theme-slick to v1.3.2 (2ce1fcd3)
  *  update dependency nodebb-theme-vanilla to v11.3.2 (9f2d0d42)
  *  update dependency nodebb-theme-persona to v10.2.69 (15810643)
  *  update dependency sharp to v0.26.3 (84d54577)
  *  update dependency nodebb-plugin-mentions to v2.13.5 (dde9f189)
  *  update dependency json2csv to v5.0.5 (b63b7ae5)
  *  update dependency benchpressjs to v2.2.2 (d1e804aa)
  *  update dependency nodebb-theme-vanilla to v11.3.1 (#8878) (85aaeded)
  *  update dependency nodebb-theme-slick to v1.3.1 (bbfb276a)
  *  update dependency nodebb-theme-persona to v10.2.68 (ec70329a)
  *  update dependency nodebb-plugin-spam-be-gone to v0.7.6 (#8877) (45922fae)
  *  update dependency nodebb-plugin-spam-be-gone to v0.7.5 (#8876) (48e82520)
  *  update dependency nodebb-plugin-spam-be-gone to v0.7.4 (#8874) (eab27f23)

##### Refactors

*  client-side handlers for user invitations (d83eb7f8)
*  async/await controllers/index.js (5598130a)
*  less dupe code (8fbe8324)

##### Tests

*  new api test to ensure each path's parameters are defined in context (97842c43)
*  updated test name to be more specific (319cfeaa)

#### v1.15.1 (2020-11-11)

##### Chores

*  incrementing version number - v1.15.1-beta.0 (e033da8a)
*  fallback l10n for admin-settings-api (8368c25b)
* **deps:**
  *  update dependency eslint to v7.13.0 (bcbc0854)
  *  update dependency eslint-config-airbnb-base to v14.2.1 (d227fe9f)
  *  update commitlint monorepo to v11 (90bcfa6d)

##### New Features

*  #8864, add action:events.log (9c5c32d4)
*  show db info side by side (62c0454c)
*  add language keys for admin-settings-api (d32e4e02)
*  #8824, cache refactor (#8851) (f1f9b225)
*  move mkdirp to beforeBuild so it doesnt get called twice (6255874e)
*  group exists API call in write api (d2631922)
*  user exist route in write api (1446cec7)
*  new shorthand route /api/v3/users/bySlug/:userslug (60e1e99b)
*  allow passwords with length > 73 characters (#8818) (512f6de6)
*  #8821, allow guest topic views (9e3eb5d4)

##### Bug Fixes

*  #8869, dont escape category title,description twice (567c5f20)
*  refresh flags list on bulk action success (769aba0a)
*  test breakage from f300c933a50263039a57811f8cc716df39a138b0 (ee4d90f6)
*  remove some unnecessary jquery wrappers (9f7902ef)
*  send back jquery object to keep backwards compat (978f1ee0)
*  use header/footer cache in prod (a0164b1c)
*  add missing maxAge to cache (05a92885)
*  clear header-cache after each suite (3f5f38dd)
*  show msg on fail (255cf43e)
*  spec (fe63c6ae)
*  guest header/footer cache (2e446392)
*  #8846, possible fix (74951f59)
*  winston error message (16d03975)
*  permanent redirect on user api redirect shorthand (6b196a20)
*  user exist route needs no authentication (f2bb42c0)
*  #8840, don't crash if /compose route is called with no query params (c61dee4b)
*  XSS in event:banned messaging modal (f68bce86)
*  #8838, fix chat dropdown timestamps (78ee8332)
*  #8836, truncate fullname (76cd5b0f)
*  #8827, do not require admin:users privilege to ban users (891a1ea2)
* **deps:**
  *  update dependency nodebb-plugin-mentions to v2.13.4 (1460a7a8)
  *  update dependency diff to v5 (72d1b3cd)
  *  update dependency nodebb-theme-persona to v10.2.67 (#8847) (e250c3f1)
  *  update dependency json2csv to v5.0.4 (#8865) (ba7b23ac)
  *  update dependency postcss to v8.1.7 (#8866) (2946bb16)
  *  update dependency nodebb-theme-slick to v1.2.40 (#8863) (20f4fe08)
  *  update dependency nodebb-plugin-mentions to v2.13.3 (#8862) (c18f4491)
  *  update dependency benchpressjs to v2.1.0 (14ba6383)
  *  update dependency benchpressjs to v2.0.9 (381a32ab)
  *  update dependency mongodb to v3.6.3 (#8841) (7e273e77)
  *  update dependency nodebb-theme-persona to v10.2.66 (#8839) (00f90cd9)
  *  update dependency nodebb-plugin-mentions to v2.13.2 (#8835) (064c99cd)
  *  update dependency postcss to v8.1.6 (e0cf9740)
  *  update dependency @nodebb/socket.io-adapter-mongo to v3.1.1 (#8831) (40eb658b)
  *  update dependency @nodebb/mubsub to v1.7.1 (#8830) (7b8a5567)
  *  update dependency postcss to v8.1.5 (9f5ef9d0)
* **#8828:**  web install templates now compiled (#8832) (de5a21f1)
* **acp:**  max-height for plugin menu list (eec630f1)

##### Refactors

*  move session revocation route to write api (f300c933)
*  change Benchpress.parse to .render (#8856) (e128264b)

#### v1.15.0 (2020-11-04)

##### Breaking Changes

*  remove toolsVisible in post tools' menu [breaking] (7e7366be)

##### Chores

*  update changelog for v1.15.0-rc.5 (69f4d5ac)
*  incrementing version number - v1.15.0-rc.5 (4bd2788b)
*  add info log into tests (b6d86878)
*  update renovate config to automatically merge non-major version bumps #yolo (1c8b8ce1)
*  update changelog for v1.15.0-rc.4 (16882941)
*  incrementing version number - v1.15.0-rc.4 (57b49320)
*  update changelog for v1.15.0-rc.3 (2738041b)
*  incrementing version number - v1.15.0-rc.3 (6de7760a)
*  bump persona (e0b67817)
*  update changelog for v1.15.0-rc.2 (c3a7ab54)
*  incrementing version number - v1.15.0-rc.2 (7c084134)
*  update changelog for v1.15.0-rc.1 (4f49b3da)
*  incrementing version number - v1.15.0-rc.1 (943424b5)
*  update changelog for v1.15.0-rc.0 (aab5f018)
*  incrementing version number - v1.15.0-rc.0 (8d48455b)
*  update changelog for v1.15.0-beta.30 (39648722)
*  incrementing version number - v1.15.0-beta.30 (2dd3c962)
*  some optimizations for codeclimate (4a63c20a)
*  update changelog for v1.15.0-beta.29 (63696c40)
*  incrementing version number - v1.15.0-beta.29 (fca176d2)
*  refactor src/emailer.js (75459517)
*  update changelog for v1.15.0-beta.28 (fd975a66)
*  incrementing version number - v1.15.0-beta.28 (57f83162)
*  update changelog for v1.15.0-beta.27 (70673824)
*  incrementing version number - v1.15.0-beta.27 (78fad240)
*  lint notifications.js (4fc84e9f)
*  update changelog for v1.15.0-beta.26 (5e01d288)
*  incrementing version number - v1.15.0-beta.26 (62c44095)
*  up persona (ff8a833a)
*  up persona (4a0f54ae)
*  update changelog for v1.15.0-beta.25 (240a04b4)
*  incrementing version number - v1.15.0-beta.25 (1124d4ee)
*  up persona (032e6001)
*  update changelog for v1.15.0-beta.24 (72ab5ba1)
*  incrementing version number - v1.15.0-beta.24 (23ba071d)
*  up persona (5407bf48)
*  up persona (4c2eab4b)
*  up persona (91133b0f)
*  up persona (bcac0805)
*  up persona (9dc4db1f)
*  up persona (ba70a1bf)
*  update changelog for v1.15.0-beta.23 (e6ea208c)
*  incrementing version number - v1.15.0-beta.23 (61a04eb9)
*  update changelog for v1.15.0-beta.22 (59ee74c2)
*  incrementing version number - v1.15.0-beta.22 (9c9329ee)
*  update changelog for v1.15.0-beta.21 (8089542e)
*  incrementing version number - v1.15.0-beta.21 (966cdc13)
*  update changelog for v1.15.0-beta.20 (1650f303)
*  incrementing version number - v1.15.0-beta.20 (c8e57ec1)
*  update changelog for v1.15.0-beta.19 (9cde5105)
*  incrementing version number - v1.15.0-beta.19 (2eb7c284)
*  update changelog for v1.15.0-beta.18 (b2ca9686)
*  incrementing version number - v1.15.0-beta.18 (e096791e)
*  update changelog for v1.15.0-beta.17 (d6178158)
*  incrementing version number - v1.15.0-beta.17 (f1c28092)
*  update changelog for v1.15.0-beta.16 (e08297ff)
*  incrementing version number - v1.15.0-beta.16 (6043c9cb)
*  update changelog for v1.15.0-beta.15 (f878b92c)
*  incrementing version number - v1.15.0-beta.15 (10b94f9b)
*  update changelog for v1.15.0-beta.14 (5e60d092)
*  incrementing version number - v1.15.0-beta.14 (6ca4b86f)
*  update commitlint config (61a8c6f0)
*  update changelog for v1.15.0-beta.13 (ca8d492b)
*  incrementing version number - v1.15.0-beta.13 (bdd71c51)
*  update changelog for v1.15.0-beta.12 (0a242605)
*  incrementing version number - v1.15.0-beta.12 (b852c9b7)
*  update changelog for v1.15.0-beta.11 (f07ba866)
*  incrementing version number - v1.15.0-beta.11 (c1ce7391)
*  update changelog for v1.15.0-beta.10 (9c34eced)
*  incrementing version number - v1.15.0-beta.10 (f252d4d7)
*  update changelog for v1.15.0-beta.9 (affc7927)
*  incrementing version number - v1.15.0-beta.9 (8dc513da)
*  update changelog for v1.15.0-beta.8 (3b960c3b)
*  incrementing version number - v1.15.0-beta.8 (34bb869c)
*  update changelog for v1.15.0-beta.7 (e449ff9a)
*  incrementing version number - v1.15.0-beta.7 (fd917b8e)
*  update changelog for v1.15.0-beta.6 (a7f03b64)
*  incrementing version number - v1.15.0-beta.6 (a9019cbe)
*  update changelog for v1.15.0-beta.5 (0e90064e)
*  incrementing version number - v1.15.0-beta.5 (81e4c4df)
*  update changelog for v1.15.0-beta.4 (6c4aed8c)
*  incrementing version number - v1.15.0-beta.4 (f2726a6d)
*  update changelog for v1.15.0-beta.3 (11e2ccab)
*  incrementing version number - v1.15.0-beta.3 (39178c2d)
*  update changelog for v1.15.0-beta.2 (d8a9f1c3)
*  incrementing version number - v1.15.0-beta.2 (59b50d0a)
*  update changelog for v1.15.0-beta.1 (aeca19d5)
*  incrementing version number - v1.15.0-beta.1 (4fa57fbb)
*  incrementing version number - v1.15.0-beta.0 (bff80983)
*  incrementing version number - v1.14.3-beta.16 (d9a05035)
*  incrementing version number - v1.14.3-beta.15 (e2a253f2)
*  incrementing version number - v1.14.3-beta.14 (9500871e)
*  incrementing version number - v1.14.3-beta.13 (b5a2e4b6)
*  incrementing version number - v1.14.3-beta.12 (f4c986a7)
*  incrementing version number - v1.14.3-beta.11 (8618c32a)
*  incrementing version number - v1.14.3-beta.10 (fa341714)
*  incrementing version number - v1.14.3-beta.9 (9945c409)
*  incrementing version number - v1.14.3-beta.8 (b5dcce9c)
*  incrementing version number - v1.14.3-beta.7 (2531c44c)
*  incrementing version number - v1.14.3-beta.6 (97088f68)
*  incrementing version number - v1.14.3-beta.5 (a33a8a5a)
*  incrementing version number - v1.14.3-beta.4 (55b3e376)
*  incrementing version number - v1.14.3-beta.3 (5a5abf3c)
*  incrementing version number - v1.14.3-beta.2 (bbab183f)
*  incrementing version number - v1.14.3-beta.1 (2c06f6ac)
*  incrementing version number - v1.14.3-beta.0 (3f87d5f9)
*  update changelog for v1.14.2 (cd94c24a)
*  incrementing version number - v1.14.2 (1e4d683f)
*  update changelog for v1.14.2 (488e69fd)
* **deps:**
  *  update dependency mocha to v8.2.1 (35e725d1)
  *  update dependency lint-staged to v10.5.1 (2fa78e43)
  *  update dependency eslint to v7.12.1 (#8799) (224502d8)
  *  update dependency lint-staged to v10.5.0 (#8797) (1f2eca6a)
  *  update dependency eslint to v7.12.0 (#8791) (3108f628)
  *  update dependency lint-staged to v10.4.2 (#8773) (4bfd0087)
  *  update dependency eslint to v7.11.0 (#8747) (bb85c059)
  *  update dependency lint-staged to v10.4.1 (#8771) (08a240fa)
  *  update dependency mocha to v8.2.0 (#8772) (a471b1af)
  *  update dependency eslint-plugin-import to v2.22.1 (aacf8f22)
  *  update dependency eslint to v7.10.0 (#8687) (119ab719)
  *  update dependency lint-staged to v10.4.0 (2833624e)
  *  update dependency eslint to v7.9.0 (b1d781e8)
  *  update dependency eslint to v7.8.1 (#8597) (39110276)
  *  update dependency lint-staged to v10.3.0 (#8608) (dc1f1db9)
  *  update dependency mocha to v8.1.3 (#8588) (05efeff6)
  *  update dependency eslint to v7.8.0 (#8594) (e1b98142)
  *  update dependency lint-staged to v10.2.13 (efc30e97)
  *  update dependency mocha to v8.1.2 (#8579) (c722b0e5)
  *  update dependency grunt to v1.3.0 (df61d080)
  *  update commitlint monorepo to v9.1.2 (877cdfb9)
  *  update dependency eslint to v7.7.0 (#8564) (f1398da2)
  *  update dependency jsdom to v16.4.0 (#8554) (bb8f7c74)
  *  update dependency eslint-config-airbnb-base to v14.2.0 (#8396) (fde4f110)
  *  update dependency eslint-plugin-import to v2.22.0 (#8390) (788a8bfe)
  *  update dependency mocha to v8.1.1 (fe352eb1)
  *  update dependency eslint to v7.6.0 (#8540) (37418375)
  *  update dependency mocha to v8.1.0 (#8536) (72a78833)
  *  update dependency @apidevtools/swagger-parser to v10.0.1 (#8517) (8c498fa1)
  *  update dependency nyc to v15.1.0 (#8353) (c872bd8b)
  *  update dependency eslint to v7.5.0 (#8463) (b2be329c)
  *  update dependency jsdom to v16.3.0 (#8483) (82ada1bd)
  *  update dependency grunt to v1.2.1 (#8462) (b2dc6d60)
  *  update dependency @apidevtools/swagger-parser to v10 (9e2c3ce0)
* **writeapi:**  cleanup (f6782471)

##### New Features

*  add back error handling for a number of api calls (1afd2150)
*  #8823, remove hardcoded write concern (a338f527)
*  #8817, add login clientside hooks (715775a7)
*  use github actions for ci (#8811) (eddf4a4f)
*  allow mods/admins to see deleted posts on user profile (6e85920c)
*  rearrange buttons on manage/users (27016d22)
*  #8801, disable express compression by default (6ac73ccb)
*  allow passing subset of user settings on update route (ec03af7a)
*  wip, write api tests framework (b156b8b5)
*  add filter:category.getFields (88a07e69)
*  move postercount to topic hash (0db0231c)
*  add free and total mem usage to info (a7b6d0df)
*  new filter filter:teasers.configureStripTags (177a9610)
*  send 'Vary' header when ACAO header set (d68ffea8)
*  add filter.topics.getPostReplies (7a019494)
*  topic reply to use api lib (also + missing file) (21974a77)
*  send 401 for invalid-uid (ede9435f)
*  async/await admin/search (c913900e)
*  ignore test folder (2927509a)
*  send back 403 on no-privileges error (14f9d8b0)
*  refactor groups.delete (8ae1f81c)
*  move groups.join to api (d69e503d)
*  allow plugins to define api routes (9dd3cc04)
*  require https if nodebb is configured with https url (a4ba2389)
*  add nyc config (3326d80c)
*  change user search to use filters array (a2edb86d)
*  add filter (959314c9)
*  require csrf token if not using bearer token (1e07886f)
*  #8662, verified/unverified user groups (682e926c)
*  more fixes (700e1e43)
*  more work (40a05b70)
*  wip admin/users (b038ac07)
*  set unread false for guests (7beaf490)
*  add stack to deprecate message (01265d08)
*  add checkbox tests (d76229c0)
*  add test for serialize/deserialize form (e92d4719)
*  disable write api tests until fixed (ae5fb103)
*  #8734, add slugify module, deprecate utils.slugify (bddfcb58)
*  #8734, move bootstrap-tagsinput to package.json (f16c8268)
*  #8734, move deserialize/serialize to package.json (eab7489e)
*  #5964, #8734 remove colorpicker (948f2614)
*  #8734 remove unused files (c721625a)
*  #8734, move sortable to package.json (cc705e5e)
*  #8734, move bootbox to package.json (300a8755)
*  load jquery-form before using (3b231360)
*  #8734, jquery-ui, jquery-form, timeago (#8748) (fda2aedf)
*  remove unused textcomplete file (59311a63)
*  #8734, remove semver.browser (ae3a231f)
*  #8734, move slideout to package.json (2c1897b3)
*  #8734, move tinycon to package.json (9c157de0)
*  #8734, move visibilityjs to package.json (43589a74)
*  #8734, move nprogress to package.json (a46cbb62)
*  #8734 move r.js to package.json (aa08f882)
*  revoke user sessions above threshold (#8731) (b3ed26ac)
*  filter:settings.get plugin hook (c7d15dfa)
*  topic delete/restore/purge/(un)pin/(un)lock (da25ce4d)
*  add new api page to ACP menu (5fc7e7bf)
*  management of API tokens via ACP (49652e6f)
*  added DELETE /api/v1/categories/:cid route (3072de48)
*  added PUT /api/v1/categories/:cid route (e942ad81)
*  added POST /api/v1/categories route (dc666fd8)
*  added PUT/DELETE /api/v1/users/:uid/ban routes (a5af2dc8)
*  added POST and DELETE /api/v1/users/:uid/follow routes (b5bbcbae)
*  added PUT /api/v1/users/:uid/password route (7aed174e)
*  added DELETE /api/v1/users/:uid and DELETE /api/v1/users (a1ddc210)
*  added openapi.yaml file for BEST documentation (91b79f17)
*  added checkRequired middleware for API calls (7b6d43bc)
*  migrating write-api skeleton into core (ec5c48b1)
*  remove post/header selector (1542a5d7)
*  category filter on post queue (#8710) (5d9a8681)
*  #6594, add top/popular sections to digest email (#8709) (e60357d2)
*  dedicated sorting buttons for plugin ordering in ACP (1761e13d)
*  #8233, search sub categories (54737d30)
*  move service-worker.js into its own file (f4d76f1e)
*  analytics:maxCache setting in ACP (14ba1a6d)
*  #8695, allow sort for guests (ea0f3262)
*  up recommended size to 512x512 + ACP labels for PWA (9c5b6907)
*  upload maskable icon for PWA (6478b32d)
*  show top 5 trending plugins in new tab in Extend > Plugins (b12e8d63)
*  register service worker, #8126 (aa268d5e)
*  add theme-color meta tag for browser address bar (5172d731)
*  basic service worker, minimum requirement for for a2hs; see #8126 (f69697b3)
*  option in ACP to configure notification/email delay for chats (5b427a0c)
*  allow autocomplete to pass optional params to user.search (611f3c61)
*  upon plugin installation via ACP, check against nbbpm first (5ddf7022)
*  up benchpress (8e88ccd6)
*  add row highlighting for popular and unread (2cd5f959)
*  return to previous page and/or category after marking topic unread (48a8ec4a)
*  add missing lang key (bd9b6c99)
*  add number of posters to topic (83d4e7ef)
*  hightlight matches in quick search (f2f3ba49)
*  add loading indicator (d38c8722)
*  allow plugins to override tags and tag counts (81595095)
*  edit test (ccddbb15)
*  add x-posts/x-votes keys (23de5613)
*  allow adding nested replies to a target component (ddc0ac37)
*  hotkey "/" to open ACP search (43571bac)
*  ctr-s for save on privileges page too (763cec31)
*  ctrl-s now saves on settingsv1/v2 forms (80931423)
*  single href (6669b23d)
*  allow passing in container to threadTools (7148be2f)
*  expose calculateTopicPostCount and getChildrenTree (43742437)
*  allow custom req.query.filter on /unread /recent (de824007)
*  fullname search (#8641) (4be693f2)
*  sorted set lex test (9389749b)
*  add topicIndex to category page (c1c617b3)
*  up lavender/slick (34eb1bd2)
*  switch to using topic/select component for merge (f6d56466)
*  undo for posts move (762e9fe8)
*  #8626, new move posts modal (5a40d26b)
*  refactor app.js (5002e0f6)
*  remove global RELATIVE_PATH (19c44861)
*  remove app.template (3cd3b7a1)
*  remove global window.templates (630bac2a)
*  remove app.isConnected, use socket.connected (fddeb5c0)
*  use const/let (6fc31df0)
*  allow nbb to work with cloudflare rocket loader :rocket: (4d665955)
*  move code (53a5f151)
*  #8602, dont send emails to unconfirmed addresses (b6917b9d)
*  add partials/footer/js.tpl (94da9fe5)
*  add missing name to profile image upload (54b49725)
*  add action:user.removeCoverPicture (b0a75922)
*  add user data to action:user.removeUploadedPicture (962446a5)
*  add userData to action:user.delete (9542ef12)
*  force upgrade scripts for test (1b7ba2c8)
*  replace relative urls to absolute before sending email notifs (1e5981c0)
*  add client side action:flag.create (09de364e)
*  additional sorting options for flags (0c203517)
*  new filter hook prior to post queue addition (8cc36de2)
*  add replies to getPostSummaryByPids (a9dfc9a7)
*  add reply count to getPostSummaryByPids (de0f4aad)
*  theme work for #8580, closes #8580 (6e805c1b)
*  allow undo of topic move (abb5e81d)
*  added alert.timeoutfn (cd8e7963)
*  sort dependencies alphabetically (a4dbbc37)
*  up persona (af9f328c)
*  banning a user will resolve their post flags (354e6ccc)
*  theme changes for #8571 (5415c01c)
*  logic for bulk actions in flags list, #8571 (a3a22793)
*  expose global/admin privileges to all routes (4737f937)
*  additional tests for #8569 (e047b72c)
*  flags list sorting, closes #8569 (346db0d8)
*  up theme (bd557af2)
*  allow adding multiple users to group (35a538ec)
*  add filter:group.getOwnersAndMembers (f1e82b64)
*  pass uid into filter:flags.list (9c70b662)
*  added security policy for github (45c8de12)
*  up deps (b97b51a8)
*  one more test (a333cb6c)
*  tests for password change (ecda4ad8)
*  limit privileges column to superadmins only (0903eb4b)
*  use nodebb-scoped bootswatch (12edd18b)
*  use assetBaseUrl instead of hardcoding (6e918858)
*  load timeago strings client-side (558a2d73)
*  +assetBaseUrl, -l10BaseUrl, -requireBaseUrl (9adaccd0)
*  #8550, add upgrade script test (b61a4da5)
*  #8493, plugin helper for standardised link/button injection (0bbb813e)
*  show event/params on error (d6baf5c2)
*  introduce overridable l10nBaseUrl config value (def16f9e)
*  allow multiple empty lines (58933c4c)
*  remove administrator property from public routes (dfabd0a3)
*  focus username when modal is shown (4216c277)
*  add helmet middlewares (774e5d04)
*  more discrete commit-on-save instead of commit-on-change w/ confirm modals (#8541) (a716a552)
*  add ability to search groups in group details page (e7a502e0)
*  use category selector in category page (fb7bb8d4)
*  css fixes (560f3eb1)
*  add privileges shortcut to groups list (91411cc4)
*  allow passing groupName to user.search (f89ec205)
*  #8531, closes #8531 (292d4904)
*  allow direct link to flag from post tools, #8531 (c705e08a)
*  allow changing requirejs base url (c4829fd8)
*  ability to clear cache from acp (bbc7737e)
*  reduce amount of data loaded on acp admin page (8d8117ff)
*  remove require fallback for plugins (303bffdb)
*  remove /assets/stylesheet.css (762b0be4)
*  add node 14 (6250a2e2)
*  make category tools in acp a dropdown (24535a62)
*  series upload (37e56d94)
*  resolve flag on delete/purge/ban/delete account (8bd63f61)
*  8502, don't change topics sitemaps on every reply (e045436c)
*  allow building custom languages during dev (0a9ea91f)
*  add link-plugins.sh (cc86f079)
*  remove deprecated utils.walk (609e37a6)
*  consolidation of flags to reduce flagspam, #8510 (55b0e902)
*  change invalid language codes to default lang (3761f05c)
*  add npx, fixes ghfw (a294e1cd)
*  remove topics.async.getTopicData usage (ce6b20c4)
*  remove deprecated checkGlobalPrivacySettings (0cea7136)
*  remove deprecated isAdmin method (a0da2ba7)
*  remove file.isFileTypeAllowed (2cdb935f)
*  remove deprecated hooks (4eae927d)
*  update readme (9869064e)
*  up node version to 10 (b39e0140)
*  highlight privs row if group is added / navigating from group page (10e4ae62)
*  prevent navigation away from groups page if changes are unsaved (53f6139b)
*  quick access dropdown on groups page to access privileges page (2c83278f)
*  #8524, allow editing category of queued topic (844f2b4e)
*  remove js-enabled (ff3c3435)
*  remove js-enabled.css (ec057835)
*  dont load all subscribers at once (2a5f8ab2)
*  short more info (23a9a334)
*  #8521, allow editing title before posting from queue (2485a550)
*  show language when key isn't found (764969ab)
*  allow searching categories in ACP (1e7397b1)
*  #8509, don't scroll chat to bottom if user scrolled up (320008cd)
*  added quick link to edit privileges on the category edit page (06143ca7)
*  hide some filters behind 'more filters' button (9fb9185f)
*  collapsible daily flags graph (d52d7bdb)
* **acp:**  autocomplete user search for welcome notifications (d40779a4)
* **writeapi:**
  *  user settings API (c26f2b65)
  *  commented-out stub code for file upload (cfee431c)
  *  file deletion route (f870721f)
  *  admin settings update route (a55b3817)
  *  token generation/delete routes, ACP updates (2ec838fc)
  *  post bookmarking (0973feea)
  *  post voting (9942c248)
  *  post delete/restore/purge (414169fd)
  *  post editing (f66c2fb6)
  *  topic tags (1605e5e4)
  *  topic follow/ignore (9be56294)
  *  adding missing files (6096f74a)
  *  topic posting and replying (4c833d0b)
  *  added DELETE /groups/:slug/membership/:uid route (40dc1c38)
  *  added group joining and deletion (952dc211)
  *  abstracted ajax calls out to new api module (d044c322)
  *  added POST /api/v1/groups (ba345e53)
* **openapi:**
  *  schema validation for write api definitions file (87e3f26f)
  *  refactor into indiv. files to match API & tpl routing (ffbf2d6d)
  *  refactor into indiv. files to match API & tpl routing (84f5e4cf)

##### Bug Fixes

* **deps:**
  *  update dependency nodebb-plugin-composer-default to v6.4.6 (b44c7e96)
  *  update dependency nodebb-plugin-spam-be-gone to v0.7.3 (f06d4878)
  *  update dependency nodebb-theme-vanilla to v11.3.0 (0d80190f)
  *  update dependency textcomplete to ^0.18.0 (df5d66e5)
  *  update dependency nodebb-theme-persona to v10.2.65 (0c7d5860)
  *  update dependency jsesc to v3.0.2 (#8802) (c4431294)
  *  update dependency nodebb-plugin-composer-default to v6.4.5 (7d0d0005)
  *  update dependency nodebb-theme-persona to v10.2.63 (b3ca7de0)
  *  update dependency nodebb-theme-persona to v10.2.62 (#8798) (12c590ad)
  *  update dependency nodebb-plugin-mentions to v2.13.1 (#8790) (8353857b)
  *  update dependency nodebb-theme-persona to v10.2.61 (#8794) (9de8497d)
  *  update dependency benchpressjs to v2.0.8 (#8767) (3b88545b)
  *  update dependency sharp to v0.26.2 (#8765) (42aed15b)
  *  update dependency nodebb-rewards-essentials to v0.1.4 (#8764) (25c447df)
  *  update dependency nodebb-theme-persona to v10.2.60 (dcf72354)
  *  update dependency nodebb-plugin-mentions to v2.13.0 (#8758) (411fa8bc)
  *  update dependency nodebb-theme-persona to v10.2.59 (#8755) (cd34bfb1)
  *  update dependency nodebb-theme-persona to v10.2.58 (#8754) (a77ba71e)
  *  update dependency nodebb-plugin-composer-default to v6.4.4 (#8752) (0399ffaf)
  *  update dependency benchpressjs to v2.0.7 (#8733) (f8e2324c)
  *  update dependency nodebb-plugin-composer-default to v6.4.3 (#8750) (666064bf)
  *  update dependency nodebb-theme-persona to v10.2.57 (#8749) (1c94220b)
  *  update dependency nodebb-theme-persona to v10.2.56 (414fe19c)
  *  update dependency nodebb-theme-slick to v1.2.39 (1bc99411)
  *  bump vanilla/persona (944a7e0e)
  *  update dependency nodebb-theme-lavender to v5.0.14 (#8739) (43df4b8e)
  *  update dependency socket.io-client to v2.3.1 (#8700) (ba62ebb6)
  *  update dependency nodebb-theme-slick to v1.2.37 (#8741) (45aceb26)
  *  update dependency nodebb-theme-vanilla to v11.2.21 (#8740) (0c7af502)
  *  update dependency nodebb-theme-persona to v10.2.54 (#8736) (4207dde4)
  *  update dependency nodebb-theme-persona to v10.2.52 (#8735) (70c085ba)
  *  update dependency nodebb-theme-persona to v10.2.51 (#8729) (bae2eada)
  *  update dependency nodebb-theme-persona to v10.2.50 (#8727) (804729fc)
  *  update dependency nodebb-theme-persona to v10.2.49 (#8722) (b01bc2ae)
  *  update dependency nodebb-theme-persona to v10.2.48 (#8721) (01702613)
  *  update dependency nodebb-theme-persona to v10.2.47 (#8720) (04b1daac)
  *  update dependency nodebb-theme-persona to v10.2.46 (#8719) (ba906d7d)
  *  update dependency nodebb-plugin-composer-default to v6.4.2 (#8718) (229421ed)
  *  update dependency nodebb-plugin-composer-default to v6.4.0 (#8716) (b3a24f74)
  *  update dependency nodebb-plugin-mentions to v2.11.0 (#8714) (c95a3898)
  *  update dependency nodebb-theme-slick to v1.2.36 (#8713) (fc2795d3)
  *  update dependency nodebb-theme-vanilla to v11.2.20 (#8715) (2b0deeb7)
  *  update dependency nodebb-theme-persona to v10.2.45 (#8711) (f14b4945)
  *  update dependency nodebb-theme-persona to v10.2.43 (#8701) (1d0eaafb)
  *  update dependency nodebb-theme-persona to v10.2.42 (2a1da61c)
  *  update dependency nodebb-theme-vanilla to v11.2.18 (#8697) (9bdef707)
  *  update dependency nodebb-theme-slick to v1.2.34 (#8696) (3e2816ae)
  *  bump persona (f17d42ed)
  *  update dependency sanitize-html to v2 (1e5621c0)
  *  update dependency nodebb-theme-persona to v10.2.39 (#8684) (d0010c40)
  *  update dependency nodebb-theme-persona to v10.2.38 (#8683) (bb04f149)
  *  update dependency json2csv to v5.0.3 (30aa7e83)
  *  update dependency nodebb-theme-persona to v10.2.36 (#8680) (07172b6f)
  *  update dependency nodebb-theme-persona to v10.2.35 (#8679) (68a5e7e3)
  *  update dependency json2csv to v5.0.2 (5a2adb42)
  *  update dependency nodebb-theme-persona to v10.2.33 (#8675) (abe83773)
  *  update dependency nodebb-theme-persona to v10.2.31 (#8673) (80dbf97a)
  *  update dependency nodebb-plugin-composer-default to v6.3.57 (#8672) (7ecac97a)
  *  update dependency nodebb-theme-persona to v10.2.30 (#8671) (c8a75631)
  *  update dependency nodebb-theme-persona to v10.2.24 (#8663) (72cd5f13)
  *  update dependency postcss to v8.0.6 (#8657) (55921ccf)
  *  update dependency validator to v13.1.17 (#8659) (01232090)
  *  update dependency sharp to v0.26.1 (#8660) (b175d671)
  *  update dependency nodebb-widget-essentials to v4.1.2 (#8658) (dc0a4a49)
  *  postcss and autoprefixer version incompatibility (70d3ad02)
  *  update dependency nodebb-plugin-mentions to v2.10.0 (5ea172f9)
  *  update dependency autoprefixer to v10 (60679481)
  *  bump theme versions (685633d0)
  *  update dependency nodebb-plugin-composer-default to v6.3.56 (#8648) (8089387b)
  *  update dependency nodebb-theme-persona to v10.2.22 (c5ca2609)
  *  update dependency nodebb-theme-vanilla to v11.2.16 (8acdf3f6)
  *  update dependency nodebb-theme-persona to v10.2.21 (ed0469b5)
  *  update dependency nodebb-theme-vanilla to v11.2.15 (134ebba6)
  *  update dependency nodebb-theme-vanilla to v11.2.14 (31635e3e)
  *  update dependency nodebb-theme-persona to v10.2.20 (2a13e583)
  *  update dependency mongodb to v3.6.2 (#8634) (4969c869)
  *  update dependency nodebb-theme-vanilla to v11.2.13 (#8633) (8137cdc2)
  *  update dependency nodebb-theme-persona to v10.2.19 (#8632) (37e37c86)
  *  update dependency nodebb-theme-vanilla to v11.2.12 (#8628) (7ab87072)
  *  update dependency nodebb-theme-persona to v10.2.18 (#8627) (2740655d)
  *  update dependency nodebb-theme-vanilla to v11.2.11 (#8624) (fd6259c8)
  *  update dependency nodebb-theme-persona to v10.2.17 (#8623) (a1d310bd)
  *  update dependency nodebb-theme-slick to v1.2.30 (#8620) (251ea79b)
  *  update dependency nodebb-theme-persona to v10.2.16 (#8618) (0d85dc48)
  *  update dependency nodebb-theme-vanilla to v11.2.10 (#8619) (b52301b1)
  *  update dependency nodebb-theme-vanilla to v11.2.9 (#8616) (69373fde)
  *  update dependency nodebb-theme-persona to v10.2.15 (#8614) (3c0540c1)
  *  update dependency socket.io-redis to v5.4.0 (#8600) (5ba23f24)
  *  update dependency nodebb-theme-vanilla to v11.2.8 (#8599) (97e3543e)
  *  update dependency nodebb-theme-persona to v10.2.12 (#8598) (1bb0896e)
  *  update dependency nodebb-plugin-composer-default to v6.3.55 (#8606) (dfeb65bb)
  *  update dependency nodebb-plugin-markdown to v8.12.1 (27426c06)
  *  update dependency nodebb-theme-vanilla to v11.2.5 (64f4179a)
  *  update dependency nodebb-theme-persona to v10.2.10 (777419b2)
  *  update dependency sharp to v0.26.0 (#8578) (7ca967ee)
  *  update dependency ipaddr.js to v2 (49aeda01)
  *  update dependency nodebb-theme-lavender to v5.1.0 (87674d68)
  *  update dependency nodebb-theme-persona to v10.2.5 (8032c8bd)
  *  update dependency helmet to v4 (#8543) (ad68a338)
  *  update dependency mongodb to v3.6.0 (#8535) (4160e828)
  *  update dependency nodebb-theme-persona to v10.2.4 (#8544) (b30ecffb)
  *  update dependency nodebb-theme-persona to v10.2.1 (#8529) (7a59c2fc)
  *  update dependency nodebb-plugin-composer-default to v6.3.53 (d24a4bd3)
  *  bump themes (b714ed22)
  *  update dependency commander to v6 (#8518) (75fb2a47)
  *  update dependency archiver to v5 (#8523) (f1cc4e29)
  *  update dependency lru-cache to v6 (#8490) (2941b9f9)
  *  update dependency connect-redis to v5 (#8480) (9c17a677)
  *  update dependency nodebb-plugin-composer-default to v6.3.52 (#8522) (ac257a65)
  *  update dependency nodebb-theme-persona to v10.1.68 (#8520) (f06b1cec)
  *  update dependency nodebb-plugin-mentions to v2.9.3 (#8516) (b5df5766)
  *  update dependency nodebb-plugin-dbsearch to v4.1.2 (649c64e4)
  *  update dependency nodebb-plugin-mentions to v2.9.2 (91bdc12a)
  *  update dependency nodebb-plugin-composer-default to v6.3.51 (0e13fd0f)
*  check is banned in buildHeader (4b63f993)
*  undefined call (518d4fa1)
*  missing await (08ff4041)
*  client side crash when creating groups (5a2b14b7)
*  disallow registration attempts with password length > 4096 (c0f699e6)
*  missing await (4818ec37)
*  broken test (87bff6cd)
*  updated commitlint config to allow longer subjects, because nobody anywhere uses an email client that limits subject lines to 72 characters (a53d49a2)
*  restore old behaviour of empty json w/ 401 code in admin middleware (dda5d426)
*  deprecate middleware.isAdmin (15e0731d)
*  post editing not taking plugin hook results into account (4439864c)
*  #8805 define our own name for write API v3 (57ed6be7)
*  removed superfluous assignment (a08fb8e5)
*  createNewPosts to build tpl with ajaxify.data (0b6ef61e)
*  handle ACP category enable/disable states after call success (bff53de0)
*  remove setCategorySort and setTopicSort (a6a52430)
*  sort setting not using correct field name (9082062e)
*  update readme to include psql (2d29e603)
*  breaking test from 0db0231cff097a6e983683e61284a72d42bd594d (cc1c7220)
*  indentation (04185d94)
*  add back derpy 20 second sleep (8e7914ff)
*  missing method in test error output (3ebb3a34)
*  topic object in post editing data return (3c98cd3d)
*  bug where token generation route would fail on null case (618e0983)
*  typo (2e9f27d8)
*  return early for guests/spiders (203db47b)
*  #8789,cache meta.settings (156e1396)
*  spec (7a318352)
*  tests (63e07c94)
*  #8781 (db63f5e3)
*  reset button loading html (1a4c0dec)
*  #8779, fix move all (e6440c0d)
*  allow admins adding users to global moderators (1f43e98f)
*  incorrect logic for post history editable bool (a691be59)
*  [breaking] send configured config URL as origin if not custom (205a1030)
*  #8776 some users unable to restore old versions via history (7a8f7049)
*  #8595, dont save escaped data when renaming groups (b26e9b59)
*  keep sortBy while searching (3ee4936d)
*  autocomplete.user on search page (85cfe49d)
*  spec (cf474ab2)
*  sortby (7bddec93)
*  #8774 (b3619d3d)
*  #8732 (c107649b)
*  #8630, sort extra deps (e362c342)
*  missing doTopicAction, fix wrong api params (e78c498e)
*  test (8fd3c044)
*  appropriate 404 handling for write API calls (b6cce75d)
*  redis hget (b2ff1594)
*  reimplementing isPrivilegedOrSelfAndPasswordMatch (e98285db)
*  socket user bans (3f347baa)
*  broken tests from api change (222b4c95)
*  tests (7d86be2b)
*  handler for group.join (51a60d3d)
*  add missing file (d07f0081)
*  #8768 (4418ff07)
*  api bug where user profile editing continued even if not allowed (cc6e995e)
*  module build (bae0f343)
*  tests (b295d15e)
*  csrf token only on non-GET routes (20bb9c7e)
*  avatar selector (4b9444f1)
*  test (e6ea71c9)
*  timestamp (8c6a5591)
*  #8763 (331d236f)
*  lastonline again (a481024d)
*  caret (71d82ec8)
*  lastonline values (97628e2f)
*  upgrade script (1289c105)
*  cant join system groups (59bbede8)
*  tests (a411df13)
*  update server param to /api/v3 (0e0f1506)
*  typo (c68653d0)
*  testing openapi write tests (7aa4d104)
*  enable tests (7b2301ff)
*  test fix for write API (54e6003a)
*  password reset to invalidate all existing reset tokens for that uid (30b3fedc)
*  show more lines (ba2e1c4c)
*  #8756, pass missing req to mock (30d6a2b8)
*  #8757, allow all slashes in category route (1ee93848)
*  timeago test for dev/prod (7db224f6)
*  timeago test (cecdd291)
*  undefined api require, @julianlam (931d44b5)
*  watch tooltip (e2d407b7)
*  module name (aedd28e0)
*  pin sortablejs (8f436eb8)
*  admin jquerui requires (75c96686)
*  timeago locale switch (8c019a6a)
*  category RSS feed was displaying deleted topics (9a5b8a79)
*  #8734 make nprogress module (45e8a4d5)
*  regression caused by 754595172549ba39b406bd36fc3387d95782d84f (8af30a51)
*  dont allow adding duplicates to privileges page (12c8b1c2)
*  #8728, dont add admins to table (f259063f)
*  remove debug log (675a62da)
*  tests (adcadbb2)
*  bad merge w/ category ACP page (cb9369f1)
*  bad logic in group assertion middleware (8e89f34d)
*  errors thrown if no password sent in to profile edit route (7757f965)
*  bug where middlewares seemingly ran in parallel (549ca110)
*  follow route to match spec (db5c5b2c)
*  missing one property in openapi doc (af2e424f)
*  error handling with POST /api/v1/users (d8879d21)
*  use POST call for user creation in ACP (58043e07)
*  user creation POST route returns user data, updated openapi spec (bba2a463)
*  selector, so it doesnt effect suggested topics (7138d433)
*  use proper api url (264818e5)
*  tests, get latest release tag recursively (8eb62e22)
*  use app.parseAndTranslate instead of benchpress.parse (fc603a53)
*  sorted list delete button (20e0cc5c)
*  unable to register async method as response hook listener (dde5b6b8)
*  dont allow sorting pinned topics on recent (b955fd36)
*  use console.info instead of console.log for sw registration (3c7f79cb)
*  spec (7cd83b9a)
*  spec (6924eb6c)
*  test (cb2f6f7c)
*  dont let mods load postqueue for a cid they are not a mod of (7bf6d3b8)
*  show disabled categories in admin&mods (2ea9768e)
*  prevent mutiple highlighted rows on category/topic pages (60afb110)
*  spec (fbd85680)
*  do not show TOC if fewer than 2 headings (f1de084d)
*  params cached in autocomplete module (caa8c00f)
*  #8686, deprecate `plugin.json/library` (#8705) (017af63f)
*  updating minimum node version in readme (d3951ebe)
*  update "install plugins" link to go to the download tab (5441651e)
*  overflow on submitPluginUsage field (c56236f0)
*  #8699 tags route is case sensitive, though tags are not (38f88fc5)
*  early button/anchor clicks do nothing (8437130e)
*  early button/anchor clicks do nothing (966d3f76)
*  error on `reset -p` if plugin is not active (7f58e3ab)
*  manifest test + remove duplicate test (bf3c1c08)
*  typo in getCompatiblePlugins (07af6213)
*  typo (54705cc4)
*  manifest - use absolute URL for start_url (31528a52)
*  prefer webmanifest extension over json (46800b66)
*  update notification delay ACP help text (4c1e717b)
*  #8681 change owner modal's search should check if user is banned (b6f2f0e5)
*  add img-responsive to post queue post items (f8032cd0)
*  language key in reset password (2ad33058)
*  issue where the last flag filter could not be removed (0fffe289)
*  multiword match highlight (f8ef380b)
*  tooltip placement on navbar search (82ab6cd3)
*  rogue tooltip on navbar profile icon (683c01b0)
*  #8580, @julianlam (445a840b)
*  topic count on category page if filter is author (bbf6889e)
*  match api when modifying ajaxify.data.deleted (int, not bool) (703ac1b6)
*  lock/unlock toggle issue (9a7c3c68)
*  #8665, trim email before checking validity (ac43cd8b)
*  editing posts saving uncessary data (e72fe259)
*  api spec (654d5830)
*  #8640, add bookmarks to intFields (4f14dc7a)
*  change user tooltip container to content (02a48e1c)
*  auth tests (fe2dc310)
*  #8656, rename /api/me to /api/self (af43f0e4)
*  add user tooltips to body (047c4148)
*  tests (22cd2654)
*  use correct topic count for category (220297d5)
*  clear old value on focus (42298fe6)
*  skip elements if they dont have proper index (c9c9dd2f)
*  call to reskin (99f24c59)
*  move necro-post to be in-line with posts (44309ee6)
*  tests, because redis is TOO FAST (4fca7938)
*  remove old test (5e8c3761)
*  client side crash if there are no topics (a8e18fdb)
*  #8418 (38d3982b)
*  typo (08912361)
*  tests (65d049c6)
*  check if unread_tids are followed (2d5bd153)
*  openapi (e9094094)
*  dont use hardcoded fontawesome icons for lock pin (632793b0)
*  #8629 and change undo timeout to 10 seconds (65d94a3b)
*  alert_id selector (2bebdf01)
*  use text-right (a78e1df9)
*  remove lang keys, remove sounds menu (a34b685c)
*  lavender version (8a752364)
*  tests (e3a0b4b1)
*  wider widget area (4bace773)
*  bypass nbbpm for now (33c1bd5f)
*  #8432, add CSP frame-ancestors (46ab2711)
*  allow setting maximumAboutMeLength to 0 (4588e521)
*  additional commit for CF rocket loader (a38784f5)
*  stack trace (4031a8ca)
*  #8604 (a2638976)
*  don't toggle elements if there is no inputEl (57f67e2b)
*  don't crash on outdated redis instances (896fe9d6)
*  update post-queue hook names (0e58d2b8)
*  accept/reject in post-queue instead of accept/delete (694f4b2b)
*  new openapi def for replies addition (b5871275)
*  #8582 (9f9164a9)
*  debug logging :dog: (fb3b4a02)
*  ip-blacklist not working after #8580 (56101ae5)
*  ip-blacklist not working after #8580 (c681b4b2)
*  post-queue not working after #8580 (dc5bd760)
*  #8411 missing language sources for ip-blacklist/post-queue (a93e1955)
*  removed invalid options for the sendmail transport (#8576) (2b785628)
*  missing localisation for topic move error (bacee6b4)
*  select all checkbox does not re-enable bulk actions button (5d60dce3)
*  dupes in unread followed topics (55533b11)
*  wrong data passed to getCategories (39f4bbaa)
*  openapi spec (4f7cfd53)
*  api spec (c4ad14cb)
*  username, email history disappering if content was deleted (91d9333a)
*  up composer (9fd37753)
*  package-install clobbering scoped nodebb plugins (840cb510)
*  empty "manage" menu showing in ACP (4b0cb26b)
*  hide nodebb version in ACP for non-superadmins (cc268605)
*  change how admin middlewares are exported (f00595b3)
*  one less return, to appease codeclimate (ae68a254)
*  inability to access /admin if not superadmin (03bd76de)
*  #8560, fix old upgrade script (29e3ab24)
*  use promises in privilege save (9cbe9389)
*  overzealous click handler on flag list row (7a5daff4)
*  +comment, -debug log (9608b44f)
*  multiple alerts in the same millisecond overwrite each other (589216e7)
*  reintroduce 20s delay for api tests (56393795)
*  client-side error in flags/detail (b2271eb6)
*  #8570 (7daba7dd)
*  sorting the flags list by newest is not considered a filter (3efe2362)
*  flag list tests due to breaking change in API (360aa00d)
*  no-widgets messaging in ACP + copy (334be113)
*  #8568 perPage not acting like a filter (cabe62a0)
*  #8562 (31c2b7d9)
*  progress bar clobbering upgrade script name (2adae879)
*  tweak upgrade script progress bar to only update 100 times in total (ac75c9a0)
*  navigation title unescape upgrade script tweak (80a2a700)
*  new language key for error handling (7456a0e3)
*  upgrade scripts not run properly if schemaDate is present (de8eebbd)
*  #8556, catch errors from admin check (bfaf648e)
*  upgrade script for 1.15.0 (32682738)
*  improper targetUid check during password change (16cee1b0)
*  #8547, remove old deps during upgrade (#8557) (1d170e0c)
*  #8558, only navigate if user is in same topic (79e847d4)
*  upgrade script (231d34d0)
*  don't allow duplicate upgrade script names (8887f0ed)
*  tests (d6297b28)
*  send hard 404 instead of soft 404 for missing modules (9f3b7811)
*  #8549 send 308 Permanent Redirect on topic/category shortlinks (68f8d6e3)
*  remove default helmet (c39c5113)
*  map instead of forEach in privileges save (a7071bb8)
*  remove duplicate configuration for helmet-hsts (0f10e083)
*  don't process invalid topics, fallback to 0 score (335169f2)
*  tests (6924a222)
*  #8539, enforce content checks for post queue (bb224184)
*  bug; additional reports could be added by the same user repeatedly (0f2b6f1f)
*  #8538, go to first unread instead of last read (519e6659)
*  #8533, validate and retry password during setup (0d698a07)
*  #8534, dont show modal on search (9e80a9ef)
*  language string (9f346c53)
*  api test (8415d2f0)
*  tests (9df871be)
*  tests (69fb1527)
*  reverse uid checks (7331faed)
*  acp view category button if category is a link (2dfe9d49)
*  remove old test (52718ce0)
*  #8515, fix login redirect on subfolder (5e5815f0)
*  tests (f48d1556)
*  #4695, remove new notif alert (fd4c3cda)
*  too small sortable handle for ACP>Manage>Categories (8473e165)
*  less fixes for category dropdown (db07dd85)
*  move check inside lock (57135761)
*  #7351, display less errors with location and error message (d1cb405d)
*  use shorter git url, #8527 (345fd72b)
*  cursor for category select (4c90fac4)
*  api docs for admin/manage/groups/x (8769e28b)
*  edge case in test (b9cff577)
*  api tests (42af4b57)
*  #8500, allow regular users select topics on unread (7260646d)
*  don't crash if content is undefined (4658121a)
*  crash if csrfToken does not exist (a3c8d456)
*  try again (6f889c9c)
*  more tests (a46adb3f)
*  tests (65395ae5)
*  tests (72c60d19)
*  tests (67ca5e32)
*  #8508, dont allow moving topics if not moderator of target category (36531511)
*  composer textarea placeholder l10n /cc @pitaj (1e14af45)
* **openapi:**
  *  final fixes to schemas (14e5c24e)
  *  users.yaml (16873800)
  *  moved write-api to public/openapi (49994f3a)
  *  test for new trending plugins in ACP (3fbddbe2)
  *  tests (d935f036)
  *  new api definition (8ff09630)
* **writeapi:**
  *  more tweaks to schema files (b2e9e3e0)
  *  fix components, + tag object schema (9f9e3c15)
  *  missing files for tests (a4f3270f)
  *  normalizing data (1392d064)
  *  tests (b092f65d)
  *  added examples to all parameter objects in schema (93f65f89)
  *  tests (ebcb664b)
  *  tests (229eb2c2)
  *  tests (b8703ba9)
  *  tests (41f55b7a)
  *  calls to profile editing routes 200 even if user DNE (8e7baac6)
  *  client-side group join API call (68ecf41e)
  *  authenticate middleware logic to work better with await (fd67355b)
* **refactor:**
  *  patching helpers.tryRoute for API routes, some re-org (d15d9e44)
  *  merging write-api auth middlewares with core middlewares (f6433ef2)
* **bug:**  #8611, custom route logic corrected (#8612) (64a457a4)
* **docs:**  updating changelog (6e34b9ef)

##### Performance Improvements

*  reorder async calls (93bdfe2f)

##### Refactors

*  simpler check in user.blocks.filter (a02ae6f5)
*  remove usage of middlewares (266d7587)
*  remove /users/{uid}/settings/{setting} route (aa8faf58)
*  api test suite to accept methods other than GET (843aff58)
*  remove unnecessary wrapper (a512d994)
*  remove console.log, extra require (75024c35)
*  show more lines of stack trace (ea31f505)
*  posts api (d9a16855)
*  post restore/delete/purge (272e73da)
*  merge post.edit (9738e202)
*  deprecate socket.emit('users.search') use api route (2279e372)
*  api categories (083c74e0)
*  remove sockets.reqFromSocket (bc880ee0)
*  topic follow/ignore to use api lib (9ee3cb9b)
*  topic tools' actions to use api lib (68d6818b)
*  topic creation to use api lib (40598b36)
*  setupApiRoute signature (bf480ee5)
*  remove unused middleware (688d7a2c)
*  user bans to use api lib (2d252f2f)
*  move groups.leave, fix some tests (e367c540)
*  change password/user follow to use api lib (960e925e)
*  user deletion to use api lib (430e7f58)
*  socket profile update to use api lib (77481947)
*  socket profile update to use api lib (31ae8a83)
*  user create and profile update to use api lib (23086dae)
*  use single function for api code (5e2caf19)
*  async/await src/user/approval (43afe7ff)
*  async/await install/web.js (3881ac30)
*  async/await (1fd2eba6)
*  use app.render (d89477ca)
*  api module (3673accd)
*  api module returns promise, error-first cb if cb passed in (a784d10f)
*  remove unused search call (dd7424e5)
*  switch to using slugify module (dc29f4dc)
*  require style (c954db84)
*  middleware.assert.* (8ecef7b8)
*  rewrite modules/api.js in AMD style (a905d7f0)
*  remove posts.tools.purge (ed092bf6)
*  shared constants (#8707) (1aa336d8)
*  post edit (16039b11)
*  expose new method for appending moderation note (29b357bc)
*  socket posts delete/restore/purge so tid is not necessary (#8607) (f743f920)
*  ip-blacklist and post-queue language files (4dc6e64a)
*  moved ip-blacklist and post-queue styles/tpls to themes (b6b94a56)
*  changed way middleware was exported (cf2f1e95)
*  remove util.promisify calls (01899459)
*  change pwd change logic (846b7d24)
*  rewrite src/upgrade.js with async/await (33c5988c)
*  change incrementViewCount and markAsRead to async/await (2c35d0ba)
*  for codeclimate (2ee62483)
*  rewrite src/install with async/await (776e34a8)
*  removed rather redundant flag reporters zset (6c00ec84)
*  flags object in post tools (fcdbdf63)
*  pass only needed data (f1974fb9)
*  startup (c54b6b9c)
*  get rid of bind calls (af91c26a)
*  setting codeclimate to A (bc26883a)
*  make msg pretty (8ddc8dd1)
*  flag sanity checks, +feat: flag limits (e3e55f25)
* **writeapi:**
  *  update route prefix to api/v3, default error option (3ea1aa47)
  *  post.tools.purge no longer a method (5e2a3ea6)

##### Code Style Changes

* **openapi:**
  *  break write API routes into individual files (dbb4cfe9)
  *  move schemas and responses out of write.yaml (ffac3c79)
*  updates to openapi files (2928b9b8)
*  allowing some es6 features client-side (e1c40b27)
*  linting (cdb79488)

##### Tests

* **openapi:**  missing commonprops addition (0dc55bbc)

#### 1.14.3 (2020-07-08)

##### Bug Fixes

*  improper targetUid check during password change (c2477d9d)

#### 1.14.2 (2020-07-15)

##### Chores

*  incrementing version number - v1.14.2 (1e4d683f)
*  update changelog for v1.14.2 (488e69fd)
*  up theme (63fb2ad7)
*  incrementing version number - v1.14.2-beta.1 (9d1465d0)
*  up theme (15aabfd3)
*  up theme (599c5015)
*  incrementing version number - v1.14.2-beta.0 (fca4ee31)
*  incrementing version number - v1.14.1 (31203b16)
*  update changelog for v1.14.1 (d4c16086)
* **deps:**  update commitlint monorepo to v9.1.1 (0ca7e28a)

##### New Features

*  logic for flag note editing, #8499 (14417209)
*  logic for flag note deletion, #8499 (f85a45c7)
*  #8460, export groups members as csv (00d39fb3)
*  pass connection options to socket.io-adapter-mongo (393f19b4)
*  #8023, allow wildcard search for uid/email (3dcf5387)
*  up composer (6235b31c)
*  #8427, daily downvote limits (c513b88d)
*  warn user if whitelisted tags are less than minTags (4adbf87c)

##### Bug Fixes

* **deps:**
  *  update dependency nodebb-plugin-mentions to v2.9.1 (c54287fe)
  *  update dependency nodebb-plugin-mentions to v2.9.0 (7730e7da)
  *  update dependency nodebb-theme-persona to v10.1.62 (#8485) (4e9743ab)
  *  update dependency nodebb-plugin-composer-default to v6.3.49 (#8479) (ab244ca6)
*  #8499 (65240a17)
*  #8500 (5e984d10)
*  invalid session error modal during logout (2286ee2a)
*  #8488 (b3a88331)
*  category search in selector (46a66863)
*  groups.updateCover (73ddf1cb)
* **docs:**  bad changelog (60bf488f)

##### Other Changes

*  update changelog for v1.14.2" (e085c846)
* flag.showModal on flag modal appearance (3379d65f)
* NodeBB/NodeBB (2fba0a14)
*  update changelog for v1.14.1" (26c74409)

#### 1.14.1 (2020-07-08)

##### Chores

*  incrementing version number - v1.14.1 (31203b16)
*  update changelog for v1.14.1 (d4c16086)
*  incrementing version number - v1.14.1-beta.3 (e8ecef6b)
*  incrementing version number - v1.14.1-beta.2 (b8d9b6b1)
*  incrementing version number - v1.14.1-beta.1 (be85123a)
*  incrementing version number - v1.14.1-beta.0 (c279875a)
*  incrementing version number - v1.14.0 (bb73d6a4)
*  update changelog for v1.14.0 (cffae0f1)

##### New Features

*  add tools to recent/unread (#8477) (658dd03b)
*  fire new hooks on chat message editing (4f51838d)
*  add back redis tests (bdc4d9e7)
*  remove redis test (8461a179)
*  use covered query (057b783d)
*  add js-enabled.css to list of preloaded css files (da29b947)
*  zscan (#8457) (723fe8e8)
*  fix blocksCount not being returned on user profile (bd228d5e)

##### Bug Fixes

* **deps:**
  *  update dependency nodebb-theme-persona to v10.1.60 (#8478) (14eafcb6)
  *  bump nodebb-plugin-composer-default to 6.3.48 (943a344a)
  *  update dependency nodebb-plugin-dbsearch to v4.1.1 (#8476) (9f06f12c)
  *  update dependency nodebb-plugin-composer-default to v6.3.47 (#8473) (857900f1)
  *  update dependency nodebb-plugin-dbsearch to v4.1.0 (#8471) (eb51cfd4)
  *  update dependency nodebb-theme-persona to v10.1.59 (#8468) (ee38e05d)
  *  update dependency nodebb-widget-essentials to v4.1.1 (#8466) (519e035d)
  *  update dependency @nodebb/socket.io-adapter-mongo to v3.0.1 (#8464) (412ca4ae)
*  #8474 (c2ca02df)
*  show stack properly (7b04d897)
*  editing chat messages does not go through content sanity checks (9a6b87d2)
*  don't show blocked users under nested replies (d6c619cf)
*  tests (87dd6c83)
*  handle scan/zscan returning duplicate elements on redis (746222d6)
*  #8467, fix url to merged topic in subfolder installs (9eb748b9)
*  openapi (5f1865c0)
*  openapi (65c0adc7)
*  dont allow searching by email/ip if not privileged (ac6b571e)
*  missing backgroundImage #8386 (fef04fcf)
*  dont allow searching by ip/banned/flagged for regular users (02ac44cc)
*  admin privileges client-side regression (f3441fce)
*  only add blocksCount for self and admins (59a2ace6)
*  tests (fd20e5c6)
*  better changelog (f992af05)
* **tests:**
  *  another shot in the dark (8853cd1a)
  *  shot in the dark (9458d90b)
* **openapi:**  tests (c468942f)

##### Other Changes

*  update changelog for v1.14.1" (26c74409)
* //github.com/NodeBB/NodeBB (0d9461b1)
* //github.com/NodeBB/NodeBB (ace312e0)
* post.changeOwner (b60e1cbf)

##### Reverts

*  bad changelog (a761e31f)

#### 1.14.0 (2020-07-02)

##### Chores

*  incrementing version number - v1.14.0 (bb73d6a4)
*  update changelog for v1.14.0 (cffae0f1)
*  bump persona (19f9af94)
*  latest translations and fallbacks (22879633)
*  incrementing version number - v1.13.3 (ee583e80)
*  bump persona (d2bd746c)
*  incrementing version number - v1.13.2 (beafd613)
* **deps:**
  *  update dependency smtp-server to v3.7.0 (e80100b5)
  *  update dependency eslint to v7.3.1 (#8417) (33492744)
  *  update commitlint monorepo to v9 (569b7664)
  *  update dependency lint-staged to v10.2.11 (157e7444)
  *  update dependency lint-staged to v10.2.10 (102a6004)
  *  update dependency mocha to v8 (#8393) (f4bace03)
  *  update dependency eslint to v7.2.0 (cd1375cb)
  *  update dependency eslint-plugin-import to v2.21.1 (4b577a52)
  *  update dependency lint-staged to v10.2.9 (#8369) (124125f7)
  *  update dependency lint-staged to v10.2.8 (331b1a85)
  *  update dependency lint-staged to v10.2.7 (d1df0826)
  *  update dependency mocha to v7.2.0 (ecaa9b76)
  *  update dependency eslint to v7.1.0 (e62d892a)
  *  update dependency lint-staged to v10.2.6 (78d562b3)
  *  update dependency lint-staged to v10.2.4 (a26011e7)
  *  update dependency eslint to v7 (28df9aba)
  *  update dependency coveralls to v3.1.0 (5ed4a108)
  *  pin dependency @apidevtools/swagger-parser to 9.0.1 (51eccef5)
  *  update dependency husky to v4.2.5 (30a25983)
  *  update dependency husky to v4.2.4 (0a650118)
  *  update dependency lint-staged to v10.1.3 (a9e68639)
  *  update dependency nyc to v15.0.1 (#8231) (a3789e28)
  *  update dependency lint-staged to v10.1.2 (#8235) (e1919c90)
  *  update dependency lint-staged to v10.1.1 (944a6f58)
  *  update dependency lint-staged to v10.1.0 (30bd233b)
  *  update dependency eslint-config-airbnb-base to v14.1.0 (811c3aee)
  *  update dependency jsdom to v16.2.2 (c5a7242d)
  *  update dependency eslint-plugin-import to v2.20.2 (b92c1600)
  *  update dependency lint-staged to v10.0.10 (0ad4b556)
  *  update dependency coveralls to v3.0.11 (14458087)
  *  update dependency smtp-server to v3.6.0 (22681945)
  *  update dependency mocha to v7.1.1 (#8215) (c5356541)
  *  update dependency grunt to v1.1.0 (#8214) (b0864e7c)
  *  update dependency husky to v4.2.3 (#8162) (776fe9d2)
  *  update dependency lint-staged to v10.0.8 (#8180) (13d8f6f1)
  *  update dependency eslint-plugin-import to v2.20.1 (#8081) (4cdb3131)
  *  update dependency jsdom to v16.2.1 (#8165) (fbd95a50)
  *  update dependency husky to v4.2.2 (#8160) (f4ed35c9)
  *  update dependency jsdom to v16 (#8114) (1037de02)

##### Documentation Changes

*  updated changelog (146388aa)

##### New Features

*  polish for user blocks UX (6cb31791)
*  #8450, next/prev link tags on /unread /recent (eb9704f8)
*  allow flagging of user acounts from post tools menu (6931f29d)
*  closes #8440, allow configuring max topic count (e09ab3dc)
*  add missing translation key (bffb830d)
*  #3783, min/max tags per category (c718b729)
*  use tags partial instead of post_bar (0482fb29)
*  hide elements if search element is a direct child of dropdown (4f6b6c56)
*  increase wait (6aecc177)
*  move export functions into child processes (8383992d)
*  display stack trace on winston.error (e80379dc)
*  show more relevant snippets (f70d1648)
*  #8412 breadcrumbs for ip-blacklist/post queue/flags (35a06a84)
*  show editor in post diffs if available (f909ed25)
*  #8408 flags' quick assignment (d5af9769)
*  bump themes, closes #8406 (cb5ba76b)
*  allow post diffs to be restored, #8406 (58b3d608)
*  add missing translation (3a80a165)
*  up composer (96cb94dc)
*  more search changes (6349fa03)
*  more merge/search fixes (4b38533b)
*  merge changes (bb3aa540)
*  more search & merge fixes (5fd05dc9)
*  merge improvements wip (c4bdeae0)
*  #8387 expose global and admin privs to flags detail page (4acb3fb2)
*  redirect /me to user profile (3be4d5f7)
*  #8384 options to delete account, content, or both (4d60eac6)
*  account content deletion, closes #8381 (67aca822)
*  add missing language files for #8347 (656b391f)
*  privileges for Admin Control Panel (#8355) (a82e9bd7)
*  add buildHeaderAsync (#8367) (842b8abb)
*  #8360 flag quick actions for delete/restore/purge (8ea16348)
*  #8349, remove user posts from queue if user is deleted (5a2b5154)
*  up plugins (5b009e07)
*  add results into results container (9ffcb6f7)
*  quick search changes (f12d448e)
*  move quick search into search module (bb1a56f0)
*  fix session mismatch errors by clearing cookie on logout (#8338) (5781a2dc)
*  add getSortedSetMembers (0009f54e)
*  add privilege give/rescind hooks (#8336) (ec5582b5)
*  filter followed tids by category (f3afba61)
*  use getSortedSetsMembers to load followed tids (1b9e8928)
*  add batch size to cursors (a015af4a)
*  up cache size (9600ede5)
*  tweak intersection code, add tests (4ee3543e)
*  change to contains to match scoped modules (6108064e)
*  improve grunt restart/rebuild speed (cb662e15)
*  don't overwrite req.query.lang if it exists (4263efa0)
*  convert queries so they used indices directly (12c6bc2e)
*  cookie SameSite property (ae2db423)
*  if only one value is passed used faster function (2587112f)
*  closes #8316, add more data to export profile (f0323b6c)
*  throw error if uid is missing for update (1d3fa3bc)
*  ignore mongodb playground file (a219285e)
*  parse quick search tpl even if no results (765b8156)
*  match hook property to topic property (0e58fa33)
*  add methods for adding/removing tags from topics (bfad4572)
*  write-api update, WIP (9fd5c439)
*  closes #8308, edit post notif for watched topic posts (a73c755b)
*  add null tests for sorted sets (edf9fe3b)
*  Add hooks for user blocks (#8296) (c4545381)
*  allow activating additional plugins for testing via config.json (a969c5ce)
*  move plugin tests to separate file (3a23ddab)
*  remove node14 for now (a72e4429)
*  reduce infinite scroll area (3fcbd691)
*  manifest.json improvements from #8126 (#8264) (6e5ebb61)
*  show error if json is invalid (15345627)
*  moved component specs into separate files (cd506557)
*  added UserObject, UserObjectFull, Breadcrumb, Pagination component (64d79fe5)
*  added some summary and descriptions (ae3e90d6)
*  add some descriptions (442c018e)
*  common schema (eade13f9)
*  openapi component (1af5507a)
*  add page query param to docs (9987813f)
*  tag route doc (bbddaadf)
*  local redoc view on development mode only (1136a369)
*  added auto-generated, slimmed-down openapi 3.0 file for read api (7b155dab)
*  add parent cids to body class (23571224)
*  add 2 hooks for modifying privileges (d080c7b0)
*  add user ip to admin/dev/info (5e91a67e)
*  change option name (cba5b23e)
*  add no-build to ./nodebb setup (476f6717)
*  add awaitable socket.emit (4083a6e3)
*  settings sorted list (#8170) (3c9689a5)
*  guard against accidental ommision (79737c53)
* **docs:**  updated changelog (87c1687d)
* **openapi:**
  *  merging openapi-test branch into master (8387178b)
  *  move all commonprops out for commonprops component (65c78de6)
  *  added template to commonprops (2425f453)

##### Bug Fixes

* **deps:**
  *  update dependency nodebb-plugin-composer-default to v6.3.46 (5a713d85)
  *  update dependency nodebb-plugin-mentions to v2.8.3 (#8449) (bbd85049)
  *  update dependency nodebb-plugin-mentions to v2.8.0 (d40720f9)
  *  update dependency nodebb-plugin-composer-default to v6.3.44 (#8436) (c1991abe)
  *  update dependency winston to v3.3.3 (#8431) (6a8f54fd)
  *  update dependency nodebb-theme-persona to v10.1.55 (#8434) (a860a793)
  *  update dependency nodebb-theme-vanilla to v11.1.30 (#8435) (272b4992)
  *  update dependency nodebb-theme-vanilla to v11.1.29 (#8429) (b5a68a44)
  *  update dependency nodebb-theme-persona to v10.1.54 (#8428) (3ffb6fde)
  *  update dependency winston to v3.3.2 (54310d69)
  *  update dependency nodebb-plugin-spam-be-gone to v0.7.2 (11244348)
  *  update dependency winston to v3.3.1 (#8421) (fd628570)
  *  #8412 bump themes (365996e7)
  *  bump persona/vanilla, closes #8408 (225cac18)
  *  update dependency sharp to v0.25.4 (#8403) (3c3e1515)
  *  update dependency nodebb-theme-vanilla to v11.1.25 (#8405) (90446365)
  *  update dependency nodebb-theme-persona to v10.1.50 (#8404) (44273a64)
  *  update dependency mongodb to v3.5.9 (#8402) (90570660)
  *  update dependency nodebb-plugin-composer-default to v6.3.43 (78b7382c)
  *  update dependency validator to v13.1.1 (#8397) (2ae68f9b)
  *  update dependency validator to v13.1.0 (#8391) (ad6e3634)
  *  update dependency nodebb-theme-vanilla to v11.1.24 (#8395) (eec03de8)
  *  update dependency nodebb-theme-persona to v10.1.49 (#8394) (90846740)
  *  update dependency postcss to v7.0.32 (87ce31d1)
  *  update dependency nodebb-plugin-composer-default to v6.3.41 (dde830db)
  *  update dependency nodebb-plugin-composer-default to v6.3.40 (#8388) (cf0f8f64)
  *  bump themes, closes #8387 (e97a2b71)
  *  bump themes (ccac6a35)
  *  update dependency nodebb-theme-persona to v10.1.46 (#8382) (036e6ef5)
  *  update dependency nodebb-theme-vanilla to v11.1.21 (#8383) (7caeb273)
  *  update dependency nodebb-plugin-composer-default to v6.3.39 (aeefc60b)
  *  update dependency nodebb-plugin-composer-default to v6.3.37 (7f6ff0b1)
  *  update dependency nodebb-plugin-composer-default to v6.3.36 (6b2ea077)
  *  update dependency nodebb-plugin-composer-default to v6.3.35 (2d582df7)
  *  update dependency nodebb-theme-persona to v10.1.45 (#8372) (771ea194)
  *  update dependency nodebb-theme-vanilla to v11.1.20 (#8373) (f8ee981b)
  *  update dependency socket.io-redis to v5.3.0 (#8370) (d2463bb4)
  *  update dependency nodebb-theme-vanilla to v11.1.19 (f6ad9605)
  *  update dependency nodebb-theme-persona to v10.1.44 (cb28e6cf)
  *  update dependency nodebb-plugin-composer-default to v6.3.34 (#8357) (d7ab0894)
  *  update dependency nodebb-plugin-composer-default to v6.3.33 (c4047179)
  *  update dependency nodebb-plugin-spam-be-gone to v0.7.1 (27ab36ac)
  *  update dependency nodebb-theme-persona to v10.1.43 (#8343) (dabff972)
  *  update dependency mongodb to v3.5.8 (#8342) (8224127f)
  *  update dependency nodebb-theme-persona to v10.1.40 (#8332) (a20af6e2)
  *  update dependency nodebb-plugin-spam-be-gone to v0.7.0 (cc206b4d)
  *  bump composer-default (827d42a9)
  *  bump composer-default (a665881b)
  *  update dependency nodebb-plugin-composer-default to v6.3.29 (bf8a2c2e)
  *  update dependency postcss to v7.0.30 (#8288) (a532e2bb)
  *  update dependency sharp to v0.25.3 (0437ecc2)
  *  update dependency nodebb-plugin-composer-default to v6.3.28 (#8309) (f246057a)
  *  update dependency nodebb-plugin-composer-default to v6.3.27 (#8307) (6d57d844)
  *  #8298 bump persona (158d9231)
  *  update dependency nodebb-plugin-composer-default to v6.3.25 (89d17647)
  *  update dependency jquery to v3.5.1 [security] (#8281) (a69f0b29)
  *  update dependency nodebb-rewards-essentials to v0.1.3 (#8289) (919034a7)
  *  update dependency mongodb to v3.5.7 (#8279) (25d509c4)
  *  actually, swagger-parser is a dev dependency (d09c6ae0)
  *  missing @apidevtools/swagger-parser (f1720735)
  *  update dependency nodebb-theme-persona to v10.1.37 (#8258) (b0c30ceb)
  *  update dependency archiver to v4 (28777f67)
  *  update dependency mongodb to v3.5.6 (#8256) (49236067)
  *  bump dependencies (#8239) (e68156e1)
  *  update dependency jsesc to v3.0.1 (#8243) (92b55ef5)
  *  update dependency jsesc to v3 (bb70cebb)
  *  update dependency pg to v8 (#8227) (ac98775f)
  *  update dependency validator to v13 (f497ee62)
  *  update dependency sharp to v0.25.2 (#8220) (dd660c87)
  *  bump markdown (ee6cb412)
  *  update dependency mongodb to v3.5.5 (#8205) (5535c50c)
  *  update dependency sitemap to v6 (#8198) (2052f14c)
  *  update dependency nodebb-plugin-composer-default to v6.3.23 (6d98d5a1)
  *  update dependency sharp to v0.25.1 (#8199) (21e91c91)
  *  update dependency nodebb-plugin-composer-default to v6.3.22 (#8193) (e01f05e3)
  *  update dependency nodebb-theme-slick to v1.2.29 (#8177) (9daa21ff)
  *  update dependency nodebb-theme-vanilla to v11.1.16 (#8178) (7d6a983b)
  *  update dependency nodebb-theme-persona to v10.1.35 (#8176) (3acc24b0)
  *  update dependency sharp to v0.24.1 (#8164) (7cc63f7d)
  *  update dependency mongodb to v3.5.3 (#8161) (4b907137)
  *  update dependency nodebb-widget-essentials to v4.1.0 (#8159) (a5f3c2a2)
  *  update dependency request to v2.88.2 (#8158) (7fde180a)
  *  update dependency redis to v3 (#8152) (ef964b11)
  *  update dependency rimraf to v3.0.2 (#8153) (d8efc6b6)
*  don't show in unreplied if score is null (fd400a00)
*  lint (0d0b9513)
*  upgrade script to unescape navigation titles (37b6b8fd)
*  test (f0ce309d)
*  show controls @julianlam (023de94e)
*  #8437, #8433 (e53a18f2)
*  copy settings showing empty category selection (ed4b5caf)
*  don't init autocomplete if user doesn't have privs (8482a54a)
*  only allow valid uids (00d8ce26)
*  tests (f03ca086)
*  vulnerability in cover and admin uploads (#8419) (48b41deb)
*  reverse tabnabbing exploit in post images (040e6a9a)
*  follower count going out of sync with real follower count (2bcf7f72)
*  test lock for user create (#8415) (bef37e27)
*  add mising timestamp (f0526bff)
*  ban (bfd7eafe)
*  remove use of 'hidden' class in navbar toggling (5a367ecb)
*  bug where category privs page thought it was on admin (2515aa77)
*  #8410 (b3115ea8)
*  tests breaking due to #8406 (d5578c99)
*  add missing translations (42466d3c)
*  #8401, #8237 (7ed1a014)
*  add timestamp to initial username history (18d89239)
*  crash in export posts if post content is undefined (53a9517d)
*  messaging unread (0041c024)
*  whitespace (a024cc13)
*  typo (0595e710)
*  #8392, clear group member cache when group is renamed (89b01024)
*  return false (8591f5d2)
*  language (a255c8f6)
*  #8386, use backgroundImage everywhere (8627bee5)
*  prevent logout form from submitting (d92032da)
*  missing space in ACP menu dropdown (daeceb45)
*  #8385 (942cc4b1)
*  acp language keys from #8347 not updated in tx config (9ae7fd3e)
*  #8363, dont break history (50703db8)
*  #8363, go to hash when entering topic (0c265a41)
*  #8374, revert event delete (30cc83c0)
*  new language tag for select_tags (09184f40)
*  remove duplicate link to manage/tags in settings/tags (260a482c)
*  tests (3a078f59)
*  handle search tag permission as well (1b5d5425)
*  checking correct permissions for user search (#8371) (f6b92d24)
*  change event name so it doesnt trigger complete event (7786187e)
*  clear error log before checking (75b3a81d)
*  #8323, let admins send validation emails without timeout (e603ebc0)
*  #8352, remove webfonts (#8354) (de7ec47f)
*  more tests (da90fd56)
*  tests due to 0633ad327 (98dffa3a)
*  retry failed setObject calls (2c9e8657)
*  acp menu items (0633ad32)
*  re-jigged tags acp pages (a83f4259)
*  move checks into timeout (47d73a2a)
*  #8339, add missing translation (a9315aee)
*  don't explode if server sends `checkSession` (84c20f91)
*  eliminate unnecessary try..catch (f0e59c14)
*  test breakages from 8d995d1eb609837e4e6e4c77cd855766830378fa (a66fe013)
*  #8320, dont load moderators separately for each category (0a31e3e6)
*  show stack trace on startup errors (11bb6abb)
*  don't trigger quick search if val doesn't change (d6c2764f)
*  prevent duplicate search triggers (6f78113e)
*  user faster method if sorting by smallest set (3ec05eea)
*  add txt to list of default allowed file extensions (01bff2ae)
*  search post snipets incase content is plain text (ada45a34)
*  derp includes (d484731d)
*  another test fix (f2907908)
*  tests (feb748a4)
*  tests on redis (7a801aba)
*  tests, handle no sessions (8bf980cb)
*  #8318, clean expired sessions on login and get (a0d76ff0)
*  tests (a032e12b)
*  #8317 (81e33b93)
*  #8142 invalid session warning if server-side session destroyed (526b3cd9)
*  check privileges before exporting post/topic data (5fd81c5c)
*  exporting posts (dfae664e)
*  undefined uid when downloading posts (bdda0222)
*  #8311, fix allowUserHomePage value (1ba6929c)
*  dont crash if topic is null (e20ad5c5)
*  if category in selector has url use it (1f992cf3)
*  convert cids to string for comparison (c47a1c4d)
*  missing await (97c086ab)
*  add missing schema item (4e14cb57)
*  category selector disabled categories (337be368)
*  #8305, don't use null values (6a5e86dc)
*  #8302, send string to writeFileSync (d09bd2cf)
*  winston showing json object (7d081843)
*  sortable topics even if only 1 pinned topic (6765de3d)
*  #8298, use class name added by jQueryUI instead (dd2bc189)
*  topic search shortcut for macs (f2c725c6)
*  #8297, uids.length is different than topics.length (0431d75f)
*  #8297 guest handles shown in category.tpl (fcb81cb8)
*  only add to set if numRecentReplies>0 (16a98eaf)
*  #8293, don't show error if there are no self messages (be305410)
*  failing tests @julianlam (ecd622fd)
*  #3321, run plugin tests for installed plugins (a6bb9f43)
*  remove deprecated mocha.opts (3d0db963)
*  spec (84383d39)
*  #8290, if there are no filters go to ?reset=1 (9839346e)
*  #8283, update gdpr link again (2d076344)
*  add missing await (4f1128fd)
*  #8287, dont readd user after deletion (9d153fd3)
*  missing await (4d6b2ec3)
*  #8286, rescind notif when its resolved/rejected (0391856d)
*  #8284, parse ToS on register (0ca84bd9)
*  #8283, point to official site (17d664e0)
*  jquery xhtml violations (275e837b)
* #8274 Don't escape HTML in manage users (#8275) (4855f1de)
*  crash in topic controller (0c7c70ed)
*  crash when res.locals.linkTags is undefined (7cab2b0f)
*  #8272 user link in digest email (e80b8101)
*  tag of /api/unread/total (9ffdab02)
*  response hook logic (5a1c6ee7)
*  remove upload picture test (avatars) (6edf02d4)
*  remove tests related to group covers, as route is gone (442fe65f)
*  #8269, return array of topics from hook (4eafe0f0)
*  remove dead picture upload code #8260 (ef52461f)
*  path.resolve to logs file (5bcaf715)
*  only trigger infinitescroll on scroll end (ba6d3fd3)
*  wrong data returned in available.groups (c7ea84a2)
*  no focus on find user modal (1b425ef1)
*  accidental fp precision on flag and acp dash graphs (bcbf98aa)
*  #8232, unresolvable session mismatch on register cancel (f2f6fbf1)
*  pin jquery to 3.4.1, #8252 (e440d617)
*  #8249, don't send move notifications for deleted posts/topics (d77036db)
*  missing descriptions for common properties (7b31fb34)
*  some definitions in read API spec (03739b6f)
*  tagged all routes in read api spec (455d42bc)
*  override ACAO header for read API spec file (240d9091)
*  throw error if topic does not exist (59cf0e80)
*  hookname (e93578b8)
*  #8230, add hook getUserDataByUserSlug (0d1b5a7f)
*  ignore case for group details route (15d6975e)
*  lint (740e598a)
*  lint (8e23dec8)
*  #8221, fix parent selection (08031730)
*  invite properly (071506eb)
*  admins not seeing invite button (8f4b99a4)
*  #8217, add missing lang key (0b5fac75)
*  #8206 first message in chat has false `newSet` (93acd139)
*  #8203, fix user invites refreshing page (2f9c7c62)
*  #8202, filter non-existing users in search by uid (f07f4f8e)
*  notification bodyShort truncated if there is a comma in topic title (266061c3)
*  hsts max-age missing translation (b67af70d)
*  call next (80f1bcad)
*  try travis fix again (05bee629)
*  try fixing psql on travis (bc9e92a1)
*  dont let regular users see other users watched categories (cf6eadb9)
*  also fix updating bookmark if sorting is newest_to_oldest (6e5de39b)
*  #8188, fix bookmark if sorting is newest_to_oldest (32ada7c4)
*  duplicate ID + label (ac241fb8)
*  #8184 global mods unable to revoke other user sessions (f0db240a)
*  return null if field does not exist (e72a29b3)
*  #8179, limit length of location/website/fullname, check grouptitle (14e78667)
*  tag key (32636755)
*  #8175 (bc93b567)
*  #8168 re-allowing slashes in homePageRoute (667608a0)
*  tweak to session validation in addHeaders (eddbd868)
*  only call clearCookie for logged in users (630f5d5b)
*  #6422, update deleted/restored messages (06703408)
*  #8163, prevent account deletion (4d0636f8)
*  register (5a0c7c14)
*  #8157, update recent tid when post is moved (e7495440)
*  tests (b73aa84d)
*  move start/stop every iteration (dd3893b1)
*  #8154, move start/stop every iteration (300c04ce)
*  #8154, respect stop (690bb69d)
*  #8156 dont allow loading members from hidden groups (f23bc347)
*  #8155, don't validate name on update if groupName didn't change (03a02e5d)
*  return correct number of suggested topics (236e1e68)
*  #8151, don't crash if taskbar doesn't have element (2e794801)
*  logic for determining dailyStats hour vars (398f0120)
*  fix daily analytics being one day off (9ecdb92f)
*  remove debug line (0b9ad416)
*  no decimal places for category analytics (14655f87)
*  #8142, broken site if no server-side session (#8148) (d6e3f3f0)
*  #8144 pluginHooks in maintenance mode middleware (0885ec68)
* **openapi:**
  *  tests for #8412 (4cae893f)
  *  api change for #8387 (6a969442)
  *  schema for new flags api (a0e243ee)
  *  broken tests (45dfeeb0)
  *  v14 test fix (23a0b8c5)
  *  remove account and group upload routes (d342a28c)
  *  more fleshing out (058a15db)
  *  fleshed out admin routes (bae88e08)
  *  added some descriptions (ab4bd7e1)
  *  added PostsObject component (2395d2be)
  *  finished moving all category objects out (23dd2727)
  *  changed some descriptions (c939f8c6)
  *  added CategoryObject component (55d0a9ff)
  *  removed repeated breadcrumb blocks in favour of $ref (646fac1e)
  *  remove all repeated pagination blocks in favour of (ac579f9d)
  *  removed warning for category mods route (1cf62095)
  *  normalising the file for programmatic updates (3a5c6e07)
* **style:**
  *  more switch..case (6b1d1acb)
  *  switch..case (922d49be)
  *  enforcing "better" indentation for switch..case (d135b6f7)
* **docs:**  added titles to all routes (aa4ae78b)

##### Other Changes

* id, category fields (2355d9d5)
* //github.com/NodeBB/NodeBB (c3c8b19a)
* //github.com/NodeBB/NodeBB (0ddfb6b0)
* //github.com/NodeBB/NodeBB (d1c1cb2c)
* //github.com/NodeBB/NodeBB (79a7f892)
* user.getFields to match topic/posts (a680a95e)
* //github.com/NodeBB/NodeBB (b459592a)
* //github.com/NodeBB/NodeBB (066b442e)
* //github.com/NodeBB/NodeBB (fd6bf0c9)
* //github.com/NodeBB/NodeBB (c1d8b9bb)
* middleware.renderHeader (2727f472)
* //github.com/NodeBB/NodeBB (69a87933)
* uploadFile (7f24200c)
*  #8142 invalid session warning if server-side session destroyed" (e327d124)
*  ''}) (2a00b0e9)
* //github.com/NodeBB/NodeBB (8c8cdc99)
* categories.getRecentTopicReplies (aad0880f)
*  #8298 (2e57d8ac)
* post.updatePostVoteCount (b25b51bd)
* //github.com/NodeBB/NodeBB (5e140454)
* categories.updateRecentTid (6c59683b)
* categories.updateRecentTid (51933c1f)
* router.page, dep. filter variant (0053e779)
* flags as well (5ebcdb18)
*  crash when res.locals.linkTags is undefined" (fe03effe)
* //github.com/NodeBB/NodeBB (87a6ff0d)
*  cnpm and pnpm (#8222) (e6a1741c)
* //github.com/NodeBB/NodeBB (7ae76477)
*  openapi component" (683e5851)
*  override ACAO header for read API spec file" (c82a2637)
* password.change (00e299e9)
* topic.tools.load (5aa76cdf)
*  #8154, move start/stop every iteration" (4abe5eb7)
* **deps:**  update dependency nodebb-plugin-mentions to v2.8.0" (5c7d37c0)

##### Refactors

*  make code climate happier? (0d112b36)
*  shorter code (af790e3f)
*  shorter code (e8f0da6e)
*  change name to privileges to match other apis (2100a03c)
*  making rendering of header and footer async functions (023942da)
*  remove general menu from ACP (#8347) (a51fff8b)
*  use getSortedSetMembers (7d484fc0)
*  src/flags.js because codeclimate (cf00cda0)
*  flags detail page (8d995d1e)
*  move code (3b6d57e4)
*  remove console.log (40b5cbab)
*  shorter function (7e429884)
*  match core field name pinned (478ed6c1)
*  getUsersCSV to use batch lib (1efb238a)
*  reorganized socket.io admin modules (e1c6c3b2)

##### Reverts

*  bad changelog (a761e31f)

#### 1.13.3 (2020-05-08)

##### Chores

*  incrementing version number - v1.13.3 (ee583e80)
*  bump persona (d2bd746c)
*  incrementing version number - v1.13.2 (beafd613)
* **deps:**
  *  update dependency coveralls to v3.1.0 (5ed4a108)
  *  pin dependency @apidevtools/swagger-parser to 9.0.1 (51eccef5)
  *  update dependency husky to v4.2.5 (30a25983)
  *  update dependency husky to v4.2.4 (0a650118)
  *  update dependency lint-staged to v10.1.3 (a9e68639)
  *  update dependency nyc to v15.0.1 (#8231) (a3789e28)
  *  update dependency lint-staged to v10.1.2 (#8235) (e1919c90)
  *  update dependency lint-staged to v10.1.1 (944a6f58)
  *  update dependency lint-staged to v10.1.0 (30bd233b)
  *  update dependency eslint-config-airbnb-base to v14.1.0 (811c3aee)
  *  update dependency jsdom to v16.2.2 (c5a7242d)
  *  update dependency eslint-plugin-import to v2.20.2 (b92c1600)
  *  update dependency lint-staged to v10.0.10 (0ad4b556)
  *  update dependency coveralls to v3.0.11 (14458087)
  *  update dependency smtp-server to v3.6.0 (22681945)
  *  update dependency mocha to v7.1.1 (#8215) (c5356541)
  *  update dependency grunt to v1.1.0 (#8214) (b0864e7c)
  *  update dependency husky to v4.2.3 (#8162) (776fe9d2)
  *  update dependency lint-staged to v10.0.8 (#8180) (13d8f6f1)
  *  update dependency eslint-plugin-import to v2.20.1 (#8081) (4cdb3131)
  *  update dependency jsdom to v16.2.1 (#8165) (fbd95a50)
  *  update dependency husky to v4.2.2 (#8160) (f4ed35c9)
  *  update dependency jsdom to v16 (#8114) (1037de02)

##### Documentation Changes

*  updated changelog (146388aa)

##### New Features

*  allow activating additional plugins for testing via config.json (a969c5ce)
*  move plugin tests to separate file (3a23ddab)
*  remove node14 for now (a72e4429)
*  reduce infinite scroll area (3fcbd691)
*  manifest.json improvements from #8126 (#8264) (6e5ebb61)
*  show error if json is invalid (15345627)
*  moved component specs into separate files (cd506557)
*  added UserObject, UserObjectFull, Breadcrumb, Pagination component (64d79fe5)
*  added some summary and descriptions (ae3e90d6)
*  add some descriptions (442c018e)
*  common schema (eade13f9)
*  openapi component (1af5507a)
*  add page query param to docs (9987813f)
*  tag route doc (bbddaadf)
*  local redoc view on development mode only (1136a369)
*  added auto-generated, slimmed-down openapi 3.0 file for read api (7b155dab)
*  add parent cids to body class (23571224)
*  add 2 hooks for modifying privileges (d080c7b0)
*  add user ip to admin/dev/info (5e91a67e)
*  change option name (cba5b23e)
*  add no-build to ./nodebb setup (476f6717)
*  add awaitable socket.emit (4083a6e3)
*  settings sorted list (#8170) (3c9689a5)
*  guard against accidental ommision (79737c53)
* **openapi:**
  *  merging openapi-test branch into master (8387178b)
  *  move all commonprops out for commonprops component (65c78de6)
  *  added template to commonprops (2425f453)

##### Bug Fixes

*  #8302, send string to writeFileSync (d09bd2cf)
*  winston showing json object (7d081843)
*  sortable topics even if only 1 pinned topic (6765de3d)
*  #8298, use class name added by jQueryUI instead (dd2bc189)
*  topic search shortcut for macs (f2c725c6)
*  #8297, uids.length is different than topics.length (0431d75f)
*  #8297 guest handles shown in category.tpl (fcb81cb8)
*  only add to set if numRecentReplies>0 (16a98eaf)
*  #8293, don't show error if there are no self messages (be305410)
*  failing tests @julianlam (ecd622fd)
*  #3321, run plugin tests for installed plugins (a6bb9f43)
*  remove deprecated mocha.opts (3d0db963)
*  spec (84383d39)
*  #8290, if there are no filters go to ?reset=1 (9839346e)
*  #8283, update gdpr link again (2d076344)
*  add missing await (4f1128fd)
*  #8287, dont readd user after deletion (9d153fd3)
*  missing await (4d6b2ec3)
*  #8286, rescind notif when its resolved/rejected (0391856d)
*  #8284, parse ToS on register (0ca84bd9)
*  #8283, point to official site (17d664e0)
*  jquery xhtml violations (275e837b)
* #8274 Don't escape HTML in manage users (#8275) (4855f1de)
*  crash in topic controller (0c7c70ed)
*  crash when res.locals.linkTags is undefined (7cab2b0f)
*  #8272 user link in digest email (e80b8101)
*  tag of /api/unread/total (9ffdab02)
*  response hook logic (5a1c6ee7)
*  remove upload picture test (avatars) (6edf02d4)
*  remove tests related to group covers, as route is gone (442fe65f)
*  #8269, return array of topics from hook (4eafe0f0)
*  remove dead picture upload code #8260 (ef52461f)
*  path.resolve to logs file (5bcaf715)
*  only trigger infinitescroll on scroll end (ba6d3fd3)
*  wrong data returned in available.groups (c7ea84a2)
*  no focus on find user modal (1b425ef1)
*  accidental fp precision on flag and acp dash graphs (bcbf98aa)
*  #8232, unresolvable session mismatch on register cancel (f2f6fbf1)
*  pin jquery to 3.4.1, #8252 (e440d617)
*  #8249, don't send move notifications for deleted posts/topics (d77036db)
*  missing descriptions for common properties (7b31fb34)
*  some definitions in read API spec (03739b6f)
*  tagged all routes in read api spec (455d42bc)
*  override ACAO header for read API spec file (240d9091)
*  throw error if topic does not exist (59cf0e80)
*  hookname (e93578b8)
*  #8230, add hook getUserDataByUserSlug (0d1b5a7f)
*  ignore case for group details route (15d6975e)
*  lint (740e598a)
*  lint (8e23dec8)
*  #8221, fix parent selection (08031730)
*  invite properly (071506eb)
*  admins not seeing invite button (8f4b99a4)
*  #8217, add missing lang key (0b5fac75)
*  #8206 first message in chat has false `newSet` (93acd139)
*  #8203, fix user invites refreshing page (2f9c7c62)
*  #8202, filter non-existing users in search by uid (f07f4f8e)
*  notification bodyShort truncated if there is a comma in topic title (266061c3)
*  hsts max-age missing translation (b67af70d)
*  call next (80f1bcad)
*  try travis fix again (05bee629)
*  try fixing psql on travis (bc9e92a1)
*  dont let regular users see other users watched categories (cf6eadb9)
*  also fix updating bookmark if sorting is newest_to_oldest (6e5de39b)
*  #8188, fix bookmark if sorting is newest_to_oldest (32ada7c4)
*  duplicate ID + label (ac241fb8)
*  #8184 global mods unable to revoke other user sessions (f0db240a)
*  return null if field does not exist (e72a29b3)
*  #8179, limit length of location/website/fullname, check grouptitle (14e78667)
*  tag key (32636755)
*  #8175 (bc93b567)
*  #8168 re-allowing slashes in homePageRoute (667608a0)
*  tweak to session validation in addHeaders (eddbd868)
*  only call clearCookie for logged in users (630f5d5b)
*  #6422, update deleted/restored messages (06703408)
*  #8163, prevent account deletion (4d0636f8)
*  register (5a0c7c14)
*  #8157, update recent tid when post is moved (e7495440)
*  tests (b73aa84d)
*  move start/stop every iteration (dd3893b1)
*  #8154, move start/stop every iteration (300c04ce)
*  #8154, respect stop (690bb69d)
*  #8156 dont allow loading members from hidden groups (f23bc347)
*  #8155, don't validate name on update if groupName didn't change (03a02e5d)
*  return correct number of suggested topics (236e1e68)
*  #8151, don't crash if taskbar doesn't have element (2e794801)
*  logic for determining dailyStats hour vars (398f0120)
*  fix daily analytics being one day off (9ecdb92f)
*  remove debug line (0b9ad416)
*  no decimal places for category analytics (14655f87)
*  #8142, broken site if no server-side session (#8148) (d6e3f3f0)
*  #8144 pluginHooks in maintenance mode middleware (0885ec68)
* **deps:**
  *  #8298 bump persona (158d9231)
  *  update dependency nodebb-plugin-composer-default to v6.3.25 (89d17647)
  *  update dependency jquery to v3.5.1 [security] (#8281) (a69f0b29)
  *  update dependency nodebb-rewards-essentials to v0.1.3 (#8289) (919034a7)
  *  update dependency mongodb to v3.5.7 (#8279) (25d509c4)
  *  actually, swagger-parser is a dev dependency (d09c6ae0)
  *  missing @apidevtools/swagger-parser (f1720735)
  *  update dependency nodebb-theme-persona to v10.1.37 (#8258) (b0c30ceb)
  *  update dependency archiver to v4 (28777f67)
  *  update dependency mongodb to v3.5.6 (#8256) (49236067)
  *  bump dependencies (#8239) (e68156e1)
  *  update dependency jsesc to v3.0.1 (#8243) (92b55ef5)
  *  update dependency jsesc to v3 (bb70cebb)
  *  update dependency pg to v8 (#8227) (ac98775f)
  *  update dependency validator to v13 (f497ee62)
  *  update dependency sharp to v0.25.2 (#8220) (dd660c87)
  *  bump markdown (ee6cb412)
  *  update dependency mongodb to v3.5.5 (#8205) (5535c50c)
  *  update dependency sitemap to v6 (#8198) (2052f14c)
  *  update dependency nodebb-plugin-composer-default to v6.3.23 (6d98d5a1)
  *  update dependency sharp to v0.25.1 (#8199) (21e91c91)
  *  update dependency nodebb-plugin-composer-default to v6.3.22 (#8193) (e01f05e3)
  *  update dependency nodebb-theme-slick to v1.2.29 (#8177) (9daa21ff)
  *  update dependency nodebb-theme-vanilla to v11.1.16 (#8178) (7d6a983b)
  *  update dependency nodebb-theme-persona to v10.1.35 (#8176) (3acc24b0)
  *  update dependency sharp to v0.24.1 (#8164) (7cc63f7d)
  *  update dependency mongodb to v3.5.3 (#8161) (4b907137)
  *  update dependency nodebb-widget-essentials to v4.1.0 (#8159) (a5f3c2a2)
  *  update dependency request to v2.88.2 (#8158) (7fde180a)
  *  update dependency redis to v3 (#8152) (ef964b11)
  *  update dependency rimraf to v3.0.2 (#8153) (d8efc6b6)
* **openapi:**
  *  v14 test fix (23a0b8c5)
  *  remove account and group upload routes (d342a28c)
  *  more fleshing out (058a15db)
  *  fleshed out admin routes (bae88e08)
  *  added some descriptions (ab4bd7e1)
  *  added PostsObject component (2395d2be)
  *  finished moving all category objects out (23dd2727)
  *  changed some descriptions (c939f8c6)
  *  added CategoryObject component (55d0a9ff)
  *  removed repeated breadcrumb blocks in favour of $ref (646fac1e)
  *  remove all repeated pagination blocks in favour of (ac579f9d)
  *  removed warning for category mods route (1cf62095)
  *  normalising the file for programmatic updates (3a5c6e07)

##### Other Changes

*  #8298 (2e57d8ac)
* post.updatePostVoteCount (b25b51bd)
* //github.com/NodeBB/NodeBB (5e140454)
* categories.updateRecentTid (6c59683b)
* categories.updateRecentTid (51933c1f)
* router.page, dep. filter variant (0053e779)
* flags as well (5ebcdb18)
*  crash when res.locals.linkTags is undefined" (fe03effe)
* //github.com/NodeBB/NodeBB (87a6ff0d)
*  cnpm and pnpm (#8222) (e6a1741c)
* //github.com/NodeBB/NodeBB (7ae76477)
*  openapi component" (683e5851)
*  override ACAO header for read API spec file" (c82a2637)
* password.change (00e299e9)
* topic.tools.load (5aa76cdf)
*  #8154, move start/stop every iteration" (4abe5eb7)

##### Refactors

*  match core field name pinned (478ed6c1)
*  getUsersCSV to use batch lib (1efb238a)
*  reorganized socket.io admin modules (e1c6c3b2)

#### 1.13.2 (2020-02-05)

##### Chores

*  incrementing version number - v1.13.2 (71f4607d)
*  bump themes (027f3f22)
*  bump vanilla (236a1730)
*  bump persona (82ace391)
*  incrementing version number - v1.13.1 (cc6758a0)
* **deps:**
  *  update dependency eslint to v6.8.0 (#8062) (15783213)
  *  update dependency nyc to v15 (#8094) (976e26a9)
  *  update commitlint monorepo (#8100) (eb4a1a57)
  *  update dependency lint-staged to v10.0.7 (#8132) (cdfbcbb9)
  *  update dependency mocha to v7 (#8106) (b370333c)
  *  update dependency husky to v4 (dd440ce9)
  *  update dependency lint-staged to v10.0.1 (66992a55)
  *  update dependency lint-staged to v10 (d74eecfb)

##### Documentation Changes

*  updated changelog (2edc6960)

##### New Features

*  add test for isOnline (66febb80)
*  add test for change post owner (df2c7851)
*  check flag values on save (assignee and state) (#8122) (8e5a2276)

##### Bug Fixes

*  admin relogin (a5ef6b53)
*  #8135 (c35a21d7)
*  handle mkdirp0.5->1.0x so it doesn't break upgrade (1e50616c)
*  #8134, upgrade mkdirp to 1.0.x (87225a90)
*  onSuccessfulLogin not working (111ed802)
*  #8139, dont allow restore if not deleted by self (8c48f94b)
*  use view_deleted when filtering, closes #8137 (9969dd63)
*  escape invalid rules (d927b763)
*  add missing await (3cca929a)
*  missing await in SocketPosts.changeOwner (0ae1eb4f)
*  #8133, check if user is in room before removing (23810cc6)
*  add missing await (cd1fa27a)
*  missing await (f799f017)
*  dont return flag data to client (418c174d)
*  check if user has read priv before flagging (51236df4)
*  restrict getUsersInRoom to members (1f13ab8a)
*  remove unused conditional, dont add dupe messages (3077eb94)
*  tests for messaging (ecc579a2)
*  #8127 user join system message duplicated (594cd7e1)
*  background-size in taskbar images (106c141f)
*  tests, was using hardcoded message id (1b08f376)
*  typo in #8116 (8bb5e71e)
*  build step defaults to series instead of parallel (3fac09b1)
*  escape system message, don't allow editing system messages (6a63c1a1)
*  escape register query param (c8fb7f92)
*  delete upload (8c6a7954)
*  check uploadName (153b1a0e)
*  #8120, bubble errors from static hooks (01d1ae78)
*  escape bootswatchSkin and homepageRoute (b0f3e48a)
*  change owner missing await (3e525576)
*  hsts always enabled (e3952674)
*  escape topic.thumb (b7a57996)
*  #8112, don't crash hook returns no data (4eb9652a)
*  escape config.userLang/acpLang, don't allow invalid language codes (e06c1bfc)
*  group create/join/update name validation (61da8c29)
*  don't crash if groupData is missing (48f08627)
*  #8105, fix export json on page load (5a8217de)
*  #8103, fix advanced menu not displaying in ACP (52774531)
*  meta description missing if url doesn't have post index (10989ccc)
*  create user modal instantly closing (c1b1ee61)
*  login with weak password (9d074731)
*  dont check password strength on login (f6d7a24a)
* **deps:**
  *  update dependency connect-redis to v4.0.4 (#8143) (16ab641d)
  *  update dependency rimraf to v3.0.1 (#8138) (726ba71c)
  *  update dependency validator to v12.2.0 (#8136) (f07b4bfa)
  *  update dependency nodebb-theme-persona to v10.1.34 (#8140) (6d7131fb)
  *  update dependency nodebb-theme-persona to v10.1.31 (#8129) (c510a2c4)
  *  update dependency mongodb to v3.5.2 (#8092) (0e49cfb9)
  *  update dependency sharp to v0.24.0 (#8121) (16e8f496)
  *  update dependency nodebb-plugin-composer-default to v6.3.21 (#8119) (ca10f8f0)
  *  update dependency nodebb-widget-essentials to v4.0.18 (#8111) (df5e3a73)

##### Other Changes

* NodeBB/NodeBB (b959c24a)
* //github.com/NodeBB/NodeBB (ee4304b4)
* //github.com/NodeBB/NodeBB (bfaba895)
*  save disableLeave (#8123) (09d55581)
* //github.com/NodeBB/NodeBB (842916ea)

##### Refactors

*  messaging (30c50361)

#### 1.13.1 (2019-12-19)

##### Chores

*  incrementing version number - v1.13.1 (d1e0672f)
*  incrementing version number - v1.13.0 (c38b2d23)
* **deps:**
  *  update dependency husky to v3.1.0 (#8046) (c3418c26)
  *  update dependency coveralls to v3.0.9 (#8067) (0aeee144)
  *  update dependency eslint to v6.7.0 (32cfe96f)
  *  update dependency coveralls to v3.0.8 (#8054) (8ba26104)

##### Documentation Changes

*  updated changelog (94499da3)

##### New Features

*  better output for cli plugins list, closes #8075 (4fc69443)
*  #5272, allow changing user groups from manage users page (05c9fe27)
*  merge social authentication into plugins menu in ACP (f9a8ebfc)
*  convert middleware.isAdmin to async/await (efd1e88b)

##### Bug Fixes

*  #8085, fix cookie name (dec157d6)
*  #8058, fix incorrect digest setting display in ACP (1b992d82)
*  remove select version (6a17e32d)
*  travis config (3ae98300)
*  travis :dog: (3731dc4e)
*  #8078, dont mark notifications read without a mergeId (a8df6d62)
*  #8077, show continue chat on all profile pages (7af1c873)
*  profile showing posts from deleted topics (2679f37d)
*  #8073, configurable necroThreshold (4d669783)
*  allow members to search as well (b323df2f)
*  #8069, dont show hidden groups in search (c2cd7de8)
*  missing await (33fd4a1c)
*  #8064, break-word on post-queue (1bda92e3)
*  #6711 (7ed002a1)
*  #8061, don't crash if there is a network problem (de404102)
*  #8059, properly mark topic unread when using mark unread for all (a688aaae)
*  #8042, dont show errors after clearing form (3811e0a3)
*  unhandled promise rejection error on reset error (51073772)
*  #8050, fix redirect after registration (366ad5cd)
*  make _csrf a secure cookie if the website is using https (#8045) (0efe27b1)
*  #8034 (0a96c923)
*  serialize (a2545204)
*  show login fields if user has local password (1eca5b3d)
*  use the correct attribute name for widgets (6c404b81)
* **deps:**
  *  update dependency semver to v7 (483d7535)
  *  update dependency nodebb-theme-vanilla to v11.1.12 (610ecf35)
  *  update dependency sharp to v0.23.4 (#8076) (eb18c182)
  *  update dependency nodebb-theme-persona to v10.1.30 (0514383a)
  *  update dependency nodebb-plugin-markdown to v8.11.0 (702ca164)
  *  update dependency connect-mongo to v3.2.0 (2aef7a5b)
  *  update dependency mongodb to v3.3.5 (#8065) (68118e43)
  *  update dependency nodebb-theme-persona to v10.1.29 (#8057) (34933091)
  *  update dependency sharp to v0.23.3 (#8044) (6fa88823)
  *  update dependency validator to v12.1.0 (#8055) (488ea394)
  *  update dependency nodebb-theme-slick to v1.2.28 (#8041) (b3511f71)
  *  update dependency nodebb-theme-vanilla to v11.1.11 (#8040) (d567c4ae)
  *  update dependency nodebb-theme-persona to v10.1.28 (#8039) (6c87bed5)
  *  update dependency nodebb-plugin-dbsearch to v4.0.7 (#8038) (1e2e16b4)

##### Refactors

*  async/await middleware (a227cbe3)
*  change to const/let (3454a24b)
*  shorter returns (cec00795)

### 1.13.0 (2019-11-13)

##### Chores

*  incrementing version number - v1.13.0 (c38b2d23)
*  incrementing version number - v1.12.2 (810e2c0b)
* **deps:**
  *  update dependency jsdom to v15.2.1 (9d946d1c)
  *  update dependency eslint to v6.6.0 (d0e428e9)
  *  update dependency lint-staged to v9.4.2 (#7954) (d108c7d0)
  *  update dependency mocha to v6.2.2 (#7984) (e31a47cd)
  *  update dependency coveralls to v3.0.7 (#7961) (9b308e4b)
  *  update dependency jsdom to v15.2.0 (#7971) (9b4e9882)
  *  update dependency husky to v3.0.9 (fd5095a3)
  *  update dependency husky to v3.0.8 (88cae415)
  *  update dependency lint-staged to v9.4.1 (a2a7bb3d)
  *  update node.js to v8.16.1 (f9ad826b)
  *  update node:8.16.0 docker digest to bb12612 (48cc317c)
  *  update dependency eslint to v6.5.1 (da12e947)
  *  update dependency husky to v3.0.7 (10a30e66)
  *  update commitlint monorepo to v8.2.0 (ddd4e039)
  *  update dependency mocha to v6.2.1 (b172d106)
  *  update dependency lint-staged to v9.2.3 (ccccba81)
  *  update dependency coveralls to v3.0.6 (#7820) (2b1f840e)
  *  update dependency husky to v3.0.3 (cbede89a)
  *  update dependency lint-staged to v9 (f2e4664d)
  *  update dependency eslint-plugin-import to v2.18.2 (#7779) (57b2a553)
  *  update dependency eslint to v6.1.0 (#7783) (7257e6b2)
  *  update dependency husky to v3.0.2 (7ad72b32)
  *  update node:8.16.0 docker digest to c671dc2 (e76214a2)
  *  update dependency mocha to v6.2.0 (d43f5dcf)
  *  update node:8.16.0 docker digest to 310db2a (c46a0772)
  *  update dependency husky to v3.0.1 (28151f86)
  *  update dependency eslint-plugin-import to v2.18.1 (9fda2c1f)
  *  update commitlint monorepo to v8.1.0 (f73468d5)
  *  update dependency coveralls to v3.0.5 (5b746d53)
  *  update dependency husky to v2.7.0 (1d0fd028)
  *  update dependency eslint to v6.0.1 (77347d0a)
  *  update dependency husky to v2.6.0 (fc69e891)
  *  update dependency eslint-plugin-import to v2.18.0 (744e4428)
  *  update dependency husky to v2.5.0 (4960b925)
  *  update dependency lint-staged to v8.2.1 (2fa68e3b)
  *  update node:8.16.0 docker digest to 06adec3 (fc224cca)
  *  update dependency husky to v2.4.1 (17ec8fde)
  *  update node:8.16.0 docker digest to d5ad3f5 (f9e99fa3)
  *  update node:8.16.0 docker digest to 75b524a (5995834b)
  *  update node:8.16.0 docker digest to b9a98ae (fca6d794)
  *  update dependency lint-staged to v8.2.0 (376390c4)
  *  update dependency husky to v2.4.0 (3d2ec0bb)
  *  update dependency coveralls to v3.0.4 (c360e0c2)
  *  update dependency eslint-plugin-import to v2.17.3 (eac4e2f1)
  *  update node:8.16.0 docker digest to 957cab2 (cc6fa97c)
  *  update commitlint monorepo to v8 (80532831)

##### Documentation Changes

*  updated changelog (183b0ed3)

##### New Features

*  displaying one-click unsubscribe link in email footer (#8024) (df139928)
*  #7467, pass query params when redirecting to posts (480a64aa)
*  use helpers.setupAdminPageRoute (b5a30006)
*  wip, better digest handling (+ eventual digest resend logic) (#7995) (645d6472)
*  add action:messaging.save (ac5c560c)
*  #7957, allow post queue based on group (1cedc4a0)
*  add filter:topics.unreadCutoff (e020b85b)
*  Add filter:topic.delete and filter:topic.restore (#7946) (#7989) (989107d9)
*  no more session cookie for guests (#7982) (cf7e0cfd)
*   Implement WICG change-password-url (#7072) (#7990) (df1efe5f)
*  log errors from mubsub (b01a47cb)
*  upgrade to sitemap5 (#7980) (d6792188)
*  #7964, change all categories at once (485fbd2f)
*  closes #7952, translate widget-settings (990508a5)
*  remove ability to delete events from acp (554e6711)
*  resetting theme will reset skin (03827fa6)
*  disable timeout on launch route (4bc77d06)
*  add new hook to get custom category tids for unread (b1926054)
*  adding filter:login.check and loginFormEntry[] for the filter:login.build hook (#7861) (94810fd6)
*  #7932, redirect to group details after creation (2444ed5c)
*  add new hook filteR:topics.getSortedTids (b93c826d)
*  bypass cropper for gifs (9a756004)
*  deprecate file.isFileTypeAllowed (ffe3670f)
*  send notification to group owners when someone leaves (ed122364)
*  add failing test for pagination (#7924) (22b02f14)
*  refactor getSortedSetRange to allow big arrays (b602c044)
*  add new test (1e5246f9)
*  add rss feed url for tags (bbc2e956)
*  add sm2x avatar class #7813 (35a4ca2f)
*  #7090, abililty to hide widgets (71cd602d)
*  #7760, body-parser config (5de6d885)
*  actually cache duh (f05c1dae)
*  cache tags:topic:count (63bd252f)
*  increase search timeouts (1789ecb4)
*  make handleSearch public (ebe5ed22)
*  increase size of local cache (b81405a8)
*  don't hardcode numberic fields in user search (09410ff1)
*  allow only watching core (451c7fd4)
*  client-side taskbar.update method, deprecates .updateTitle() (9b09ee0e)
*  option to restrict group leaving, closes #7770 (1796b65d)
*  preserver querystring when changing category sort (ad96b0e0)
*  html sanitization on all filter:parse.* hooks, closes #7872 (2580306d)
*  up socket.io-adapter-mongo (3d2cb628)
*  update LESS to v3.x, #7855 (#7867) (aea04de0)
*  up psql socket.io adapter (b565e568)
*  add client side hook for quick search&normal search (f31d30cd)
*  allow floating pinned topics to top in getSortedTopics (1d7e0c63)
*  promisify recent.getData (6f7ab586)
*  faster initial stat loading (89cd31ed)
*  cache stats, mongo count sucks (cb50b3f4)
*  dashboard stats (3ff6e1bb)
*  add filter:search.getPosts (aeb44faf)
*  add image and imageClass to post summaries (80bd52fc)
*  #7842, make isInvited, isPending work with uids (fa268556)
*  convert search controller to async/await (acf12e3d)
*  notification on membership acceptance, closes #7835 (1a2a381a)
*  additional events logged for various group actions (1ce33faa)
*  async (e6353486)
*  async/await controllers/admin/dashboard (32ea04a8)
*  async/await admin/controllers (72590b34)
*  async/await (7beef91c)
*  async/await refactor (3cc7ec63)
*  async/await controllers/accounts (a3541d88)
*  rewrite getRawPost to async/await (b734defb)
*  added new filter hook filter:post.getRawPost (973075cf)
*  convert categories controller to async/await (e9fd49e2)
*  new client-side hooks for chat minimize and close (3d3fa865)
*  test psql without defineProperty (#7815) (af1f7249)
*  fire updateRemainingLength hook for chats (af968c6a)
*  send pids into filter:post.getFields hook (0e07ffa1)
*  move cache tpl (65fc0612)
*  async refactor (3a9d83a4)
*  move group privs above user, add labels (47e30a67)
*  widgets/index.js (dec8040c)
*  use promise version (4d6b6871)
*  #7743, meta/dependencies (1c2540d3)
*  #7743, widgets/admin (96ebe7b5)
*  #7743, meta/languages and languages (c02686bf)
*  added filter:tags.getAll plugin hook (66aa443b)
*  #7743, events (102d4b02)
*  #7743 meta/errors (97d7a850)
*  get rid of async.eachSeries (99cf47ee)
*  #7743 meta/tags.js (7b908639)
*  #7743 meta/templates.js (79eed9ae)
*  #7743 navigation (764a2b12)
*  #7743 account/posts controller (e72f3e4f)
*  #7743 finish topics controller (9b3f4b98)
*  #7743, webserver (0d047f4e)
*  #7743 meta/themes.js (7dc0eaf0)
*  #7743, meta/sounds (a15c50bf)
*  #7743 , meta/cachebuster, meta/configs (7f72181e)
*  convert src/messaging/* to async/await (#7778) (756a717e)
*  #7743 meta/blacklist (fcf8fd51)
*  #7743 meta/index (69860e58)
*  #7743 plugins (c126cd85)
*  #7743 plugins/data (f5f5f76b)
*  dont waste whitespace (17f843f9)
*  switch to promise.all (34d85b52)
*  #7743, privileges (faccb191)
*  #7743 , search.js (6d3a92b8)
*  shorter name (8e75646a)
*  cache group:members for priv groups (daed76d5)
*  #7743 finish groups (72def7df)
*  #7743, groups/index, invite, leave,membership (a39ca51e)
*  #7743,groups/index,join (d5342a40)
*  #7743, groups/delete,ownership,posts,user (fcd4445a)
*  #7743 groups/cover,create,data (5e8614e1)
*  #7743, finish post module (c0c6c652)
*  #7743 posts/diff, posts/edit (c4bb467e)
*  #7743, posts module (1b2b308a)
*  #7743, finish user module (a51ec591)
*  #7743 (6fea46b6)
*  #7743 (cd80c263)
*  #7743 (0a690c57)
*  #7743 (1c5fad6d)
*  #7743 (fe4c0481)
*  #7743 categories (fcf3e077)
*  #7743, user/digest, user/email, user/follow (c610eb14)
*  #7743, user/create, user/data, user/delete (d6e36c31)
*  #7743 , user/block, user/categories (4541caa4)
*  #7743 notifications (6f738c2b)
*  remove unused code, add 2 tests (cd2e68cb)
*  #7743 user/ban, up mubsub (1970214a)
*  #7743, user/approval, user/auth (b24ce976)
*  #7743, posts/votes (8ef75be3)
*  #7743 posts (e1ecc36d)
*  #7743 user/admin.js (2c335955)
*  add utils.promiseParallel (4170abfd)
*  #7743, posts/user.js (0a6cfb37)
*  added new admin option newbiePostEditDuration (#7737) (8a6a58ee)
*  returning category data in tags page (75ff4d7d)
*  ACP analytics API route (#7725) (a0c0ef1b)
*  closes #7718 (ee4d78ca)
*  add status to post summaries (41bc6ca2)
*  use arrow functions (3100d803)
*  ability to sort watched topics, closes #3735 (f24c14d7)
*  use fewer system resources to draw the progress bar (d0ee312c)
*  removed series from upgrade script (23fb904f)
*  remove duped zadds, these are already in topics.onNewPostMade (cb51c239)
*  log data on error (f8a7cf73)
*  cleanup, use bulk (198d0587)
*  #7707, added sortedSetAddBulk (3ecd703e)
*  change widget-* to data-widget-* (#7703) (13efbc99)
*  shorter setsCard (3780a58f)
*  show best & latest posts on profile (b53a60c2)
*  use db.sortedSetsAdd (7e54d7aa)
*  use db.sortedSetsAdd (29a124c4)
*  dont log action:plugins.fireHook (a7600b4b)
*  upgrade to connect-mongo 3.0.0, closes #7693 (ebfc369a)
*  add hook for user notifications, closes #7672 (ede060a6)
*  user/notifications refactor (580f7860)
*  send new post/topic event in batches (8c331088)
*  allowing count to be passed to ./nodebb events (f6d3cc0e)
*  awaitable websockets (#7645) (aee47b29)
*  hooks can now return promise or call callbacks (a6436716)
*  fallback strings for ACP events (99120676)
*  design revamp of ACP events page (#7664) (c7f95cce)
*  optimize group rename (48538b28)
*  allow multiple scores in sortedSetsAdd (31ccc860)
*  optimize copy privileges (0dca13e9)
*  on category search reveal children and parents (0721bee1)
*  async3 upgrade (#7639) (4d9bc30d)
*  #7627, close chat on ajaxify on mobile (6cebc7f0)
*  update meta tags on ajaxify (#7580), fixes #7544 (a41769e6)

##### Bug Fixes

* **deps:**
  *  update dependency mongodb to v3.3.4 (#8032) (2093418d)
  *  update dependency nodebb-theme-vanilla to v11.1.10 (c01699f7)
  *  update dependency nodebb-theme-persona to v10.1.27 (182397b1)
  *  update dependency nodebb-plugin-spam-be-gone to v0.6.7 (#8027) (c2565a2f)
  *  update dependency nodebb-theme-slick to v1.2.27 (#8020) (7122bdc7)
  *  update dependency nodebb-theme-persona to v10.1.26 (#8019) (73d9752e)
  *  update dependency connect-mongo to v3.1.2 (#8013) (bfea9d39)
  *  update dependency postcss to v7.0.21 (#7998) (ef5f6714)
  *  update dependency nodebb-plugin-composer-default to v6.3.17 (#8009) (e1e2d20c)
  *  update dependency sharp to v0.23.2 (#8005) (420f9fe4)
  *  update dependency nodebb-theme-persona to v10.1.25 (#8012) (cb91e756)
  *  update dependency connect-mongo to v3.1.1 (#8006) (7655265c)
  *  update dependency connect-mongo to v3.1.0 (#7994) (401d1eed)
  *  bump persona (6155c460)
  *  update dependency nodebb-theme-persona to v10.1.23 (#7986) (9bd6f686)
  *  update dependency nodebb-theme-persona to v10.1.22 (#7965) (bf6ae6d6)
  *  update dependency nodebb-rewards-essentials to v0.1.2 (#7962) (692d94bf)
  *  update dependency nodebb-theme-persona to v10.1.21 (#7956) (1a150d8f)
  *  update dependency nodebb-plugin-spam-be-gone to v0.6.6 (#7944) (cffbb325)
  *  update dependency nodebb-theme-persona to v10.1.20 (#7943) (9589fa32)
  *  update dependency nodebb-theme-persona to v10.1.19 (#7942) (0d629f06)
  *  update dependency connect-redis to v4.0.3 (#7933) (2856333d)
  *  update dependency spider-detector to v2 (310039e8)
  *  update socket.io packages to v2.3.0 (764ed7f8)
  *  update dependency sharp to v0.23.1 (#7928) (17437897)
  *  update dependency nodebb-plugin-dbsearch to v4.0.6 (#7918) (44cd7189)
  *  update dependency nodebb-plugin-composer-default to v6.3.16 (#7917) (d8fe6e42)
  *  update dependency nodebb-plugin-composer-default to v6.3.15 (#7916) (c5e5e24b)
  *  update dependency nodebb-plugin-composer-default to v6.3.14 (#7914) (e18392ab)
  *  update dependency nodebb-theme-persona to v10.1.18 (#7906) (8ed80bcb)
  *  update dependency nodebb-rewards-essentials to v0.1.1 (#7905) (5b8bb3e4)
  *  update dependency connect-redis to v4 (#7869) (8b7f6566)
  *  update dependency nodebb-plugin-mentions to v2.7.3 (#7899) (b2423bae)
  *  update dependency nodebb-plugin-mentions to v2.7.2 (#7898) (a3120a62)
  *  update dependency nodebb-plugin-dbsearch to v4.0.5 (#7896) (106c20e2)
  *  update dependency nodebb-plugin-composer-default to v6.3.13 (#7895) (fa251ece)
  *  update dependency nodebb-plugin-mentions to v2.7.1 (8c2fc577)
  *  update dependency nodebb-plugin-composer-default to v6.3.12 (#7889) (429e124f)
  *  update dependency nodebb-plugin-composer-default to v6.3.11 (#7888) (516b62ea)
  *  update dependency nodebb-plugin-composer-default to v6.3.10 (6a4a9e26)
  *  update dependency nodebb-plugin-dbsearch to v4.0.4 (#7883) (12ba589d)
  *  update dependency postcss to v7.0.18 (c75f3d27)
  *  update dependency nodebb-theme-persona to v10.1.17 (317c6771)
  *  update dependency nodebb-theme-vanilla to v11.1.8 (6e9caddc)
  *  update dependency nodebb-plugin-composer-default to v6.3.9 (effe3989)
  *  update dependency nodebb-plugin-mentions to v2.7.0 (b69769bb)
  *  update dependency benchpressjs to v2 (#7876) (9149db1f)
  *  update dependency nodebb-plugin-composer-default to v6.3.8 (793c5eaa)
  *  update dependency nodebb-plugin-composer-default to v6.3.7 (57de99d2)
  *  update dependency mongodb to v3.3.2 (#7871) (4ee2c090)
  *  update dependency nodebb-plugin-spam-be-gone to v0.6.5 (#7865) (8ce2a5fc)
  *  update dependency mongodb to v3.3.1 (#7862) (0dfce49f)
  *  update dependency connect-pg-simple to v6 [security] (#7864) (e4b5d0b4)
  *  update dependency nodebb-plugin-mentions to v2.6.1 (a1210985)
  *  update dependency nodebb-plugin-mentions to v2.6.0 (cdccc646)
  *  update dependency rimraf to v3 (#7843) (2f02edbc)
  *  update dependency rimraf to v2.7.1 (#7838) (cf2504f8)
  *  update dependency nodebb-theme-persona to v10.1.16 (#7848) (ca7ba9be)
  *  update dependency nodebb-theme-persona to v10.1.15 (#7845) (b1c0beb7)
  *  update dependency nodebb-theme-persona to v10.1.14 (#7837) (661284cf)
  *  update dependency nodebb-theme-persona to v10.1.13 (eaea6f63)
  *  update dependency sitemap to v4 (d3d677da)
  *  update dependency commander to v3 (7a5dbd9f)
  *  update dependency mongodb to v3.3.0 (360e172e)
  *  update dependency nodebb-plugin-markdown to v8.10.4 (61f9be99)
  *  update dependency nodebb-plugin-markdown to v8.10.3 (d860f8c7)
  *  update dependency sharp to v0.23.0 (#7806) (2258452c)
  *  update dependency nodebb-theme-persona to v10.1.12 (#7799) (b9aac424)
  *  update dependency nodebb-plugin-dbsearch to v4 (#7797) (d98313b5)
  *  update dependency nodebb-plugin-dbsearch to v3.0.8 (#7796) (ef734b62)
  *  update dependency nodebb-theme-persona to v10.1.11 (8b1fc5c8)
  *  update dependency nodebb-theme-vanilla to v11.1.7 (ba1bb528)
  *  update dependency nodebb-theme-vanilla to v11.1.6 (#7784) (7a88c4cc)
  *  update dependency nodebb-theme-slick to v1.2.26 (#7782) (e074b0bf)
  *  update dependency nodebb-theme-persona to v10.1.10 (#7781) (4f20b4d3)
  *  update dependency nodebb-plugin-composer-default to v6.3.6 (3fdc638b)
  *  update dependency connect-redis to v3.4.2 (8a11193f)
  *  update dependency nodebb-plugin-mentions to v2.5.4 (45223cde)
  *  update dependency nodebb-plugin-markdown to v8.10.2 (86546232)
  *  update dependency nodebb-theme-persona to v10.1.9 (#7759) (c1660a1a)
  *  update dependency nodebb-plugin-dbsearch to v3.0.7 (#7758) (efedd621)
  *  update dependency nodebb-plugin-composer-default to v6.3.5 (7f4b1043)
  *  update dependency nodebb-theme-vanilla to v11.1.5 (#7756) (15e01d12)
  *  update dependency nodebb-theme-persona to v10.1.8 (#7755) (19679608)
  *  update dependency nodebb-theme-persona to v10.1.7 (#7754) (3cb6cfe8)
  *  update dependency nodebb-plugin-composer-default to v6.3.3 (8394a0fd)
  *  update dependency nodebb-theme-vanilla to v11.1.4 (#7741) (43ce5f8a)
  *  update dependency nodebb-theme-persona to v10.1.5 (27da2325)
  *  update dependency validator to v11.1.0 (#7738) (bd09ba92)
  *  bump composer-default (851424a7)
  *  update dependency nodebb-theme-persona to v10.1.4 (f426e105)
  *  update dependency nodebb-plugin-composer-default to v6.2.16 (#7723) (fb087029)
  *  update dependency nodebb-theme-persona to v10.1.3 (413259a2)
  *  update dependency nodebb-theme-lavender to v5.0.11 (#7705) (208c821e)
  *  update dependency nodebb-theme-vanilla to v11.1.3 (#7714) (e0b2ae8d)
  *  update dependency nodebb-theme-slick to v1.2.25 (#7713) (af7ecd2f)
  *  update dependency nodebb-theme-persona to v10.1.2 (#7712) (e5733f40)
  *  update dependency nodebb-plugin-mentions to v2.5.3 (26ff02dc)
  *  update dependency nodebb-theme-persona to v10.1.1 (4e513cf3)
  *  update dependency nodebb-theme-vanilla to v11.1.2 (c2887505)
  *  update dependency nodebb-theme-vanilla to v11.1.1 (#7700) (b3ed89f5)
  *  update dependency nodebb-theme-slick to v1.2.24 (#7699) (629b5ce3)
  *  update to eslint@6 (289dada5)
  *  update dependency nodebb-plugin-emoji to v3 (15020b46)
  *  update dependency nodebb-plugin-emoji to v3 (6b43d26f)
  *  update dependency nodebb-theme-persona to v10.1.0 (fc89516e)
  *  update dependency nodebb-theme-vanilla to v11.1.0 (c9689f11)
  *  update dependency nodebb-theme-persona to v10.0.1 (#7687) (ada8f22e)
  *  update dependency nodebb-theme-vanilla to v11.0.1 (#7688) (6db3604e)
  *  update dependency nodebb-theme-vanilla to v11 (89fea9d3)
  *  update dependency nodebb-theme-persona to v10 (0a7778bd)
  *  update dependency nodebb-theme-lavender to v5.0.10 (#7682) (e1e4abeb)
  *  update dependency nodebb-plugin-markdown to v8.10.0 (de046297)
  *  update dependency postcss to v7.0.17 (ae891390)
  *  update dependency nodebb-rewards-essentials to v0.0.14 (#7671) (3f4f8afa)
  *  update dependency mongodb to v3.2.7 (#7665) (988cbb63)
  *  update dependency nodebb-plugin-composer-default to v6.2.15 (e21246a9)
  *  update dependency nodebb-theme-persona to v9.1.38 (#7652) (d202be5b)
  *  update dependency nodebb-theme-vanilla to v10.1.34 (#7653) (e3308659)
  *  update dependency nodebb-theme-vanilla to v10.1.33 (#7651) (6f70397b)
  *  update dependency nodebb-theme-persona to v9.1.37 (#7650) (d43bdb41)
  *  update dependency async to v3.0.1 (#7649) (3b8e6e15)
  *  update dependency mongodb to v3.2.6 (#7616) (3f21096d)
  *  update dependency validator to v11 (a3d42404)
  *  update dependency nodebb-plugin-composer-default to v6.2.14 (#7635) (b174c2d2)
  *  update dependency nodebb-theme-vanilla to v10.1.32 (#7631) (85ca5b19)
  *  update dependency nodebb-plugin-composer-default to v6.2.13 (d1f29e26)
  *  update dependency nodebb-plugin-spam-be-gone to v0.6.3 (#7614) (20fa751c)
*  crash if post doesn't have topic data (eabc6f47)
*  don't touch objects that don't have the required fields (e52ecfaf)
*  add missing await to sendValidationEmail (f4381ba3)
*  #8007 added tfoot to clear new group button (dee1d447)
*  tests (e3c9dafa)
*  #8018, allow absolute urls in notification.path (0037a038)
*  #8010, fix isBanned call (59242d31)
*  #8003, check children recursively (c4e58160)
*  dont show delete topics on unread (b91c4790)
*  #8000, tweak wording; password reset success (3952849f)
*  parseInt cutoff (0e5e47f4)
*  lint (4b8897d9)
*  convert param to string in slugify (441dd86d)
*  cli/reset.js (#7979) (f9f85fc4)
*  #7977, fix undefined url (#7978) (95a372df)
*  passwords always expiring upon login (ddf3812c)
*  #7974 (#7976) (ca3be1f3)
*  delete follower/followingCount as well (d72b0d16)
*  event tests (0da4f7ee)
*  #7958, give rewards one by one (3775301f)
*  rewards page acp not loading rewards (88818a5b)
*  #7929, use fixed bootswatch (dd202931)
*  #7960, dont try to save size for non images (f272daaf)
*  #7941, validate some input fields (565f9726)
*  don't show deleted topics on unread (661a0f50)
*  #7951, don't send notification for system messages (c01b0fbd)
*  #7953, allow icon only group badges (5b458fc7)
*  remove 0 fields (ac4a5004)
*  remove unused data from post/topic/user hashes (75bcb0f4)
*  groups not visible on widget panes (205d3f9d)
*  new nav items will show group select (c5f7b66c)
*  move post and change owner (f402d727)
*  404 on new groups with spaces (b19f0a68)
*  #7940, run upgrade scripts on startup (7823144b)
*  #7949, delete old user notifs (38322ec3)
*  tests (6fb29e84)
*  check threshold before setting bookmark (f983f536)
*  mongo collection stats (4e28e575)
*  #7947, disable unused cookie (91e8e390)
*  #7945, show watched categories in ignored categories (c9bf6d0f)
*  db.init calls (18bf865d)
*  #7938, escape username in registration queue (d5dda26f)
*  #7901, handle group names that are translation keys (3455c27a)
*  fix the order of groups on user profile (41f8da2e)
*  #7935, ACP digest wording (54c9f877)
*  #7934, return tids (10f168b8)
*  tests (3caa387a)
*  tests (9c051386)
*  remove jquery (95ab0712)
*  picture not showing up in change modal (13c87059)
*  profile page meta tags getting escaped twice (7effc892)
*  missing await (2150701f)
*  potential for XSS here (40f131a6)
*  account/categories (7a0f6074)
*  redis tests (1f054c7e)
*  #7921, dont create wrong entries in db for flag (a651d154)
*  #7913, dont allow urls in fullname/location, validate birthday (babb9d7c)
*  upgrade scripts (bd026cb1)
*  only allow png/jpg/bmp in cover/profile images (96ab8d05)
*  #7919, add useUnifiedTopology (910b9b88)
*  crash in feed (873ec519)
*  lang key (795d4183)
*  time cutoff and lang string (5b8550f0)
*  returned data (87f6ac59)
*  dont send all category data back to recent&unread  etc (955e00fd)
*  #7912 (ecf39727)
*  only return necessary data for categories (307abaa8)
*  dont crash if callback is undefined (e0fec866)
*  #7800, dont crash on resize (781b3f1a)
*  change params (de461968)
*  remove dupe code (9b151b23)
*  #7894, translate log in to view (2a5fe2b8)
*  minor typo (b99279a8)
*  #7893, check private upload setting (0843497d)
*  #7892, handle string 'true'/'false' (77cb4b55)
*  dont show deleted topics in digest (4652c68b)
*  #7824, update timeago settings on userlanguage change (3887fc67)
*  don't move theme/plugin to top if its already active (acd95764)
*  #7853, dissociation on post purge (30a86ed5)
*  added comment back (0c4cd840)
*  inability for plugins to actually alter parser sanitization config (fe452762)
*  htmlentity instead of url encoding for room rename system message (9b8ac89e)
*  page count for filters (e291a609)
*  #7866, show correct title based on digest interval (547bb496)
*  #7780 (21e81f96)
*  pinned tids showing on page > 1 (f2912e9f)
*  #7860, allow running single upgrade scripts from plugins (a4dec7e3)
*  reset should not automatically build assets (a67762bc)
*  update morgan and lodash (2b1912a9)
*  #7842, groups.invite works with an array of uids (1e0190ab)
*  #7844, add uid to events, log plugin install/uninstall events (592d9c82)
*  removed console.logs (c44bf48c)
*  broken tests from 71b205a889da1ee8dd326b0891d122a522084f54 (f736f0b3)
*  typo (c6c13725)
*  category description getting translated in ACP (647713f3)
*  #7791 (71620519)
*  #7831, fix pagination (014e3153)
*  remove empty line (292bbe34)
*  remove useless catchs and empty line (5fce4558)
*  #7823, fix topic move readding pids when topic is deleted (fd5f9822)
*  #7826, fix order of categories on recent dropdown (3ecac97d)
*  redis pubsub not being required correctly (8d4f2086)
*  mongo.close using wrong client (186321e6)
*  digest not sending topics (bc6f22eb)
*  #7816, adding GDPR and TOU interstitials earlier on route reloading (52a2e5d6)
*  #7809, dont check postDelay if submitting from queue (9780f5b9)
*  newPostEditDuration (2abe244b)
*  #7789 (6a289fba)
*  #7798, fix nested post selection (666e0eaf)
*  #7788, fix on topic move and new post (8bf40d04)
*  #7788, fix another edge case (053ff510)
*  topicData passed to action:topic.edit (b10ad7b6)
*  derpy catch (ce912886)
*  #7788 No new posts (#7793) (3c32d860)
*  user urls in subfolder install (6a486e35)
*  #7765 (0b498acd)
*  tests (87552c55)
*  revert requires (3dd806dc)
*  #7763, parse about me on all profile pages (f8d34101)
*  status and groupTitle, if its not set (e2e33dfb)
*  don't return promise (2f0a331f)
*  socket.io methods calling callbacks twice if method returns promise (44a33520)
*  tests (87b1148f)
*  tests (930ffd07)
*  #7601 removed check for another user when sending messages (0e8ee31b)
*  mongodb tests (3b24de4c)
*  getTopicsFromSet (13aaf07b)
*  #7762, allow array for isBanned (9eb1fcd4)
*  add flag for change post owner (46639be3)
*  sitemap ajaxify (9f78bd7a)
*  #7751, make necro separator a partial (2b70e86f)
*  #7748, if reputation system is disabled, dont check min reputation (7b95ebbb)
*  remove left over code, use proper names (0ac49d63)
*  compatibility conditional (fba67196)
*  private upload img replacement should happen before img wrapping (16aae517)
*  #7423 private uploads are linked to login page, for guests (49e3a368)
*  typo (f3440ebf)
*  #7722, hsts deprecation warnings (8b1dadb7)
*  upgrade script #7720 (accf48f3)
*  indents (a5de54f8)
*  remove debug code that should not have made it in (af17c6e3)
*  dont display post tools if there are no options (708df46e)
*  output span in buildAvatar helper instead of div (69fae1a7)
*  restore uid in teasers userObj (67b8cb89)
*  dont allow edit if post is deleted by someone else (667bc67f)
*  dont show delete posts on profile (e48c7cd7)
*  on new post add it to cid::uid::pids (6a7bc1c5)
*  #5570, create per category user post zsets (a39f0ef5)
*  restrict drag drop to pin icon, closes #7702 (e1c05e59)
*  remove dupe code (68e5d7ad)
*  get uids directly for csv (39ee3980)
*  typo (a251032f)
*  id/for (b4cc8d88)
*  #7659 add option to change cookie link url (25ea6347)
*  middle vertical-align for .avatar elements (1894cd9b)
*  dependency checker always triggering dep upgrade, hopefully (c241551d)
*  #7483, show latest undeleted message as teaser (644504ff)
*  #7567, allow invite and approval at the same time (4b843ba1)
*  #7625, on group rename update nav/widget items (5b85ed31)
*  psql error (8d319e42)
*  try to fix psql :dog: (2e6b562f)
*  no need for moderate bit for global mods and admins (8aef689f)
*  attribute name so it works for both templates (ebb32e78)
*  #7647, fix getModeratorUids (64679b37)
*  #7644 (5cd9e1bf)
*  bad usage of async requisition (603c5262)
*  7638, returnTo accidentally saved into user hash (f321b426)
*  #7634, make strip exif configurable (157b921e)
*  #7636, use reputation threshold for post queue (a8409fbd)
*  #7623, wait for lastonline to update on /users (63e5d383)
*  https://github.com/barisusakli/nodebb-plugin-dbsearch/issues/53 (e65ddc98)
*  #7593, unable to set account password if no password set (80c0d579)
*  incorrect pathname format for app.previousUrl (a97e97b9)
*  #7598, use notice element instead of alert (106d52a4)
*  #7620, allow adding new fields into user objects for posts (a8e65205)
*  #7629, new filter hook for room rename (7ba4a864)
*  #7628, log email send errors (7a4b68e8)
*  {username} not working in notification.tpl (f55cc667)
*  do not prevent nbb from starting (3b0459a0)
*  #7624, default open state on stateless flags (91f0bce6)
*  #7431, add /unread link to topic route (15391da5)
*  #7619 (35d10f76)
*  #7618 save pathname into app.previousUrl ins. of entire url (7e5cb72a)
*  handle missing timestamps (172e6888)
*  broken test for meta tags on ajaxify (b70e03a7)
*  #7613 (15ce23da)
*  #7600, removing nbsp from email CTAs (#7606) (f552cea5)
*  #7604 shortened CTA text and added custom text for some notifs (#7605) (b32da57f)
* **style:**
  *  requiring parens in block bodies (29f96b19)
  *  updated code to follow new eslint recommendations (09212309)

##### Refactors

*  use arrow function (6b3eb014)
*  async/await (02d38caf)
*  remove log, topics.exists (f8c8038a)
*  async/await (dc8d721c)
*  async/await mongo (1f0c6f3d)
*  async/await socket.io/index (603908c1)
*  async/await image.js (c5ffd8cc)
*  remove var (05e753c7)
*  async/await flags.js (ac6eb31c)
*  async/await flags (0ced71be)
*  shorter map (572bc297)
*  remove logs (03971049)
*  dont modify key (7e7ea7a6)
*  remove logs (e32a5546)
*  async/await flags (9ee1a882)
*  shorter, new Date doesnt throw (625b0815)
*  remove temp var (b842057f)
*  async/await file (f9d6912b)
*  async/await analytics (223c108c)
*  change to const (5505628c)
*  returned fields (86b16629)
*  async/await emailer (63bd3fc5)
*  async/await routes/feeds (ec3b5dd9)
*  async/await rewards (b110aec6)
*   async/await socket.io (a7d2b8a1)
*  async/await (52b2d670)
*  async/await (75d7ae92)
*  async/await socket.io/topics (5c2afe5e)
*  async/await controllers/user.js (3c6c40b1)
*  async/await uploads (5c0266d8)
*  move tos parsing to /tos (3e2ed21d)
*  remove commented out code (ec98945a)
*  async/await controllers/authentication (b9105ef9)
*  remove async from isPasswordValid, function is sync (22f80116)
*  make categories.buildForSelectCategories non async (6cda3698)
*  remove dupe code (a4d84a66)
*  async/await socket.io/posts (e93ef0d7)
*  async/await socket.io/admin (88dfbf21)
*  socket.io/admin/categories async/await (71e50bbf)
*  admin groups.join socket async/await (4588a4fd)
*  password async/await (dd8386d9)
*  sitemap to async/await (0164e51f)
*  remove hook assign (d3727207)
*  async/await users (f9a804e0)
*  remove empty line (19b63bfa)
*  remove vars (69333f59)
*  async/await controllers (2c4f0446)
*  async/await controllers/tags (53624885)
*  async/await (f15c7f12)
*  globalmods/groups (0722cc47)
*  controllers/category.js (bd8736db)
*  use arrow func (27c27b49)
*  async/await controllers/api (4eaa630b)
*  async/await admin/controllers (6f375482)
*  async/await, remove dupe code for homepage routes (c9250a01)
*  async/await for src/socket.io/groups.js (71b205a8)
*  rewrote SocketPosts.getRawPost in await style (08530bb3)
*  replace avatar conditional code with buildAvatar helper (#7681) (25238899)

##### Reverts

*  accidental removal of some needed translation source strings (868dedd1)

#### 1.12.2 (2019-05-15)

##### Chores

*  incrementing version number - v1.12.2 (22db818e)
*  bump themes #7576 (d349754d)
*  bump themes (59bdc970)
*  bump themes (abcca134)
*  bump themes (551b18cd)
*  incrementing version number - v1.12.1 (dd973abe)
* **deps:**
  *  update dependency lint-staged to v8.1.7 (dc6b49ca)
  *  update commitlint monorepo (9998e86b)
  *  update dependency jsdom to v15.1.0 (fcd6dc88)
  *  update dependency mocha to v6.1.4 (3ff8154b)
  *  update node:8.16.0 docker digest to b5484d1 (6421f10f)
  *  update dependency husky to v2.3.0 (c20e3313)
  *  update dependency nyc to v14.1.1 (#7584) (9047210c)
  *  update dependency eslint to v5.16.0 (692e2ead)
  *  update dependency nyc to v14 (9210baf5)
  *  update dependency husky to v2.2.0 (8a018a5f)
  *  update dependency lint-staged to v8.1.6 (4e39caf8)
  *  update dependency husky to v2.1.0 (65ff0bbd)
  *  update dependency husky to v2 (e81a1dbb)
  *  update dependency eslint-plugin-import to v2.17.2 (#7546) (c1fb17f9)
  *  update dependency jsdom to v15 (#7556) (d4d8d98f)
  *  update dependency jsdom to v14.1.0 (#7555) (ca694fd1)
  *  update node.js to v8.16.0 (#7554) (f10708e7)
  *  update dependency eslint-plugin-import to v2.17.1 (69dd8e4d)
  *  update dependency mocha to v6.1.2 (b7169772)

##### Documentation Changes

*  updated changelog (93b688d0)

##### New Features

*  let theme know downvoting is disabled, closes https://github.com/NodeBB/NodeBB/pull/7568 (bd94fbc2)
*  closes #7583 (cf5aeace)
*  #7319 (9385c8e3)
*  add node12 to travis (1a7036a6)
*  allow file uploading on registration interstitial (ddffc904)
*  #7527 (ba5e1eaa)
*  #7515 (c38db4f7)

##### Bug Fixes

*  #7599 image size measurement erroring out on missing path (0d86781c)
*  #7590 updated chat and post edit and delete timeout labels in ACP (4f0dc443)
*  tests (3a7e99a5)
*  #7586, switchTimeagoLanguage shouldn't discriminate against languages w/o shorthands (1703233f)
*  #7576 "Disable password changes" can be sidestepped (50260e13)
*  if editing password is disabled in ACP, prevent direct access via route/socket  (related: #7576) (e114b16d)
*  #7582 (c9ca72d0)
*  #7461 (96cb29aa)
*  increase batch size (3d938e7b)
*  #7564 (bf6fc502)
*  group cover upload not working for s3 upload (#7571) (8945ebcb)
*  test (b9903120)
*  #7539 (c940a733)
*  #7565 (07e9b67e)
*  #7464 (32cf07d7)
*  #7147 (fe6d64cc)
*  #7424 (f86d74d8)
*  #7562 (09681e6c)
*  node12 tests (8775e7e6)
*  add post queue to /compose POST route (c6cd6c57)
*  remove redis object cache (4df925e7)
*  #7545 (74038849)
*  failing test from 00552d7183f0416a0caa113fe2f1e658659648f7 (9bf3517d)
*  fire filter:register.complete for users approved via registration queue (00552d71)
*  #7540 (8778f00b)
*  more graceful error handling and output for cli/reset (d3ebda73)
*  #6438 only apply whitelist when fields request empty (#7528) (808c4909)
* **deps:**
  *  update dependency nodebb-theme-vanilla to v10.1.31 (#7589) (a9f9d19b)
  *  update dependency nodebb-theme-persona to v9.1.36 (#7588) (bd86e58d)
  *  update dependency mongodb to v3.2.4 (#7581) (26d6d0be)
  *  update dependency postcss to v7.0.16 (10a47a29)
  *  update dependency nodebb-theme-persona to v9.1.33 (#7563) (7c4201f2)
  *  update dependency sharp to v0.22.1 (#7561) (288a25f0)
  *  update dependency nodebb-plugin-composer-default to v6.2.12 (#7538) (a54f8f00)
  *  update dependency mongodb to v3.2.3 (97a7f02f)

#### 1.12.1 (2019-04-10)

##### Chores

*  incrementing version number - v1.12.1 (dd973abe)
*  comment cleanup (6bed51ef)
*  bump persona (1f4db132)
*  bump themes, fix: https://github.com/NodeBB/NodeBB/issues/7446 (0d19bb3d)
*  incrementing version number - v1.12.0 (d87f8c52)
* **deps:**
  *  update dependency lint-staged to v8.1.5 (ae17481d)
  *  update node:8.15.1 docker digest to 918f0be (5f787d73)
  *  update node:8.15.1 docker digest to 3d43ad1 (ea77ad4e)
  *  update dependency grunt to v1.0.4 (a9130fad)
  *  update dependency eslint to v5.15.3 (d2932cf6)
  *  update dependency mocha to v6.0.2 (#7408) (1c671c32)
  *  update dependency eslint to v5.15.1 (d8486e88)
  *  update node:8.15.1 docker digest to c151597 (2cb0bdea)
  *  update dependency jsdom to v14 (a967253a)

##### Documentation Changes

*  updating changelog (9aeb291e)

##### New Features

*  #7515 (ac889db1)
*  update unban logic/invocation and refactor User.bans module (3fbb6faf)
*  add original sessionID to static:user.loggedOut (abe4abb6)
*  #7501 (2ee2cd52)
*  allow multiple cids for getActiveUsers (81306fff)
*  manual password expiry. closes #7471 (24dcae21)
*  #7358 (7211dde7)

##### Bug Fixes

*  don't crash if templateData is undefined (eb2c3e56)
*  clear children before building tree (397e062a)
*  upgrade script date (4f3ca4d8)
*  #7519 (ed91d3f2)
*  #7517 (e479fad7)
*  #7470 Properly handle recompilation of email templates (75ae29c1)
*  resolve CORS error on uploading via URL (3871a02c)
*  #7461 (dbc4d840)
*  #7491 (8cc1864a)
*  #7476 (4db0efe3)
*  #7508 (b52dba5c)
*  escape search snippet closes #7506 (e906bea4)
*  #7490 once again (3ec9fc40)
*  #7502 (3304ffe9)
*  #7503 (1f3554ff)
*  #7493, adding robots noindex meta tag to compose and reset routes (6415ba82)
*  #7490, handling of image sizes if no size saved in db (86e1cdd5)
*  #7494 (8f55ab13)
*  #6911, email throttling options set (63e16ec0)
*  throttling email output to 2 messages every second, fixes #6911 (33a1bf6c)
*  #7469 missing email logos, occasionally (8d62ead3)
*  #7487 (fddb783e)
*  #7485 (78e0b983)
*  move upload_url to prestart so it is defined in upgrade scripts (ad2d7a69)
*  #7342 (cead89f0)
*  #7477 (240f563a)
*  #7473 (c289b904)
*  #7378 (c37b2f2e)
*  #7454 (dcdd41c7)
*  #7472 (962b7f73)
*  remove async.series, dont crash if postAtIndex is undefined (dd8d4f20)
*  tests (c12e1d19)
*  #7468 (b4a9bb10)
*  #7444 Re-factor handling of og:image tags (#7463) (697a6597)
*  tests (45d7e37a)
*  callbacks (b48b6d75)
*  return early if keys is empty (7addc5a0)
*  return early if keys is empty (b3962c16)
*  prevent infinite loops if category is already in children (b71e0eb1)
*  #7448 (4732bed3)
*  return early if there are not blocked uids (73d14e45)
*  #7008 (756dfd8a)
*  typo (f9d92db5)
*  tests (e71ae80c)
*  #7406 (cbfbcee5)
*  #7432 (777ca032)
*  change user/system cpu usage (aecdf739)
*  strip exif data on image uploads (5eaa14e7)
* **deps:**
  *  update dependency nodebb-theme-persona to v9.1.29 (e5c12a49)
  *  update dependency nodebb-plugin-composer-default to v6.2.11 (30b042b8)
  *  update dependency nodebb-plugin-composer-default to v6.2.10 (cf180e09)
  *  update dependency html-to-text to v5 (b39ce25c)
  *  update dependency semver to v6 (8662aa95)
  *  update dependency spdx-license-list to v6 (447cf66b)
  *  update dependency nodebb-widget-essentials to v4.0.17 (#7489) (0f9cb86d)
  *  update dependency mongodb to v3.2.2 (#7482) (357f931c)
  *  update dependency nodemailer to v6 (0274c2bd)
  *  update dependency sharp to v0.22.0 (#7466) (c3261415)
  *  update dependency nodebb-theme-slick to v1.2.23 (#7460) (c20cd528)
  *  update dependency nodebb-theme-vanilla to v10.1.25 (fe30e06d)
  *  update dependency nodebb-theme-persona to v9.1.27 (5c605392)
  *  update dependency connect-redis to v3.4.1 (02804fe9)
  *  update dependency nodebb-plugin-composer-default to v6.2.9 (#7442) (80293146)
  *  update dependency nodebb-theme-vanilla to v10.1.23 (#7438) (48dd3c5b)
  *  update dependency nodebb-theme-slick to v1.2.22 (#7437) (3f4ae4b0)
  *  update dependency nodebb-theme-persona to v9.1.25 (#7436) (9887bb4f)
  *  update dependency nodebb-plugin-composer-default to v6.2.8 (#7435) (c18f2e1f)

### 1.12.0 (2019-03-06)

##### Chores

*  incrementing version number - v1.12.0 (d87f8c52)
*  incrementing version number - v1.11.2 (757bff27)
* **deps:**
  *  update node:8.15.1 docker digest to 287b8a5 (0b8d1833)
  *  update node.js to v8.15.1 (ae89db28)
  *  update dependency mocha to v6 (#7387) (30bdb1a1)
  *  update dependency coveralls to v3.0.3 (#7397) (cf74904c)
  *  update dependency eslint to v5.14.1 (4df9c206)
  *  update dependency jsdom to v13.2.0 (cb5e3d83)
  *  update node:8.15.0 docker digest to a8a9d8e (edcb5314)
  *  update dependency nyc to v13.3.0 (a78f5da5)
  *  update dependency lint-staged to v8.1.4 (18c90913)
  *  update dependency eslint to v5.14.0 (9d8d2d0d)
  *  update commitlint monorepo (aed5b29d)
  *  update dependency eslint-plugin-import to v2.16.0 (e0fa6965)
  *  update dependency @commitlint/cli to v7.4.0 (362d9397)
  *  update dependency lint-staged to v8.1.1 (96644350)

##### Documentation Changes

*  updated changelog (aec2f210)

##### New Features

*  admin/groups style change (2b6f1a05)
*  add process cpu usage to admin (db477538)
*  pass options to digest (23da3009)
*  revamp email templates to be more style agnostic (#7375) (f32a9922)
*  lower search timeout (fc830c0f)
*  quick search (8a0e1280)
*  add vote status to getPostData API call (eafe76de)
*  make topic search a function (d2b83967)
*  quick search (c01d43e0)
*  check overide (ba90bf31)
*  check CI failure (f2d7f75e)
*  logging password resets and errors into event log (0c09b740)
*  add `action:alert.new`, `action:alert.update` hooks (daadcc48)
*  allow themes to define custom classes for categories via filter:admin.category.get (5031bfe8)
*  show more unread notifs (d75a0d77)
*  pass topic creation data to action:topic.save (cd2f72fb)
*  textcomplete over jquery-textcomplete, closes #7309 (02a8ed9b)
*  new hook filter:privileges.posts.edit (f659ef4d)
*  new hook type: `response` (a23854e3)

##### Bug Fixes

* **deps:**
  *  update dependency nodebb-theme-persona to v9.1.24 (0f2d3181)
  *  update dependency nodebb-plugin-composer-default to v6.2.7 (#7411) (9ebc900a)
  *  bump markdown (82c8ee3f)
  *  bump markdown (7ce5a81f)
  *  bump persona (a0b71f09)
  *  update dependency nodebb-theme-vanilla to v10.1.21 (#7404) (699eddcb)
  *  update dependency nodebb-theme-persona to v9.1.22 (#7403) (d87751ea)
  *  update dependency nodebb-theme-persona to v9.1.21 (#7401) (f721155d)
  *  update dependency nodebb-theme-slick to v1.2.21 (#7398) (f6e55651)
  *  update dependency nodebb-widget-essentials to v4.0.14 (#7399) (f812e0b7)
  *  update dependency nodebb-theme-persona to v9.1.19 (#7392) (deff7b34)
  *  update dependency nodebb-plugin-composer-default to v6.2.6 (#7389) (fab32a49)
  *  update dependency nodebb-theme-persona to v9.1.18 (042b81a0)
  *  update dependency nodebb-theme-persona to v9.1.17 (#7379) (546e04e1)
  *  update dependency nodebb-plugin-composer-default to v6.2.5 (#7374) (d0874f34)
  *  update dependency async to v2.6.2 (#7365) (264eadde)
  *  update dependency nodebb-plugin-composer-default to v6.2.4 (30ff4582)
  *  update dependency nodebb-theme-persona to v9.1.16 (65df6711)
  *  update dependency nodebb-plugin-markdown to v8.9.0 (07b29d59)
  *  bump contenteditable to v0.1.1, #7325 (fbbe2ab7)
  *  update dependency nodebb-plugin-composer-default to v6.2.3 (#7341) (176efb5f)
  *  update dependency nodebb-theme-persona to v9.1.15 (#7295) (8f69ffd4)
  *  update dependency nodebb-theme-slick to v1.2.20 (#7197) (a82bd3d0)
  *  update dependency nodebb-theme-lavender to v5.0.9 (#7322) (b350be27)
  *  update dependency nodebb-plugin-composer-default to v6.2.2 (99f82fb3)
  *  update dependency winston to v3.2.1 (#7317) (7e872d32)
  *  update dependency nodebb-plugin-markdown to v8.8.8 (#7314) (9cf81afe)
  *  update dependency nodebb-plugin-dbsearch to v3.0.6 (#7305) (d48ef6d8)
  *  update dependency nodebb-plugin-dbsearch to v3.0.5 (#7304) (57e3f162)
  *  update dependency nodebb-theme-vanilla to v10.1.19 (#7301) (443dcee4)
  *  update dependency winston to v3.2.0 (#7299) (6f957cb9)
  *  update dependency nodebb-plugin-spam-be-gone to v0.6.0 (247ac828)
*  #7413 (684175f7)
*  #7414 (e331f6b5)
*  l2spread @baris nib (0360f6e1)
*  restored email logo to all outgoing emails (6c1f9c3c)
*  die hydra!!! (ad6c8dcc)
*  incorrect teaserPost logic (97313508)
*  normalized font sizes for paragraphs in digest (43c4eb23)
*  removed notification subheader translation string (6f272e34)
*  broken 50% border radius on emails, failing tests (d3a10628)
*  hook names getting objectified by winston (6472a065)
*  failing tests from revamped-emails branch (3a7f1c19)
*  #7395 (03305db8)
*  mounting of all-route middlewares to router instead of app (d722f3b8)
*  incorrect returnTo set in registerComplete (f972f752)
*  search.api not working on subfolder (158f68eb)
*  tests for #7385 (7a534453)
*  #7385 better handling for errors in Adv>Databases (57069a5c)
*  no relative path needed in req.session.returnTo (949b10f1)
*  don't refresh page when enabling/disabling categories (d5ece9a4)
*  #7373 (c2e7ae7f)
*  autocomplete not triggered if chat switched (ab0e547d)
*  #7366 (6c2f48f1)
*  #7357 (45c322ae)
*  #7359 (2996a5dc)
*  re-introducing indeterminate checkbox state to ACP privs (e8f3c256)
*  #7354 (c6ad8fae)
*  uid check (efd7d953)
*  uid checks (c24dcf78)
*  only allow numbers as scores (#7356) (5917dec2)
*  #7231, missing success alert on group name change in ACP (0fffcb38)
*  remove debug logs (fe63fca8)
*  don't use same db as prod values (39e35275)
*  database 0 was being replaced with undefined because 0 is falsy (bcd62586)
*  #7352 (2e2c3ac1)
*  #7261, banned users still get digests (aca05560)
*  #7346, panel-header widget colours in ACP (91a7b907)
*  #7350 (8c68780e)
*  eslint failure from daadcc4889a91b9bbd279d49db348610cc079ccc (96b6ce1f)
*  prevent crash if results.stats or results.serverStatus is undefined (fab52b84)
*  move `action:alert.update` to after translator (d864da1a)
*  #7098 (fc6767e1)
*  #7232 (70d9c6c4)
*  #7229 (e59b907d)
*  #7339 (12c58990)
*  #7338 (8e3bf581)
*  dont crash if userData is undefined #7262 (56a493d8)
*  #7240 (a2f08e7d)
*  give default privs on new install to guests/spiders (cd120990)
*  #6806 (c72da559)
*  #7334 (ae779ea4)
*  closes #7217 (9d1fcf4e)
*  merge post notifs (6e69a9ab)
*  don't crash if body doesn't have `skin-` (f6cfbbb5)
*  #7324 (c7abf07a)
*  allow regular groups to local login (0366cfd8)
*  #7316 (5353960a)
*  #7306 (8aebe884)
*  #7312 (7a4a8ea4)
*  #7311, missing dependencies (263e58df)
*  #7300 (920efad0)
*  #6848 (70f8b418)
*  #7298 privilege header misalignment (df6f75eb)
*  #7211 (cf918078)
*  #7215 (7a9780f6)
*  #7296, local login privilege available to registered-users only (7fb3c168)
*  #7094 (d03220cd)

#### 1.11.2 (2019-01-24)

##### Chores

*  incrementing version number - v1.11.2 (757bff27)
*  incrementing version number - v1.11.1 (2104877c)
* **deps:**
  *  update node:8.15.0 docker digest to cb66110 (1719cd77)
  *  update dependency eslint-plugin-import to v2.15.0 (f7191eb9)
  *  update dependency eslint to v5.12.1 (d928c54d)
  *  update dependency @commitlint/cli to v7.3.2 (6ae2b972)
  *  update node.js to v8.15.0 (ac39fe90)
  *  update dependency eslint to v5.12.0 (f96ef7bb)
  *  update commitlint monorepo to v7.3.1 (50594118)
  *  update dependency smtp-server to v3.5.0 (00063708)
  *  update dependency husky to v1.3.1 (719995a4)
  *  update dependency eslint to v5.11.0 (#7151) (26f3bdbf)
  *  update dependency husky to v1.3.0 (eb606281)
  *  update dependency jsdom to v13.1.0 (60e9430b)
  *  update dependency eslint to v5.10.0 (#7084) (dae861da)
  *  update dependency husky to v1.2.1 (63f4b569)
  *  update node:8.14.0 docker digest to dd2381f (7449ae3e)
  *  update node.js to v8.14.0 (8a5a031d)
  *  update dependency lint-staged to v8.1.0 (dd7f8a14)
  *  update dependency husky to v1.2.0 (aee21628)
  *  update node:8.12.0 docker digest to 5dae8ea (0ef451dd)
  *  update dependency husky to v1.1.4 (95d6ab06)
  *  update dependency eslint to v5.9.0 (92441794)
  *  pin dependencies (b0483f21)
  *  update dependency eslint-config-airbnb-base to v13 (#6599) (64b9dabf)
  *  update node.js to v8.12.0 (fa3afbd2)
  *  update dependency husky to v1.1.3 (6cee5b8e)
  *  update dependency lint-staged to v8.0.4 (9d258668)
  *  update dependency lint-staged to v8.0.3 (aaa6fe9e)
  *  update dependency lint-staged to v8 (95d7a5fa)
  *  update dependency jsdom to v13 (52f141c9)
* **husky:**  setting up husky as recommended in docs (e8a3d929)

##### Documentation Changes

*  updated changelog for v1.11.1 (c04e192d)

##### New Features

*  new hook filter:user.logout (63061ffd)
*  explicit handling of SSO success and failure (059a4be2)
*  additional options for SSO plugins (2b9322e1)
*  get rid of disk access (ed5d2d6d)
*  support for one-click unsubscribe from email clients (#7203) (70a87d43)
*  added new hook `static:sockets.validateSession` (#7189) (0263b4da)
*  #7120 (f4ea2c43)
*  #7032 (0c1ac4d6)
*  small fixes (fef7e13c)
*  name topic controller (b9b9d8b2)
*  header (0cb9bba4)
*  more naming (ae0fe5e8)
*  give the rest of the middlewares names (f88db22c)
*  give names to more middlewares (fdfbcc6e)
*  give names to middlewares (53793e16)
*  change sortedSetsScore (d2c2d56f)
*  Allow getting logfile path from config (#7044) (f3e8e065)
*  remove uid:<uid>:ignored:cids (#7099) (263c9180)
*  cache category tag whitelist (78fa7340)
*  make user cards look less derpy (31bb2ae9)
*  added new middleware authenticateOrGuest (4fba1492)
*  closes #7070 (7ca62b83)
*  added README.md in languages folder (648964fa)
*  up composer (7eee8e1d)
*  allow array results (54c127d1)
*  #7023 (f581c052)
*  close #7002, console message if mismatched origins (89c025d1)
*  added changelog file to root of repo (e89b4fca)
*  enabling commitlint (c58a41ed)
*  allow disabling of GDPR features via ACP toggle, closes #6847 (4919e9ef)
* **deps:**  update bootstrap to v3.4.0 (#7106) (d1ea5d15)
* **email:**  don't escape html in notification bodies. (#7042) (d7c55bc3)

##### Bug Fixes

*  test (bc41848a)
*  #7235 (7064fd06)
*  use ACP config value for checking online status (ef0e7808)
*  log error to prevent headers already sent (a22a3a98)
*  #7289 timeago shorthand toggle fails on non-existant language (cee47f78)
*  #7276 improper request for client-noskin.css (5ee173c2)
*  #7274 incorrect handling of client script 404s (831d0795)
*  #7270 Flags graph label not translatable (8ceb35f5)
*  #7266 body does not contain skin class (f122fc44)
*  generate timeago codes from files (7524d3c3)
*  removal of timeago fallback middleware (#7259) (c831ff0d)
*  post queue notifs (ac655564)
*  added missing translation and error state for password change (51b5fb98)
*  #7236, header search stops working after header update (3859d417)
*  #7226, added placeholder styling for fa-nbb-none (87c2d108)
*  escape hook method (9328eeca)
*  #7216, hide taskbar on chat modal invocation on mobile (a70db885)
*  #7208 (428f587c)
*  #7054 (a662f118)
*  #7209 (b9833483)
*  missing notification (1a3838e1)
*  #7193, closes #7194 (7809ba28)
*  #https://github.com/barisusakli/nodebb-plugin-dbsearch/issues/49 (6f1fb4eb)
*  #7187 (28459d04)
*  #7176, FUOC on app.reskin() (954af0f0)
*  #7174 (9aa1aa68)
*  #7181 (0d409610)
*  #7142 (8da3b2a4)
*  #7179 (03299736)
*  #7169 Fixed logout being broken (b0eaa858)
*  #7167, composer and chat not closing on logout (629b3554)
*  shorter function (43e7cc0a)
*  #7162 (2da0a657)
*  uid filtering (72afc180)
*  dont crash if default cover is invalid (41fb5cca)
*  #7136 socket.disconnect() now called on invalid session (8e9de540)
*  RTL not respected when changed in user settings, related to #7146 (4873a339)
*  #7146 Better RTL handling on (de-)authentication (d81e0a5f)
*  #7118, invoking autoLocale middleware on logout (900f0a0b)
*  closes #6784 (#7137) (7fb29f42)
*  7100 (ab81cca7)
*  #7139 (3917022a)
*  #7116 (7e828404)
*  #7138 (29a85aec)
*  lint (b47f939b)
*  #7091, #7093 (69e0dbbf)
*  #7131 (d31684e8)
*  remove cache (b2a74b41)
*  loop (60390c01)
*  #7124 (4650a760)
*  unread badge (9f506268)
*  move the check to get methods (99e0895e)
*  #7115 (989879a6)
*  #6979 (29b63ae7)
*  upgrade script key (0eef3e1c)
*  remove log (00afc5b3)
*  #7108 (81697390)
*  dont save data for non-positive uids (62f01a83)
*  #7103 (f103390a)
*  dont update cid:<cid>:tids:votes if topic is pinned (2f57a4b9)
*  #7102 (d117df77)
*  #7102 (85a07e99)
*  don't explode if there is no css el (74d0e88d)
*  db info page (26ccd8f6)
*  logAttempt conditional (a6c8e0ab)
*  #7087, server-side protection against guest blocks (33d4956b)
*  don't crash in flags.validate if user blocked target (81aa3a0b)
*  dont send empty strings (555c092f)
*  #7085 (fe0f95a2)
*  #7086 (e55fb437)
*  wrong variable #7085 (71163421)
*  admins&mods when there are mutliple lines of users (de437e36)
*  refreshing settings page on save if language changed (ed46c5e2)
*  not calling authenticate middleware on resource direct access routes (eeaee8cc)
*  #7038, autoLocale logic not playing nicely with no-refresh auths (#7059) (5f3d1c76)
*  #7074 (2604cf63)
*  #7071 buildSkinAsset won't rebuild continuously (a07d9898)
*  #7063, logout code should do hard page nav to / or data.next (6df5668e)
*  #7061 (eab297bd)
*  skin not changing after login or logout, #7038 (28a1fa78)
*  #7040 (a63ddbe2)
*  #7041 (ec0c50d4)
*  #7043 (8d7c3897)
*  add missing render function (cb7c2d8c)
*  #7033 (8808a033)
*  #7037 (b86f1556)
*  #6991, add timeout for version Github request (43c3bb02)
*  #7030 (58d4376f)
*  added admin/manage/uploads to tx config (7357926f)
*  #7013, add cache buster to js-enabled.css (f6b92c1d)
*  removal of scroll anchoring code in favour of browser handling (98c14e0e)
*  custom navigation item not showing groups (d9452bf3)
*  flags detail page crash if reporter blocks author (d027207f)
*  #6922, skin assets not including plugin LESS files (a5022ce4)
*  #6921, allow square brackets in usernames (da10ca08)
*  interstitial redirects failing if done via ajaxify (3c8939a8)
*  username trim on login, closes #6894 (157bea69)
* **deps:**
  *  update dependency nodebb-widget-essentials to v4.0.13 (#7293) (22cbcc3e)
  *  update dependency mongodb to v3.1.13 (1aadbc3c)
  *  update dependency postcss to v7.0.14 (4d64de76)
  *  #7271, updating autoprefixer to latest version (a7af0198)
  *  #7270 (b48f1b4d)
  *  update dependency sharp to v0.21.3 (#7267) (8a64667f)
  *  theme upgrades for #7266 (5607261c)
  *  update dependency mongodb to v3.1.12 (eeab7d20)
  *  update dependency mongodb to v3.1.11 (#7252) (b5f188b6)
  *  update dependency validator to v10.11.0 (77dc8fc7)
  *  update dependency nodebb-plugin-composer-default to v6.1.21 (2fbb2614)
  *  update dependency postcss to v7.0.12 (f1842295)
  *  update dependency postcss to v7.0.11 (57bec2fb)
  *  update dependency sharp to v0.21.2 (8f3c4b09)
  *  update dependency postcss to v7.0.10 (82475fe5)
  *  update dependency postcss to v7.0.9 (f171c169)
  *  update dependency nodebb-theme-vanilla to v10.1.15 (ea059e89)
  *  update dependency nodebb-theme-persona to v9.1.10 (96482569)
  *  update dependency nodebb-theme-persona to v9.1.9 (bbe05043)
  *  update dependency nodebb-theme-vanilla to v10.1.14 (6cc5dbc8)
  *  update dependency nodebb-theme-persona to v9.1.8 (e5443690)
  *  update dependency pg-cursor to v2 (29acad42)
  *  update dependency diff to v4 (#7198) (84e228bb)
  *  update dependency nodebb-plugin-mentions to v2.5.2 (#7199) (0a647316)
  *  update dependency nodebb-plugin-markdown to v8.8.7 (90b4d40e)
  *  update dependency rimraf to v2.6.3 (f4cc3122)
  *  update dependency spider-detector to v1.0.19 (#7177) (0faba325)
  *  update dependency nodemailer to v5 (4993b03c)
  *  update dependency json-2-csv to v3 (80cee665)
  *  update dependency nodebb-plugin-composer-default to v6.1.20 (07bf0b98)
  *  update dependency nodebb-theme-persona to v9.1.7 (#7161) (c68d4ae8)
  *  update dependency nodebb-plugin-composer-default to v6.1.19 (#7159) (07af46ea)
  *  update dependency nodebb-plugin-composer-default to v6.1.18 (#7158) (584b45fc)
  *  update dependency validator to v10.10.0 (#7152) (8003bed8)
  *  update dependency nodebb-plugin-mentions to v2.5.0 (792dce14)
  *  update dependency nodebb-theme-persona to v9.1.6 (#7141) (325b0293)
  *  update dependency nodebb-plugin-dbsearch to v3.0.4 (ddd07c1a)
  *  update dependency nodebb-widget-essentials to v4.0.12 (#7133) (f614a44d)
  *  update dependency nodebb-plugin-mentions to v2.4.0 (9ab31d7e)
  *  update dependency postcss to v7.0.7 (7ef8c3fd)
  *  update dependency sharp to v0.21.1 (#7082) (bf75f3e3)
  *  update dependency nodebb-theme-vanilla to v10.1.13 (#7114) (fc5598b9)
  *  update dependency nodebb-theme-slick to v1.2.19 (#7113) (56ad43aa)
  *  update dependency nodebb-theme-persona to v9.1.5 (#7112) (953f8fe5)
  *  update dependency nodebb-plugin-composer-default to v6.1.17 (3bcfd7fc)
  *  update dependency nodebb-theme-persona to v9.1.4 (b6ad5fd4)
  *  update dependency nodebb-plugin-markdown to v8.8.6 (#7079) (46fb365d)
  *  update dependency nodebb-theme-persona to v9.1.3 (#7075) (d2aea57a)
  *  update dependency nodebb-theme-persona to v9.1.2 (42e792ab)
  *  update dependency nodebb-theme-persona to v9.1.1 (#7069) (bdb33056)
  *  update dependency postcss to v7.0.6 (6b5428c5)
  *  update dependency nodebb-plugin-composer-default to v6.1.14 (#7058) (e48ed6e0)
  *  update dependency nodebb-plugin-composer-default to v6.1.13 (#7057) (ada1d6d0)
  *  update dependency nodebb-plugin-composer-default to v6.1.12 (#7056) (9f9f72da)
  *  update dependency nodebb-plugin-composer-default to v6.1.11 (#7055) (89acb896)
  *  update dependency nodebb-theme-slick to v1.2.18 (#7049) (b6cb77c1)
  *  update dependency nodebb-theme-slick to v1.2.17 (#7048) (7334c45b)
  *  update dependency nodebb-theme-slick to v1.2.16 (#7047) (1cb1af0c)
  *  update dependency connect-mongo to v2.0.3 (#7046) (d0d0c7f0)
  *  update dependency nodebb-plugin-dbsearch to v3.0.3 (#7035) (adb1b5f3)
  *  update dependency lru-cache to v4.1.5 (#7031) (887582eb)
  *  update dependency socket.io to v2.2.0 (b9d49867)
  *  update dependency socket.io-client to v2.2.0 (824bd541)
  *  update dependency nodebb-plugin-dbsearch to v3.0.2 (#7028) (11f1b409)
  *  update dependency nodebb-plugin-dbsearch to v3.0.1 (#7027) (e71f443c)
  *  update dependency nodebb-theme-vanilla to v10.1.12 (cf928f44)
  *  update dependency nodebb-theme-persona to v9.1.0 (179be9ed)
  *  update dependency nodebb-theme-persona to v9.0.63 (#7019) (68ae3eb6)
  *  update dependency nodebb-plugin-markdown to v8.8.5 (d3ab7d1b)
  *  update dependency nodebb-theme-persona to v9.0.60 (#6984) (cbd50a80)
  *  update dependency nodebb-theme-vanilla to v10.1.10 (#6982) (4c769487)
  *  update dependency nodebb-theme-slick to v1.2.15 (#6981) (acaf1a05)
  *  update dependency nodebb-theme-persona to v9.0.59 (#6980) (5863bb2c)
  *  update dependency lru-cache to v4.1.4 (#6977) (375ab769)
  *  update dependency connect-mongo to v2.0.2 (#6975) (e1597b83)
  *  update dependency nodebb-plugin-markdown to v8.8.4 (84d1013d)
  *  update dependency nodebb-plugin-composer-default to v6.1.8 (fee7e336)
  *  update dependency nodebb-plugin-markdown to v8.8.3 (b182a195)
  *  update dependency nodebb-plugin-composer-default to v6.1.7 (#6966) (1101f327)
  *  update dependency nodebb-theme-persona to v9.0.58 (#6964) (6ade156b)
  *  update dependency mongodb to v3.1.10 (#6962) (662215fa)
  *  update dependency nodebb-theme-persona to v9.0.57 (#6956) (1bf1a439)
  *  update dependency nodebb-theme-persona to v9.0.55 (#6955) (e06683f7)
  *  update dependency nodebb-plugin-composer-default to v6.1.6 (c51ceaf0)
  *  update dependency nodebb-theme-persona to v9.0.54 (bb940b01)
  *  update dependency nodebb-plugin-mentions to v2.2.12 (#6936) (e12a803b)
  *  update dependency nodebb-theme-vanilla to v10.1.9 (#6935) (b480c321)
  *  update dependency nodebb-theme-slick to v1.2.14 (#6934) (9cdd5316)
  *  update dependency nodebb-theme-persona to v9.0.53 (#6933) (9ee1c2f8)
  *  update dependency nodebb-plugin-dbsearch to v2.0.23 (#6931) (dba1db9c)
  *  update dependency jsesc to v2.5.2 (511b4edc)
  *  update dependency validator to v10.9.0 (032caafa)
  *  update dependency spdx-license-list to v5 (a639b6b8)
  *  update dependency nodebb-theme-vanilla to v10.1.8 (eb0a322d)
  *  update dependency nodebb-theme-persona to v9.0.52 (6566a0cb)
  *  update dependency nodebb-plugin-dbsearch to v2.0.22 (#6916) (7808e58c)
  *  update dependency mongodb to v3.1.9 (#6914) (9a9f2af9)
  *  update dependency nodebb-theme-persona to v9.0.51 (e2274fe0)
  *  update dependency nodebb-theme-slick to v1.2.13 (3005428d)
  *  update dependency nodebb-theme-persona to v9.0.50 (#6902) (22140a20)
  *  update dependency nodebb-plugin-markdown to v8.8.2 (0b4c9a80)
  *  update dependency nodebb-theme-vanilla to v10.1.7 (3150a2fc)
  *  update dependency nodebb-theme-slick to v1.2.12 (#6881) (9bcda7f7)
  *  update dependency nodebb-theme-persona to v9.0.49 (#6880) (e0dc00da)
  *  update dependency nodebb-theme-persona to v9.0.48 (2b6f5eec)
* **i18n:**  pushed notifications source to tx, pulled fallbacks (8dd8370b)
* **uploads:**  ugly filenames on uploaded asset downloading (f96208a0)
* **acp:**
  *  small UI fixes for ACP privileges category selector (#6946) (57b39d5b)
  *  hard-to-discover dropdown selector in ACP (b3f96d28)
* **l10n:**  some translations (34cbd1fc)

##### Other Changes

* //github.com/NodeBB/nodebb-theme-persona/issues/363 (702be3f6)
* //github.com/NodeBB/NodeBB/issues/6433 (7e00d6b9)
*  #6408 (f0f30041)
*  #6425 (fbf52407)
* //github.com/NodeBB/NodeBB/issues/6073 (5da24b41)
*  #5862, setting chat list height even if no message list is present (bc9a1250)
* //github.com/Schamper/nodebb-plugin-poll/issues/86 (c0f39032)

##### Refactors

*  use loash when possible (#7230) (e1ca2d81)

##### Code Style Changes

*  lint fix (fbe6ccd7)
* **eslint:**
  *  match operator-linebreak preferences (ba619c7e)
  *  newlines in public/src as well (f7bd398e)
  *  enforcing newline on chained calls (95cc27f1)

#### 1.11.1 (2018-12-14)

##### Chores

*  incrementing version number - v1.11.1 (2104877c)
* **deps:**
  *  update dependency husky to v1.2.1 (63f4b569)
  *  update node:8.14.0 docker digest to dd2381f (7449ae3e)
  *  update node.js to v8.14.0 (8a5a031d)

##### New Features

*  Allow getting logfile path from config (#7044) (f3e8e065)
*  remove uid:<uid>:ignored:cids (#7099) (263c9180)
*  cache category tag whitelist (78fa7340)
*  make user cards look less derpy (31bb2ae9)
*  added new middleware authenticateOrGuest (4fba1492)
*  closes #7070 (7ca62b83)
*  added README.md in languages folder (648964fa)
*  up composer (7eee8e1d)
*  allow array results (54c127d1)
*  #7023 (f581c052)
*  close #7002, console message if mismatched origins (89c025d1)
*  added changelog file to root of repo (e89b4fca)
* **email:**  don't escape html in notification bodies. (#7042) (d7c55bc3)

##### Bug Fixes

*  #7108 (81697390)
*  dont save data for non-positive uids (62f01a83)
*  #7103 (f103390a)
*  dont update cid:<cid>:tids:votes if topic is pinned (2f57a4b9)
*  #7102 (d117df77)
*  #7102 (85a07e99)
*  don't explode if there is no css el (74d0e88d)
*  db info page (26ccd8f6)
*  logAttempt conditional (a6c8e0ab)
*  #7087, server-side protection against guest blocks (33d4956b)
*  don't crash in flags.validate if user blocked target (81aa3a0b)
*  dont send empty strings (555c092f)
*  #7085 (fe0f95a2)
*  #7086 (e55fb437)
*  wrong variable #7085 (71163421)
*  admins&mods when there are mutliple lines of users (de437e36)
*  refreshing settings page on save if language changed (ed46c5e2)
*  not calling authenticate middleware on resource direct access routes (eeaee8cc)
*  #7038, autoLocale logic not playing nicely with no-refresh auths (#7059) (5f3d1c76)
*  #7074 (2604cf63)
*  #7071 buildSkinAsset won't rebuild continuously (a07d9898)
*  #7063, logout code should do hard page nav to / or data.next (6df5668e)
*  #7061 (eab297bd)
*  skin not changing after login or logout, #7038 (28a1fa78)
*  #7040 (a63ddbe2)
*  #7041 (ec0c50d4)
*  #7043 (8d7c3897)
*  add missing render function (cb7c2d8c)
*  #7033 (8808a033)
*  #7037 (b86f1556)
*  #6991, add timeout for version Github request (43c3bb02)
*  #7030 (58d4376f)
* **deps:**
  *  update dependency nodebb-plugin-composer-default to v6.1.17 (3bcfd7fc)
  *  update dependency nodebb-theme-persona to v9.1.4 (b6ad5fd4)
  *  update dependency nodebb-plugin-markdown to v8.8.6 (#7079) (46fb365d)
  *  update dependency nodebb-theme-persona to v9.1.3 (#7075) (d2aea57a)
  *  update dependency nodebb-theme-persona to v9.1.2 (42e792ab)
  *  update dependency nodebb-theme-persona to v9.1.1 (#7069) (bdb33056)
  *  update dependency postcss to v7.0.6 (6b5428c5)
  *  update dependency nodebb-plugin-composer-default to v6.1.14 (#7058) (e48ed6e0)
  *  update dependency nodebb-plugin-composer-default to v6.1.13 (#7057) (ada1d6d0)
  *  update dependency nodebb-plugin-composer-default to v6.1.12 (#7056) (9f9f72da)
  *  update dependency nodebb-plugin-composer-default to v6.1.11 (#7055) (89acb896)
  *  update dependency nodebb-theme-slick to v1.2.18 (#7049) (b6cb77c1)
  *  update dependency nodebb-theme-slick to v1.2.17 (#7048) (7334c45b)
  *  update dependency nodebb-theme-slick to v1.2.16 (#7047) (1cb1af0c)
  *  update dependency connect-mongo to v2.0.3 (#7046) (d0d0c7f0)
  *  update dependency nodebb-plugin-dbsearch to v3.0.3 (#7035) (adb1b5f3)
  *  update dependency lru-cache to v4.1.5 (#7031) (887582eb)
  *  update dependency socket.io to v2.2.0 (b9d49867)
  *  update dependency socket.io-client to v2.2.0 (824bd541)
  *  update dependency nodebb-plugin-dbsearch to v3.0.2 (#7028) (11f1b409)
  *  update dependency nodebb-plugin-dbsearch to v3.0.1 (#7027) (e71f443c)
* **i18n:**  pushed notifications source to tx, pulled fallbacks (8dd8370b)

##### Code Style Changes

* **eslint:**  match operator-linebreak preferences (ba619c7e)

### 1.11.0 (2018-11-28)

##### Chores

* **deps:**
  *  update dependency lint-staged to v8.1.0 (dd7f8a14)
  *  update dependency husky to v1.2.0 (aee21628)
  *  update node:8.12.0 docker digest to 5dae8ea (0ef451dd)
  *  update dependency husky to v1.1.4 (95d6ab06)
  *  update dependency eslint to v5.9.0 (92441794)
  *  pin dependencies (b0483f21)
  *  update dependency eslint-config-airbnb-base to v13 (#6599) (64b9dabf)
  *  update node.js to v8.12.0 (fa3afbd2)
  *  update dependency husky to v1.1.3 (6cee5b8e)
  *  update dependency lint-staged to v8.0.4 (9d258668)
  *  update dependency lint-staged to v8.0.3 (aaa6fe9e)
  *  update dependency lint-staged to v8 (95d7a5fa)
  *  update dependency jsdom to v13 (52f141c9)
* **husky:**  setting up husky as recommended in docs (e8a3d929)

##### New Features

*  enabling commitlint (c58a41ed)
*  allow disabling of GDPR features via ACP toggle, closes #6847 (4919e9ef)

##### Bug Fixes

* **deps:**
  *  update dependency nodebb-theme-vanilla to v10.1.12 (cf928f44)
  *  update dependency nodebb-theme-persona to v9.1.0 (179be9ed)
  *  update dependency nodebb-theme-persona to v9.0.63 (#7019) (68ae3eb6)
  *  update dependency nodebb-plugin-markdown to v8.8.5 (d3ab7d1b)
  *  update dependency nodebb-theme-persona to v9.0.60 (#6984) (cbd50a80)
  *  update dependency nodebb-theme-vanilla to v10.1.10 (#6982) (4c769487)
  *  update dependency nodebb-theme-slick to v1.2.15 (#6981) (acaf1a05)
  *  update dependency nodebb-theme-persona to v9.0.59 (#6980) (5863bb2c)
  *  update dependency lru-cache to v4.1.4 (#6977) (375ab769)
  *  update dependency connect-mongo to v2.0.2 (#6975) (e1597b83)
  *  update dependency nodebb-plugin-markdown to v8.8.4 (84d1013d)
  *  update dependency nodebb-plugin-composer-default to v6.1.8 (fee7e336)
  *  update dependency nodebb-plugin-markdown to v8.8.3 (b182a195)
  *  update dependency nodebb-plugin-composer-default to v6.1.7 (#6966) (1101f327)
  *  update dependency nodebb-theme-persona to v9.0.58 (#6964) (6ade156b)
  *  update dependency mongodb to v3.1.10 (#6962) (662215fa)
  *  update dependency nodebb-theme-persona to v9.0.57 (#6956) (1bf1a439)
  *  update dependency nodebb-theme-persona to v9.0.55 (#6955) (e06683f7)
  *  update dependency nodebb-plugin-composer-default to v6.1.6 (c51ceaf0)
  *  update dependency nodebb-theme-persona to v9.0.54 (bb940b01)
  *  update dependency nodebb-plugin-mentions to v2.2.12 (#6936) (e12a803b)
  *  update dependency nodebb-theme-vanilla to v10.1.9 (#6935) (b480c321)
  *  update dependency nodebb-theme-slick to v1.2.14 (#6934) (9cdd5316)
  *  update dependency nodebb-theme-persona to v9.0.53 (#6933) (9ee1c2f8)
  *  update dependency nodebb-plugin-dbsearch to v2.0.23 (#6931) (dba1db9c)
  *  update dependency jsesc to v2.5.2 (511b4edc)
  *  update dependency validator to v10.9.0 (032caafa)
  *  update dependency spdx-license-list to v5 (a639b6b8)
  *  update dependency nodebb-theme-vanilla to v10.1.8 (eb0a322d)
  *  update dependency nodebb-theme-persona to v9.0.52 (6566a0cb)
  *  update dependency nodebb-plugin-dbsearch to v2.0.22 (#6916) (7808e58c)
  *  update dependency mongodb to v3.1.9 (#6914) (9a9f2af9)
  *  update dependency nodebb-theme-persona to v9.0.51 (e2274fe0)
  *  update dependency nodebb-theme-slick to v1.2.13 (3005428d)
  *  update dependency nodebb-theme-persona to v9.0.50 (#6902) (22140a20)
  *  update dependency nodebb-plugin-markdown to v8.8.2 (0b4c9a80)
  *  update dependency nodebb-theme-vanilla to v10.1.7 (3150a2fc)
  *  update dependency nodebb-theme-slick to v1.2.12 (#6881) (9bcda7f7)
  *  update dependency nodebb-theme-persona to v9.0.49 (#6880) (e0dc00da)
  *  update dependency nodebb-theme-persona to v9.0.48 (2b6f5eec)
*  added admin/manage/uploads to tx config (7357926f)
*  #7013, add cache buster to js-enabled.css (f6b92c1d)
*  removal of scroll anchoring code in favour of browser handling (98c14e0e)
*  custom navigation item not showing groups (d9452bf3)
*  flags detail page crash if reporter blocks author (d027207f)
*  #6922, skin assets not including plugin LESS files (a5022ce4)
*  #6921, allow square brackets in usernames (da10ca08)
*  interstitial redirects failing if done via ajaxify (3c8939a8)
*  username trim on login, closes #6894 (157bea69)
* **uploads:**  ugly filenames on uploaded asset downloading (f96208a0)
* **acp:**
  *  small UI fixes for ACP privileges category selector (#6946) (57b39d5b)
  *  hard-to-discover dropdown selector in ACP (b3f96d28)
* **l10n:**  some translations (34cbd1fc)

##### Code Style Changes

* **eslint:**
  *  newlines in public/src as well (f7bd398e)
  *  enforcing newline on chained calls (95cc27f1)

