<?php if(!defined('ROOT')) die('Access denied.');

class c_settings extends Admin{

	public function __construct($path){
		parent::__construct($path);

		SubMenu('系统设置', array(
			array('基本设置', 'settings', 1)
		));

		$this->CheckAction();
	}

    public function save(){
		$action = ForceStringFrom('action');
		$filename = ROOT . "config/settings.php";

		if(!is_writeable($filename)) $errors[] = '请将系统配置文件config/settings.php设置为可写, 即属性设置为: 777';
		if(isset($errors)) Error($errors, '系统设置错误');

		//解决PHP7 Opcache开启时无法实时更新设置的问题
		if(function_exists('opcache_reset')) {
			@opcache_reset();
		}

		$settings    = $_POST['settings'];

		$fp = @fopen($filename, 'rb');
		$contents = @fread($fp, filesize($filename));
		@fclose($fp);
		$contents = $oldcontents = trim($contents);

		foreach($settings as $key => $value){
			$value = $this->Clear_string_for_js($value); //去掉换行符, 兼容JS变量调用
			$value = str_replace('"', "'", $value); //将引双引号替换成单引号

			if(APP::$_CFG[$key] != $value){
				//$value = ForceString($value);

				//对有关设置项的值进行限制处理等
				switch($key){
					case 'BaseUrl':

						if(substr($value, -1) != '/') $value .= '/';

						$value = strtolower($value);

						if(!preg_match('/^http(s)?:\\/\\/.+/i', $value)){
							$value = Iif(is_https(), "https://", "http://") .  $value;
						}

						break;

					case 'KillRobotCode':

						if(trim($value) == "") $value =  APP::$_CFG[$key];

						break;

					case 'UploadLimit':
					case 'MaxWaitings':
						$value = ForceInt($value);
						if($value < 2) $value = 2;
						if($value > 20) $value = 20;
						break;

					case 'AutoOffline':
						$value = ForceInt($value);
						if($value < 4) $value = 4;
						if($value > 30) $value = 30;
						break;

						break;

					case 'SocketPort':
						$value = ForceInt($value);

						if($value < 100) $value = 100;
						if($value >= 8500 AND $value < 8520) $value = 8520;
						if($value > 65535) $value = 65535;

						break;

					case 'SSL_CrtPath':
					case 'SSL_KeyPath':
						$value = str_replace("\\", "/", $value); //将反斜杆替换成顺斜杆

						break;

					case 'STUN_Server':

						if(trim($value) == "") $value =  "stun.xten.com";

						break;

				}

				$code = ForceString($key);
				$contents = preg_replace("/[$]_CFG\['$code'\]\s*\=\s*[\"'].*?[\"'];/is", "\$_CFG['$code'] = \"$value\";", $contents);
			}
		}

		if($contents != $oldcontents){
			$fp = @fopen($filename, 'w');
			@fwrite($fp, $contents);
			@fclose($fp);
		}

		Success('settings'. Iif($action, '/'.$action));
	}

    public function index(){

		echo '<form method="post" action="'.BURL('settings/save').'">';

		TableHeader('基本设置');

		TableRow(array('<B>WeCaller电话客服系统URL</B><BR><font class=grey>WeCaller电话客服系统安装后的完整URL, 请以 <span class=note>/</span> 结束.', '<input type="text" style="width:360px;" name="settings[BaseUrl]" value="' . BASEURL . '">'));

		$Radio = new Radio;
		$Radio->Name = 'settings[Actived]';
		$Radio->SelectedID = APP::$_CFG['Actived'];
		$Radio->AddOption(1, '开启', '<i class="w20"></i>');
		$Radio->AddOption(0, '关闭', '&nbsp;&nbsp;');
		TableRow(array('<B>系统工作状态</B><BR><font class=grey>WeCaller电话客服系统的工作状态设置为 <span class=note>关闭</span> 时, 将不对外提供任何服务.</font>', $Radio->Get()));

		$Langs = GetLangs();
		$Radio ->Clear();
		$Radio->Name = 'settings[Lang]';
		$Radio->SelectedID = APP::$_CFG['Lang'];
		$Radio->AddOption('Auto', '自动', '<i class="w20"></i>');
		foreach($Langs as $lang){
			$lang_name = Iif($lang == 'Chinese', '中文', $lang);
			$Radio->AddOption($lang, $lang_name, '<i class="w20"></i>');
		}
		TableRow(array('<B>访客窗口默认语言</B><BR><font class=grey>当选择 <span class=note>自动</span> 时, 访客通话窗口将根据其浏览器语言自动选择语言, 非中文浏览器将显示英文界面.</font>', $Radio->Get()));

		$Radio ->Clear();
		$Radio->Name = 'settings[AutoTrans]';
		$Radio->SelectedID = APP::$_CFG['AutoTrans'];
		$Radio->AddOption(1, '自动转接', '<i class="w20"></i>');
		$Radio->AddOption(0, '不转接', '&nbsp;&nbsp;');
		TableRow(array('<B>自动转接客服组(<font class=red>需重启Workerman</font>)</B><BR><font class=grey>如果某客服组不存在或已禁用，那么进入该组的访客是否自动转入默认客服组？ <br>如果设置为“不转接”, 将显示客服组不存在或已关闭的提示信息，并断开访客与服务器的连接.</font>', $Radio->Get()));

		$Radio ->Clear();
		$Radio->Name = 'settings[Record]';
		$Radio->SelectedID = APP::$_CFG['Record'];
		$Radio->AddOption(10, '10条', '<i class="w20"></i>');
		$Radio->AddOption(20, '20条', '<i class="w20"></i>');
		$Radio->AddOption(30, '30条', '<i class="w20"></i>');
		$Radio->AddOption(40, '40条', '<i class="w20"></i>');
		$Radio->AddOption(60, '60条', '<i class="w20"></i>');
		TableRow(array('<B>显示对话记录数(<font class=red>需重启Workerman</font>)</B><BR><font class=grey>访客再次进入WeCaller电话客服系统后, 系统自动显示多少条对话的历史记录(与机器人对话无记录). ', $Radio->Get()));

		TableRow(array('<B>访客排队人数基数(<font class=red>需重启Workerman</font>)</B><BR><font class=grey>默认为5, 即: 如果某客服组有2位客服在线, 那么本客服组最多可接受10个访客排队等候. 可设置范围[2 - 20].</font>', '<input type="text" style="width:80px;" name="settings[MaxWaitings]" value="' . APP::$_CFG['MaxWaitings'] . '"> (人)'));

		$Select = new Select;
		$Select->Name = 'settings[AutoOffline]';
		$Select->SelectedValue = APP::$_CFG['AutoOffline'];
		for($i = 4; $i <= 30; $i += 2){
			$Select->AddOption($i, "$i 分钟");
		}
		TableRow(array('<B>自动离线时间</B><BR><font class=grey>访客保持沉默状态(不发送文字信息)多少分钟后, 系统会自动将其设置成离线, 并断开其与服务器的Socket连接.<BR>此项设置有利于减少服务器资源的浪费, 保持其承载能力, 且仅对未排队取号的访客有效.</font>', $Select->Get()));

		$Radio ->Clear();
		$Radio->Name = 'settings[AllowUploadFile]';
		$Radio->SelectedID = APP::$_CFG['AllowUploadFile'];
		$Radio->AddOption(1, '开放', '<i class="w20"></i>');
		$Radio->AddOption(0, '禁用', '&nbsp;&nbsp;');
		TableRow(array('<B>上传文件功能</B><BR><font class=grey>是否允许访客上传文件? 此项设置不影响访客上传图片.</font>', $Radio->Get()));

		$Radio ->Clear();
		$Radio->Name = 'settings[AuthUpload]';
		$Radio->SelectedID = APP::$_CFG['AuthUpload'];
		$Radio->AddOption(1, '需要授权', '<i class="w20"></i>');
		$Radio->AddOption(0, '不需要', '&nbsp;&nbsp;');
		TableRow(array('<B>访客上传授权</B><BR><font class=grey>是否需客服授权才能上传文件？授权上传可降低访客上传病毒、木马文件的风险. 此项设置不影响访客上传图片.</font>', $Radio->Get()));

		TableRow(array('<B>允许上传的文件大小(M)</B><BR><font class=grey>最大允许上传的文件大小, 可设置范围[2 - 20], 此项设置仅对上传文件有效(上传图片限10M内).</font>', '<input type="text" style="width:80px;" name="settings[UploadLimit]" value="' . APP::$_CFG['UploadLimit'] . '"> (M)'));

		$Select->Clear();
		$Select->Name = 'settings[Timezone]';
		$Select->SelectedValue = APP::$_CFG['Timezone'];
		$Select->AddOption('-12', '(GMT -12) Eniwetok,Kwajalein');
		$Select->AddOption('-11', '(GMT -11) Midway Island,Samoa');
		$Select->AddOption('-10', '(GMT -10) Hawaii');
		$Select->AddOption('-9', '(GMT -9) Alaska');
		$Select->AddOption('-8', '(GMT -8) Pacific Time(US & Canada)');
		$Select->AddOption('-7', '(GMT -7) Mountain Time(US & Canada)');
		$Select->AddOption('-6', '(GMT -6) Mexico City');
		$Select->AddOption('-5', '(GMT -5) Bogota,Lima');
		$Select->AddOption('-4', '(GMT -4) Caracas,La Paz');
		$Select->AddOption('-3', '(GMT -3) Brazil,Buenos Aires,Georgetown');
		$Select->AddOption('-2', '(GMT -2) Mid-Atlantic');
		$Select->AddOption('-1', '(GMT -1) Azores,CapeVerde Islands');
		$Select->AddOption('', '(GMT) London,Lisbon,Casablanca');
		$Select->AddOption('+1', '(GMT +1) Paris,Brussels,Copenhagen');
		$Select->AddOption('+2', '(GMT +2) Kaliningrad,South Africa');
		$Select->AddOption('+3', '(GMT +3) Moscow,Baghdad,Petersburg');
		$Select->AddOption('+4', '(GMT +4) Abu Dhabi,Muscat,Baku,Tbilisi');
		$Select->AddOption('+5', '(GMT +5) Karachi,Islamabad,Tashkent');
		$Select->AddOption('+6', '(GMT +6) Almaty,Dhaka,Colombo');
		$Select->AddOption('+7', '(GMT +7) Bangkok,Hanoi,Jakarta');
		$Select->AddOption('+8', '(GMT +8) 北京, 香港, 新加坡');
		$Select->AddOption('+9', '(GMT +9) Tokyo,Osaka,Yakutsk');
		$Select->AddOption('+10', '(GMT +10) Australia,Guam,Vladivostok');
		$Select->AddOption('+11', '(GMT +11) Magadan,Solomon Islands');
		$Select->AddOption('+12', '(GMT +12) Auckland,Wellington,Fiji');
		TableRow(array('<B>系统默认时区</B><BR><font class=grey>'.APP_NAME.'电话客服系统将按此项设置的时区显示日期和时间.</font>', $Select->Get()));

		$Select->Clear();
		$Select->Name = 'settings[DateFormat]';
		$Select->SelectedValue = APP::$_CFG['DateFormat'];
		$Select->AddOption('Y-m-d', "2010-08-12");
		$Select->AddOption('Y-n-j', "2010-8-12");
		$Select->AddOption('Y/m/d', "2010/08/12");
		$Select->AddOption('Y/n/j', "2010/8/12");
		$Select->AddOption('Y年n月j日', "2010年8月12日");
		$Select->AddOption('m-d-Y', "08-12-2010");
		$Select->AddOption('m/d/Y', "08/12/2010");
		$Select->AddOption('M j, Y', "Aug 12, 2010");
		TableRow(array('<B>日期格式</B><BR><font class=grey>系统显示日期的格式.</font>', $Select->Get()));

		TableRow(array('<B>系统页面标题</B><BR><font class=grey>'.APP_NAME.'电话客服系统后台管理、客服操作窗口等页面显示的标题.</font>', '<input type="text" style="width:292px;" name="settings[Title]" value="' . APP::$_CFG['Title'] . '">'));

		TableRow(array('<B>欢迎信息(<span class=blue>中文</span>)</B><BR><font class=grey>访客(中文浏览器)进入通话窗口后，首次显示的问候语.</font>', '<textarea style="width:500px;height:80px;border-color:blue;" name="settings[Welcome]">' . APP::$_CFG['Welcome'] . '</textarea>'));

		TableRow(array('<B>欢迎信息(<span class=green>English</span>)</B><BR><font class=grey>访客(非中文浏览器)进入通话窗口后，首次显示的问候语.</font>', '<textarea style="width:500px;height:80px;" name="settings[Welcome_en]">' . APP::$_CFG['Welcome_en'] . '</textarea>'));

		TableRow(array('<B><font class=red>以下8项修改后, 需重启Workerman服务才能生效</font></B>', '&nbsp;'));

		TableRow(array('<B>Socket服务端口号</B><BR><font class=grey>需要在服务器(宝塔)防火墙、云服务器安全策略组设置开放TCP协议的8520端口.<BR>本系统中, Workerman默认需要占用8500--8520多个服务器端口, 请确保这21个端口未被其它程序使用.<BR>其中8500--8519端口均为Workerman内部通讯端口, 仅8520端口对外提供websocket通讯服务(访客与客服通话).</font>', '<input type="text" style="width:80px;" name="settings[SocketPort]" value="' . APP::$_CFG['SocketPort'] . '">'));

		$Radio ->Clear();
		$Radio->Name = 'settings[Is_Https]';
		$Radio->SelectedID = APP::$_CFG['Is_Https'];
		$Radio->AddOption(1, 'Https(SSL) 协议', '<i class="w20"></i>');
		$Radio->AddOption(0, 'Http 协议', '&nbsp;&nbsp;');
		TableRow(array('<B>Socket传输协议</B><BR><font class=grey>WeCaller电话客服系统需要选择 <span class=note>Https(SSL)</span> 传输协议才能实现实时语音通话, 且需要正确设置下面两项:</font>', $Radio->Get()));

		TableRow(array('<B>SSL协议证书crt文件</B><BR><font class=grey>请填写SSL协议证书crt文件的绝对路径(注意: 是文件路径, 不是URL).</font>', '<input type="text" style="width:292px;border-color:blue;" name="settings[SSL_CrtPath]" value="' . APP::$_CFG['SSL_CrtPath'] . '">'));

		TableRow(array('<B>SSL协议证书key文件</B><BR><font class=grey>请填写SSL协议证书key文件的绝对路径(注意: 是文件路径, 不是URL).</font>', '<input type="text" style="width:292px;" name="settings[SSL_KeyPath]" value="' . APP::$_CFG['SSL_KeyPath'] . '">'));

		TableRow(array('<B>STUN服务器地址</B><BR><font class=grey>WebRTC点对点穿越服务器地址, 免费的STUN服务器如: <br>"stun.xten.com", "stun3.l.google.com:19302", "stun2.l.google.com:19302", "stun1.l.google.com:19302"</font>', '<input type="text" style="width:220px;border-color:blue;" name="settings[STUN_Server]" value="' . APP::$_CFG['STUN_Server'] . '">'));

		TableRow(array('<B>TURN服务器地址(可选)</B><BR><font class=grey>WebRTC点对点穿透中继服务器地址, 一般没有免费的TURN服务器, 需要自行搭建.<br>实时音视频通话时, STUN穿越失败后自动启用TURN服务器, 配置TURN服务器可增加实时音视频的<span class=note>成功率</span>.</font>', '<input type="text" style="width:220px;" name="settings[TURN_Server]" value="' . APP::$_CFG['TURN_Server'] . '">'));

		TableRow(array('<B>TURN服务器用户名</B><BR><font class=grey>TURN服务器用户名, 一般TURN服务器需要用户名和密码.</font>', '<input type="text" style="width:220px;" name="settings[TURN_User]" value="' . APP::$_CFG['TURN_User'] . '">'));

		TableRow(array('<B>TURN服务器密码</B><BR><font class=grey>TURN服务器用户密码, 一般TURN服务器需要用户名和密码.</font>', '<input type="text" style="width:220px;" name="settings[TURN_Pass]" value="' . APP::$_CFG['TURN_Pass'] . '">'));
		
		TableFooter();

		PrintSubmit('保存设置', '取消');
	} 


	//去掉空白及换行函数
	private function Clear_string_for_js($str) 
	{ 
		$str = str_replace(PHP_EOL, '', $str); //去掉换行符, 兼容JS变量调用
		$str = preg_replace("/\t/", '', $str); //使用正则表达式替换内容，如：换行
		$str = preg_replace("/\r\n/", '', $str); 
		$str = preg_replace("/\r/", '', $str); 
		$str = preg_replace("/\n/", '', $str); 
		return trim($str); //返回字符串
	}

} 

?>