
/* WeCaller support.js  @Copyright weensoft.cn */

var userAgent = navigator.userAgent.toLowerCase();
var isIE = window.ActiveXObject && userAgent.indexOf('msie') != -1 && userAgent.substr(userAgent.indexOf('msie') + 5, 3);

//JQuery计时器 start
var stopwatchInterval = 0, stopwatchClock, stopwatchDigits;

function initStopWatch(clock, digits){
	stopwatchClock = $(clock);
	stopwatchDigits = stopwatchClock.find(digits);

	if(Number(localStorage.stopwatchBeginingTimestamp) && Number(localStorage.stopwatchRunningTime)){
		var runningTime = Number(localStorage.stopwatchRunningTime) + new Date().getTime() - Number(localStorage.stopwatchBeginingTimestamp);

		localStorage.stopwatchRunningTime = runningTime;
		startStopWatch();
	}

	if(localStorage.stopwatchRunningTime){
		stopwatchDigits.text(returnFormattedToMilliseconds(Number(localStorage.stopwatchRunningTime)));
	}else{
		localStorage.stopwatchRunningTime = 0;
	}
}

function startStopWatch(){
    clearInterval(stopwatchInterval);

    var startTimestamp = new Date().getTime(),
        runningTime = 0;

    localStorage.stopwatchBeginingTimestamp = startTimestamp;

    if(Number(localStorage.stopwatchRunningTime)){
        runningTime = Number(localStorage.stopwatchRunningTime);
    }else{
        localStorage.stopwatchRunningTime = 1;
    }

    stopwatchInterval = setInterval(function () {
        var stopwatchTime = (new Date().getTime() - startTimestamp + runningTime);

        stopwatchDigits.text(returnFormattedToMilliseconds(stopwatchTime));
    }, 100);

    stopwatchClock.removeClass('inactive');
}

function pauseStopWatch(){
    clearInterval(stopwatchInterval);

    if(Number(localStorage.stopwatchBeginingTimestamp)){
        var runningTime = Number(localStorage.stopwatchRunningTime) + new Date().getTime() - Number(localStorage.stopwatchBeginingTimestamp);

		localStorage.stopwatchBeginingTimestamp = 0;
        localStorage.stopwatchRunningTime = runningTime;

        stopwatchClock.addClass('inactive');
    }
}

function resetStopWatch(){
    clearInterval(stopwatchInterval);

    stopwatchDigits.text(returnFormattedToMilliseconds(0));
    localStorage.stopwatchBeginingTimestamp = 0;
    localStorage.stopwatchRunningTime = 0;

    stopwatchClock.addClass('inactive');
}


function returnFormattedToMilliseconds(time){
    var seconds = Math.floor((time/1000) % 60),
        minutes = Math.floor((time/(1000*60)) % 60),
        hours = Math.floor((time/(1000*60*60)) % 24);

    seconds = seconds < 10 ? '0' + seconds : seconds;
    minutes = minutes < 10 ? '0' + minutes : minutes;

    return hours + ":" + minutes + ":" + seconds;
}
//JQuery计时器 end


//Ajax封装
var ajax_isOk = 1;
function ajax(url, send_data, callback) {
	if(!ajax_isOk) return false;
	$.ajax({
		url: url,
		data: send_data,
		type: "post",
		cache: false,
		dataType: "json",
		beforeSend: function(){ajax_isOk = 0;$("#ajax-loader").addClass('loading');},
		complete: function(){ajax_isOk = 1;$("#ajax-loader").removeClass('loading');},
		success: function(data){
			if(callback)	callback(data);
		},
		error: function(XHR, Status, Error) {
			file_temp_data = "";
			//showDialog("Ajax错误");
			showDialog("Data: " + XHR.responseText + "<br>Status: " + Status + "<br>Error: " + Error);
		}
	});
}

//设置cookie
function setCookie(n,val,d) {
	var e = "";
	if(d) {
		var dt = new Date();
		dt.setTime(dt.getTime() + parseInt(d)*24*60*60*1000);
		e = "; expires="+dt.toGMTString();
	}
	document.cookie = n+"="+val+e+"; path=/";
}

//获取cookie
function getCookie(n) {
	var a = document.cookie.match(new RegExp("(^| )" + n + "=([^;]*)(;|$)"));
	if (a != null) return a[2];
	return '';
}

//将已转义的字符恢复
function recoverHtml(str) {
	if(!str) return "";
	return str.replace(/\\/g, '').replace(/\&amp;/g, '&').replace(/\&#039;/g, "'").replace(/\&quot;/g, '"').replace(/\&lt;/g, '<').replace(/\&gt;/g, '>');
}

//滚动到底部
function scrollBottom(obj){
	obj.scrollTop(20000); //滚动到底部
}

//新消息闪动页面标题
function flashTitle() {
	clearInterval(tttt);
	flashtitle_step=1;
	tttt = setInterval(function(){
		if (flashtitle_step==1) {
			document.title='【新消息】'+pagetitle;
			flashtitle_step=2;
		}else{
			document.title='【　　　】'+pagetitle;
			flashtitle_step=1;
		}
	}, 500);
}

//停止闪动页面标题
function stopFlashTitle() {
	if(flashtitle_step != 0){
		flashtitle_step=0;
		clearInterval(tttt);
		document.title=pagetitle;
	}
}

//获得计算机当前时间
function getLocalTime() {
	var date = new Date();

	function addZeros(value, len) {
		var i;
		value = "" + value;
		if (value.length < len) {
			for (i=0; i<(len-value.length); i++)
				value = "0" + value;
		}
		return value;
	}
	return addZeros(date.getHours(), 2) + ':' + addZeros(date.getMinutes(), 2) + ':' + addZeros(date.getSeconds(), 2);
}

//鼠标左右划动后执行动作
function initSlider(handler, func){
	var oX = 0, oY = 0, eX = 0, eY = 0, status = false;

	function mousexy(e){
		var x, y;
		var e = e||window.event;
		return {x:e.clientX, y:e.clientY};
	}

	handler.mousedown(function(e) {
		status = true;
		oX = eX = mousexy(e).x;
		oY = eY = mousexy(e).y;
	}).mouseup(function(e){
		status = false;
		e.stopPropagation();

		var dx = Math.abs(eX - oX);
		var dy = Math.abs(eY - oY);

		if(dx > 20 || dy > 20) welive.isSlider = 1;

		if(dx > 80 && dy < 60 && func){
			var d = "left";
			if(eX - oX > 0) d = "right";
			func(d); //正常的左右滑动后执行
		}

		setTimeout(function() {
			welive.isSlider = 0;
		}, 500);

		return false;
	}).mousemove(function(e){
		if (!status) return;
		eX = mousexy(e).x;
		eY = mousexy(e).y;
		e.stopPropagation();
		return false;
	});
}

//显示确认操作对话框 callback表示按确定时执行的函数; time是自动关闭时间;
function showDialog(info, title, callback, time){
	var ti = time? time * 1000 : 0;

	easyDialog.open({
		container:{
			header: "<font color=red>" + (title? title : "系统信息") + "</font>",
			content: "<font color=#FF9900>" + info + "</font>",
			yesFn: callback,
			yesText: '确定',
			noFn:true,
			noText: '取消'
		},
		autoClose:ti
	});

	$("#easyDialogYesBtn").focus(); //确定按钮获得焦点
}


//顶部下拉菜单 b为参数对象, c为下拉菜单显示后的事件函数
(function(a) {
	a.fn.Jdropdown = function(b, c) {
		if (this.length) {
			"function" == typeof b && (c = b, b = {});
			var d = a.extend({
					event: "mouseover",
					current: "hover",
					delay: 0
				}, b || {}),
				e = "mouseover" == d.event ? "mouseout" : "mouseleave";
			a.each(this, function() {
				var b = null,f = null,g = !1;
				a(this).bind(d.event, function() {
					if (g) clearTimeout(f);
					else {
						var e = a(this);
						b = setTimeout(function() {
							e.addClass(d.current), g = !0, c && c(e)
						}, d.delay);
					}
				}).bind(e, function() {
					if (g) {
						var c = a(this);
						f = setTimeout(function() {
							c.removeClass(d.current), g = !1
						}, 0)
					} else clearTimeout(b);
				});
			});
		}
	}
})(jQuery);


//格式化输出信息
function formatOutput(data) {
	//生成URL链接
	data = data.replace(/((((https?|ftp):\/\/)|www\.)([\w\-]+\.)+[\w\.\/=\?%\-&~\':+!#;]*)/ig, function($1){return getURL($1);});
	//将表情代码换成图标路径
	data = data.replace(/\[:(\d*):\]/g, '<img src="' + SYSDIR + 'public/smilies/$1.png">').replace(/\\n/g, '<br>').replace(/\n/g, '<br>');
	return data;
}

//格式化生成URL
function getURL(url, limit) {
	if(!limit) limit = 60;
	var urllink = '<a href="' + (url.substr(0, 4).toLowerCase() == 'www.' ? 'http://' + url : url) + '" target="_blank" title="' + url + '">';
	if(url.length > limit) {
		url = url.substr(0, 30) + ' ... ' + url.substr(url.length - 18);
	}
	urllink += url + '</a>';
	return urllink;
}

//显示大图片
function showBigImage(me, width, height){
	return false;
}

//插入表情符号
function insertSmilie(code, towhere) {
	code = '[:' + code + ':]';
	if(towhere){
		var obj = guest_msg[0];
	}else{
		var obj = s_msg[0];
	}
	var selection = document.selection;
	obj.focus();

	if(typeof obj.selectionStart != 'undefined') {
		var opn = obj.selectionStart + 0;
		obj.value = obj.value.substr(0, obj.selectionStart) + code + obj.value.substr(obj.selectionEnd);
	} else if(selection && selection.createRange) {
		var sel = selection.createRange();
		sel.text = code;
		sel.moveStart('character', -code.length);
	} else {
		obj.value += code;
	}
}

//socket连接
function weliveLink(){
	welive.ws = new WebSocket(WS_HEAD + WS_HOST + ':'+ WS_PORT);
	welive.ws.onopen = function(){setTimeout(weliveVerify, 100);}; //连接成功后, 小延时再验证用户, 否则IE下刷新时发送数据失败
	welive.ws.onclose = function(){weliveClose();};
	welive.ws.onmessage = function(get){weliveParseOut(get.data);};
}

//清空过长客服对话记录(保留40条)
function weliveClear(){
	var rec = s_history.children("div");
	var len = rec.length;
	if(len >= 80){
		rec.slice(0, len - 40).remove();
		scrollBottom(s_history);
	}
}

//更新客服数量(在原数量上加或减n)
function adminsUpdate(n){
	var x = parseInt(s_admins.html());
	x = x + n;
	if(x < 0) x = 0;
	s_admins.html(x);
}

//更新客服新消息统计-显示
function sChatUpdate(){
	if(s_chat_isopen) return;

	var num = parseInt(s_chat_num.html());
	if(num == 0) s_chat_num.show();

	var x = num + 1;

	if(x > 999){
		x = "999..";
	}else{
		x = "+" + x;
	}

	s_chat_num.html(x);
}


//输出聊天记录
function outputRecords(reArr){
	var recs_html = '';

	$.each(reArr, function(i, rec){

		//上传图片的记录
		if(rec.ft == 1){
			var img_arr = rec.m.split("|");
			var img_w = parseInt(img_arr[1]);
			var img_h = parseInt(img_arr[2]);

			if(img_w < 1) img_w = 1;
			var img_h_new = parseInt(img_h * 200 / img_w); //CSS样式中已确定宽度为200

			var rec_i = '<img src="' + SYSDIR + 'upload/img/' +img_arr[0] + '" class="receive_img" style="height:' + img_h_new + 'px;" onclick="showBigImage(this, ' + img_w + ', ' + img_h + ');">';

		//上传的文件记录
		}else if(rec.ft == 2){
			var file_arr = rec.m.split("|");
			var rec_i = '<a href="' + SYSDIR + 'upload/file/' + file_arr[0] + '" target="_blank" download="' + file_arr[1] + '"><img src="' + SYSDIR + 'public/img/save.png">&nbsp;&nbsp;点击下载: ' +  file_arr[1] + '</a>';
		}else{
			var rec_i = formatOutput(rec.m);
		}

		if(rec.t == 1){ //客服的
			recs_html += '<div class="msg r"><u><img src="' + SYSDIR + 'avatar/' + admin.av + '"></u><div>' + rec_i + '</div><b>' + rec.d + '</b></div>';
		}else{ //客人的
			recs_html += '<div class="msg l"><u><img src="' + SYSDIR + 'public/img/guest2.png"></u><div>' + rec_i + '</div><b>' + rec.d + '</b></div>';
		}
	});

	if(recs_html != ''){
		recs_html += '<div class="msg s"><div class="b"><div class="ico"></div><div class="i">... 以上为最近对话记录.</div></div></div>';
		guest_history.append(recs_html); //输出
		scrollBottom(guest_history); //滚动到底部
	}
}

//解析数据并输出
function weliveParseOut(data){
	var gid = 0, d = false, type = 0, data = $.parseJSON(data);

	if(data.g) gid = parseInt(data.g); //统一将访客id转为数字

	switch(data.x){
		case 1: //客服群内对话
			var time = getLocalTime();
			if(data.aid == admin.aid){ //自己的发言
				d = '<div class=me><u>' + admin.fullname + ' - ' + data.p + '</u><i>' + time + '</i><p>' + formatOutput(data.i) + '</p></div>';
			}else{
				d = '<div' + ((data.t==1 || data.t==2)? ' class=a' : '') + '><u>' + data.n + ' - ' + data.p + '</u><i>' + time + '</i><p>' + formatOutput(data.i) + '</p></div>';
			}
			break;

		case 5:  //客人与客服文字对话
			d = data.i;
			if(data.a == 1){
				type = 1; //自己发出的对话
			}else{
				type = 2; //客人发来的
			}

			break;

		case 4: //webRTC
			if(!audioStatusOk) return; //实时语音状态未OK

			var event = data.e;
			var msg = data.m;

			switch(event) {
				case 'client-call': //客服收到访客实时语音连接请求
					if(!userAudioStream) return;

					applyAudioIceCandidate(userAudioStream); //客服发起ICE申请

					break;

				case 'client-audio-answer': //客服发送offer后收到访客的应答
					if(!peerAudioConnection || !msg || !msg.sdp) return;

					peerAudioConnection.setRemoteDescription(new RTCSessionDescription(msg), function(){}, function(e){
						console.error(e);
					});

					break;

				case 'client-audio-candidate': //请求方与接收方互传: candidate传输地址
					if(!peerAudioConnection || !msg || !msg.candidate) return;

					//添加对方的candidate
					peerAudioConnection.addIceCandidate(new RTCIceCandidate(msg), function(){}, function(e){
						console.error(e);
					});

					break;

				case 'client-call-stop': //访客不支持实时语音或未授权使用麦克风时

					layer.msg("访客不支持实时语音或未授权使用麦克风", {time: 6000});
					weliveCallStop(); //终止通话

					break;

 				//////// 视频相关

				case 'client-video': //客服收到视频接收请求
					remoteVideoStatus = 1; //访客视频状态已OK

					//防止访客重复点击视频按钮
					layer.open({
						type: 1
						,title: '<div style="">访客视频</div>'
						,content: '<div style="width:300px;padding:20px 10px;text-align:center;color:#ff6600;">访客打开了摄像头，请开始观看吧!</div>'
						,shift: 6
						,shade: 0
						,closeBtn: 0
						,id: 'LAY_videoOK'
						,skin: 'layui-layer-molv'
						,btn: ["开始"]
						,yes: function(index){
							startVideo(); //允许开始视频
							layer.close(index)
						}
					});

					break;

				case 'client-video-offer': //客服接收到访客的offer
					if(!msg) return;
					applyVideoIceCandidate(msg);

					break;

				case 'client-video-candidate': //客服收到: candidate传输地址
					if(!peerVideoConnection || !msg || !msg.candidate) return;
					//添加对方的candidate
					peerVideoConnection.addIceCandidate(new RTCIceCandidate(msg), function(){}, function(e){
						console.error(e);
					});

					break;

				//////// 操控相关

				case 'client-camera-close': //访客关闭摄像头
					stopVideo();

					break;
			}

			return true;
			break;

		case 3:  //客服接听访客 返回
			switch(data.a){
				case 1: //接听成功

					//其他客服接听时
					if(data.aid != admin.aid) {
						guestDelete(gid); //直接删除
						return false;
					}

					CurrentId = gid; //正在通话的客人gid
					welive.isCalling = 1; //表示客服正在通话

					guest_online.children("#gst_" + gid).addClass("curr").find(".operatebtn").addClass("hangup").html("挂断");

					var gDiv = $("#win_" + gid);
					guest_history.html(gDiv.html());
					outputRecords(data.recs); //输出对话记录
					selectPhrase(data.lang) //切换中英快捷回复

					startStopWatch(); //开启计时器
					weliveCallStart(); //开始语音通话

					gDiv.html("");

					type = 3; 
					d = '当前客人已接通, 请开始通话吧!';

					break;

				case 2: //接听失败
					layer.msg('接通失败! 当前客人排队失效, 请接通下一位!', {time: 10000});
					guestDelete(gid); //删除客人

					break;

				case 3: //挂断成功
					if(gid != CurrentId) return false;

					CurrentId = 0
					welive.isCalling = 0; //表示未通话
					guestDelete(gid); //删除客人
					guest_history.html("");
					profile＿loaded = 0; //访客信息未加载
					resetStopWatch(); //重置计时器

					break;
			}

			break;

		case 2: //客服特别操作及反馈信息
			switch(data.a){
				case 1: //上线
					if(s_online.children('#adm_' + data.aid).length > 0) return false; //有相同客服返回

					var status = '';
					if(data.mb == 1) status = '<u></u>';
					d = '<div class=i><b></b>' + data.n + ' 上线了</div>';

					s_online.append('<li id="adm_' + data.aid + '" title="' + data.p + '"><div><img src="' + SYSDIR + 'avatar/' + data.av + '" title="服务中...">' + status + '</div><i' + ((data.t==1 || data.t==2)? ' class=a' : '') + '>' + data.n + '</i></li>');

					adminsUpdate(1); //更新客服在线人数
					break;

				case 2: //离线
					//解决客服重复连接时, 给新连接的窗口发送自己离线信息的问题(也就是说自己无法看到自己离线)
					if(data.aid == admin.aid) return false;

					d = '<div class=i><b></b>' + data.i + ' 已离线</div>';
					s_online.children('#adm_' + data.aid).remove();
					adminsUpdate(-1);
					break;

				case 3: //挂起
					var support = s_online.children('#adm_' + data.aid);
					d = '<div class=i><b></b>' + support.children("i").html() + ' 已挂起</div>';
					support.children("div").append('<b></b>');
					support.children("div").children("img").attr('title', '已挂起');

					if(data.aid == admin.aid){
						$(".set_busy").hide();
						$(".set_serving").show();
					}
					break;

				case 4: //解除挂起
					var support = s_online.children('#adm_' + data.aid);
					d = '<div class=i><b></b>' + support.children("i").html() + ' 解除挂起</div>';
					support.children("div").children("b").remove();
					support.children("div").children("img").attr('title', '服务中...');

					if(data.aid == admin.aid){
						$(".set_serving").hide();
						$(".set_busy").show();
					}
					break;

				case 5: //获取客人信息
					if(typeof data.d != "object") return false; //客人数据不存在

					profile＿loaded = 1; //设置数据已更新
					guest_profile.find("a.fromurl").attr("href", data.d.fromurl.replace(/\&amp;/g, '&')).html(data.d.fromurl);
					guest_profile.find(".ipzone").html(data.d.ipzone + " ( " + data.d.lastip + " )");
					guest_profile.find("input[name=grade]").prop("checked",false);
					guest_profile.find("input[name=grade][value=" + data.d.grade + "]").prop("checked", true);
					guest_profile.find("input[name=fullname]").val(recoverHtml(data.d.fullname));
					guest_profile.find("textarea[name=remark]").val(recoverHtml(data.d.remark));

					guest_profile.show();
					$(".t_profile").addClass("hover");

					break;

				case 6: //保存客人信息后返回的结果
					type = 3; d = '访客信息保存成功!';

					if(data.fullname != ''){ //客人有姓名时, 更新之
						var ipzone = guest_online.find("#gst_" + gid + ">s").html();
						guest_online.children("#gst_" + gid).attr("title", data.fullname + " (" + ipzone + ")").find("i").html(data.fullname);
					}

					closeProfile();

					break;

				case 7: //重复连接返回的指令
					welive.autolink = 0;
					clearTimeout(welive.ttt); //停止重连

					if(data.i && data.i == "isCalling"){
						var tmp = '你已在其它页面与访客通话中, 禁止重复连接!!';
					}else{
						var tmp = '当前客服已在其它页面登录, 此页面已废弃!!';
					}

					weliveOutput('<div class="i"><b></b><font color=red>' + tmp + '</font></div>');

					break;

				case 8: //客服连接验证成功
					var aid = parseInt(data.aid);
					if(aid != admin.aid) return false; //非法登录

					d = '<div class=i><b></b>服务器连接成功!</div>';

					welive.status = 1;
					welive.aix = data.aix; //socket连接索引值
					s_history.removeClass('loading3');
					sounder.html(welive.mp3); //登录声音

					//配置iceConfig
					var iceArr = [];
					iceArr.push({urls: "stun:" + data.ice.stun});

					if(data.ice.turn != ''){
						iceArr.push({urls: "turn:" + data.ice.turn, username: data.ice.user, credential: data.ice.pass});
					}

					iceConfig = {iceServers: iceArr, sdpSemantics: 'plan-b'};


					//更新自己的客服列表
					var num = 0, status;

					$.each(data.alist, function(n, a){
						num += 1;

						if(a.b == 1){
							status = 'title="已挂起"><b></b>';
						}else{
							status = 'title="服务中...">';
						}

 						if(a.mb == 1) status += '<u></u>';
						if(a.aid == admin.aid) admin.av = a.av; //记录当前客服的头像文件名

						s_online.append('<li id="adm_' + a.aid + '" title="' + a.p + '"><div><img src="' + SYSDIR + 'avatar/' + a.av + '" ' + status + '</div><i' + ((a.t==1 || a.t==2)? ' class=a' : '') + '>' + a.n + '</i></li>');
					});

					adminsUpdate(num); //更新客服人数

					//正在通话的访客
					var curr_gid = parseInt(data.gid);
					if(curr_gid){
						CurrentId = curr_gid; //正在通话的客人gid
						welive.isCalling = 1; //表示客服正在通话
						outputRecords(data.recs); //输出对话记录
						guestOutput('当前客人已接通, 请开始通话吧!', curr_gid, 3);
						guest_msg.focus(); //访客输入框获焦点

						weliveCallStart(); //开始语音通话

					}else{
						resetStopWatch(); //重置计时器
						s_msg.focus(); //群聊输入框获焦点
					}

					//重建所有在线客人
					$.each(data.glist, function(i, guest){
						guestCreate(guest);
					});

					//初始化挂起动作
					$(".set_busy").click(function(e) {
						showDialog('确定挂起吗?<br>注: 挂起后, 将不再接受新客人取号等候', '', function(){
							weliveSend({type: "s_handle", operate: "setbusy", value: 1}); //发送挂起请求
						});

						e.preventDefault();
					});

					$(".set_serving").click(function(e) {
						weliveSend({type: "s_handle", operate: "setbusy", value: 0}); //发送解除挂起请求
						e.preventDefault();
					});

					//管理员 重置机器人
					if(admin.type == 1){
						$(".reset_robot").click(function(e) {
							layer.msg("WeCaller免费版无此功能", {time: 5000});

							e.preventDefault();
						});
					}

					//启动心跳, 即每隔26秒自动发送一个特殊信息, 解决IE下30秒自动断线的问题
					ttt_1 = setInterval(function() {						
						weliveSend({type:"ping"}); //只要连接状态, 均要发送心跳数据, 设置一个怪异的数字避免与自动离线的时间间隔重合, 避免在同一时间点上send数据上可能产生 -----幽灵bug
					}, 26125);

					checkPickupGuest(); //查找需要接听的访客, 并显示接听按钮

					break;

				case 9: //添加快捷回复返回
					var pid = parseInt(data.pid);
					var lang = parseInt(data.lang);

					if(pid && data.msg){
						var obj = s_phrases_en;
						if(lang) obj = s_phrases_cn;

						if(obj.children("li").length <= 0) obj.html("");
						obj.append('<li onclick="insertPhrase(this);">' + data.msg.replace(/\\n/g, '&lt;br&gt;') + '<b onclick="deletePhrase(this, \'' + pid + '\')"></b></li>');

						scrollBottom(obj);
					}

					break;

				case 10: //重置机器人返回
					layer.msg("机器人重置成功！");
					break;
			}

			break;

		case 6: //客人特别操作及返回信息
			switch(data.a){
				case 3: //客人离线
					
					if(gid == CurrentId){ //正常通话中的客人不能删除
						welive.isCalling = 0; //表示客服通话中断
						pauseStopWatch(); //暂停计时器
						flashTitle(); //闪烁标题
						weliveCallStop(); //停止通话

						type = 4; d = '<font color=red>此客人已离线!</font>';
						
					}else{ //其他客人, 直接删除
						guestDelete(gid);
					}

					break;

				case 8: //客人登录成功

					//创建新客人
					guestCreate(data);
					checkPickupGuest(); //查找需要接听的访客, 并显示接听按钮

					//访客此前正在通话(客人断线重连)
					if(gid == CurrentId){
						welive.isCalling = 1;
						sounder.html(welive.ring); //特殊情况发出铃声
						selectPhrase(data.l) //切换中英快捷回复
						if(stopwatchClock.hasClass('inactive')) startStopWatch(); //开启计时器

						//防止访客暴力刷新, 实时语音通话重复开关
						layer.open({
							type: 1
							,title: '<div style="">实时语音</div>'
							,content: '<div style="width:300px;padding:20px 10px;text-align:center;color:#ff6600;">通话中断，访客重新连线成功，请开始通话吧!</div>'
							,shift: 6
							,shade: 0
							,closeBtn: 0
							,id: 'LAY_audioOK'
							,skin: 'layui-layer-molv'
							,btn: ["开始"]
							,yes: function(index){
								if(welive.isCalling) weliveCallStart(); //开始语音通话, 点击时访客可能已断线, 所以需要判断一下
								layer.close(index)
							}
						});

						type = 3; d = '此客人重新上线, 请开始通话吧!';
					}

					break;
			}

			break;
	}

	weliveOutput(d, gid, type); //输出
}


//创建客人
function guestCreate(data){
	var gid = parseInt(data.g); //访客id
	var oid = parseInt(data.oid); //访客原网站用户id
	var fullname = data.n; //访客昵称

	var ipzone = data.iz; //ip归属地
	var fromurl = data.fr; //来源url

	var lang = parseInt(data.l); //访客语言: 1中文  0英文
	var mobile = parseInt(data.mb); //是否为移动设备
	var ticket_no = parseInt(data.tn); //访客排队票号

	//无gid或未取号时不创建
	if(!gid || !ticket_no) return false;

	//gid在访客列表数组中存在时 或者 在左侧访客列表中存在时 不创建(解决访客重复登录的问题)
	if($.inArray(gid, guest_list) > -1 || guest_online.children('#gst_' + gid).length > 0) return false;

	//处理访客昵称
	if(fullname == '') fullname = (lang ? '访客 ' : 'Guest ') + gid;
	if(oid) fullname = fullname + " - Oid: " + oid;

	//创建新访客
	guest_list.push(gid);
	guestNumUpdate(); //更新访客人数统计显示

	//正在通话的客人排在最前(客服断线重连、刷新才能执行到此处)
	if(gid == CurrentId){
		var guestHtml = '<div id="gst_' + gid + '" tn="' + ticket_no + '" class="g curr" title="' + fullname + ' (' + ipzone + ')"><div>' + ((mobile == 1)? '<u></u>'  : '') + '</div><s>' + ipzone + '</s><i>' + fullname + '</i><a onclick="operateGuest(' + gid + ');return false;" class="operatebtn hangup">挂断</a><p></p></div>';

		guest_online.prepend(guestHtml);
		selectPhrase(lang) //切换中英快捷回复

		return true;
	}

	var done = 0; //是否已经插入
	var guestHtml = '<div id="gst_' + gid + '" tn="' + ticket_no + '" class="g" title="' + fullname + ' (' + ipzone + ')"><div>' + ((mobile == 1)? '<u></u>'  : '') + '</div><s>' + ipzone + '</s><i>' + fullname + '</i><a onclick="operateGuest(' + gid + ');return false;" class="operatebtn">接听</a><p></p></div>';
	
	//检查是否需要插队
	guest_online.children().each(function(){
		var tn = parseInt($(this).attr('tn'));
		var gid_str = $(this).attr('id');

		if(ticket_no < tn && gid_str != 'gst_' + CurrentId){ //不可排到正在通话的客人前面
			done = 1;			
			$(this).before(guestHtml);
			return false; //终止检查插队(终止each循环)
		}
	});

	//未插队时, 排在最后
	if(!done) guest_online.append(guestHtml);

	//创建隐藏的客人DIV(正在通话的客人不创建)
	$(document.body).append('<div id="win_' + gid + '" class="x-win"><div class="msg"><div class="i">客人上线, 问候语已发送. 来自: <br>' + formatOutput(fromurl) + '</div></div></div>');
}


//操作访客: 接通或挂断
function operateGuest(gid){
	if(!gid) return false;

	if(gid == CurrentId){
		showDialog('您确定要挂断与当前访客的通话吗?', '确认提示', function(){
			var totalTalkTime = stopwatchDigits.text().split(":");
			totalTalkTime = parseInt(totalTalkTime[0]) * 3600 + parseInt(totalTalkTime[1]) * 60 + parseInt(totalTalkTime[2]);
			weliveSend({type: "s_handle", operate: "hangup", gid: gid, ttt: totalTalkTime}); //请求挂断访客
			closeProfile();

			weliveCallStop(); //停止通话
		});
	}else{
		//防止客服自己作弊
		var gid_str = guest_online.children().eq(0).attr("id");
		if(gid_str != "gst_" + gid){
			layer.msg("请勿非法接通客人, 否则老大可能会剥了你的皮!");
			return false;
		}

		profile＿loaded = 0; //访客信息未加载
		weliveSend({type: "s_handle", operate: "pickup", gid: gid}); //请求接通访客
	}
}


//查找访客队列中第一接听者, 并显示接听按钮
function checkPickupGuest(){
	if(CurrentId || guest_list.length <= 0) return false; //正在通话或没有访客时

	var firstGuest = guest_online.children().eq(0);
	if(firstGuest.length <=0 || firstGuest.hasClass("curr") || firstGuest.find(".operatebtn").is(':visible')) return false; //正在通话或本来就显示了接口按钮

	sounder.html(welive.ring); //铃声
	guest_online.find(".operatebtn").hide(); //隐藏所有接听按钮
	firstGuest.find(".operatebtn").show(); //显示接听按钮
}


//更新访客人数统计-显示
function guestNumUpdate(){
	online_guests.html(guest_list.length);
}


//删除客人并清除信息
function guestDelete(gid){
	gid = parseInt(gid);

	$('#win_'+gid).remove(); //清除窗口

	var thisGuest = guest_online.children('#gst_' + gid);

	var checkPickup = false;
	if(thisGuest.find(".operatebtn").is(':visible')) checkPickup = true;

	thisGuest.remove(); //更新列表
	guest_list.splice($.inArray(gid, guest_list), 1); //删除访客数组中的元素	
	guestNumUpdate(); //更新访客人数统计显示

	if(checkPickup) checkPickupGuest(); //查找需要接听的访客, 并显示接听按钮
}

//客人窗口输出信息, no_format是否不格式化输出的信息
function guestOutput(d, gid, type){
	if(!d || !gid || !type) return; //没有信息及类型返回

	if(type != 5) d = formatOutput(d); //客服发送图片给客人时, 输出信息不能格式化, 否则本地图片无法显示

	switch(type){
		case 1: //客服
			d = '<div class="msg r"><u><img src="' + SYSDIR + 'avatar/' + admin.av + '"></u><div>' + d + '</div><b>' + getLocalTime() + '</b></div>';
			break;
		case 2: //客人
			flashTitle(); //闪烁标题
			d = '<div class="msg l"><u><img src="' + SYSDIR + 'public/img/guest2.png"></u><div>' + d + '</div><b>' + getLocalTime() + '</b></div>';
			break;
		case 5: //客服发送图片给客人
			d = '<div class="msg r"><u><img src="' + SYSDIR + 'avatar/' + admin.av + '"></u><div>' + d + '</div><b>' + getLocalTime() + '</b></div>';
			break;
		default: //一般信息提示
			d = '<div class="msg"><div class="i">' + d + '</div></div>';
			break;
	}

	guest_history.append(d);
	scrollBottom(guest_history); //滚动到底部
}

//客服交流输出信息
function weliveOutput(d, gid, type){
	if(gid){
		guestOutput(d, gid, type);
	}else{
		if(d === false) return; //没有信息返回

		s_history.append(d);
		scrollBottom(s_history); //滚动到底部
		sChatUpdate(); //收拢时更新未读数量
	}
}

//客服连接验证
function weliveVerify(){
	welive.status = 1;
	weliveSend({type: "login", from: "backend", session_id: admin.sid, agent: admin.agent, admin_id: admin.aid, mobile: 0});

	//将挂起及解除挂起按钮恢复
	$(".set_serving").hide();
	$(".set_busy").show();
}

//连接断开时执行
function weliveClose(){
	if(welive.status){ //断线重连
		s_online.html(""); //客服在线列表
		s_admins.html(0); //客服在线人数
		welive.aix = 0; //客服连接索引

		if(welive.isCalling){
			weliveCallStop(); //停止通话
			welive.isCalling = 0; //设置为未通话状态
		}

		CurrentId = 0; //无正在通话的客人
		profile＿loaded = 0; //访客信息未加载
		guest_list = new Array(); //访客数组
		guest_online.html(""); //客人在线列表
		guest_history.html(""); //访客信息输出窗口
		guestNumUpdate(); //更新访客人数
		closeProfile(); //关闭访客备注信息
		$(".x-win").remove(); //所有客人小窗口
	}

	welive.status = 0;
	clearInterval(ttt_1); //连接断开后停止发送心跳数据

	//允许重新连接
	if(welive.autolink){
		weliveOutput('<div class="i"><b></b>连接失败, 3秒后自动重试 ...</div>');
		welive.ttt = setTimeout(weliveLink, 3000);
	}
}


//发送信息(直接)
function weliveSend(d){
	var re = 0;

	if(welive.status) {
		welive.ws.send(JSON.stringify(d)); //将json对象转换成字符串发送
		re = 1;
	}else if(welive.autolink){
		weliveOutput('<div class=i><b></b>服务器连接中, 请等待 ...</div>');
	}

	return re; //回返是否成功
}


//点击上传图片或文件给客人
function doUpload(){
	//通话中且未断线时
	if(welive.status && CurrentId && welive.isCalling){
		layer.msg("WeCaller免费版无上传文件功能");
	}else{
		layer.msg("未接通访客!");
	}

	return false;
}


//授权上传文件
function guestAuthUpload(){
	if(!CurrentId){
		layer.msg("未接通访客!");
		return;
	}

	$("#tiptip_holder").hide();
	guest_msg.focus();

	layer.msg("WeCaller免费版无上传文件功能");
}


//获取当前客人数据
function getProfile(me){
	if(!welive.status || !CurrentId){
		layer.msg("未接通访客!");
		return;
	}

	var btn = $(me);

	if(guest_profile.is(":hidden")){
		if(profile＿loaded) {
			guest_profile.show();
			btn.addClass("hover");

			return;
		}

		weliveSend({type: "s_handle", operate: "get_guest", guestid: CurrentId}); //发送客人数据请求
	 }else{
		guest_profile.hide();
		btn.removeClass("hover");
	 }
}

//保存当前客人数据
function saveGuest(me){
	var arr = $(me).closest("form").serializeArray();
	var obj = {};
	
	//将数据转换成对象
	$.each(arr, function(index, field){
		obj[field.name] = field.value;
	});

	weliveSend({type: "s_handle", operate: "save_guest", guestid: CurrentId, msg: obj});
}

//关闭客人数据层
function closeProfile(){
	guest_profile.hide();
	$('.t_profile').removeClass("hover");
	return false;
}

//设置发送信息按钮模式
function setSendMod(mod, me){
	if(mod == send_btn_mod) return;
	send_btn_mod = mod;
	$(me).parent().children().removeClass("curr_send_mod").eq(mod).addClass("curr_send_mod");

	if(send_btn_mod == 1){
		s_msg.attr("placeholder", "Enter: 发送");
		guest_msg.attr("placeholder", "Enter: 发送");
	}else{
		s_msg.attr("placeholder", "Ctrl + Enter: 发送");
		guest_msg.attr("placeholder", "Ctrl + Enter: 发送");
	}
	setCookie(COOKIE_KEFU + "_SBM", mod, 1000);
}

//插入快捷回复(常用短语)
function insertPhrase(me) {
	if(welive.isSlider) return;

	var del_btn = $(me).children("b");
	del_btn.remove(); //去掉删除标志

	var phrase = recoverHtml($(me).html());
	phrase = $.trim(phrase.replace(/<br>/ig, '\n'));
	if(!phrase) return;

	var obj = guest_msg[0];
	var selection = document.selection;
	obj.focus();

	if(typeof obj.selectionStart != 'undefined') {
		var opn = obj.selectionStart + 0;
		obj.value = obj.value.substr(0, obj.selectionStart) + phrase + obj.value.substr(obj.selectionEnd);
	} else if(selection && selection.createRange) {
		var sel = selection.createRange();
		sel.text = phrase;
		sel.moveStart('character', -phrase.length);
	} else {
		obj.value += phrase;
	}

	$(me).append(del_btn); //恢复删除标志
}

//滑动切换中英快捷回复
function togglePhrase(direction){
	if(s_phrases_cn.is(":hidden")){
		s_phrases_en.hide();
		if(direction == "left"){
			s_phrases_cn.css({"left": "100%"}).show().animate({left:0}, 300);
		}else{
			s_phrases_cn.css({"right": "100%"}).show().animate({right:0}, 300);
		}
	}else{
		s_phrases_cn.hide();
		if(direction == "left"){
			s_phrases_en.css({"left": "100%"}).show().animate({left:0}, 300);
		}else{
			s_phrases_en.css({"right": "100%"}).show().animate({right:0}, 300);
		}
	}
}

//根据语言切换快捷回复
function selectPhrase(lang){
	if(parseInt(lang)){
		s_phrases_en.hide();
		s_phrases_cn.show();
	}else{
		s_phrases_cn.hide();
		s_phrases_en.show();
	}
}

//添加快捷回复
function addPhrase(){
	var lang = 1;
	if(s_phrases_cn.is(":hidden")) lang = 0;

	var obj = $("#sp_phrase_msg");

	var msg = $.trim(obj.val());
	obj.val('').focus();

	if(msg) {
		weliveSend({type: "s_handle", operate: "save_phrase", del: 0, lang: lang, msg: msg});
	}else{
		layer.msg("未输入快捷回复内容!");
	}
}

//删除快捷回复
function deletePhrase(me, pid){
	var e = window.event || arguments.callee.caller.arguments[0];
	e.preventDefault();
	e.stopPropagation();

	easyDialog.open({
		container:{
			header: "<font color=#FF9900>操作确认</font>",
			content: "<font color=red>确定 - 删除 - 此条快捷回复吗？</font>",
			yesFn: function(){
				weliveSend({type: "s_handle", operate: "save_phrase", del: 1, pid: pid});
				$(me).parent().fadeOut(600, function(){$(this).remove();});
			},
			yesText: '确定',
			noFn:true,
			noText: '取消'
		},
		autoClose: 8000,
		overlay: false,
		follow: me,
		followX: -160,
		followY: -160
	});
}


//webRTC语音视频 start
//开始语音通话
function weliveCallStart(){
	if(audioStatusOk) return;

	if(!userNavigator.getUserMedia){
		layer.msg("浏览器不支持实时语音通话", {time: 6000});
		return false;
	}

	userNavigator.getUserMedia({
        audio:{
			noiseSuppression: true, // 降噪
			echoCancellation: true, // 回音消除
			autoGainControl: true, //自动增益
			channelCount: 1, //单声道, 否则有噪音
			volume: 1.0
		}
	}).then(function(stream){
		wRecordWaver.fadeIn(500); //麦克风波形先显示
		userAudioStream = stream;

		audioStatusOk = 1; //语音通话已准备OK

		weliveSend({type: "webrtc", event: "audio_status_ok", msg: ""}); //客服语音准备完毕, 通知访客发起语音通话

		$(".t_microphone").show(); //关闭麦按钮
	}).catch(function(e){
		layer.msg("浏览器未授权使用麦克风", {time: 6000});
	});
}

//停止通话
function weliveCallStop(){
	audioStatusOk = 0;

	if(userAudioStream){
		userAudioStream.stop();
		userAudioStream = null;

		wRecordWaver.fadeOut(500);
		$(".t_microphone").attr('title', '麦克风').removeClass("t_micoff").hide(); //闭麦按钮恢复
	}

	if(peerAudioConnection){
		peerAudioConnection.close();
		peerAudioConnection = null;

		try{ //避免DOM权限报错
			voicePlayer.srcObject = null;
		}catch(e){}
	}

	stopVideo(); //终止视频
}

//发起音频ice申请(NAT穿透服务器)
function applyAudioIceCandidate(stream){
    const rtcPeerConnection = window.RTCPeerConnection || window.mozRTCPeerConnection || window.webkitRTCPeerConnection;
	peerAudioConnection = new rtcPeerConnection(iceConfig); //连接

	peerAudioConnection.onicecandidate = function(event){
		if(event.candidate) {
			//将ice申请结果发送给对方
			weliveSend({type: "webrtc", event: "client-audio-candidate", msg: event.candidate});
		}
	};

	//使用addTrack 和 ontrack, addStream 和 onaddstream 将被废弃
	if(typeof peerAudioConnection.addTrack == 'function'){
		peerAudioConnection.ontrack = function(e){
			voicePlayer.srcObject = e.streams[0];
			voicePlayer.muted = false;
			voicePlayer.play();
		};

		peerAudioConnection.addTrack(stream.getAudioTracks()[0], stream);
	}else{
		peerAudioConnection.onaddstream = function(e){
			voicePlayer.srcObject = e.stream;
			voicePlayer.muted = false;
			voicePlayer.play();
		};

		peerAudioConnection.addStream(stream);
	}

	peerAudioConnection.createOffer().then(function(desc){
		peerAudioConnection.setLocalDescription(desc).then(function(){

			//客服将申请的ICE发送给访客
			weliveSend({type: "webrtc", event: "client-audio-offer", msg: peerAudioConnection.localDescription});

		}).catch(function(e){
			console.error(e);
		});

	}).catch(function(e){
		console.error(e);
	});
}


//闭麦/开麦
function setMicrophone(me){
	if(!audioStatusOk || !userAudioStream) return;

	var mic = 	userAudioStream.getAudioTracks()[0];

	if(mic.enabled){
		mic.enabled = false;
		$(me).attr('title', '闭麦中').addClass("t_micoff");
	}else{
		mic.enabled = true;
		$(me).attr('title', '麦克风').removeClass("t_micoff");
	}
}

////////////////////////// ****************************** ////////////////////////////////////

//开始视频
function startVideo(){
	if(!audioStatusOk) return; //语音未OK, 返回

	//访客可能已经关闭了摄像头
	if(remoteVideoStatus){
		weliveSend({type: "webrtc", event: "client-video-start", msg: ""}); //通知访客开始ice申请
	}else{
		layer.msg("访客已关闭摄像头", {time: 4000});
	}	
}

//结束视频
function stopVideo(){
	remoteVideoStatus = 0; //访客已终止

	if(peerVideoConnection){
		peerVideoConnection.close();
		peerVideoConnection = null;

		try{ //避免DOM权限报错
			remoteVideo.srcObject = null;
		}catch(e){}

		$("#video_container").slideUp(400); //访客视频窗口
	}
}

//客服发起视频ice申请(NAT穿透服务器)
function applyVideoIceCandidate(data){
	const rtcPeerConnection = window.RTCPeerConnection || window.mozRTCPeerConnection || window.webkitRTCPeerConnection;
	peerVideoConnection = new rtcPeerConnection(iceConfig); //连接

	peerVideoConnection.onicecandidate = function(event){
		if(event.candidate) {
			//将ice申请结果发送给访客
			weliveSend({type: "webrtc", event: "client-video-candidate", msg: event.candidate});
		}
	};

	if(typeof peerVideoConnection.addTrack == 'function'){
		peerVideoConnection.ontrack = function(e){
			remoteVideo.srcObject = e.streams[0];
		};
	}else{
		peerVideoConnection.onaddstream = function(e){
			remoteVideo.srcObject = e.stream;
		};
	}

	$("#video_container").slideDown(800); //访客视频窗口

	const desc = new RTCSessionDescription(data);
	peerVideoConnection.setRemoteDescription(desc);

	peerVideoConnection.createAnswer().then(function(answer) {
	    peerVideoConnection.setLocalDescription(answer);
		weliveSend({type: "webrtc", event: "client-video-answer", msg: answer});
	}).catch(function(e){
		console.error(e);
	});
}

//切换视频大小
function toggleVideoSize(me){
	var original = $(me).attr("original"); //原始bottom值

	if(original){
		$(me).css("bottom", original);
		$(me).attr("original", "");
	}else{
		var bottom = $(me).css("bottom");
		$(me).attr("original", bottom); //记录下来

		var height = $(me).height();

		bottom = (parseInt(bottom) + height / 2) + "px";
		$(me).css("bottom", bottom);
	}
}

//关闭访客摄像头
function xGuestCamera(){
	var e = window.event || arguments.callee.caller.arguments[0];
	e.preventDefault();
	e.stopPropagation();

	stopVideo();

	weliveSend({type: "webrtc", event: "client-camera-close", msg: ""});
}
//webRTC语音视频 end


//welive初始化
function weliveInit(){
	guest_list = new Array();

	guest_online = $("#g88");
	sounder = $("#wl_sounder");
	online_guests = $(".online_guests");
	guest_history = $("#guest_history"); //访客信息输出窗口
	guest_send = $("#guest_send");
	guest_profile = $("#guest_profile");

	s_history = $("#sp_history");
	s_online = $("#sp_list");
	s_admins = $("#sp_num");
	s_send = $("#sp_send");
	s_chat_num = $("#s_chat_num");
	s_phrases_cn = $("#sp_phrases_cn");
	s_phrases_en = $("#sp_phrases_en");

	pagetitle = document.title;

	//socket连接服务器
	weliveLink();

	//客服群聊Ctrl + Enter发送
	s_msg.keydown(function(e){
		var e = e||event, keyCode=e.keyCode||e.which||e.charCode;
		if((send_btn_mod == 0 && e.ctrlKey && keyCode == 13) || (send_btn_mod == 1 && keyCode == 13)){
			e.preventDefault();
			s_send.trigger("click");
		}
	});

	//客服群聊发送
	s_send.click(function(e) {
		var msg = $.trim(s_msg.val());

		if(msg){
			if(weliveSend({type: "msg", sendto: "team", msg: msg})){
				s_msg.val('');
			}else{
				layer.msg("发送失败!");
				s_msg.val(msg);
			}
		}else{
			s_msg.val('');
			layer.msg("未输入!");
		}

		s_msg.focus();
		e.preventDefault();
	});

	//访客Ctrl + Enter发送
	guest_msg.keydown(function(e){
		var e = e||event, keyCode=e.keyCode||e.which||e.charCode;
		if((send_btn_mod == 0 && e.ctrlKey && keyCode == 13) || (send_btn_mod == 1 && keyCode == 13)){
			e.preventDefault();
			guest_send.trigger("click");
		}
	});

	//访客发送
	guest_send.click(function(e) {
		var msg = $.trim(guest_msg.val());

		//通话中且访客未断线时才能发信息
		if(msg && CurrentId && welive.isCalling){
			if(weliveSend({type: "msg", sendto: "front", gid: CurrentId, msg: msg})){
				guest_msg.val('');
			}else{
				layer.msg("发送失败!");
				guest_msg.val(msg);
			}
		}else if(msg){
			guest_msg.val(msg);
			layer.msg("未接通访客!");
		}else{
			guest_msg.val('');
			layer.msg("未输入!");
		}

		guest_msg.focus();
		e.preventDefault();
	});

	//客服群聊区和快捷回复切换
	$(".toggle_btn").click(function(e) {
		if($(this).hasClass("curr")) return false;

		var a = $(this).attr("for");

		if(a == 2){
			var b = 1;
			s_chat_isopen = 0;
		}else{
			var b = 2;
			s_chat_isopen = 1;
			s_chat_num.html(0).hide();
		}

		$(".toggle_btn").removeClass("curr");
		$(this).addClass("curr");

		$("#div_for_btn" + a).show();
		$("#div_for_btn" + b).hide();

		if(a == 1) scrollBottom(s_history);
	});

	var smilies_div = $(".smilies_div");

	//客服表情符号
	$(".sp_face").tipTip({content: smilies_div.html().replace(/4040/ig, 0), keepAlive:true, maxWidth:"292px", defaultPosition:"top", edgeOffset:-38, delay:300});

	//访客表情符号
	$(".t_smilies").tipTip({content: smilies_div.html(), keepAlive:true, maxWidth:"292px", defaultPosition:"top", left: 122, arrowLeft: -122, edgeOffset:6, delay:300, hoverClass: "hover"});

	smilies_div.remove(); //原div删除

	//授权访客上传文件(不含图片)
	$(".t_auth").tipTip({content: '<input class="save" type="submit" value="授权访客上传文件" onclick="guestAuthUpload();return false;">', keepAlive:true, maxWidth:"348px", defaultPosition:"top", edgeOffset:6, delay:300, hoverClass: "hover"});

	//挂起, 解除挂起提示
	$(".set_busy").tipTip({content: '1. 挂起后, 将不再接受新客人排队取号<br>2. 特别忙或暂时离开座席时, 可使用挂起功能', keepAlive:true, maxWidth:"300px", defaultPosition:"bottom", delay:600});
	$(".set_serving").tipTip();

	//切换信息发送方式
	$("#send_mod_btn").tipTip({content: $("#send_mod_div").html(), enter: function(){$("#tiptip_content").children().eq(send_btn_mod).addClass("curr_send_mod");}, keepAlive:true, maxWidth:"300px", defaultPosition:"top", delay:300});

	//管理员专有
	if(admin.type == 1){
		$(".reset_robot").tipTip({content: '1. 客服接通访客前, 均由机器人为其提供文字服务<br>2. 添加、编辑机器人自动回复后, 需要重置才能生效<br>3. 频繁重置机器人可能导致机器人服务中断', keepAlive:true, maxWidth:"368px", defaultPosition:"bottom", delay:600});
	}

	//中英快捷回复左右滑动切换
	initSlider(s_phrases_cn, togglePhrase);
	initSlider(s_phrases_en, togglePhrase);

	//停止页面标题闪烁、禁止刷新
	$(document).mousedown(stopFlashTitle).keydown(function(e){
		var e = e||event, keyCode=e.keyCode||e.which||e.charCode;
		stopFlashTitle();

		//通话中禁止F5, ctrl或shift + F5或R键刷新
		if(welive.isCalling && (keyCode == 116 || ((e.ctrlKey || e.shiftKey) && (keyCode == 82 || keyCode == 116))) ){
			layer.msg("通话中请勿刷新页面！");
			e.returnValue = false;
			e.cancelBubble = true;
			e.keyCode = e.which = e.charCode = 0;
			e.preventDefault();
			return false;
		}
	});


	//初始化计时器
	initStopWatch("#welive_clock", 'span');


	//离开当前页面时提示和选择
	window.onbeforeunload=function(event){if(welive.status){return " ";}};

	//离开当前页面时关闭自动重连
	$(window).unload(function(){welive.status=0;clearTimeout(welive.ttt);clearInterval(ttt_1);clearInterval(tttt);});

	//每20分钟清除过长的客服间对话记录
	setInterval(weliveClear, 1000*1200);
}

//websocket
var WebSocket = window.WebSocket || window.MozWebSocket;

//定义全局变量
var tttt = 0, ttt_1 = 0, ttt_2 = 0, pagetitle, flashtitle_step = 0, sounder, sending_mask, send_btn_mod = 0;
var s_chat, s_msg, s_history, s_online, s_send, s_admins, s_chat_num, s_phrases_cn, s_phrases_en, s_chat_isopen = 1;
var guest_list, online_guests, guest_online, guest_send, guest_msg, guest_history, guest_profile, profile＿loaded = 0, CurrentId = 0;
var welive = {ws:{}, ttt: 0, aix: 0, status: 0, autolink: 1, mp3: '', ring: '', isSlider: 0, isCalling: 0};

var file_chunk_size = 1048576; //切片大小 默认为1M
var file_temp_data = ""; //切片上传文件时使用

//webRTC语音相关
var userNavigator, userAudioStream, peerAudioConnection, iceConfig;
var audioStatusOk = 0;
var wRecordWaver, voicePlayer; //语音播放dom对象

//视频相关
var peerVideoConnection, remoteVideo, remoteVideoStatus = 0;


//页面加载完成
$(function(){
	if(WS_HOST == "")	WS_HOST = document.domain; //先记录下来供websocket连接使用

	//访客铃声
	welive.ring = '<audio src="' + SYSDIR + 'public/ring_b.mp3" autoplay="autoplay"></audio>';

	//客服登录等信息提示音
	welive.mp3 = '<audio src="' + SYSDIR + 'public/sound_b.mp3" autoplay="autoplay"></audio>';

	s_msg = $("#sp_msg");
	guest_msg = $("#guest_msg");

	//初始化发送按钮模式
	send_btn_mod = getCookie(COOKIE_KEFU + "_SBM");
	if(!send_btn_mod) send_btn_mod = 0;
	if(send_btn_mod == 1) {
		s_msg.attr("placeholder", "Enter: 发送");
		guest_msg.attr("placeholder", "Enter: 发送");
	}

	//通话相关 start
	//MediaStream stop兼容性处理
	if(typeof MediaStream !== 'undefined') {
		if(typeof MediaStream.prototype.stop === 'undefined') {
			MediaStream.prototype.stop = function() {
				this.getTracks().forEach(function(track) {
					track.stop();
				});
			};
		}
	}

	//兼容性处理
	userNavigator = navigator.mediaDevices||{};
	if(!userNavigator.getUserMedia){
		userNavigator.getUserMedia = navigator.getUserMedia || navigator.webkitGetUserMedia || navigator.mozGetUserMedia || navigator.msGetUserMedia;
	}

    window.RTCIceCandidate = window.RTCIceCandidate || window.mozRTCIceCandidate;
	window.RTCSessionDescription = window.RTCSessionDescription || window.mozRTCSessionDescription || window.webkitRTCSessionDescription;

	//先授权使用麦克风
	if(userNavigator.getUserMedia){
		userNavigator.getUserMedia({audio:true}).then(stream => {
			setTimeout(function(){stream.stop();}, 200);
		}).catch(err => {
			layer.msg("浏览器未授权使用麦克风", {time: 6000});
		});
	}else{
		layer.msg("浏览器不支持实时语音通话", {time: 6000});
	}

	wRecordWaver = $(".voice_waver"); //波形图
	voicePlayer = document.getElementById("voice_player"); //播放器
	remoteVideo = document.getElementById('remoteVideo'); //访客摄像头
	//通话相关 end


	weliveInit(); //welive初始化


	$("#topbar dl").Jdropdown({delay: 50}, function(a){});

	//退出登录
	$(".logout").click(function(e) {
		showDialog('确定退出 WeCaller 电话客服系统吗?', '', function(){
			document.location = 'index.php?a=logout';
		});

		e.preventDefault();
	});

});