<?php
/* ========================================================================
 * Email: www@onez.cn
 * QQ: 6200103
 * HomePage: http://www.onezphp.com
 * ========================================================================
 * Copyright 2016-2017 佳蓝科技.
 * 
 * ======================================================================== */
error_reporting(E_ALL ^ E_NOTICE);
@set_time_limit(0);

ob_start();
define('ONEZ_ROOT', str_replace("\\",'/', dirname(__FILE__)));
define('APP_STORE_URL', 'http://www.onezphp.com');
define('APP_STORE_API', 'http://www.onezphp.com/api/usersite.php');
define('ONEZ_PKEY', 'PKEY-23582');
if($_GET['res']) {
	$res = $_GET['res'];
	$reses = tpl_resources();
	if(array_key_exists($res, $reses)) {
		if($res == 'css') {
			header('content-type:text/css');
		} else {
			header('content-type:image/png');
		}
		echo base64_decode($reses[$res]);
		exit();
	}
  
}

$actions = array('license', 'env', 'onez', 'db', 'finish');
$action = $_COOKIE['action'];
$action = in_array($action, $actions) ? $action : 'license';
$ispost = strtolower($_SERVER['REQUEST_METHOD']) == 'post';
if(file_exists(ONEZ_ROOT . '/cache/install.lock') && $action != 'finish') {
	header('location: ./index.php');
	exit;
}
header('content-type: text/html; charset=utf-8');
if($action == 'license') {
	if($ispost) {
		setcookie('action', 'env');
		header('location: ?refresh');
		exit;
	}
	tpl_install_license();
}
if($action == 'env') {
	if($ispost) {
		setcookie('action', $_POST['do'] == 'continue' ? 'onez' : 'license');
		header('location: ?refresh');
		exit;
	}
	$ret = array();
	$ret['server']['os']['value'] = php_uname();
	if(PHP_SHLIB_SUFFIX == 'dll') {
		$ret['server']['os']['remark'] = '建议使用 Linux 系统以提升程序性能';
		$ret['server']['os']['class'] = 'warning';
	}
	$ret['server']['sapi']['value'] = $_SERVER['SERVER_SOFTWARE'];
	if(PHP_SAPI == 'isapi') {
		$ret['server']['sapi']['remark'] = '建议使用 Apache 或 Nginx 以提升程序性能';
		$ret['server']['sapi']['class'] = 'warning';
	}
	$ret['server']['php']['value'] = PHP_VERSION;
	$ret['server']['dir']['value'] = ONEZ_ROOT;
	if(function_exists('disk_free_space')) {
		$ret['server']['disk']['value'] = floor(disk_free_space(ONEZ_ROOT) / (1024*1024)).'M';
	} else {
		$ret['server']['disk']['value'] = 'unknow';
	}
	$ret['server']['upload']['value'] = @ini_get('file_uploads') ? ini_get('upload_max_filesize') : 'unknow';

	$ret['php']['version']['value'] = PHP_VERSION;
	$ret['php']['version']['class'] = 'success';
	if(version_compare(PHP_VERSION, '5.3.0') == -1) {
		$ret['php']['version']['class'] = 'danger';
		$ret['php']['version']['failed'] = true;
		$ret['php']['version']['remark'] = 'PHP版本必须为 5.3.0 以上. ';
	}

	$ret['php']['fopen']['ok'] = @ini_get('allow_url_fopen') && function_exists('fsockopen');
	if($ret['php']['fopen']['ok']) {
		$ret['php']['fopen']['value'] = '<span class="glyphicon glyphicon-ok text-success"></span>';
	} else {
		$ret['php']['fopen']['value'] = '<span class="glyphicon glyphicon-remove text-danger"></span>';
	}

	$ret['php']['curl']['ok'] = extension_loaded('curl') && function_exists('curl_init');
	if($ret['php']['curl']['ok']) {
		$ret['php']['curl']['value'] = '<span class="glyphicon glyphicon-ok text-success"></span>';
		$ret['php']['curl']['class'] = 'success';
	} else {
		$ret['php']['curl']['value'] = '<span class="glyphicon glyphicon-remove text-danger"></span>';
		$ret['php']['curl']['class'] = 'danger';
		$ret['php']['curl']['remark'] = '您的PHP环境不支持cURL, 也不支持 allow_url_fopen, 系统无法正常运行.';
		$ret['php']['curl']['failed'] = true;
	}

	$ret['php']['ssl']['ok'] = extension_loaded('openssl');
	$ret['php']['ssl']['ok'] = 1;
	if($ret['php']['ssl']['ok']) {
		$ret['php']['ssl']['value'] = '<span class="glyphicon glyphicon-ok text-success"></span>';
		$ret['php']['ssl']['class'] = 'success';
	} else {
		$ret['php']['ssl']['value'] = '<span class="glyphicon glyphicon-remove text-danger"></span>';
		$ret['php']['ssl']['class'] = 'danger';
		$ret['php']['ssl']['failed'] = true;
		$ret['php']['ssl']['remark'] = '没有启用OpenSSL, 将无法访问云端接口, 系统无法正常运行.';
	}

	$ret['php']['gd']['ok'] = extension_loaded('gd');
	if($ret['php']['gd']['ok']) {
		$ret['php']['gd']['value'] = '<span class="glyphicon glyphicon-ok text-success"></span>';
		$ret['php']['gd']['class'] = 'success';
	} else {
		$ret['php']['gd']['value'] = '<span class="glyphicon glyphicon-remove text-danger"></span>';
		$ret['php']['gd']['class'] = 'danger';
		$ret['php']['gd']['failed'] = true;
		$ret['php']['gd']['remark'] = '没有启用GD, 将无法正常上传和压缩图片, 系统无法正常运行. ';
	}

	$ret['php']['dom']['ok'] = class_exists('DOMDocument');
	if($ret['php']['dom']['ok']) {
		$ret['php']['dom']['value'] = '<span class="glyphicon glyphicon-ok text-success"></span>';
		$ret['php']['dom']['class'] = 'success';
	} else {
		$ret['php']['dom']['value'] = '<span class="glyphicon glyphicon-remove text-danger"></span>';
		$ret['php']['dom']['class'] = 'danger';
		$ret['php']['dom']['failed'] = true;
		$ret['php']['dom']['remark'] = '没有启用DOMDocument, 将无法正常安装使用模块, 系统无法正常运行. ';
	}


	$ret['php']['asp_tags']['ok'] = ini_get('asp_tags');
	if(empty($ret['php']['asp_tags']['ok']) || strtolower($ret['php']['asp_tags']['ok']) == 'off') {
		$ret['php']['asp_tags']['value'] = '<span class="glyphicon glyphicon-ok text-success"></span>';
		$ret['php']['asp_tags']['class'] = 'success';
	} else {
		$ret['php']['asp_tags']['value'] = '<span class="glyphicon glyphicon-remove text-danger"></span>';
		$ret['php']['asp_tags']['class'] = 'danger';
		$ret['php']['asp_tags']['failed'] = true;
		$ret['php']['asp_tags']['remark'] = '请禁用可以使用ASP 风格的标志，配置php.ini中asp_tags = Off';
	}

	$ret['write']['root']['ok'] = local_writeable(ONEZ_ROOT . '/');
	if($ret['write']['root']['ok']) {
		$ret['write']['root']['value'] = '<span class="glyphicon glyphicon-ok text-success"></span>';
		$ret['write']['root']['class'] = 'success';
	} else {
		$ret['write']['root']['value'] = '<span class="glyphicon glyphicon-remove text-danger"></span>';
		$ret['write']['root']['class'] = 'danger';
		$ret['write']['root']['failed'] = true;
		$ret['write']['root']['remark'] = '本地目录无法写入, 将无法使用自动更新功能, 系统无法正常运行.  ';
	}
	$ret['write']['cache']['ok'] = local_writeable(ONEZ_ROOT . '/cache');
	if($ret['write']['cache']['ok']) {
		$ret['write']['cache']['value'] = '<span class="glyphicon glyphicon-ok text-success"></span>';
		$ret['write']['cache']['class'] = 'success';
	} else {
		$ret['write']['cache']['value'] = '<span class="glyphicon glyphicon-remove text-danger"></span>';
		$ret['write']['cache']['class'] = 'danger';
		$ret['write']['cache']['failed'] = true;
		$ret['write']['cache']['remark'] = 'cache目录无法写入, 将无法写入配置文件, 系统无法正常安装. ';
	}
	$ret['write']['plugins']['ok'] = local_writeable(ONEZ_ROOT . '/plugins');
	if($ret['write']['plugins']['ok']) {
		$ret['write']['plugins']['value'] = '<span class="glyphicon glyphicon-ok text-success"></span>';
		$ret['write']['plugins']['class'] = 'success';
	} else {
		$ret['write']['plugins']['value'] = '<span class="glyphicon glyphicon-remove text-danger"></span>';
		$ret['write']['plugins']['class'] = 'danger';
		$ret['write']['plugins']['failed'] = true;
		$ret['write']['plugins']['remark'] = 'plugins目录无法写入, 将无法写入配置文件, 系统无法正常安装. ';
	}

	$ret['continue'] = true;
	foreach($ret['php'] as $opt) {
		if($opt['failed']) {
			$ret['continue'] = false;
			break;
		}
	}
	if($ret['write']['failed']) {
		$ret['continue'] = false;
	}
	tpl_install_env($ret);
}
if($action == 'onez') {
  if(defined('ONEZ_PKEY') && ONEZ_PKEY!=''){
		setcookie('action', 'db');
		header('location: ?refresh');
		exit();
  }
	$userkey = $_GET['userkey'];
  if($userkey){
    setcookie('userkey', $userkey);
		setcookie('action', 'onez');
		header('location: ?refresh');
		exit();
  }
	$userkey = $_COOKIE['userkey'];
	if(!$ispost) {
    if($userkey){
      $ispost=1;
      $_POST['do']='continue';
      $_POST['onez']=array(
        'type'=>'check',
        'userkey'=>$userkey,
      );
    }
  }
	if($ispost) {
		if($_POST['do'] != 'continue') {
			setcookie('action', 'env');
			header('location: ?refresh');
			exit();
		}
    
    $onez=$_POST['onez'];
    $post=array(
      'action'=>'product',
      'data'=>base64_encode(json_encode($onez)),
    );
  	$ch = curl_init();
  	curl_setopt($ch, CURLOPT_URL, APP_STORE_API);
  	curl_setopt($ch, CURLOPT_POST, 1);
  	curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post));
  	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
  	$content = curl_exec($ch);
  	curl_close($ch);
    $json=json_decode($content,1);
    if($json['error']){
      tpl_install_onez($json['error']);
    }
    if(isset($json['userkey'])){
      setcookie('userkey', $json['userkey']);
    }
    if($json['action']){
			setcookie('action', $json['action']);
			header('location: ?refresh');
			exit();
    }
    if($json['content']){
      tpl_install_onez('',base64_decode($json['content']));
    }
    if($json['extra']){
      mkdirs(dirname(ONEZ_ROOT.'/cache'));
      file_put_contents(ONEZ_ROOT.'/cache/install.extra',$json['extra']);
      if(!file_exists(ONEZ_ROOT.'/cache/install.extra')){
        tpl_install_db('请确认你的安装程序目录有写入权限. 多次安装失败, 请访问论坛获取解决方案！');
      }
    }
    
    
		setcookie('action', 'db');
		header('location: ?refresh');
		exit();
	}
  tpl_install_onez('');
}
if($action == 'db') {
  $G['hasdata']=0;
	if($ispost) {
		if($_POST['do'] != 'continue') {
			setcookie('action', 'onez');
			header('location: ?refresh');
			exit();
		}
    if(!file_exists(dirname(__FILE__).'/lib/onezphp.php')){
      $post=array(
        'action'=>'download',
      );
    }else{
      $post=array(
        'action'=>'download2',
      );
    }
    $post['userkey']=$_COOKIE['userkey'];
    if(file_exists(ONEZ_ROOT.'/cache/install.extra')){
      $post['extra']=file_get_contents(ONEZ_ROOT.'/cache/install.extra');
    }
  	$ch = curl_init();
  	curl_setopt($ch, CURLOPT_URL, APP_STORE_API);
  	curl_setopt($ch, CURLOPT_POST, 1);
  	curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post));
  	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
  	$content = curl_exec($ch);
  	curl_close($ch);
    $json=json_decode($content,1);
    if($json['error']){
      tpl_install_db($json['error']);
    }
    if(!file_exists(dirname(__FILE__).'/lib/onezphp.php')){
      if(!$json['files']['lib/onezphp.php']){
        tpl_install_db('获取安装信息失败，可能是由于网络不稳定，请重试。');
      }
    }
    foreach($json['files'] as $file=>$data){
      $data=base64_decode($data);
      mkdirs(dirname(ONEZ_ROOT.'/'.$file));
      file_put_contents(ONEZ_ROOT.'/'.$file,$data);
      if(!file_exists(ONEZ_ROOT.'/'.$file)){
        tpl_install_db('请确认你的安装程序目录有写入权限. 多次安装失败, 请访问论坛获取解决方案！');
      }
    }
      
      
    include_once(dirname(__FILE__).'/lib/onezphp.php');
    $db=$_POST['db'];
    $user=$_POST['user'];
    if(!$user['username']){
      tpl_install_db('管理员账号不能为空');
    }
    if(!$user['password']){
      tpl_install_db('管理员密码不能为空');
    }
    $link=@mysql_connect($db['server'], $db['username'], $db['password']);
    if(!$link){
      tpl_install_db('无法连接数据库，请检查数据库账号和密码是否正确');
    }
  	if(!@mysql_select_db($db['name'], $link)){
      @mysql_query('CREATE DATABASE IF NOT EXISTS `'.$db['name'].'` DEFAULT CHARSET utf8 COLLATE utf8_general_ci;', $link);
      $error=mysql_error();
      if(!@mysql_select_db($db['name'], $link)){
        tpl_install_db('数据库<code>'.$db['name'].'</code>不存在且无法创建，请检查['.$error.']');
      }
    }
		$statement = @mysql_query("SHOW TABLES LIKE '{$db['prefix']}%';",$link);
		if ($statement) {
      $rs=mysql_fetch_array($statement);
      if($rs){
        if($_POST['clear']){
          @mysql_query("DROP TABLE IF EXISTS {$db['prefix']}data;",$link);
          @mysql_query("DROP TABLE IF EXISTS {$db['prefix']}device;",$link);
          @mysql_query("DROP TABLE IF EXISTS {$db['prefix']}member;",$link);
          @mysql_query("DROP TABLE IF EXISTS {$db['prefix']}order;",$link);
        }else{
          $G['hasdata']=1;
          tpl_install_db('');
        }
      }
		}
    $code=<<<ONEZ
<?php
!defined('IN_ONEZ') && exit('Access Denied');
return array(
  'dbhost'=>'$db[server]',
  'dbuser'=>'$db[username]',
  'dbpass'=>'$db[password]',
  'dbname'=>'$db[name]',
  'dbcharset'=>'utf8',
  'tablepre'=>'$db[prefix]',
  'pconnect'=>'1',
);
ONEZ;
    onez()->write(ONEZ_ROOT.'/config/db.default.php',$code);
    #安装数据库
    $sysFile=ONEZ_ROOT.'/cache/dbtables.php';
    if(file_exists($sysFile)){
      $dbtables=include($sysFile);
      if($dbtables){
        foreach($dbtables as $tablename=>$table){
          $sql=onez('db')->create_mysql($tablename,$table['idname'],$table['fields']);
          onez('db')->db()->query($sql);
        }
      }
    }
    #默认数据
    $sysFile=ONEZ_ROOT.'/cache/datas.default.php';
    if(file_exists($sysFile)){
      $value=onez()->read($sysFile);
      if($value){
        $value=substr($value,strpos($value,'?>')+2);
        $value=base64_decode($value);
        $value=unserialize($value);
        if($value){
          foreach($value as $table=>$datas){
            if(is_numeric($table)){
              $datas['namespace']='site.main';
              $datas['tablename']=$datas['tablename'];
              $datas['appid']='0';
              $datas['siteid']='0';
              onez('db')->open('data')->insert($datas);
            }else{
              foreach($datas as $rs){
                if(!empty($rs)){
                  $rs['namespace']='site.main';
                  $rs['appid']='0';
                  $rs['siteid']='0';
                  onez('db')->open($table)->insert($rs);
                }
              }
            }
          }
        }
      }
    }
    $G['this']=onez('main');
    #写入管理账号
    $userid=onez('db')->open('member')->insert(array(
      'username'=>$user['username'],
      'password'=>md5($user['password']),
      'grade'=>'admin',
      'infotime'=>time(),
      'infoip'=>onez()->ip(),
    ));
    $G['this']->db_init('member','grade,username,password,mobile','appid,upid','amt,amt_pay,amt_charge,amt_lock');
    $T=$G['this']->data()->open('member')->one("`username`='$user[username]'");
    if($T){
      $G['this']->data()->open('member')->update(array(
        'nickname'=>$user['username'],
        'password'=>md5($user['password']),
        'grade'=>'admin',
        'infotime'=>time(),
        'infoip'=>onez()->ip(),
      ),"`username`='$user[username]'");
    }else{
      $G['this']->data()->open('member')->insert(array(
        'nickname'=>$user['username'],
        'username'=>$user['username'],
        'password'=>md5($user['password']),
        'grade'=>'admin',
        'infotime'=>time(),
        'infoip'=>onez()->ip(),
      ));
    }
    onez('cache')->cookie('main',"$userid\t$user[username]\t".uniqid(),0);
    $G['userid']=$userid;
    onez('kefu')->install();
    $pkey='';
    if(file_exists(ONEZ_ROOT.'/cache/install.extra')){
      $extra=file_get_contents(ONEZ_ROOT.'/cache/install.extra');
      $json=json_decode(base64_decode($extra),1);
      if(!empty($json['pkey'])){
        $pkey=$json['pkey'];
      }
    }
    if(!$pkey && defined('ONEZ_PKEY') && ONEZ_PKEY!=''){
      $pkey=ONEZ_PKEY;
    }
    define('IS_SITE_FRONT',1);
    #带产品识别码的安装
    if($pkey){
      $post=array();
      $post['action']='install';
      $post['userkey']=$_COOKIE['userkey'];
      $post['pkey']=$pkey;
      $post['homepage']=onez()->homepage();
      $response = onez()->post(APP_STORE_API, http_build_query($post));
      $json=json_decode($response,1);
      $arr=array();
      foreach($json as $k=>$v){
        if(strpos($k,'onez_')!==false){
          $arr[$k]=$v;
        }
      }
      onez()->myoption_set($arr);
      if($json['files']){
        foreach($json['files'] as $file=>$data){
          $data=base64_decode($data);
          mkdirs(dirname(ONEZ_ROOT.'/'.$file));
          file_put_contents(ONEZ_ROOT.'/'.$file,$data);
        }
      }
      if($json['addon']){
        onez('onez')->install($json['addon']);
      }
      if($json['addons']){
        foreach($json['addons'] as $v){
          onez('onez')->install($v);
        }
      }
      if($json['error']){
        tpl_install_db($json['error']);
      }
      if($json['datas']){
        onez('onez')->import($json['datas']);
      }
      if($json['plugins'] && is_array($json['plugins'])){
        foreach($json['plugins'] as $v){
          onez($v);
        }
      }
    }
    
    if(file_exists(ONEZ_ROOT.'/cache/install.extra')){
      @unlink(ONEZ_ROOT.'/cache/install.extra');
    }
		touch(ONEZ_ROOT . '/cache/install.lock');
		setcookie('action', 'finish');
		setcookie('userkey', '');
		header('location: ?refresh');
		exit();
	}
  tpl_install_db('');
}
if($action == 'finish') {
	setcookie('action', '', -10);
	tpl_install_finish();
}

function mkdirs($dir){
  if(!is_dir($dir)){
    mkdirs(dirname($dir));
    mkdir($dir,0777);
  }
  return ;
}
function local_writeable($dir) {
	$writeable = 0;
	if(!is_dir($dir)) {
		@mkdir($dir, 0777);
	}
	if(is_dir($dir)) {
		if($fp = fopen("$dir/test.txt", 'w')) {
			fclose($fp);
			unlink("$dir/test.txt");
			$writeable = 1;
		} else {
			$writeable = 0;
		}
	}
	return $writeable;
}



function tpl_frame() {
	global $action, $actions;
	$action = $_COOKIE['action'];
	$step = array_search($action, $actions);
	$steps = array();
	for($i = 0; $i <= $step; $i++) {
		if($i == $step) {
			$steps[$i] = ' list-group-item-info';
		} else {
			$steps[$i] = ' list-group-item-success';
		}
	}
	$progress = $step * 20 + 20;
	$content = ob_get_contents();
	ob_clean();
	$tpl = <<<EOF
<!DOCTYPE html>
<html lang="zh-cn">
	<head>
		<meta charset="utf-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<title>安装佳蓝在线客服</title>
		<link rel="stylesheet" href="http://cdn.bootcss.com/bootstrap/3.2.0/css/bootstrap.min.css">
		<style>
			html,body{font-size:13px;font-family:"Microsoft YaHei UI", "微软雅黑", "宋体";}
			.pager li.previous a{margin-right:10px;}
			.header a{color:#FFF;}
			.header a:hover{color:#428bca;}
			.footer{padding:10px;}
			.footer a,.footer{color:#eee;font-size:14px;line-height:25px;}
		</style>
		<!--[if lt IE 9]>
		  <script src="http://cdn.bootcss.com/html5shiv/3.7.2/html5shiv.min.js"></script>
		  <script src="http://cdn.bootcss.com/respond.js/1.4.2/respond.min.js"></script>
		<![endif]-->
		<script src="http://cdn.bootcss.com/jquery/1.11.1/jquery.min.js"></script>
		<script src="http://cdn.bootcss.com/bootstrap/3.2.0/js/bootstrap.min.js"></script>
	</head>
	<body style="background:url(?res=background) repeat">
		<div class="container">
			<div class="header" style="margin:15px auto;">
				<ul class="nav nav-pills pull-right" role="tablist">
					<li role="presentation" class="active"><a href="javascript:;">安装向导</a></li>
				</ul>
				<img src="?res=logo" height="40" />
			</div>
			<div class="row well" style="margin:auto 0;">
				<div class="col-xs-3">
					<div class="progress" title="安装进度">
						<div class="progress-bar progress-bar-info progress-bar-striped active" role="progressbar" aria-valuenow="{$progress}" aria-valuemin="0" aria-valuemax="100" style="width: {$progress}%;">
							{$progress}%
						</div>
					</div>
					<div class="panel panel-default">
						<div class="panel-heading">
							安装步骤
						</div>
						<ul class="list-group">
							<a href="javascript:;" class="list-group-item{$steps[0]}"><span class="glyphicon glyphicon-copyright-mark"></span> &nbsp; 许可协议</a>
							<a href="javascript:;" class="list-group-item{$steps[1]}"><span class="glyphicon glyphicon-eye-open"></span> &nbsp; 环境监测</a>
							<a href="javascript:;" class="list-group-item{$steps[2]}"><span class="glyphicon glyphicon-globe"></span> &nbsp; 选择产品</a>
							<a href="javascript:;" class="list-group-item{$steps[3]}"><span class="glyphicon glyphicon-cog"></span> &nbsp; 参数配置</a>
							<a href="javascript:;" class="list-group-item{$steps[4]}"><span class="glyphicon glyphicon-ok"></span> &nbsp; 成功</a>
						</ul>
					</div>
				</div>
				<div class="col-xs-9">
					{$content}
				</div>
			</div>
			<div class="footer" style="margin:15px auto;">
				<div class="text-center">
					Powered by <a href="http://www.onezphp.com" target="_blank"><b>佳蓝科技</b></a> v2.0 &copy; 2017 <a href="http://www.onezphp.com" target="_blank">www.onezphp.com</a>
				</div>
			</div>
		</div>
	</body>
</html>
EOF;
	echo trim($tpl);
}

function tpl_install_license() {
	echo <<<EOF
		<div class="panel panel-default">
			<div class="panel-heading">阅读许可协议</div>
			<div class="panel-body" style="overflow-y:scroll;max-height:400px;line-height:20px;">
				<h3>版权所有 (c)2017，佳蓝科技保留所有权利。 </h3>
				<p>
					感谢您选择佳蓝在线客服。 <br />
					为了使你正确并合法的使用本软件，请你在使用前务必阅读清楚下面的协议条款：
				</p>
				<p>
					<strong>一、本授权协议适用且仅适用于佳蓝云引擎系统(onezphp. 以下简称云引擎)任何版本，佳蓝科技官方对本授权协议的最终解释权。</strong>
				</p>
				<p>
					<strong>二、协议许可的权利 </strong>
					<ol>
						<li>您可以在完全遵守本最终用户授权协议的基础上，将本软件应用于非商业用途，而不必支付软件版权授权费用。</li>
						<li>您可以在协议规定的约束和限制范围内修改云引擎源代码或界面风格以适应您的网站要求。</li>
						<li>您拥有使用本软件构建的网站全部内容所有权，并独立承担与这些内容的相关法律义务。</li>
						<li>获得商业授权之后，您可以将本软件应用于商业用途，同时依据所购买的授权类型中确定的技术支持内容，自购买时刻起，在技术支持期限内拥有通过指定的方式获得指定范围内的技术支持服务。商业授权用户享有反映和提出意见的权力，相关意见将被作为首要考虑，但没有一定被采纳的承诺或保证。</li>
					</ol>
				</p>
				<p>
					<strong>三、协议规定的约束和限制 </strong>
					<ol>
						<li>未获商业授权之前，不得将本软件用于商业用途（包括但不限于企业网站、经营性网站、以营利为目的或实现盈利的网站）。</li>
						<li>未经官方许可，不得对本软件或与之关联的商业授权进行出租、出售、抵押或发放子许可证。</li>
						<li>未经官方许可，禁止在云引擎的整体或任何部分基础上以发展任何派生版本、修改版本或第三方版本用于重新分发。</li>
						<li>如果您未能遵守本协议的条款，您的授权将被终止，所被许可的权利将被收回，并承担相应法律责任。</li>
					</ol>
				</p>
				<p>
					<strong>四、有限担保和免责声明 </strong>
					<ol>
						<li>本软件及所附带的文件是作为不提供任何明确的或隐含的赔偿或担保的形式提供的。</li>
						<li>用户出于自愿而使用本软件，您必须了解使用本软件的风险，在尚未购买产品技术服务之前，我们不承诺对免费用户提供任何形式的技术支持、使用担保，也不承担任何因使用本软件而产生问题的相关责任。</li>
						<li>电子文本形式的授权协议如同双方书面签署的协议一样，具有完全的和等同的法律效力。您一旦开始确认本协议并安装云引擎，即被视为完全理解并接受本协议的各项条款，在享有上述条款授予的权力的同时，受到相关的约束和限制。协议许可范围以外的行为，将直接违反本授权协议并构成侵权，我们有权随时终止授权，责令停止损害，并保留追究相关责任的权力。</li>
						<li>如果本软件带有其它软件的整合API示范例子包，这些文件版权不属于本软件官方，并且这些文件是没经过授权发布的，请参考相关软件的使用许可合法的使用。</li>
					</ol>
				</p>
			</div>
		</div>
		<form class="form-inline" role="form" method="post">
			<ul class="pager">
				<li class="pull-left" style="display:block;padding:5px 10px 5px 0;">
					<div class="checkbox">
						<label>
							<input type="checkbox"> 我已经阅读并同意此协议
						</label>
					</div>
				</li>
				<li class="previous"><a href="javascript:;" onclick="if(jQuery(':checkbox:checked').length == 1){jQuery('form')[0].submit();}else{alert('您必须同意软件许可协议才能安装！')};">继续 <span class="glyphicon glyphicon-chevron-right"></span></a></li>
			</ul>
		</form>
EOF;
	tpl_frame();
}

function tpl_install_env($ret = array()) {
	if(empty($ret['continue'])) {
		$continue = '<li class="previous disabled"><a href="javascript:;">请先解决环境问题后继续</a></li>';
	} else {
		$continue = '<li class="previous"><a href="javascript:;" onclick="$(\'#do\').val(\'continue\');$(\'form\')[0].submit();">继续 <span class="glyphicon glyphicon-chevron-right"></span></a></li>';
	}
	echo <<<EOF
		<div class="panel panel-default">
			<div class="panel-heading">服务器信息</div>
			<table class="table table-striped">
				<tr>
					<th style="width:150px;">参数</th>
					<th>值</th>
					<th></th>
				</tr>
				<tr class="{$ret['server']['os']['class']}">
					<td>服务器操作系统</td>
					<td>{$ret['server']['os']['value']}</td>
					<td>{$ret['server']['os']['remark']}</td>
				</tr>
				<tr class="{$ret['server']['sapi']['class']}">
					<td>Web服务器环境</td>
					<td>{$ret['server']['sapi']['value']}</td>
					<td>{$ret['server']['sapi']['remark']}</td>
				</tr>
				<tr class="{$ret['server']['php']['class']}">
					<td>PHP版本</td>
					<td>{$ret['server']['php']['value']}</td>
					<td>{$ret['server']['php']['remark']}</td>
				</tr>
				<tr class="{$ret['server']['dir']['class']}">
					<td>程序安装目录</td>
					<td>{$ret['server']['dir']['value']}</td>
					<td>{$ret['server']['dir']['remark']}</td>
				</tr>
				<tr class="{$ret['server']['disk']['class']}">
					<td>磁盘空间</td>
					<td>{$ret['server']['disk']['value']}</td>
					<td>{$ret['server']['disk']['remark']}</td>
				</tr>
				<tr class="{$ret['server']['upload']['class']}">
					<td>上传限制</td>
					<td>{$ret['server']['upload']['value']}</td>
					<td>{$ret['server']['upload']['remark']}</td>
				</tr>
			</table>
		</div>

		<div class="alert alert-info">PHP环境要求必须满足下列所有条件，否则系统或系统部份功能将无法使用。</div>
		<div class="panel panel-default">
			<div class="panel-heading">PHP环境要求</div>
			<table class="table table-striped">
				<tr>
					<th style="width:150px;">选项</th>
					<th style="width:180px;">要求</th>
					<th style="width:50px;">状态</th>
					<th>说明及帮助</th>
				</tr>
				<tr class="{$ret['php']['version']['class']}">
					<td>PHP版本</td>
					<td>5.3或者5.3以上</td>
					<td>{$ret['php']['version']['value']}</td>
					<td>{$ret['php']['version']['remark']}</td>
				</tr>
				<tr class="{$ret['php']['curl']['class']}">
					<td>cURL</td>
					<td>支持</td>
					<td>{$ret['php']['curl']['value']}</td>
					<td>{$ret['php']['curl']['remark']}</td>
				</tr>
				<tr class="{$ret['php']['ssl']['class']}">
					<td>openSSL</td>
					<td>支持</td>
					<td>{$ret['php']['ssl']['value']}</td>
					<td>{$ret['php']['ssl']['remark']}</td>
				</tr>
				<tr class="{$ret['php']['gd']['class']}">
					<td>GD2</td>
					<td>支持</td>
					<td>{$ret['php']['gd']['value']}</td>
					<td>{$ret['php']['gd']['remark']}</td>
				</tr>
				<tr class="{$ret['php']['asp_tags']['class']}">
					<td>asp_tags</td>
					<td>关闭</td>
					<td>{$ret['php']['asp_tags']['value']}</td>
					<td>{$ret['php']['asp_tags']['remark']}</td>
				</tr>
			</table>
		</div>

		<div class="alert alert-info">系统要求云引擎整个安装目录必须可写, 才能使用云引擎所有功能。</div>
		<div class="panel panel-default">
			<div class="panel-heading">目录权限监测</div>
			<table class="table table-striped">
				<tr>
					<th style="width:150px;">目录</th>
					<th style="width:180px;">要求</th>
					<th style="width:50px;">状态</th>
					<th>说明及帮助</th>
				</tr>
				<tr class="{$ret['write']['root']['class']}">
					<td>/</td>
					<td>整目录可写</td>
					<td>{$ret['write']['root']['value']}</td>
					<td>{$ret['write']['root']['remark']}</td>
				</tr>
				<tr class="{$ret['write']['cache']['class']}">
					<td>/cache</td>
					<td>cache目录可写</td>
					<td>{$ret['write']['cache']['value']}</td>
					<td>{$ret['write']['cache']['remark']}</td>
				</tr>
				<tr class="{$ret['write']['plugins']['class']}">
					<td>/plugins</td>
					<td>plugins目录可写</td>
					<td>{$ret['write']['plugins']['value']}</td>
					<td>{$ret['write']['plugins']['remark']}</td>
				</tr>
			</table>
		</div>
		<form class="form-inline" role="form" method="post">
			<input type="hidden" name="do" id="do" />
			<ul class="pager">
				<li class="previous"><a href="javascript:;" onclick="$('#do').val('back');$('form')[0].submit();"><span class="glyphicon glyphicon-chevron-left"></span> 返回</a></li>
				{$continue}
			</ul>
		</form>
EOF;
	tpl_frame();
}

function tpl_install_db($error = '') {
  global $G;
	if(!empty($error)) {
		$message = '<div class="alert alert-danger">发生错误: ' . $error . '</div>';
	}
	$insTypes = array();
	if(file_exists(ONEZ_ROOT . '/index.php') && is_dir(ONEZ_ROOT . '/app') && is_dir(ONEZ_ROOT . '/web')) {
		$insTypes['local'] = ' checked="checked"';
	} else {
		$insTypes['remote'] = ' checked="checked"';
	}
	if (!empty($_POST['type'])) {
		$insTypes = array();
		$insTypes[$_POST['type']] = ' checked="checked"';
	}
	$disabled = empty($insTypes['local']) ? ' disabled="disabled"' : '';
  $db=$_POST['db'];
  $user=$_POST['user'];
  $extra=$_POST['extra'];
  empty($db['server']) && $db['server']='localhost';
  empty($db['username']) && $db['username']='root';
  empty($db['prefix']) && $db['prefix']='onez_';
  empty($db['name']) && $db['name']='kefu';
  
  if($G['hasdata']){
    $error=<<<ONEZ
				<div class="form-group">
					<label class="col-sm-2 control-label"></label>
					<div class="col-sm-8">
						<input type="checkbox" name="clear" value="1" id="input-clear" />
            <label for="input-clear" style="color:red">
              您的数据库不为空，请重新建立数据库或是清空该数据库或更改表前缀！
              
              如选中此项，将会自动删除已有数据，请慎重操作
            </label>
					</div>
				</div>
ONEZ;
  }
	echo <<<EOF
	{$message}
	<form class="form-horizontal" method="post" role="form">
		<div class="panel panel-default">
			<div class="panel-heading">数据库选项</div>
			<div class="panel-body">
				<div class="form-group">
					<label class="col-sm-2 control-label">数据库主机</label>
					<div class="col-sm-4">
						<input class="form-control" type="text" name="db[server]" value="$db[server]">
					</div>
				</div>
				<div class="form-group">
					<label class="col-sm-2 control-label">数据库用户</label>
					<div class="col-sm-4">
						<input class="form-control" type="text" name="db[username]" value="$db[username]">
					</div>
				</div>
				<div class="form-group">
					<label class="col-sm-2 control-label">数据库密码</label>
					<div class="col-sm-4">
						<input class="form-control" type="text" name="db[password]" value="$db[password]">
					</div>
				</div>
				<div class="form-group">
					<label class="col-sm-2 control-label">表前缀</label>
					<div class="col-sm-4">
						<input class="form-control" type="text" name="db[prefix]" value="$db[prefix]">
					</div>
				</div>
				<div class="form-group">
					<label class="col-sm-2 control-label">数据库名称</label>
					<div class="col-sm-4">
						<input class="form-control" type="text" name="db[name]" value="$db[name]">
					</div>
				</div>
        $error
			</div>
		</div>
		<div class="panel panel-default">
			<div class="panel-heading">管理选项</div>
			<div class="panel-body">
				<div class="form-group">
					<label class="col-sm-2 control-label">管理员账号</label>
					<div class="col-sm-4">
						<input class="form-control" type="username" name="user[username]" value="$user[username]">
					</div>
				</div>
				<div class="form-group">
					<label class="col-sm-2 control-label">管理员密码</label>
					<div class="col-sm-4">
						<input class="form-control" type="password" name="user[password]" value="$user[password]">
					</div>
				</div>
				<div class="form-group">
					<label class="col-sm-2 control-label">确认密码</label>
					<div class="col-sm-4">
						<input class="form-control" type="password" name="user[password]" value="$user[password]">
					</div>
				</div>
			</div>
		</div>
		<input type="hidden" name="do" id="do" />
		<input type="hidden" name="extra" value="{$extra}" />
		<ul class="pager">
			<li class="previous"><a href="javascript:;" onclick="$('#do').val('back');$('form')[0].submit();"><span class="glyphicon glyphicon-chevron-left"></span> 返回</a></li>
			<li class="previous"><a href="javascript:;" onclick="$('#do').val('continue');$('form')[0].submit();">继续 <span class="glyphicon glyphicon-chevron-right"></span></a></li>
		</ul>
	</form>
	<script>
		var lock = false;
		function check(obj) {
			if(lock) {
				return;
			}
			$('.form-control').parent().parent().removeClass('has-error');
			var error = false;
			$('.form-control').each(function(){
				if($(this).val() == '') {
					$(this).parent().parent().addClass('has-error');
					this.focus();
					error = true;
				}
			});
			if(error) {
				alert('请检查未填项');
				return false;
			}
			if($(':password').eq(0).val() != $(':password').eq(1).val()) {
				$(':password').parent().parent().addClass('has-error');
				alert('确认密码不正确.');
				return false;
			}
			lock = true;
			$(obj).parent().addClass('disabled');
			$(obj).html('正在执行安装');
			return true;
		}
	</script>
EOF;
	tpl_frame();
  exit();
}
function tpl_install_onez($error = '',$content='') {
	if(!empty($error)) {
		$message = '<div class="alert alert-danger">发生错误: ' . $error . '</div>';
	}
  if($content){
    echo $content;
  	tpl_frame();
    exit();
  }
  
  
  $onez=$_POST['onez'];
	echo <<<EOF
	{$message}
  <div class="alert alert-info">登录成功后可以自动注册您的站点，如已购买过产品，可以选择后快速安装</div>
	<form class="form-horizontal" method="post" role="form">
		<div class="panel panel-default">
			<div class="panel-heading">登录佳蓝账号</div>
			<div class="panel-body">
				<div class="form-group">
					<label class="col-sm-2 control-label">佳蓝账号</label>
					<div class="col-sm-4">
						<input class="form-control" type="text" name="onez[username]" value="$onez[username]">
					</div>
				</div>
				<div class="form-group">
					<label class="col-sm-2 control-label">佳蓝密码</label>
					<div class="col-sm-4">
						<input class="form-control" type="password" name="onez[password]" value="$onez[password]">
					</div>
				</div>
			</div>
		</div>
		<input type="hidden" name="do" id="do" />
		<input type="hidden" name="onez[type]" value="login" />
		<ul class="pager">
			<li class="previous"><a href="javascript:;" onclick="$('#do').val('back');$('form')[0].submit();"><span class="glyphicon glyphicon-chevron-left"></span> 返回</a></li>
			<li class="previous"><a href="javascript:;" onclick="$('#do').val('continue');$('form')[0].submit();">继续 <span class="glyphicon glyphicon-chevron-right"></span></a></li>
			<li class="previous"><a href="http://www.onezphp.com/?mod=%2Fregister.php" target="_blank">免费注册佳蓝账号 <span class="glyphicon glyphicon-fire"></span></a></li>
		</ul>
	</form>
	<script>
		var lock = false;
		function check(obj) {
			if(lock) {
				return;
			}
			$('.form-control').parent().parent().removeClass('has-error');
			var error = false;
			$('.form-control').each(function(){
				if($(this).val() == '') {
					$(this).parent().parent().addClass('has-error');
					this.focus();
					error = true;
				}
			});
			if(error) {
				alert('请检查未填项');
				return false;
			}
			lock = true;
			$(obj).parent().addClass('disabled');
			$(obj).html('正在执行安装');
			return true;
		}
	</script>
  <script type="text/javascript" src="http://www.onezphp.com/js/install/login.js"></script>
EOF;
	tpl_frame();
  exit();
}

function tpl_install_finish() {
  global $G;
  include_once(dirname(__FILE__).'/lib/onezphp.php');
	$modules = get_store_module();
	$themes = get_store_theme();
  $_REQUEST['mod']='/admin/index.php';
  $regurl=onez('onez')->href('/onez/cloud/profile.php');
  if(!$modules && !$themes){
    $classname='hide';
  }
	echo <<<EOF
	<div class="page-header"><h3>安装完成</h3></div>
	<div class="alert alert-success">
		恭喜您!已成功安装“佳蓝在线客服”，您现在可以: 
    <a target="_blank" class="btn btn-success" href="./index.php">访问首页</a>
    
    
	</div>
	<div class="form-group $classname">
		<h5><strong>云引擎应用商城</strong></h5>
		<span class="help-block">应用商城特意为您推荐了一批优秀模块、主题，赶紧来安装几个吧！</span>
		<table class="table table-bordered">
			<tbody>
				{$modules}
				{$themes}
			</tbody>
		</table>
	</div>

	<!--<div class="alert alert-warning">
		我们强烈建议您立即注册云服务，享受“在线更新”等云服务。
		<a target="_blank" class="btn btn-success" href="admin.php$regurl">马上去注册</a>
		<a target="_blank" class="btn btn-success" href="http://www.onezphp.com" target="_blank">访问应用商城首页</a>
	</div>-->
EOF;
	tpl_frame();
}


function get_store_module() {
	$response = onez()->post(APP_STORE_API, http_build_query(array('action' => 'module')));
  $response=json_decode($response,1);
  if(empty($response) || empty($response['content'])){
    return;
  }
	$response = $response['content'];

	$modules = '';
  if(!$response['message']){
    return '';
  }
	foreach ($response['message'] as $key => $module) {
		if ($key % 3 < 1) {
			$modules .= '</tr><tr>';
		}
		$module['detail_link'] = APP_STORE_URL . trim($module['detail_link'], '.');
		$modules .= '<td>';
		$modules .= '<div class="col-sm-4">';
		$modules .= '<a href="' . $module['detail_link'] . '" title="查看详情" target="_blank">';
		$modules .= '<img src="' . $module['logo']. '"' . ' width="50" height="50" ' . $module['title'] . '" /></a>';
		$modules .= '</div>';
		$modules .= '<div class="col-sm-8">';
		$modules .= '<p><a href="' . $module['detail_link'] .'" title="查看详情" target="_blank">' . $module['title'] . '</a></p>';
		$modules .= '<p>安装量：<span class="text-danger">' . $module['purchases'] . '</span></p>';
		$modules .= '</div>';
		$modules .= '</td>';
	}
	$modules = substr($modules, 5) . '</tr>';

	return $modules;
}

function get_store_theme() {
	$response = onez()->post(APP_STORE_API, http_build_query(array('action' => 'theme')));
  $response=json_decode($response,1);
  if(empty($response) || empty($response['content'])){
    return;
  }
	$response = $response['content'];

	$modules = '';
  if(!$response['message']){
    return '';
  }

	$themes = '<tr><td colspan="' . count($response['message']) . '">';
	$themes .= '<div class="form-group">';
	foreach ($response['message'] as $key => $theme) {
		$theme['detail_link'] = APP_STORE_URL . trim($theme['detail_link'], '.');
		$themes .= '<div class="col-sm-2" style="padding-left: 7px;margin-right: 25px;">';
		$themes .= '<a href="' . $theme['detail_link'] .'" title="查看详情" target="_blank" /><img src="' . $theme['logo']. '" /></a>';
		$themes .= '<p></p><p class="text-right">';
		$themes .= '<a href="' . $theme['detail_link']. '" title="查看详情" target="_blank">'  . $theme['title'] . '</a></p>';
		$themes .= '</div>';
	}
	$themes .= '</div>';

	return $themes;
}

function tpl_resources() {
	$res = array(
		'logo' => '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',
    'background'=>'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',
	);
	return $res;
}