<?php

/* ========================================================================
 * $Id: chartjs.php 4760 2017-10-12 14:22:54Z onez $
 * 
 * Email: www@onez.cn
 * QQ: 6200103
 * HomePage: http://www.onezphp.com
 * ========================================================================
 * Copyright 2016-2017 佳蓝科技.
 * 
 * ======================================================================== */

!defined('IN_ONEZ') && exit('Access Denied');
#名称：Chart.js
#标识：chartjs

class onezphp_chartjs extends onezphp{
  var $rows=array();
  var $items=array();
  var $key='mychart';
  function __construct(){
    
  }
  function clear(){
    $this->key='mychart_'.uniqid();
    $this->rows=array();
    $this->items=array();
    return $this;
  }
  function head(){
    echo onez('ui')->js($this->url.'/lib/Chart.min.js');
  }
  function color($color=false,$alpha=1){
    $colors=array(
      'red'=>'rgb(255, 99, 132)',
      'orange'=>'rgb(255, 159, 64)',
      'yellow'=>'rgb(255, 205, 86)',
      'green'=>'rgb(75, 192, 192)',
      'blue'=>'rgb(54, 162, 235)',
      'purple'=>'rgb(153, 102, 255)',
      'grey'=>'rgb(201, 203, 207)',
    );
    if($color===false){
      $color=$colors[array_rand($colors)];
    }elseif(gettype($color)=='integer'){
      $colors=array('#4dc9f6',
    		'#f67019',
    		'#f53794',
    		'#537bc4',
    		'#acc236',
    		'#166a8f',
    		'#00a950',
    		'#58595b',
    		'#8549ba',
      );
      $color=$colors[$color % count($colors)];
    }
    if($alpha<1){
      if(strpos($color,'rgb(')!==false){
        $color=str_replace('rgb(','rgba(',$color);
        $color=str_replace(')',','.$alpha.')',$color);
      }else{
        $hexColor=$color=str_replace('#', '', $color);
        if (strlen($color) > 3) {
            $rgb = array(
                'r' => hexdec(substr($color, 0, 2)),
                'g' => hexdec(substr($color, 2, 2)),
                'b' => hexdec(substr($color, 4, 2))
            );
        } else {
            $color = $hexColor;
            $r = substr($color, 0, 1) . substr($color, 0, 1);
            $g = substr($color, 1, 1) . substr($color, 1, 1);
            $b = substr($color, 2, 1) . substr($color, 2, 1);
            $rgb = array(
                'r' => hexdec($r),
                'g' => hexdec($g),
                'b' => hexdec($b)
            );
        }
        $color="rgba($rgb[r],$rgb[g],$rgb[b],$alpha)";
      }
    }
    return $color;
  }
  function code($option=array()){
    if(is_string($option)){
      $option=array(
        'type'=>$option,
      );
    }
    
    !$option['type'] && $option['type']='line';
    if($option['type']=='pie'){
      !$option['width'] && $option['width']='300';
      !$option['height'] && $option['height']='300';
    }else{
      !$option['width'] && $option['width']='600';
      !$option['height'] && $option['height']='300';
    }
    
    
    $chart_data=array(
      'labels'=>array(),
      'datasets'=>array(),
    );
    $first=current($this->rows);
    !$first['data'] && $first['data']=array();
    foreach($first['data'] as $v){
      $chart_data['labels'][]=$v['label'];
    }
    $n=0;
    foreach($this->rows as $row){
      $dataset=array();
      $dataset['label']=$row['title'];
      $color=$this->color($n);
      $dataset['backgroundColor']=$this->color($n,0.2);
      $dataset['borderColor']=$color;
      $dataset['fill']=true;
      
      if($option['type']=='pie'){
        $dataset['backgroundColor']=array();
        unset($dataset['borderColor']);
      }
      
      if($row['option']){
        foreach($row['option'] as $k=>$v){
          $dataset[$k]=$v;
        }
      }
      foreach($row['data'] as $k=>$v){
        $dataset['data'][]=$v['value']*1;
        if($option['type']=='pie'){
          $dataset['backgroundColor'][]=$this->color($k);
        }
      }
      $chart_data['datasets'][]=$dataset;
      $n++;
    }
    
    
    $chart_options=array(
      'bezierCurve'=>true,
    );
    $config=array(
      'type'=>$option['type'],
      'data'=>$chart_data,
      'options'=>$chart_options,
    );
    $key=$this->key;
    $html=array();
    if($this->times(1)){
      $html[]=onez('ui')->js($this->url.'/lib/Chart.min.js');
    }
    
    $html[]='<canvas id="'.$key.'" width="'.$option['width'].'" height="'.$option['height'].'"></canvas>';
    $html[]='<script type="text/javascript">';
    $html[]='var '.$key.'ctx = document.getElementById("'.$key.'").getContext("2d");';
    $html[]='var '.$key.'Chart = new Chart('.$key.'ctx,'.json_encode($config).');';
    $html[]='</script>';
    
    return implode("\n",$html);
  }
  function addrow($row,$title,$option=array()){
    $row=strval($row);
    $this->rows[$row]=array(
      'title'=>$title,
      'option'=>$option,
      'value'=>array(),
    );
    return $this;
  }
  function add($row,$label,$value){
    $row=strval($row);
    $this->rows[$row]['data'][]=array('label'=>$label,'value'=>$value);
    return $this;
  }
  function addArr($row){
    $row=strval($row);
    $args=func_get_args();
    unset($args[0]);
    foreach($args as $v){
      $this->rows[$row]['data'][]=$v;
    }
    return $this;
  }
}