var onez_kefu_code=function(comid){
  var that=this;
  var io;
  that.data={};
  that.init=function(){
    that.loadScript(onez_kefu_resurl+'/js/socket.io/2.0.3/socket.io.js',function(){
      that.start();
    });
  };
  that.loadScript=function(url, callback) {
    var script = document.createElement("script");
    script.type = "text/javascript";
    if(typeof(callback) != "undefined"){
      if (script.readyState) {
        script.onreadystatechange = function () {
          if (script.readyState == "loaded" || script.readyState == "complete") {
            script.onreadystatechange = null;
            callback();
          }
        };
      } else {
        script.onload = function () {
          callback();
        };
      }
    }
    script.src = url;
    document.body.appendChild(script);
  };
  if(typeof $!='undefined' && $(window) instanceof jQuery){
    that.$=$;
    that.init();
  }else{
    that.loadScript(onez_kefu_resurl+'/js/jquery-1.9.1.min.js',function(){
      that.$=jQuery.noConflict();
      that.init();
    });
  }
  that.open=function(wid){
    var width=that.data.width;
    var height=that.data.height;
    var talkurl=that.data.talkurl;
    if(typeof wid=='undefined' || isNaN(wid)){
      wid=0;
    }
    if(typeof width=='undefined' || isNaN(width)){
      width=800;
    }
    if(typeof height=='undefined' || isNaN(height)){
      height=600;
    }
    window.open(talkurl+'&wid='+wid,"group","toolbar=no,location=no,status=no,menubar=no,scrollbars=no,resizable=no,width="+width+",height="+height+",left="+($(window).width()-width)/2+",top="+($(window).height()-height)/2);
  };
  that.start=function(){
    var post={action:'info',vtoken:that.udid()};
    post['info-systemlanguage']=(navigator.systemLanguage?navigator.systemLanguage:navigator.language);
    post['info-color']=screen.colorDepth;
    post['info-screensize']=(screen.width + '*' + screen.height);
    post['info-charset']=document.charset;
    post['info-pagetitle']=document.title;
    try{
      post['info-pageurl']=window.top.location.href;
    }catch(e){
      post['info-pageurl']=window.location.href;
    }
    try{
      post['info-referer']=window.top.document.referrer;
    }catch(e){
      post['info-referer']=document.referrer;
    }
    that.$.post(onez_kefu_apiurl,post,function(o){
      that.ui=$('<div />').html(onez_kefu_html).appendTo('body').find('.onez-kefu');
      that.data=o;
      if(typeof that.data.server_url=='undefined'){
        return;
      }
      if(typeof that.data.room=='undefined'){
        return;
      }
      if(typeof that.data.userid=='undefined'){
        return;
      }
      that.socket= window.io.connect(that.data.server_url); 
      that.socket.on('getmsg',function(item) {
        //console.log(item);
        if(item.type=='in'){
          $(document).trigger('chat-in',item);
          that.socket.emit('getRoomList',{});
        }else if(item.type=='out'){
          $(document).trigger('chat-out',item);
          that.socket.emit('getRoomList',{});
        }else if(item.type=='getmsg'){
          if(typeof item.to!='undefined' && item.to!='' && item.to!=that.data.userid){
            return;
          }
          $(document).trigger('kefu-newmsg',item);
        }
      });
      that.socket.on('welcome', function (item) {
        that.socket.emit('join',{uid:''+that.data.userid,room:that.data.room});
        that.socket.emit('getRoomList',{});
      });
      that.socket.on('roomlist', function (item) {
        that.roomlist_update(item);
      });
      if(typeof onez_kefu_get.left!='undefined'){
        that.ui.css({'left':onez_kefu_get.left});
      }else if(typeof onez_kefu_get.right!='undefined'){
        that.ui.css({'right':onez_kefu_get.right});
      }else{
        that.ui.css({'right':'0'});
      }
      if(typeof onez_kefu_get.top!='undefined'){
        that.ui.css({'top':onez_kefu_get.top});
      }else if(typeof onez_kefu_get.bottom!='undefined'){
        that.ui.css({'bottom':onez_kefu_get.bottom});
      }else{
        that.ui.css({'top':'0'});
      }
      that.ui.parent().find('[data-kefu-wid]').bind('click',function(){
        that.open($(this).attr('data-kefu-wid'));
      });
      that.ready();
    },'json');
  };
};
onez_kefu_code.prototype.roomlist_update=function(item){
  var that=this;
  var workerNum=0;
  if(that.ui.hasClass('onez-kefu-method-icon')){
    var wids=that.ui.attr('data-kefu-wids');
    that.ui.removeClass('online').addClass('offline');
    for(var i=0;i<item.uids.length;i++){
      if(item.uids[i].indexOf('w-')!=-1){
        var wid=item.uids[i].substr(2);
        if(wids.indexOf(','+wid+',')!=-1){
          that.ui.removeClass('offline').addClass('online');
          that.ui.attr('data-kefu-wid',wid);
          return;
        }
      }
    }
    that.ui.attr('data-kefu-wid',wids.split(',')[1]);
    return;
  }
  that.ui.find('[data-kefu-wid]').removeClass('online').addClass('offline');
  for(var i=0;i<item.uids.length;i++){
    if(item.uids[i].indexOf('w-')!=-1){
      that.ui.find('[data-kefu-wid="'+item.uids[i].substr(2)+'"]').removeClass('offline').addClass('online');
      workerNum++;
    }
  }
};
onez_kefu_code.prototype.udid=function(url){
	if(this._udid){
		return this._udid;
	}
	if(navigator.userAgent.indexOf(' Onez/')!=-1){
		var o=navigator.userAgent.split(' Onez/');
		o=o[1].split('/');
		this._udid=o[0];
		window.localStorage.setItem("udid",this._udid);
		return this._udid;
	}
	if(window.localStorage){
		if(window.localStorage.getItem("udid")!=null){
			this._udid=window.localStorage.getItem("udid");
			window.localStorage.setItem("udid",this._udid);
			return this._udid;
		}
	}else{
    return '';
  }
	this._udid=Math.floor(Math.random()*89999999+10000000)+''+Math.floor(Math.random()*89999999+10000000);
	window.localStorage.setItem("udid",this._udid);
	return this._udid;
};
onez_kefu_code.prototype.ready=function(){
};