var onez_kefu=function(box,option){
  var that=this;
  if(typeof option!='object'){
    option={};
  }
  that.options=option;
  that.online=0;
  that.box=$(box);
  that.box.attr('data-comid',option.comid);
  that.box.bind('kefu-print',function(e,data){
    var comid=$(this).attr('data-comid');
    if(comid!=data.comid){
      return;
    }
    that.print(data);
  });
  that.box.bind('kefu-file',function(e,data){
    that.AddImage();
    that.box.find('.inputbox').val('[img]'+data+'[/img]');
    that.send();
  });
  that.connect=function(host,room,userid){
    that.userid=userid;
    that.socket= io.connect(host); 
    that.socket.on('getmsg',function(item) {
      //console.log(item);
      if(item.type=='in'){
        $(document).trigger('kefu-in',item);
        that.socket.emit('getRoomList',{});
      }else if(item.type=='out'){
        $(document).trigger('kefu-out',item);
        that.socket.emit('getRoomList',{});
      }else if(item.type=='getmsg'){
        if(typeof item.id_to!='undefined' && item.id_to!='' && item.id_to!=that.userid){
          return;
        }
        that.getmsg(item);
      }else{
        that.getmsg_other(item);
      }
    });
    that.socket.on('welcome', function (item) {
      that.socket.emit('join',{uid:''+userid,room:room});
      that.socket.emit('getRoomList',{});
    });
    that.socket.on('roomlist', function (item) {
      that.roomlist_update(item);
    });
  };
  that.sendmsg=function(msg){
    that.socket.emit('sendmsg',msg);
  };
  that.is_master=function(userid){
    for(var k in that.options.masters){
      if(that.options.masters[k]==userid){
        return true;
      }
    }
    return false;
  };
  that.at='';
  that.call_plugins=function(name,args){
    var f=that[name];
    if(typeof f=='function'){
      return f.apply(that, [args]);
    }
    return '';
  };
  that.toBottom=function(){
    if(!that.is_bottom){
      return;
    }
    that.box.find('#showbox').scrollTop(that.box.find('#showbox').get(0).scrollHeight);
  };
  that.now=function(){
  	var date = new Date();
  	H_=date.getHours().toString();
  	i_=date.getMinutes().toString();
  	s_=date.getSeconds().toString();
  	if(H_.length==1)H_="0"+H_;
  	if(i_.length==1)i_="0"+i_;
  	if(s_.length==1)s_="0"+s_;
  	return H_+":"+i_+":"+s_;
  };
};
onez_kefu.prototype.ubbtohtml=function(fdata){
  var that=this;
  fdata=fdata.replace(/\n/g,'<br />');
  fdata=fdata.replace(new RegExp('(\\[img\\]\\[url\\])+','gi'),'[img]');
  fdata=fdata.replace(new RegExp('(\\[\/url\\]\\[\/img\\])+','gi'),'[/img]');
  fdata=fdata.replace(new RegExp(':([a-zA-Z]+)_([0-9]{1,2})','g'),'<img class="emote" src="'+that.options.pluginurl+'/images/smiley/$1_$2.png">');
  fdata=fdata.replace(new RegExp('\\[url\\](www.|http:\/\/){1}([^\[\"\'\]]+?)\\[\/url\\]','gi'),'<a href="$1$2" target="_blank">$1$2</a>');
  fdata=fdata.replace(new RegExp('\\[url=(www.|http:\/\/){1}([^\[\"\'\]+?)\\](.+?)\\[\/url\\]','gi'),'<a href="$1$2" target="_blank">$3</a>');
  fdata=fdata.replace(new RegExp('\\[img\\]([^\[\"\']+?)\.(gif|jpg|bmp|png){1}\\[\/img\\]','gi'),'<img src="$1.$2" style="max-height:280px" class="large-image" />');
  return fdata;
};
onez_kefu.prototype.getmsg=function(item){
  var that=this;
  var msg={
    type:'user',
    msgid:item.id,
    nickname:item.nickname,
    style:item.style,
    message:item.message,
    time:item.time,
  };
  if(item.id_to!=that.userid){
    return;
  }
  if(that.userid==item.id_from){
    msg.type='me';
  }
  that.print(msg);
  $.post(window.location.href,{action:'read',online:that.online,msgid:item.id,to:that.wid},function(o){
  },'json');
  $(document).trigger('kefu-newmsg',msg);
};
onez_kefu.prototype.getmsg_other=function(item){
};
onez_kefu.prototype.playSound=function(url){
  $('#audio').remove();
  $('<audio src="'+url+'" autoplay="autoplay" id="audio" />').appendTo('body');
};
onez_kefu.prototype.udid=function(url){
	if(this._udid){
		return this._udid;
	}
	if(navigator.userAgent.indexOf(' Onez/')!=-1){
		var o=navigator.userAgent.split(' Onez/');
		o=o[1].split('/');
		this._udid=o[0];
		window.localStorage.setItem("udid",this._udid);
		return this._udid;
	}
	if(window.localStorage){
		if(window.localStorage.getItem("udid")!=null){
			this._udid=window.localStorage.getItem("udid");
			window.localStorage.setItem("udid",this._udid);
			return this._udid;
		}
	}else{
    return '';
	}
	this._udid=Math.floor(Math.random()*89999999+10000000)+''+Math.floor(Math.random()*89999999+10000000);
	window.localStorage.setItem("udid",this._udid);
	return this._udid;
};

onez_kefu.prototype.send=function(){
  var that=this;
  var message=that.box.find('.inputbox').val();
  message=message.replace(new RegExp('<scr'+'ipt[^>]*?>.*?</scr'+'ipt>','g'), "") ;
  message=message.replace(new RegExp('\<\!\-\-.*?\-\-\>','g'), "") ;
  message=message.replace('\<\!\-\-', "") ;
  if(message.length<1){
    return false;
  }
  that.box.find('.inputbox').val('');
  that.box.find('.inputbox').get(0).focus();
  that.at='';
  $.post(window.location.href,{action:'send',online:that.online,style:that.msg_style,message:message,at:that.at},function(o){
    if(typeof o.error!='undefined'){
      onez.alert(o.error);
    }
    if(typeof o.print!='undefined'){
      that.print(o.print);
    }
    if(typeof o.msg!='undefined'){
      that.sendmsg(o.msg);
    }
  },'json');
};
onez_kefu.prototype.print=function(msg){
  var that=this;
  if(typeof msg.msgid=='undefined'){
    return;
  }
  if(that.box.find('#showbox [data-msgid="'+msg.msgid+'"]').length>0){
    return;
  }
  var item=$('<div class="msg-item" data-msgid="'+msg.msgid+'" data-userid="'+msg.userid+'"></div>');
  if(typeof msg.classname!='undefined'){
    item.addClass(msg.classname);
  }
  if(typeof msg.time=='undefined'){
    msg.time='';
  }
  if(msg.type=='me'){
    $('<div class="im_to">'+msg.nickname+' <span>'+msg.time+'</span> </div>').appendTo(item);
  }else if(msg.type=='user'){
    
    $('<div class="im_from">'+msg.nickname+' <span>'+msg.time+'</span> </div>').appendTo(item);
  }else if(msg.type=='system'){
    $('<div class="im_sys">'+that.ubbtohtml(msg.text)+'</div>').appendTo(item);
  }else if(msg.type=='tip'){
    $('<div class="im_tip">'+that.ubbtohtml(msg.tip)+'</div>').appendTo(item);
  }
  if(typeof msg.message!='undefined'){
    if(typeof msg.style=='undefined'){
      msg.style='';
    }
    $('<div class="im_content" style="'+msg.style+'">'+that.ubbtohtml(msg.message)+'</div>').appendTo(item);
  }
  item.find('img').bind('load',function(){
    that.toBottom();
  }).end().appendTo(that.box.find('#showbox'));
  that.toBottom();
};
onez_kefu.prototype.roomlist_update=function(item){
  
};
onez_kefu.prototype.resize=function(){
};
onez_kefu.prototype.exit=function(){
  onez.confirm('你确定要确出登录吗？',function(){
    location.href='?mod=/exit.php&goto='+encodeURIComponent(location.href);
  });
};
onez_kefu.prototype.init=function(){
  var that=this;
  $(window).bind('resize',function(){
    that.resize();
  });
  that.resize();
  that.box.find('.kefu-tab li[data-key]').bind('click',function(){
    var key=$(this).attr('data-key');
    if(key=='logout'){
      onez.confirm('你确定要确出登录吗？',function(){
        location.href='?mod=/exit.php&goto='+encodeURIComponent(location.href);
      });
      return;
    }
    that.box.find('.kefu-tab li[data-key]').removeClass('current');
    $(this).addClass('current');
    that.box.find('.tab-body').hide();
    if(key=='kefu'){
      that.box.find('.tab-body[data-key="kefu"]').show();
      that.box.find('.frame').attr('src','about:blank');
    }else{
      that.box.find('.tab-body[data-key="web"]').show();
      var url=$(this).attr('data-url');
      that.box.find('.frame').attr('src',url);
    }
  });
  that.box.find('.btn-bar a.btn-bar-open').bind('click',function(){
    that.box.addClass('noright');
    that.resize();
  });
  that.box.find('.btn-bar a.btn-bar-close').bind('click',function(){
    that.box.removeClass('noright');
    that.resize();
  });
  that.box.find('.btn-bar').hover(function(){
    $(this).addClass('hover');
  },function(){
    $(this).removeClass('hover');
  });
  that.box.find('.key-ctrl-enter').bind('click',function(){
    that.box.removeClass('enter-noctrl');
  });
  that.box.find('.key-enter').bind('click',function(){
    that.box.addClass('enter-noctrl');
  });
  that.box.find('.btn-send').bind('click',function(){
    that.send();
  });
  that.box.find('a.icon-font').bind('click',function(){
    if($(this).hasClass('current')){
      that.box.find('.box_font').hide();
      $(this).removeClass('current');
    }else{
      that.box.find('.box_font').show();
      $(this).addClass('current');
    }
  });
  that.box.find('a.icon-emote').bind('click',function(){
    that.box.find('.box_emote').toggle();
  });
  that.box.find('a.icon-image').bind('click',function(){
    
  });
  
  that.box.find('.inputbox').bind('keydown',function(e){
    if(e.keyCode ==13){
      if(that.box.hasClass('enter-noctrl')){
        if(!e.ctrlKey){
          e.preventDefault();
          e.returnValue=false;
          that.send();
        }
      }else if(e.ctrlKey){
        e.preventDefault();
        e.returnValue=false;
        that.send();
      }
    }
  });
  that.box.find('.showbox,.inputbox').bind('click',function(e){
    $('.box_emote').hide();
  });
  that.is_bottom=true;
  that.box.find('.showbox,.inputbox').bind('scroll',function(e){
    var bottom=$(this).get(0).scrollHeight-$(this).scrollTop()-$(this).height();
    that.is_bottom=bottom<100;
  });
  that.box.find('.kefu-toolbar span.icon-text').hover(function(){
    $(this).addClass('hover');
  },function(){
    $(this).removeClass('hover');
  });
  
  
  if(that.options.mode=='group'){
    $.post(window.location.href,{action:'userlist'},function(o){
      if(typeof o.users!='undefined'){
        for(var userid in o.users){
          if(typeof that.newuids[userid]!='undefined'){
            delete that.newuids[userid];
          }
          that.adduser(userid);
          that.users[userid]=o.users[userid];
          that.showuser(userid);
        }
        that.newuids={};
      }
    },'json');
    
  }
  var html='<table><tr>';
  for(var i=1;i<=69;i++){
    html+='<td><img src="'+that.options.pluginurl+'/images/smiley/emoji_'+i+'.png" data-emote=":emoji_'+i+'" /></td>';
    if(i % 13==0){
      html+='</tr><tr>';
    }
  }
  html+='</tr></table>';
  that.box.find('.box_emote').html(html).find('[data-emote]').bind('click',function(){
    var emote=$(this).attr('data-emote');
    that.box.find('.inputbox').insertAtCaret(emote);
    that.box.find('.box_emote').hide();
  });
  that.ready();
};
onez_kefu.prototype.ready=function(){
};
function doit(obj){
  $('.kefu').trigger('kefu-doit',obj);
};
function kefu_event(obj){
  var data=$(obj).data();
  $('.kefu').trigger('kefu-event',data);
};
function file_ok(rndid,data){
  if(data.indexOf('ok')!=-1){
    $('.kefu').trigger('kefu-file',data.substr(2));
  }else{
    alert(data);
  }
}