var onez_kefu_user=function(user){
  
};
onez_kefu.prototype.loading=function(text){
  if(typeof text=='undefined'){
    text='加载中,请稍候...';
  }else if(text==''){
    setTimeout(function(){
      $('.loading').hide();
    },1000);
    return;
  }
  $('.loading').find('.progress-bar').html(text).end().show();
};

onez_kefu.prototype.resize=function(e){
  var that=this;
  var winW=$(window).innerWidth();
  var winH=$(window).innerHeight();
  var headerH=$('.kefu-header').height();
  var footerH=$('.kefu-footer').height();
  var BodyH=winH-headerH;
  var mainH=BodyH;
  var mainW=winW;
  var border=5;
  
  mainW-=that.options.width_left;
  mainW-=that.options.width_right;
  mainW-=border*2;
  
  var leftBoxHeight=mainH;
  var leftBoxNum=0;
  that.box.find('.userlist dt').each(function(){
    leftBoxHeight-=$(this).outerHeight(true);
    leftBoxNum++;
  });
  if(leftBoxNum>0){
    that.box.find('.userlist dd').height(leftBoxHeight/leftBoxNum);
  }
    
  var showboxH=mainH;
  if(that.box.hasClass('dialog-talk')){
    showboxH-=footerH;
    showboxH-=that.box.find('.user-info').outerHeight(true);
  }
  
  var lastSideBarDD=that.box.find('.kefu-right .block dd:last');
  if(lastSideBarDD.length>0){
    var userlistH=winH-lastSideBarDD.offset().top;
    lastSideBarDD.height(userlistH);
  }
  
  that.box.find('.kefu-body').height(BodyH);
  that.box.find('.tab-body').height(mainH);
  that.box.find('.kefu-main').width(mainW);
  that.box.find('.showbox').height(showboxH-border);
  that.box.find('.inputbox').width(mainW-10);
  that.box.find('.frame').width(winW).height(mainH);
  
};
onez_kefu.prototype.roomlist_update=function(item){
  var that=this;
  if(typeof item=='undefined'){
    return;
  }
  if(typeof item.uids=='undefined'){
    return;
  }
  that.box.find('.userlist li[data-uid]').addClass('offline');
  that.online=item.uids.length;
  for(var i=0;i<item.uids.length;i++){
    that.adduser(item.uids[i]);
  }
  that.loaduser();
  that.box.find('.userlist-vistor li.offline[data-uid]').appendTo('.userlist-vistor-offline');
  that.box.find('.userlist-vistor li[data-uid]').not('.offline').appendTo('.userlist-vistor-online');
  //that.box.find('.userlist-vistor li.offline[data-uid]').remove();
  that.usernum_update();
};
onez_kefu.prototype.usernum_update=function(){
  var that=this;
  var totalnum=that.box.find('.userlist-vistor li[data-uid]').length;
  var onlinenum=that.box.find('.userlist-vistor-online li[data-uid]').length;
  that.box.find('.online-info').html('('+onlinenum+' / '+totalnum+')');
  that.box.find('.userlist li[data-uid]').removeClass('talking');
  that.box.find('.userlist li[data-uid="'+that.dialog_uid+'"]').addClass('talking');
};
onez_kefu.prototype.users={};
onez_kefu.prototype.newuids={};
onez_kefu.prototype.adduser=function(userid){
  var that=this;
  var item=that.box.find('.userlist li[data-uid="'+userid+'"],.userlist-loading li[data-uid="'+userid+'"]');
  if(item.length>0){
    item.removeClass('offline');
    return;
  }
  var item=$('<li data-uid="'+userid+'"></li>').appendTo(that.box.find('.userlist-loading'));
  that.newuids[userid]=1;
};
onez_kefu.prototype.reload=function(userid){
  var that=this;
  if(typeof that.users[userid]!='undefined'){
    delete that.users[userid];
  }
  that.dialog_uid='';
  that.dialog_open(userid);
};
onez_kefu.prototype.loaduser=function(){
  var that=this;
  var uids=[];
  for(var userid in that.newuids){
    if(typeof that.users[userid]=='undefined'){
      uids.push(userid);
    }else{
      that.showuser(userid);
    }
  }
  if(uids.length<1){
    return;
  }
  $.post(window.location.href,{action:'loaduser',online:that.online,uids:uids.join(',')},function(o){
    if(typeof o.users!='undefined'){
      for(var userid in o.users){
        if(typeof that.newuids[userid]!='undefined'){
          delete that.newuids[userid];
        }
        that.users[userid]=o.users[userid];
        that.users[userid].userid=userid;
        that.showuser(userid);
        $(document).trigger('kefu-adduser',that.users[userid]);
      }
    }
  },'json');
};
onez_kefu.prototype.showuser=function(userid){
  var that=this;
  if(typeof userid=='undefined'){
    return;
  }
  if(typeof that.users[userid]=='undefined'){
    return;
  }
  var user=that.users[userid];
  if(userid.indexOf('v-')!=-1 && user.wid!='' && user.wid!='0' && user.wid!=that.userid.substr(2)){
    return;
  }
  var html='<img src="'+user.avatar+'" class="avatar" /><span>'+user.nickname+'</span>';
  var item=that.box.find('.userlist li[data-uid="'+userid+'"],.userlist-loading li[data-uid="'+userid+'"]');
  if(item.length<1){
    item=$('<li data-uid="'+userid+'"></li>').appendTo(that.box.find('.userlist-loading'));
  }
  if(user.newmsg>0){
    html+='<em>'+user.newmsg+'</em>';
  }
  item.html(html);
  var loading_item=that.box.find('.userlist-loading li[data-uid="'+userid+'"]');
  if(loading_item.length>0){
    if(user.type=='vistor'){
      item.prependTo(that.box.find('.userlist-vistor-online'));
    }else if(user.type=='worker'){
      item.prependTo(that.box.find('.userlist-worker'));
    }else{
      item.prependTo(that.box.find('.userlist-'+user.type));
    }
  }
  if(!item.hasClass('is-event')){
    item.addClass('is-event');
    item.bind('click',function(){
      var uid=$(this).attr('data-uid');
      that.dialog_open(uid);
    }).hover(function(){
      $(this).addClass('hover');
    },function(){
      $(this).removeClass('hover');
    });
  }
  that.usernum_update();
};
onez_kefu.prototype.ready=function(){
  var that=this;
  that.box.find('.btn-close').bind('click',function(){
    that.dialog_close();
  });
  that.box.find('.btn-words-refresh').bind('click',function(){
    that.loading();
    that.words_load();
  });
  that.words_load();
  $(document).bind('kefu-adduser',function(){
    that.playSound(that.options.baseurl+'/kefu/sound/online.ogg');
  });
  $(document).bind('kefu-newmsg',function(){
    that.playSound(that.options.baseurl+'/kefu/sound/msg.ogg');
  });
  $(document).bind('kefu-change',function(){
    that.playSound(that.options.baseurl+'/kefu/sound/change.ogg');
  });
  $(document).trigger('kefu-ready');
};
onez_kefu.prototype.history_load=function(uid){
  var that=this;
  $.post(window.location.href,{action:'history',to:uid},function(o){
    $('#showbox').empty();
    if(typeof o.history!='undefined'){
      for(var i=o.history.length-1;i>=0;i--){
        that.print(o.history[i]);
      }
    }
  },'json');
};
onez_kefu.prototype.words_load=function(){
  var that=this;
  $.post(window.location.href,{action:'words'},function(o){
    that.loading('');
    if(typeof o.words!='undefined'){
      that.box.find('.words dd ul').empty();
      for(var i=0;i<o.words.length;i++){
        var word=o.words[i];
        var item=$('<li title="'+word.word+'"><a href="javascript:;" onclick="kefu.words_insert(this)">'+word.word+'</a><i onclick="kefu.words_insert2(this)" class="glyphicon glyphicon-flash" title="直接发送"></i></li>');
        item.appendTo(that.box.find('.words dd ul'));
      }
    }
  },'json');
};
onez_kefu.prototype.words_insert=function(obj){
  var that=this;
  var word=$(obj).parents('li').attr('title');
  that.insert(word);
};
onez_kefu.prototype.words_insert2=function(obj){
  var that=this;
  that.words_insert(obj);
  that.send();
};
onez_kefu.prototype.dialog_uid='';
onez_kefu.prototype.dialog_user={};
onez_kefu.prototype.dialog_open=function(uid){
  var that=this;
  if(typeof uid=='undefined' || uid==''){
    return;
  }
  if(that.dialog_uid==uid){
    return;
  }
  that.dialog_close();
  if(typeof that.users[uid]=='undefined'){
    $.post(window.location.href,{action:'loaduser',online:that.online,uids:uid},function(o){
      if(typeof o.users!='undefined'){
        for(var userid in o.users){
          that.users[userid]=o.users[userid];
          that.users[userid].userid=userid;
          that.dialog_open(userid);
        }
      }
    },'json');
    return;
  }
  that.dialog_uid=uid;
  that.dialog_user=that.users[uid];
  that.dialog_user.newmsg=0;
  that.showuser(uid);
  that.box.find('.user-name').html(that.dialog_user.nickname);
  that.box.find('.user-left').html(that.dialog_user.infoA);
  that.box.find('.user-right').html(that.dialog_user.infoB);
  that.box.addClass('dialog-talk');
  that.resize();
  that.history_load(uid);
  $(document).trigger('dialog_open',that.dialog_user);
};
onez_kefu.prototype.dialog_close=function(){
  var that=this;
  that.dialog_uid='';
  that.dialog_user={};
  that.box.removeClass('dialog-talk');
  that.resize();
  $('#showbox').empty();
  $(document).trigger('dialog_close','');
  that.usernum_update();
};
onez_kefu.prototype.send=function(message){
  var that=this;
  if(typeof message=='undefined'){
    message=that.box.find('.inputbox').val();
  }
  message=message.replace(new RegExp('<scr'+'ipt[^>]*?>.*?</scr'+'ipt>','g'), "") ;
  message=message.replace(new RegExp('\<\!\-\-.*?\-\-\>','g'), "") ;
  message=message.replace('\<\!\-\-', "") ;
  if(message.length<1){
    return false;
  }
  that.box.find('.inputbox').val('');
  that.box.find('.inputbox').get(0).focus();
  that.at='';
  $.post(window.location.href,{action:'send',online:that.online,style:that.msg_style,message:message,to:that.dialog_uid},function(o){
    if(typeof o.error!='undefined'){
      onez.alert(o.error);
    }
    if(typeof o.print!='undefined'){
      that.print(o.print);
    }
    if(typeof o.msg!='undefined'){
      that.sendmsg(o.msg);
    }
  },'json');
};
onez_kefu.prototype.getmsg=function(item){
  var that=this;
  var msg={
    type:'user',
    msgid:item.id,
    nickname:item.nickname,
    style:item.style,
    message:item.message,
    time:item.time,
  };
  if(that.userid==item.id_from){
    msg.type='me';
  }
  if(item.id_to!=that.userid){
    return;
  }
  
  $(document).trigger('kefu-newmsg',msg);
  if(that.dialog_uid==item.id_from){
    that.print(msg);
    $.post(window.location.href,{action:'read',online:that.online,to:that.dialog_uid,msgid:item.id},function(o){
    },'json');
  }else{
    if(typeof that.users[item.id_from]!='undefined'){
      if(typeof that.users[item.id_from].newmsg=='undefined'){
        that.users[item.id_from].newmsg=0;
      }
      that.users[item.id_from].newmsg++;
      that.showuser(item.id_from);
    }
  }
};
onez_kefu.prototype.getmsg_other=function(item){
  var that=this;
  if(item.type=='input'){
    if(that.dialog_uid==item.id_from){
      var message=item.message;
      if(message.length<1){
        $('#tmp-input').hide();
      }else{
        if($('#tmp-input').length<1){
          $('<div id="tmp-input"></div>').appendTo('.kefu-bottom .pull-left');
        }
        $('#tmp-input').text('正在输入: '+message).show();
      }
    }
  }else if(item.type=='change'){
    if(item.id_to==that.userid){
      if(typeof that.users[item.id]!='undefined'){
        delete that.users[item.id];
      }
      that.socket.emit('getRoomList',{});
      if(typeof item.message!='undefined'){
        $(document).trigger('kefu-change',item);
        if($('.bootbox-confirm').length<1){
          onez.confirm(item.message,function(){
            that.dialog_uid='';
            that.dialog_open(item.id);  
          });
        }
      }
    }
  }
  $(document).trigger('getmsg_other',item);
};
