
--
-- 'onez_answer'
--

DROP TABLE IF EXISTS onez_answer;
CREATE TABLE onez_answer (
  aid bigint(20) NOT NULL AUTO_INCREMENT,
  content longtext,
  asknum int(11) NOT NULL DEFAULT '0',
  addtime int(11) NOT NULL DEFAULT '0',
  updatetime int(11) NOT NULL DEFAULT '0',
  keywords longtext,
  jscode longtext,
  phpcode longtext,
  PRIMARY KEY (aid)
) ENGINE=MyISAM;

-- --------------------------------------------------------

--
-- 'onez_book'
--

DROP TABLE IF EXISTS onez_book;
CREATE TABLE onez_book (
  bid bigint(20) NOT NULL AUTO_INCREMENT,
  token varchar(20) NOT NULL,
  hid bigint(20) NOT NULL DEFAULT '0',
  caption varchar(120) DEFAULT NULL,
  `time` int(11) NOT NULL DEFAULT '0',
  ip varchar(20) DEFAULT NULL,
  PRIMARY KEY (bid)
) ENGINE=MyISAM;

-- --------------------------------------------------------

--
-- 'onez_faq'
--

DROP TABLE IF EXISTS onez_faq;
CREATE TABLE onez_faq (
  fid bigint(20) NOT NULL AUTO_INCREMENT,
  qid bigint(20) NOT NULL DEFAULT '0',
  aid bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (fid),
  UNIQUE KEY qid (qid,aid)
) ENGINE=MyISAM;

-- --------------------------------------------------------

--
-- 'onez_history'
--

DROP TABLE IF EXISTS onez_history;
CREATE TABLE onez_history (
  hid bigint(20) NOT NULL AUTO_INCREMENT,
  uid varchar(50) DEFAULT NULL,
  firsttime int(11) NOT NULL DEFAULT '0',
  lasttime int(11) NOT NULL DEFAULT '0',
  firstip varchar(20) DEFAULT NULL,
  lastip varchar(20) DEFAULT NULL,
  cometimes int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (hid)
) ENGINE=MyISAM;

-- --------------------------------------------------------

--
-- 'onez_keywords'
--

DROP TABLE IF EXISTS onez_keywords;
CREATE TABLE onez_keywords (
  kid bigint(20) NOT NULL AUTO_INCREMENT,
  word varchar(50) DEFAULT NULL,
  url varchar(120) DEFAULT NULL,
  PRIMARY KEY (kid)
) ENGINE=MyISAM;

-- --------------------------------------------------------

--
-- 'onez_message'
--

DROP TABLE IF EXISTS onez_message;
CREATE TABLE onez_message (
  mid bigint(20) NOT NULL AUTO_INCREMENT,
  hid bigint(20) NOT NULL DEFAULT '0',
  qid bigint(20) NOT NULL DEFAULT '0',
  aid bigint(20) NOT NULL DEFAULT '0',
  ifusr int(1) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL DEFAULT '0',
  content longtext,
  PRIMARY KEY (mid)
) ENGINE=MyISAM;

-- --------------------------------------------------------

--
-- 'onez_options'
--

DROP TABLE IF EXISTS onez_options;
CREATE TABLE onez_options (
  oid bigint(20) NOT NULL AUTO_INCREMENT,
  uid bigint(20) NOT NULL DEFAULT '0',
  objid bigint(20) NOT NULL DEFAULT '0',
  tablename char(20) NOT NULL,
  token char(20) NOT NULL,
  `value` longtext,
  isarray int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (oid)
) ENGINE=MyISAM;

-- --------------------------------------------------------

--
-- 'onez_question'
--

DROP TABLE IF EXISTS onez_question;
CREATE TABLE onez_question (
  qid bigint(20) NOT NULL AUTO_INCREMENT,
  content longtext,
  asknum int(11) NOT NULL DEFAULT '0',
  addtime int(11) NOT NULL DEFAULT '0',
  updatetime int(11) NOT NULL DEFAULT '0',
  keywords longtext,
  isdefault int(1) NOT NULL DEFAULT '0',
  only int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (qid)
) ENGINE=MyISAM;

-- --------------------------------------------------------

--
-- 'onez_ufield'
--

DROP TABLE IF EXISTS onez_ufield;
CREATE TABLE onez_ufield (
  fid bigint(20) NOT NULL AUTO_INCREMENT,
  uid bigint(20) NOT NULL DEFAULT '0',
  token varchar(50) NOT NULL,
  `value` longtext,
  PRIMARY KEY (fid),
  UNIQUE KEY uid (uid,token)
) ENGINE=MyISAM;

-- --------------------------------------------------------

--
-- 'onez_users'
--

DROP TABLE IF EXISTS onez_users;
CREATE TABLE onez_users (
  uid bigint(20) NOT NULL AUTO_INCREMENT,
  username varchar(50) DEFAULT NULL,
  nickname varchar(50) DEFAULT NULL,
  `password` varchar(32) DEFAULT NULL,
  ismaster int(1) NOT NULL DEFAULT '0',
  email varchar(120) DEFAULT NULL,
  emailverify varchar(50) DEFAULT NULL,
  qq varchar(15) DEFAULT NULL,
  mobile varchar(11) DEFAULT NULL,
  mobileverify varchar(50) DEFAULT NULL,
  ufrom char(20) NOT NULL DEFAULT 'onez',
  infotime int(11) NOT NULL DEFAULT '0',
  infoip varchar(20) DEFAULT NULL,
  amt float(11,2) NOT NULL DEFAULT '0.00',
  payamt float(11,2) NOT NULL DEFAULT '0.00',
  lockamt float(11,2) NOT NULL DEFAULT '0.00',
  credit int(11) NOT NULL DEFAULT '0',
  lasttime int(11) NOT NULL DEFAULT '0',
  lastip varchar(20) DEFAULT NULL,
  thistime int(11) NOT NULL DEFAULT '0',
  thisip varchar(20) DEFAULT NULL,
  paytime int(11) NOT NULL DEFAULT '0',
  payip varchar(20) DEFAULT NULL,
  sn varchar(50) DEFAULT NULL,
  exptime int(11) NOT NULL DEFAULT '0',
  loginkey varchar(50) DEFAULT NULL,
  PRIMARY KEY (uid)
) ENGINE=MyISAM;
