<?php
/*
'#################################################################
'# 程序名称：中环留言版V3.2
'# 授权方式：免费软件
'# 作者：善
'# 联系QQ:9118847
'# 作者网站:http://www.ps173.com
'# 发布时间：2015-1-3
'# 声明：欢迎广大的PHP爱好者一起共同探讨
'# 声明：各种用途均可免费使用、自由传播，但必须保留程序代码中的版权信息。
'#################################################################
 */

class BookModel extends Model{
		
    //初始化成员		
	public function __construct(){
		parent::__construct();
		$this->tabName=TAB_FIX."book";
		$this->tabkey=array("id", "name", "title", "content", "reply", "phone", "face", "pic", "ip", "top", "state", "date");
				
	}
    //检测内容是否为空
	public function check_null($content){
		if(!valdate::checknull($content)){
			valdate::showmsg("留言内容不能为空！");
			return false;
		}

		return $content;
	}
    //检测留言是否合法
    public function check_write($post){
        $rs=true;

        if(!valdate::checknull($post['name'])){
            valdate::showmsg("姓名不能为空！");
            $rs=false;
        }

        if(!valdate::check_length($post['name'], 5)){
            valdate::showmsg("姓名不能超过5位!");
            $rs=false;
        }

        if(!valdate::check_length($post['phone'], 15)){
            valdate::showmsg("联系方式不能超过15位!");
            $rs=false;
        }

        if(!valdate::checknull($post['title'])){
            valdate::showmsg("标题不能为空！");
            $rs=false;
        }

        if(!valdate::check_length($post['title'], 10)){
            valdate::showmsg("标题不能超过10位!");
            $rs=false;
        }

        if(!valdate::checknull($post['content'])){
            valdate::showmsg("留言内容不能为空!");
            $rs=false;
        }

        if(!valdate::check_length($post['content'], 300)){
            valdate::showmsg("留言内容不能超过300字!");
            $rs=false;
        }

        return $rs;
    }
    //获取留言的总数			
	public function book_total(){
		return $this->total();
	}
	//获取留言内容及条数
	public function book_all($offset, $num){
        return $this->findall(null, $offset, $num);

	}
    //通过传递过来的ID获取留言数据，如果不存在就返回假
	public function one_id($id){
		if(valdate::check_num($id)){
			$num=$this->find($id);
		}
		if(!empty($num)){
			return $num;
		}else{
			valdate::showmsg("该留言不存在，或者已经被删除");
		}
	}
    //回复留言
	public function reply($post){
		if($this->check_null($post['content'])){
			return $this->mod($post);
		}else{
			return null;
		}
	}
    //删除留言
    public function del_book($id){
        if(valdate::check_num($id)){
            return $this->del($id);
        }else{
            return false;
        }

    }
    //获取留言，并对留言进行相应的处理
    public function book_num($offset, $num){
        $num=$this->findall(null, $offset, $num, $order="top desc, id desc");
        if(!empty($num)){
            foreach($num as $key=>$val){
                $str=explode('.', $val['ip']);
                $str[2]='*';
                $str[3]='*';
                $num[$key]['ip']=join('.', $str);
                $num[$key]['phone']=substr_replace($val['phone'], '*', 0, 5);
            }

        }
        return $num;
  
    }
    //添加留言到数据库
    public function addbook($post){
        $time=date('Y-m-d H:i:s', time());
        if(isset($post)){
            $data=array(
                "name"=>$post['name'],
                "phone"=>$post['phone'],
                "title"=>$post['title'],
                "face"=>$post['face'],
                "pic"=>$post['pic'],
                "ip"=>$post['ip'],
                "state"=>$post['state'],
                "content"=>$post['content'],
                "date"=>$time
            );
            return  $this->add($data);
        }
        
    }

}


?>
