<?php
/*
'#################################################################
'# 程序名称：中环留言版V3.2
'# 授权方式：免费软件
'# 作者：善
'# 联系QQ:9118847
'# 作者网站:http://www.ps173.com
'# 发布时间：2015-1-3
'# 声明：欢迎广大的PHP爱好者一起共同探讨
'# 声明：各种用途均可免费使用、自由传播，但必须保留程序代码中的版权信息。
'#################################################################
 */

class Model extends Mysql{   
	protected $tabName;
	protected $tabkey;
	private $str;
	private $list;


	/**************************************
	 *根据sql语句查询。
	 *如果存在就返回一行数组，如果不存在就返回假
	 **************************************/
	protected function Rs_one($query){
		if(empty($query)){
			return false;
		}
		$result=$this->mysqli->query($query);
		if($result && $result->num_rows > 0){
			return $result->fetch_assoc();
		}else{
			return false;
		}
	}

	/**************************************
	 *根据提交过来的SQL语句进行增、删、改
	 *成功返回1、失败返回假
	 **************************************/
	protected function Rs_affected($query){
		if(empty($query)){
			return false;
		}

		$result=$this->mysqli->query($query);
        if($result && $this->mysqli->affected_rows > 0){
            return $this->mysqli->affected_rows;
        }else{
            return false;
        }           
	}


	/**************************************
	 *将提交来过的数据增加到数据库
	 *成功返回1，失败返回假
	 *************************************/
	protected function add($post){
		foreach($post as $key=>$val){
			if(in_array($key, $this->tabkey)){
				$this->list.=$key.",";
				$this->str.="'".valdate::clean_html($val)."',";

			}

		}

		$this->list=rtrim($this->list, ",");
		$this->str=rtrim($this->str, ",");

		$query="INSERT INTO {$this->tabName} (".$this->list.") VALUES(".$this->str.")";
		return $this->Rs_affected($query);
	}


	/**************************************
	 *将提交来过的数据进修改
	 *成功返回1，失败返回假
	 *************************************/        
    protected  function mod($post){
		$id=$post['id'];
        unset($post['id']);
		foreach($post as $key=>$val){
		    if(in_array($key, $this->tabkey)){
				$this->str.=$key."='".valdate::clean_html($val)."',";
               
			}
		}

		$this->str=rtrim($this->str, ",");
		$query="UPDATE {$this->tabName} SET {$this->str} WHERE id='{$id}'";
		return $this->Rs_affected($query);
	}


	/**************************************
	 *将提交来过的ID进行删除
	 *成功返回1，失败返回假
	 *************************************/
	protected function del($id){
		if(is_array($id))
			$tmp="IN(" .join(",", $id) .")";
		else
			$tmp= "= $id";

		$query="DELETE FROM {$this->tabName} WHERE id ".$tmp;
		return $this->Rs_affected($query);
	}


   /********************************
   *根据ID查询整个数据表,如果存在就返回数组
   *如果为空就返回假
   ********************************/
	protected function find($id){
		if(empty($id)){
			return false;
		}

		$filed=join(",", $this->tabkey);
		$query="SELECT {$filed} FROM {$this->tabName} WHERE id={$id} LIMIT 1";
		return $this->Rs_one($query);
	}


  /********************************
   *根据where条件查询ID,如果存在就返回表的数量
   ********************************/        
	protected function total($where=null){
		$query="SELECT id from {$this->tabName} {$where}";
		$result=$this->mysqli->query($query);
		return $result->num_rows;
	}


  /********************************
   *根据提交过来表字段进行查询
   *如果where为空就是返回整个表字段内容.
   *最后以数组的形式返回
   ********************************/        
	protected function Get_one($list, $where=null){
		if(!is_array($list)){
			return false;
		}

		$filed=join(",", $list);
		$query="SELECT {$filed} FROM {$this->tabName} {$where} LIMIT 1";
		return $this->Rs_one($query);
    } 

   /********************************
   *根据提交过来表字段进行查询,如果为空就默认查整个表
   *最后以数组的形式返回
   ********************************/   
	protected function findall($filed=array(), $offset=0, $num=0, $order="id desc"){
		if(empty($filed)){
			$filed=join(",", $this->tabkey);
		}else{
			$filed=join(",", $filed);
		}
		
		$query="SELECT {$filed} FROM {$this->tabName} ORDER BY {$order} LIMIT {$offset}, {$num}";
		
		$result=$this->mysqli->query($query);
		
		if($result && $result->num_rows >0){
			$arr = array();
			
			while($row = $result->fetch_assoc()){
				$arr[] = $row;
			}
			
			return $arr;
		}else{
			return null;
		}
	}


}


?>
