<?php
/*
'#################################################################
'# 程序名称：中环留言版V3.2
'# 授权方式：免费软件
'# 作者：善
'# 联系QQ:9118847
'# 作者网站:http://www.ps173.com
'# 发布时间：2015-1-3
'# 声明：欢迎广大的PHP爱好者一起共同探讨
'# 声明：各种用途均可免费使用、自由传播，但必须保留程序代码中的版权信息。
'#################################################################
 */

class SysModel extends Model{
    private $dbsize;
    private $serverenv;
    private $host;
    private $phpversion;
    private $gdinfo;
    private $mysqlversion;
    private $allowurl;
    private $fileup;
    private $maxexetime;
    private $gd;
    //初始化成员
    public function __construct(){
        parent::__construct();
        $this->serverenv = $this->getserverenv();
        $this->host = $this->gethost();
        $this->phpversion = $this->getphpversion();
        $this->gdinfo = $this->getgdinfo();
        $this->mysqlversion = $this->getmysqlversion();
        $this->allowurl = $this->getallowurl();
        $this->fileup = $this->getfileup();
        $this->dbsize = $this->getmysqlsize();
        $this->maxexetime = $this->getmaxexetime();
    }
    //获取服务器信息
    private function getserverenv(){
        return PHP_OS.' | '.$_SERVER['SERVER_SOFTWARE'];

    }
    //获取主机信息
    private function gethost(){
        return $_SERVER['SERVER_NAME'];
    }
    //获取PHP版本
    private function getphpversion(){
        return PHP_VERSION;
    }
    //获取GD信息
    private function getgdinfo(){
        if(function_exists('gd_info')){
            $this->gd=gd_info();
            $gdinfo =$this->gd['GD Version'];
        }else{
            $gdinfo ='<span class="red_font">未知</span>';
        }
        return $gdinfo;
    }
    //获取MYSQLI版本
    private function getmysqlversion(){
        return $this->mysqli->server_info;
    }
    //获取远程文件信息
    private function getallowurl(){
        if(ini_get('allow_url_fopen'))
            return '支持';
        else
            return '<span class="red_font">不支持</span>';

    }
    //获取上传文件大小
    private function getfileup(){
        if(ini_get('file_uploads')){
            $umfs =ini_get('upload_max_filesize');
            $pms  =ini_get('post_max_size');
            return '允许 | 文件:'.$umfs.' | 表单 : '.$pms;
        }else{
            return '<span class="red_font">禁止</span>';
        }

    }  
    //获取数据库使用的大小
    private function getmysqlsize(){
        return $this->getdbsize();
    }
    //获取脚本执行时间
    private function getmaxexetime(){
        return ini_get('max_execution_time').'秒';
    }
    //将上面得到的信息输出到界面
    public function getsysinfo(){
        $info =array(
            "server"=>$this->serverenv,
            "host"=>$this->host,
            "phpver"=>$this->phpversion,
            "gdinfo"=>$this->gdinfo,
            "mysqlver"=>$this->mysqlversion,
            "allowurl"=>$this->allowurl,
            "fileup"=>$this->fileup,
            "dbsize"=>$this->dbsize,
            "exemaxtime"=>$this->maxexetime
        );

        return $info;
    }


}



?>
