<?php
/*
'#################################################################
'# 程序名称：中环留言版V3.2
'# 授权方式：免费软件
'# 作者：善
'# 联系QQ:9118847
'# 作者网站:http://www.ps173.com
'# 发布时间：2015-1-3
'# 声明：欢迎广大的PHP爱好者一起共同探讨
'# 声明：各种用途均可免费使用、自由传播，但必须保留程序代码中的版权信息。
'#################################################################
 */

class vcode{
    private $width;
    private $height;
    private $codenum;
    private $disturbcolornum;
    private $checkcode;
    private $image;

    //初始化成员
    public function __construct($width=80, $height=20, $codenum=4){
        $this->width=$width;
        $this->height=$height;
        $this->codenum=$codenum;
        $number=floor($height*$width/15);
        if($number > 200 - $codenum)
            $this->disturbcolornum=200 - $codenum;
        else
            $this->disturbcolornum=$number;

        $this->checkcode=$this->createcheckcode();
    }
    //合用PHP的魔术方法，这样可以省去 new 
    public function __toString(){
        $_SESSION['code']=strtoupper($this->checkcode);
        return $this->outimg();
    }
    //输出验证码
    private function outimg(){
        $this->getcreateimage();
        $this->setdisturbcolor();
        $this->outputtext();
        $this->outputimage();
    }
    //得到验证码图片
    private function getcreateimage(){
        $this->image=imagecreatetruecolor($this->width, $this->height);

        $backcolor=imagecolorallocate($this->image, rand(225, 255), rand(225, 255), rand(225, 255));
        imagefill($this->image, 0, 0, $backcolor);

        $border=imagecolorallocate($this->image, 0, 0, 0);
        imagerectangle($this->image, 0, 0, $this->width-1, $this->height-1, $border);
    }
    //创建验证码字符
    private function createcheckcode(){
        $code="3456789abcedfghijkmnpqrstuvwxyABCDEFGHIJKMNPQRSTUVWXY";
        for($i=0; $i<$this->codenum; $i++){
            $char=$code{rand(0, strlen($code)-1)};

            @$ascii.=$char;
        }
        return $ascii;
    }
    //创建验证码背景色
    private function setdisturbcolor(){
        for($i=0; $i<=$this->disturbcolornum; $i++){
            $color=imagecolorallocate($this->image, rand(0,255), rand(0,255), rand(0,255));
            imagesetpixel($this->image, rand(1, $this->width-2), rand(1, $this->height-2), $color);

        }

        for($i=0; $i<3; $i++){
            $color=imagecolorallocate($this->image, rand(0, 255), rand(0, 255), rand(0, 255));
            imagearc($this->image, rand(-10, $this->width), rand(-10, $this->height), rand(30, 300), rand(20, 200), 55, 44, $color);
      }
    }
    //输出验证码字符
	private function outputtext() {       
        for($i=0;$i<=$this->codenum; $i++) {
		    $fontcolor=imagecolorallocate($this->image, rand(0,128), rand(0,128), rand(0,128));
			$fontsize=rand(5,7);
			$x = floor($this->width/$this->codenum)*$i+3;
            $y = rand(0,$this->height-imagefontheight($fontsize));
            @imagechar($this->image, 5, $x, $y, $this->checkcode{$i}, $fontcolor);
 	     }
      }
    //输出背景图
    private function outputimage(){
        if(imagetypes() & IMG_GIF){
            header("Content-type:image/gif");
            imagegif($this->image);
        }else if(imagetypes() & IMG_JPG){
            header("Content-type:image/jpeg");
            imagejpeg($this->image, "", 0.5);
        }else if(imagetypes() & IMG_PNG){
            header("Content-type:image/png");
            imagepng($this->image);
        }else if(imagetypes() & IMG_WBMP){
            header("Content-type:image/vnd.wap.wbmp");
            imagewbmp($this->image);
        }else{
            die("无效图像");
        }
    }
    //销毁资源
    public function __destruct(){
        imagedestroy($this->image);
    }

}


?>
