<?php
/*
'#################################################################
'# 程序名称：中环留言版V3.2
'# 授权方式：免费软件
'# 作者：善
'# 联系QQ:9118847
'# 作者网站:http://www.ps173.com
'# 发布时间：2015-1-3
'# 声明：欢迎广大的PHP爱好者一起共同探讨
'# 声明：各种用途均可免费使用、自由传播，但必须保留程序代码中的版权信息。
'#################################################################
 */

class page{
    private $total;
    private $page;
    private $num;
    private $pagenum;
    private $offset;

    //初始化成员
    public function __construct($total, $page=1, $num=10){
        $this->total=$total;
        $this->num=$num;
        $this->page=$page;          
        $this->pagenum=$this->getpagenum();  
        $this->offset=$this->getoffset();

    }
	//得到总数
	private function getpagenum(){
		return ceil($this->total / $this->num);
	
	}
	//输出下一页
	private function getnextpage(){
		if($this->page == $this->pagenum)
			return false;
		else
			return $this->page+1;
	}
	//输出上一页
	private function getprevpage(){
		if($this->page == 1)
			return false;
		else
			return $this->page-1;
	}
	//得到当前的页
	private function getoffset(){
		return ($this->page-1)*$this->num;
	}
	//检测是否还有下一页
	private function getstartnum(){
		if($this->total==0)
			return 0;
		else
			return $this->offset+1;
	}
	//得到最后一页
	private function getendnum(){
		return min($this->offset+$this->num, $this->total);
    }

	//输出分页
	public function getpageinfo(){
		$pageinfo=array(
			"row_total"=>$this->total,
			"row_num"=>$this->num,
			"page_num"=>$this->getpagenum(),
			"current_page"=>$this->page,
			"row_offset"=>$this->offset,
			"next_page"=>$this->getnextpage(),
			"prev_page"=>$this->getprevpage(),
			"page_start"=>$this->getstartnum(),
            "page_end" =>$this->getendnum()
		);
		
		return $pageinfo;
		}
	}


?>
