<?php

class install{
    private $process;
    private $installfrom;
    private $messlist;
    private $includefile;


    public function __construct(){
        $this->includefile=dirname(dirname(__FILE__))."/App/config.php";
        $this->process=new process($this->includefile, "zh_book.sql");
        $this->installfrom=new installfrom();
        $this->messlist='';
    }

    public function exestep($step){
        switch($step){
            case 1:
                echo $this->installfrom->getagreement();
                break;
            case 2:
                $inputs=array(
                    "DB_HOST"=>DB_HOST,
                    "DB_USER"=>DB_USER,
                    "DB_PWD"=>DB_PWD,
                    "DB_NAME"=>DB_NAME,
                    "TAB_FIX"=>TAB_FIX,
                );
                echo $this->installfrom->getdbfrom($this->messlist, $inputs);
                break;
             case 3:
                 if(!$this->validatedbfrom($_POST)){
                     echo $this->installfrom->getdbfrom($this->messlist, $_POST, "error");
                 }else{
                     if($this->process->configsys($_POST)){
                         $this->messlist='请在下面的表单中正确填写管理员账号信息';
                         $inputs=array(
                             "ADMIN_NAME"=>"admin",
                             "ADMIN_PWD"=>"",
                             "ADMIN_REPWD"=>""
                         );
                         echo $this->installfrom->getadminfrom($this->messlist, $inputs);
                     }else{
                         echo "写入配置文件失败";
                     }
                 }
                 break;
             case 4:
                 if(!$this->validateadminfrom($_POST)){
                     echo $this->installfrom->getadminfrom($this->messlist, $_POST, "error");
                 }else{
                     if($this->process->createdb($_POST)){
                         $installstats=true;
                     }else{
                         $installstats=false;
                     }
                     echo $this->installfrom->getinstallmesslist($this->process->getinstallinfo(), $installstats);
                 }
                 break;
              case 5:
                  if(file_put_contents("install_lock.txt", "恭喜您，安装中环留言版成功...")){
                      echo '<script>window.location="../index.php"</script>';
                  
                  }
                  break;
            }
    }

    public function validatedbfrom($post){
        $rs=true;
        if(trim($post['DB_HOST']=='')){
            $this->messlist.='数据库主机名不能为空!</br>';
            $rs=false;
        }
        if(trim($post['DB_USER']=='')){
            $this->messlist.='数据库用户名不能为空!</br>';
            $rs=false;
        }
        if(trim($post['DB_NAME']=='')){
            $this->messlist.='数据库名不能为空!</br>';
            $rs=false;
        }
        if(trim($post['TAB_FIX']=='')){
            $this->messlist.='表名前缀不能为空!</br>';
            $rs=false;
        }
        if(!$rs){
            return false;
        }

        if(!mysqli_connect($post['DB_HOST'], $post['DB_USER'], $post['DB_PWD'])){
            $this->messlist.="数据库<b>".$post['DB_NAME']."</b>不存在，请先创建数据库</br>";
            $rs=false;
        }
        return $rs;
    }

    public function validateadminfrom($post){
        $rs=true;
        if(trim($post['ADMIN_NAME']=='')){
            $this->messlist.='管理员账号不能为空!</br>';
            $rs=false;
        }
        if(trim($post['ADMIN_PWD']=='')){
            $this->messlist.='管理员密码不能为空!</br>';
            $rs=false;
        }
        if(trim($post['ADMIN_REPWD']=='')){
            $this->messlist.='重复输入密码不能为空!</br>';
            $rs=false;
        }
        if(trim($post['ADMIN_PWD']) !=trim($post['ADMIN_REPWD'])){
            $this->messlist.='输入的两次密码不一致!</br>';
            $rs=false;
        }
        if(trim(($post['ADMIN_EMAIL'])=='')){
            $this->messlist.='管理员邮箱不能为空!</br>';
            $rs=false;
        }else if(!preg_match("/\w+([-+.']\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*/", $post['ADMIN_EMAIL'])){
            $this->messlist.='管理员邮箱不是正确的邮箱格式!</br>';
            $rs=false;
        }

        return $rs;
    }



}


?>
