using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace ESFramework.Demos.DynamicGroup.Client
{
    public partial class JoinGroupForm : Form
    {
        private string currentGroupID;
        public string CurrentGroupID
        {
            get { return currentGroupID; }           
        }
        private string userID;
        private GroupTools groupTools;
        public JoinGroupForm(GroupTools _groupTools, string _userID)
        {
            InitializeComponent();            
            this.groupTools = _groupTools;
            this.userID = _userID;
        }

        private void button_join_Click(object sender, EventArgs e)
        {
            string groupID = this.textBox1.Text.Trim();
            if (groupID == "")
            {
                MessageBox.Show("");
                return;
            }
            bool success = this.groupTools.JoinGroup(groupID);
            if (success)
            {
                this.currentGroupID = groupID;
                MessageBox.Show("ɹ");
                this.DialogResult = DialogResult.OK;
            }
            else
            {
                MessageBox.Show("ʧ");               
            }
        }

        private void button_create_Click(object sender, EventArgs e)
        {
            if (this.textBox1.Text.Trim() == "")
            {
                MessageBox.Show("ţ");
                return;
            }
            this.currentGroupID = this.textBox1.Text.Trim();
            this.groupTools.CreateGroup(this.currentGroupID);
            this.groupTools.JoinGroup(this.currentGroupID);
            this.DialogResult = DialogResult.OK;
        }
    }
}