﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ESBasic.ObjectManagement;
using ESBasic.Emit.DynamicBridge;
using ESPlus.Application.Basic.Passive;
using ESBasic.ObjectManagement.Forms;
using ESBasic;
using ESFramework.Engine.Tcp.Passive;
using ESPlus.Rapid;
using ESPlus.Application.CustomizeInfo.Passive;
using ESFramework.Engine.ContractStyle.Stream;
using ESPlus.Application.FileTransfering.Passive;
using ESPlus.Application.Basic;
using ESPlus.Application.Group.Passive;
using ESPlus.Application.Group;
using ESPlus.Application.CustomizeInfo;
using ESFramework.Demos.DynamicGroup.Core;

namespace ESFramework.Demos.DynamicGroup.Client
{
    public partial class MainForm : Form, ICustomizeHandler
    {
        private IBasicOutter basicOutter;        
        private IGroupOutter groupOutter;
        private RapidPassiveEngine rapidPassiveEngine;        
        private string groupID = null;
        private object lockObject = new object();
        private GroupTools groupTools = null;
        
        #region UserID
        private string userID;
        public string UserID
        {
            get { return userID; }
            set { userID = value; }
        } 
        #endregion

        #region Ctor
        public MainForm()
        {
            InitializeComponent();
        } 
        #endregion

        #region Initialize
        public void Initialize(string currentUserID,string _groupID, RapidPassiveEngine engine)
        {
            this.userID = currentUserID;
            this.groupID = _groupID;
            this.rapidPassiveEngine = engine;
            this.basicOutter = engine.BasicOutter;          
            this.groupOutter = engine.GroupOutter;
            this.groupTools = new GroupTools(engine);

            this.textChatControl1.Initialize(this.userID,this.groupID, this.groupOutter);

            this.rapidPassiveEngine.ConnectionInterrupted += new CbGeneric(rapidPassiveEngine_ConnectionInterrupted);           
            this.rapidPassiveEngine.ConnectionRebuildStart += new CbGeneric(rapidPassiveEngine_ConnectionRebuildStart);
            this.rapidPassiveEngine.RelogonCompleted +=new CbGeneric<LogonResponse>(rapidPassiveEngine_RelogonCompleted);
            this.rapidPassiveEngine.BasicOutter.BeingPushedOut += new CbGeneric(OnBeingPushedOut);
            this.rapidPassiveEngine.GroupOutter.GroupmateConnected += new CbGeneric<string>(OnGroupmateConnected);
            this.rapidPassiveEngine.GroupOutter.GroupmateOffline += new CbGeneric<string>(OnGroupmateOffline);
            this.rapidPassiveEngine.GroupOutter.BroadcastReceived += new CbGeneric<string, string, int, byte[]>(GroupOutter_BroadcastReceived);            

            this.toolStripLabel_loginfo.Text = string.Format("当前用户：{0}，当前组号：{1}", currentUserID,this.groupID);
            this.toolStripLabel_state.Text = "连接状态：正常";
            this.InitializeGroupmates();
        }            
        #endregion

        #region InitializeGroupmates
        private void InitializeGroupmates()
        {
           Groupmates groupmates = this.rapidPassiveEngine.GroupOutter.GetGroupMembers(this.groupID);      
            foreach (string groupmateID in groupmates.OnlineGroupmates)
            {
                if (groupmateID != this.userID && !this.ContainsGroupmate(groupmateID))
                {
                    this.AddGroupmate(groupmateID);                    
                }
            }
        } 
        #endregion

        #region AddGroupmate
        private void AddGroupmate(string userID)
        {
            lock (this.lockObject)
            {
                if (this.ContainsGroupmate(userID))
                {
                    return;
                }
                this.listView1.Items.Add(userID, 0);
            }
        } 
        #endregion

        #region ContainsGroupmate
        private bool ContainsGroupmate(string userID)
        {
            foreach (ListViewItem item in this.listView1.Items)
            {
                if (item.Text == userID)
                {
                    return true;
                }
            }
            return false;
        } 
        #endregion

        #region 断线 重连 重新登录完成事件
        void rapidPassiveEngine_RelogonCompleted(LogonResponse relogonResult)
        {
            //如果在 重新登录的时候，数据库的密码 修改了，则这里relogonResult会返回登录失败 
            if (this.InvokeRequired)
            {
                this.Invoke(new CbGeneric<LogonResponse>(this.rapidPassiveEngine_RelogonCompleted), relogonResult);
            }
            else
            {
                if (relogonResult.LogonResult != LogonResult.Succeed)
                {
                    return;
                }
                this.toolStripLabel_state.Text = "连接状态：正常（重连成功）";
                this.toolStripLabel_state.ForeColor = Color.Black;
                bool success = this.groupTools.JoinGroup(this.groupID);
                if (success)
                {
                    this.InitializeGroupmates();
                }
                else
                {
                    MessageBox.Show(string.Format("组{0}已经不存在", this.groupID));
                }
            }
        }
        #endregion

        #region 重连开始事件
        void rapidPassiveEngine_ConnectionRebuildStart()
        {
            if (this.InvokeRequired)
            {
                this.Invoke(new CbSimple(this.rapidPassiveEngine_ConnectionRebuildStart), null);
            }
            else
            {
                this.toolStripLabel_state.Text = "连接状态：断开，重连中......";
                this.toolStripLabel_state.ForeColor = Color.Red;
            }
        }
        #endregion

        #region 断线事件
        void rapidPassiveEngine_ConnectionInterrupted()
        {
            if (this.InvokeRequired)
            {
                this.Invoke(new CbSimple(this.rapidPassiveEngine_ConnectionInterrupted), null);
            }
            else
            {
                this.OnDisconnected();
                this.toolStripLabel_state.Text = "连接状态：断开";
                this.toolStripLabel_state.ForeColor = Color.Red;
            }
        }

        private void OnDisconnected()
        {
            this.listView1.Clear();
        } 
        #endregion       

        #region IGroupOutter的事件    
        #region OnGroupmateConnected
        public void OnGroupmateConnected(string memberID)
        {
            if (this.InvokeRequired)
            {
                this.Invoke(new CbGeneric<string>(this.OnGroupmateConnected), memberID);
            }
            else
            {
                if (!this.ContainsGroupmate(memberID))
                {
                    this.AddGroupmate(memberID);
                }
            }
        }
         #endregion

        #region OnGroupmateOffline
        public void OnGroupmateOffline(string memberID)
        {
            if (this.InvokeRequired)
            {
                this.Invoke(new CbGeneric<string>(this.OnGroupmateOffline), memberID);
            }
            else
            {
                ListViewItem target = null;
                foreach (ListViewItem item in this.listView1.Items)
                {
                    if (item.Text == memberID)
                    {
                        target = item;
                        break;
                    }
                }

                if (target != null)
                {
                    this.listView1.Items.Remove(target);
                }
            }
        }
        #endregion 

        #region BroadcastReceived
        void GroupOutter_BroadcastReceived(string broadcastID, string groupID, int broadcastType, byte[] broadcastContent)
        {
            if (groupID != this.groupID)
            {
                return;
            }

            if (broadcastType == GroupInformationTypes.GroupChat)
            {
                TextChatContract contract = (TextChatContract)ESBasic.Helpers.SerializeHelper.DeserializeBytes(broadcastContent, 0, broadcastContent.Length);
                this.textChatControl1.ShowOtherTextChat(broadcastID, contract);
            }
        }   
        #endregion
        #endregion

        #region IBasicOutter的事件 
        #region OnBeingPushedOut
        public void OnBeingPushedOut()
        {
            if (this.InvokeRequired)
            {
                this.Invoke(new CbGeneric(this.OnBeingPushedOut), null);
            }
            else
            {
                this.OnDisconnected();
                this.toolStripLabel_state.Text = "连接状态：断开。在别处登录！";
                this.toolStripLabel_state.ForeColor = Color.Red;

            }
        } 
        #endregion              
        #endregion

        #region ICustomizeHandler 成员
        public void HandleInformation(string sourceUserID, int informationType, byte[] info)
        {
            try
            {
                if (informationType == GroupInformationTypes.SomeoneJoinGroup)
                {
                    this.OnGroupmateConnected(System.Text.UTF8Encoding.UTF8.GetString(info));
                    return;
                }
                if (informationType == GroupInformationTypes.SomeoneQuitGroup)
                {
                    this.OnGroupmateOffline(System.Text.UTF8Encoding.UTF8.GetString(info));
                    return;
                }
            }
            catch (Exception ee)
            {
                MessageBox.Show(ee.Message);
            }
        }

        public byte[] HandleQuery(string sourceUserID, int informationType, byte[] info)
        {
            return null;
        }

        #endregion       
    }
}
