﻿using System;
using System.Collections.Generic;
using System.Text;
using ESPlus.Application.CustomizeInfo.Server;
using System.Windows.Forms;
using ESPlus.Application.CustomizeInfo;
using ESFramework.Demos.DynamicGroup.Core;

namespace ESFramework.Demos.DynamicGroup.Server
{
    public class CustomizeHandler : ICustomizeHandler
    {
        private ICustomizeController customizeController;
        private DynamicGroupManager groupManager;
        public void Initialize(DynamicGroupManager _groupManager ,ICustomizeController controller)
        {
            this.groupManager = _groupManager;
            this.customizeController = controller;
        }

        public void HandleInformation(string sourceUserID, int informationType, byte[] info)
        {
            try
            {
                if (informationType == GroupInformationTypes.CreateGroup)
                {
                    GroupContract contract = ESPlus.Serialization.CompactPropertySerializer.Default.Deserialize<GroupContract>(info,0);
                    this.groupManager.CreateGroup(contract.GroupID, sourceUserID);
                    return;
                }
                if (informationType == GroupInformationTypes.DestroyGroup)
                {
                    GroupContract contract = ESPlus.Serialization.CompactPropertySerializer.Default.Deserialize<GroupContract>(info, 0);
                    this.groupManager.DestroyGroup(sourceUserID, contract.GroupID);
                    return;
                }
                if (informationType == GroupInformationTypes.QuitGroup)
                {
                    GroupContract contract = ESPlus.Serialization.CompactPropertySerializer.Default.Deserialize<GroupContract>(info, 0);                   
                    this.groupManager.QuitGroup(contract.GroupID, sourceUserID);
                    List<string> members = this.groupManager.GetGroupMembers(contract.GroupID);
                    foreach (string memberID in members)
                    {
                        this.customizeController.Send(memberID, GroupInformationTypes.SomeoneQuitGroup, System.Text.UTF8Encoding.UTF8.GetBytes(sourceUserID), true, ESFramework.ActionTypeOnChannelIsBusy.Continue);
                    } 
                    return;
                }

            }
            catch (Exception ee)
            {
                MessageBox.Show(ee.Message);
            }
        }

        public byte[] HandleQuery(string sourceUserID, int informationType, byte[] info)
        {
            try
            {
                if (informationType == GroupInformationTypes.JoinGroup)
                {
                    GroupContract contract = ESPlus.Serialization.CompactPropertySerializer.Default.Deserialize<GroupContract>(info, 0);
                    bool result = this.groupManager.JoinGroup(contract.GroupID, sourceUserID);
                    if (result)
                    {
                        List<string> members = this.groupManager.GetGroupMembers(contract.GroupID);
                        foreach (string memberID in members)
                        {
                            if (memberID != sourceUserID)
                            {
                                this.customizeController.Send(memberID, GroupInformationTypes.SomeoneJoinGroup, System.Text.UTF8Encoding.UTF8.GetBytes(sourceUserID), true, ESFramework.ActionTypeOnChannelIsBusy.Continue);
                            }
                        }
                    }
                    return BitConverter.GetBytes(result);
                }
            }
            catch (Exception ee)
            {
                MessageBox.Show(ee.Message);
            }
            return null;
        }
    }
}
