using System;
using System.Collections.Generic;
using System.Text;
using ESPlus.Application.Group.Server;
using ESBasic.ObjectManagement.Managers;
using ESBasic;
using ESBasic.Collections;
using ESPlus.Rapid;
using ESFramework.Server.UserManagement;
using ESFramework.Server;
using ESFramework.Demos.DynamicGroup.Core;

namespace ESFramework.Demos.DynamicGroup.Server
{
    public class DynamicGroupManager : IGroupManager
    {
        private ObjectManager<string, Group> manager = new ObjectManager<string, Group>();       

        public void Initialize(IUserManager userManager)
        {
            userManager.SomeOneDisconnected += new CbGeneric<UserData, DisconnectedType>(UserManager_SomeOneDisconnected);
        }

        void UserManager_SomeOneDisconnected(UserData user, DisconnectedType disconnectedType)
        {
            this.QuitGroup(user.UserID);
        }
       
        public void CreateGroup(string groupID, string userID)
        {
            Group group = this.manager.Get(groupID);
            if (group == null)
            {
                group = new Group(groupID);
                this.manager.Add(groupID, group);
            }            
        }

        public bool JoinGroup(string groupID, string userID)
        {
            Group group = this.manager.Get(groupID);
            if (group == null)
            {
                return false;
            }            
            group.Add(userID);
            return true;
        }        

        public void DestroyGroup(string destroierID, string groupID)
        {
            this.manager.Remove(groupID);            
        }

        public void QuitGroup(string groupID, string userID)
        {
            Group group = this.manager.Get(groupID);
            if (group == null)
            {
                return;
            }
            group.Remove(userID);                    
        }

        public void QuitGroup(string userID)
        {
            foreach (Group group in this.manager.GetAll())
            {
                group.Remove(userID);
            }
        }

        public List<string> GetGroupmates(string userID)
        {
            SortedArray<string> array = new SortedArray<string>();
            foreach (Group group in this.manager.GetAll())
            {
                if (group.Contains(userID))
                {
                    array.Add(group.GetMembers());
                }
            }
            return array.GetAll();
        }
       
        public List<string> GetGroupMembers(string groupID)
        {
            Group group = this.manager.Get(groupID);
            if (group == null)
            {
                return null;
            }

            return group.GetMembers();
        }

        public string GetGroupID(string userID)
        {
            List<Group> allGroups = this.manager.GetAll();
            foreach (Group group in allGroups)
            {
                if (group.GetMembers().Contains(userID))
                {
                    return group.GroupID;
                }
            }
            return null;
        }
    }
}
