﻿using System;
using System.Collections.Generic;
using System.Windows.Forms;
using ESPlus.Widgets;
using ESPlus.Rapid;
using ESPlus.Application.CustomizeInfo.Server;
using ESFramework;
using ESFramework.Server.UserManagement;
using ESPlus.Application.Basic.Server;
using ESPlus.Application.Friends.Server;

/*
 * 本demo采用的是ESFramework的免费版本，不需要再次授权、也没有使用期限限制。若想获取ESFramework其它版本，请联系 www.oraycn.com 或 QQ：372841921。
 * 
 */
namespace ESFramework.Demos.DynamicGroup.Server
{
    static class Program
    {
        

        [STAThread]
        static void Main()
        {
            try
            {
                Application.EnableVisualStyles();
                Application.SetCompatibleTextRenderingDefault(false);

                //如果是其它类型的授权用户，请使用下面的语句设定正确的授权用户ID和密码。              
                ESPlus.GlobalUtil.SetAuthorizedUser(AuthorizationVerifier.FreeUser, "");

                RapidServerEngine rapidServerEngine = new RapidServerEngine();
                //关闭P2P服务器
                rapidServerEngine.UseAsP2PServer = false;

                DynamicGroupManager groupManager = new DynamicGroupManager();
                CustomizeHandler customizeHandler = new CustomizeHandler();
                
                rapidServerEngine.GroupManager = groupManager;
                rapidServerEngine.Initialize(4530, customizeHandler);
                //开启组友上下线通知                
                rapidServerEngine.GroupController.GroupNotifyEnabled = true;                

                //如果不需要UI显示，可以不用调用下面的两句
                ESPlus.Widgets.MainServerForm mainForm = new ESPlus.Widgets.MainServerForm(rapidServerEngine);
                mainForm.Text = "ESFramework 4.0 Dynamic Group Demo Server";
                //设置重登陆模式
                rapidServerEngine.UserManager.RelogonMode = RelogonMode.ReplaceOld;
                
                groupManager.Initialize(rapidServerEngine.UserManager);
                customizeHandler.Initialize(groupManager, rapidServerEngine.CustomizeController);
                Application.Run(mainForm);
            }
            catch (Exception ee)
            {
                MessageBox.Show(ee.Message);
            }
        }

        



    }

    

    

    

}
