﻿using System;
using System.Collections.Generic;
using System.Text;
using ESPlus.Application.CustomizeInfo.Server;
using ESPlus.Application.Basic.Server;
using ESPlus.Application.CustomizeInfo;
using ESFramework.Demos.Core;

namespace ESFramework.Demos.Server
{
    /// <summary>
    /// 自定义信息处理器
    /// </summary>
    public class CustomizeHandler : ICustomizeHandler 
    {
        /// <summary>
        /// 处理来自客户端的消息。
        /// </summary> 
        public void HandleInformation(string sourceUserID, int informationType, byte[] info)
        {
        }

        /// <summary>
        /// 处理来自客户端的同步调用请求。
        /// </summary>       
        public byte[] HandleQuery(string sourceUserID, int informationType, byte[] info)
        {
            if (informationType == InformationTypes.ClientCallServer)
            {
                string requestMessage = System.Text.Encoding.UTF8.GetString(info);
                string responseMessage = requestMessage + " 已经被服务端处理了！";
                return System.Text.Encoding.UTF8.GetBytes(responseMessage);
            }
            return null;
        }   
    }
}
