﻿using System;
using System.Collections.Generic;
using System.Windows.Forms;
using ESPlus.Widgets;
using ESPlus.Rapid;
using ESPlus.Application.CustomizeInfo.Server;
using ESFramework;
using ESFramework.Server.UserManagement;
using ESPlus.Application.Friends.Server;

/*
 * 本demo采用的是ESFramework的免费版本，不需要再次授权、也没有使用期限限制。若想获取ESFramework其它版本，请联系 www.oraycn.com 或 QQ：372841921。
 * 
 */
namespace ESFramework.Demos.Server
{
    static class Program
    {
        private static ESPlus.Rapid.RapidServerEngine RapidServerEngine = new ESPlus.Rapid.RapidServerEngine();

        [STAThread]
        static void Main()
        {
            try
            {
                Application.EnableVisualStyles();
                Application.SetCompatibleTextRenderingDefault(false);

                //如果是其它类型的授权用户，请使用下面的语句设定正确的授权用户ID和密码。              
                ESPlus.GlobalUtil.SetAuthorizedUser(AuthorizationVerifier.FreeUser, "");

                //使用简单的好友管理器，假设所有在线用户都是好友。（仅仅用于demo）
                DefaultFriendsManager friendsManager = new DefaultFriendsManager();
                RapidServerEngine.FriendsManager = friendsManager;
                //初始化服务端引擎
                RapidServerEngine.Initialize(4530, new CustomizeHandler(), new BasicHandler());
                friendsManager.UserManager = RapidServerEngine.UserManager; //RapidServerEngine初始化成功后，其UserManager属性才可用。

                //设置重登陆模式
                RapidServerEngine.UserManager.RelogonMode = RelogonMode.ReplaceOld;

                //如果不需要默认的UI显示，可以替换下面这句为自己的Form
                ESPlus.Widgets.MainServerForm mainForm = new ESPlus.Widgets.MainServerForm(RapidServerEngine);
                Application.Run(mainForm);
            }
            catch (Exception ee)
            {
                MessageBox.Show(ee.Message);
            }
        }        
    }
}
