<?php
/**
 * Smarty plugin
 *
 * @package Smarty
 * @subpackage PluginsModifier
 */

/**
 * Smarty truncate modifier plugin
 *
 * Type:     modifier<br>
 * Name:     truncate<br>
 * Purpose:  Truncate a string to a certain length if necessary,
 *               optionally splitting in the middle of a word, and
 *               appending the $etc string or inserting $etc into the middle.
 *
 * @link http://smarty.php.net/manual/en/language.modifier.truncate.php truncate (Smarty online manual)
 * @author Monte Ohrt <monte at ohrt dot com>
 * @param string  $string      input string
 * @param integer $length      length of truncated text
 * @param string  $etc         end string
 * @param boolean $break_words truncate at word boundary
 * @param boolean $middle      truncate in the middle of text
 * @return string truncated string
 */
//function smarty_modifier_truncate($string, $length,  $break_words = false, $middle = false) {
//    if ($length == 0)
//        return '';
//
//    if (SMARTY_MBSTRING /* ^phpunit */&&empty($_SERVER['SMARTY_PHPUNIT_DISABLE_MBSTRING'])/* phpunit$ */) {
//        if (mb_strlen($string, SMARTY_RESOURCE_CHAR_SET) > $length) {
//            $length -= min($length, mb_strlen(SMARTY_RESOURCE_CHAR_SET));
//            if (!$break_words && !$middle) {
//                $string = preg_replace('/\s+?(\S+)?$/u', '', mb_substr($string, 0, $length + 1, SMARTY_RESOURCE_CHAR_SET));
//            }
//            if (!$middle) {
//                return mb_substr($string, 0, $length, SMARTY_RESOURCE_CHAR_SET);
//            }
//            return mb_substr($string, 0, $length, SMARTY_RESOURCE_CHAR_SET). mb_substr($string, - $length, $length, SMARTY_RESOURCE_CHAR_SET);
//        }
//        return $string;
//    }
//
//    // no MBString fallback
//    if (isset($string[$length])) {
//        $length -= min($length);
//        if (!$break_words && !$middle) {
//            $string = preg_replace('/\s+?(\S+)?$/', '', substr($string, 0, $length + 1));
//        }
//        if (!$middle) {
//            return substr($string, 0, $length);
//        }
//        return substr($string, 0, $length) . substr($string, - $length);
//    }
//    return $string;
//}


function smarty_modifier_truncate($string, $strlen = 20, $etc = '...',$keep_first_style = false)
{
$strlen = $strlen*2;
$string = trim($string);
if ( strlen($string) <= $strlen ) {
return $string;
}
$str = strip_tags($string);
$j = 0;
for($i=0;$i<$strlen;$i++) {
   if(ord(substr($str,$i,1))>0xa0) $j++;
}
if($j%2!=0) $strlen++;
$rstr=substr($str,0,$strlen);
if (strlen($str)>$strlen   ) {$rstr .= $etc;}

if ( $keep_first_style == true && ereg('^<(.*)>$',$string) ) {
if ( strlen($str) <= $strlen ) {
return $string;
}
$start_pos = strpos($string,substr($str,0,4));
$end_pos = strpos($string,substr($str,-4));
$end_pos = $end_pos+4;
$rstr = substr($string,0,$start_pos) . $rstr . substr($string,$end_pos,strlen($string));
}

return $rstr;

}


?>