var i_im_isIE = (document.all) ? true : false;

Array.prototype.in_array = function(e) 
{ 
    for(i=0;i<this.length;i++)
    {
        if(this[i] == e)
        return true;
    }
    return false;
}

var i_im_$ = function (id) {
	return "string" == typeof id ? document.getElementById(id) : id;
};

var i_im_Class = {
	create: function() {
		return function() { this.initialize.apply(this, arguments); }
	}
}

var i_im_Extend = function(destination, source) {
	for (var property in source) {
		destination[property] = source[property];
	}
}

var i_im_Bind = function(object, fun) {
	return function() {
		return fun.apply(object, arguments);
	}
}

var i_im_BindAsEventListener = function(object, fun) {
	return function(event) {
		return fun.call(object, (event || window.event));
	}
}

var i_im_CurrentStyle = function(element){
	return element.currentStyle || document.defaultView.getComputedStyle(element, null);
}

function i_im_addEventHandler(oTarget, sEventType, fnHandler) {
	if (oTarget.addEventListener) {
		oTarget.addEventListener(sEventType, fnHandler, false);
	} else if (oTarget.attachEvent) {
		oTarget.attachEvent("on" + sEventType, fnHandler);
	} else {
		oTarget["on" + sEventType] = fnHandler;
	}
}

function i_im_removeEventHandler(oTarget, sEventType, fnHandler) {
    if (oTarget.removeEventListener) {
        oTarget.removeEventListener(sEventType, fnHandler, false);
    } else if (oTarget.detachEvent) {
        oTarget.detachEvent("on" + sEventType, fnHandler);
    } else {
        oTarget["on" + sEventType] = null;
    }
}

//拖放程序
var i_im_Drag = i_im_Class.create();
i_im_Drag.prototype = {
  //拖放对象
  initialize: function(drag, options) {
	this.Drag = i_im_$(drag);//拖放对象
	this._x = this._y = 0;//记录鼠标相对拖放对象的位置
	this._marginLeft = this._marginTop = 0;//记录margin
	//事件对象(用于绑定移除事件)
	this._fM = i_im_BindAsEventListener(this, this.Move);
	this._fS = i_im_Bind(this, this.Stop);

	this.SetOptions(options);

	this.Limit = !!this.options.Limit;
	this.mxLeft = parseInt(this.options.mxLeft);
	this.mxRight = parseInt(this.options.mxRight);
	this.mxTop = parseInt(this.options.mxTop);
	this.mxBottom = parseInt(this.options.mxBottom);

	this.LockX = !!this.options.LockX;
	this.LockY = !!this.options.LockY;
	this.Lock = !!this.options.Lock;

	this.onStart = this.options.onStart;
	this.onMove = this.options.onMove;
	this.onStop = this.options.onStop;

	this._Handle = i_im_$(this.options.Handle) || this.Drag;
	this._mxContainer = i_im_$(this.options.mxContainer) || null;

	this.Drag.style.position = "absolute";
	//透明
	if(i_im_isIE && !!this.options.Transparent){
		//填充拖放对象
		with(this._Handle.appendChild(document.createElement("div")).style) {
			width = height = "100%"; backgroundColor = "#fff"; filter = "alpha(opacity:0)"; fontSize = 0;
		}
	}
	//修正范围
	this.Repair();
	i_im_addEventHandler(this._Handle, "mousedown", i_im_BindAsEventListener(this, this.Start));
  },
  //设置默认属性
  SetOptions: function(options) {
	this.options = {//默认值
		Handle:			"",//设置触发对象（不设置则使用拖放对象）
		Limit:			false,//是否设置范围限制(为true时下面参数有用,可以是负数)
		mxLeft:			0,//左边限制
		mxRight:		9999,//右边限制
		mxTop:			0,//上边限制
		mxBottom:		9999,//下边限制
		mxContainer:	"",//指定限制在容器内
		LockX:			false,//是否锁定水平方向拖放
		LockY:			false,//是否锁定垂直方向拖放
		Lock:			false,//是否锁定
		Transparent:	false,//是否透明
		onStart:		function(){},//开始移动时执行
		onMove:			function(){},//移动时执行
		onStop:			function(){}//结束移动时执行
	};
	i_im_Extend(this.options, options || {});
  },
  //准备拖动
  Start: function(oEvent) {
	if(this.Lock){ return; }
	this.Repair();
	//记录鼠标相对拖放对象的位置
	this._x = oEvent.clientX - this.Drag.offsetLeft;
	this._y = oEvent.clientY - this.Drag.offsetTop;
	//记录margin
	this._marginLeft = parseInt(i_im_CurrentStyle(this.Drag).marginLeft) || 0;
	this._marginTop = parseInt(i_im_CurrentStyle(this.Drag).marginTop) || 0;
	//mousemove时移动 mouseup时停止
	i_im_addEventHandler(document, "mousemove", this._fM);
	i_im_addEventHandler(document, "mouseup", this._fS);
	if(i_im_isIE){
		//焦点丢失
		i_im_addEventHandler(this._Handle, "losecapture", this._fS);
		//设置鼠标捕获
		this._Handle.setCapture();
	}else{
		//焦点丢失
		i_im_addEventHandler(window, "blur", this._fS);
		//阻止默认动作
		oEvent.preventDefault();
	};
	//附加程序
	this.onStart();
  },
  //修正范围
  Repair: function() {

	if(this.Limit){
		//修正错误范围参数
		this.mxRight = Math.max(this.mxRight, this.mxLeft + this.Drag.offsetWidth);
		this.mxBottom = Math.max(this.mxBottom, this.mxTop + this.Drag.offsetHeight);
		//如果有容器必须设置position为relative或absolute来相对或绝对定位，并在获取offset之前设置
		!this._mxContainer || i_im_CurrentStyle(this._mxContainer).position == "relative" || i_im_CurrentStyle(this._mxContainer).position == "absolute" || (this._mxContainer.style.position = "relative");
	}
  },
  //拖动
  Move: function(oEvent) {
	//判断是否锁定
	if(this.Lock){ this.Stop(); return; };
	//清除选择
	window.getSelection ? window.getSelection().removeAllRanges() : document.selection.empty();
	//设置移动参数
	var iLeft = oEvent.clientX - this._x, iTop = oEvent.clientY - this._y;
	//设置范围限制
	if(this.Limit){
		//设置范围参数
		var mxLeft = this.mxLeft, mxRight = this.mxRight, mxTop = this.mxTop, mxBottom = this.mxBottom;
		//如果设置了容器，再修正范围参数
		if(!!this._mxContainer){
			mxLeft = Math.max(mxLeft, 0);
			mxTop = Math.max(mxTop, 0);
			mxRight = Math.min(mxRight, this._mxContainer.clientWidth);
			mxBottom = Math.min(mxBottom, this._mxContainer.clientHeight);
		};
		//修正移动参数
		iLeft = Math.max(Math.min(iLeft, mxRight - this.Drag.offsetWidth), mxLeft);
		iTop = Math.max(Math.min(iTop, mxBottom - this.Drag.offsetHeight), mxTop);
	}
	//设置位置，并修正margin
	if(!this.LockX){ this.Drag.style.left = iLeft - this._marginLeft + "px"; }
	if(!this.LockY){ this.Drag.style.top = iTop - this._marginTop + "px"; }
	//附加程序
	this.onMove();
  },
  //停止拖动
  Stop: function() {
	//移除事件
	i_im_removeEventHandler(document, "mousemove", this._fM);
	i_im_removeEventHandler(document, "mouseup", this._fS);
	if(i_im_isIE){
		i_im_removeEventHandler(this._Handle, "losecapture", this._fS);
		this._Handle.releaseCapture();
	}else{
		i_im_removeEventHandler(window, "blur", this._fS);
	};
	//附加程序
	this.onStop();
  }
};
//显示、隐藏样式
function i_im_show(obj){
	i_im_$(obj).style.display = (i_im_$(obj).style.display == 'none')?'block':'none'
}

function i_im_setHidden(obj){
	if(i_im_$(obj+'_c').value=='') {
		i_im_$(obj).style.display='none';
	}
}
function i_im_setShow(obj){
	i_im_$(obj).style.display = (i_im_$(obj).style.display == 'none')?'block':'none'
	i_im_readyBlur(obj);
}
function i_im_readyBlur(obj){
	i_im_$(obj+'_c').focus();
}

var i_im_timeout;
function setOnShowPara(obj){
	i_im_$(obj+'_c').value='1';
	clearTimeout(i_im_timeout);
}
function i_im_setHiddenPara(obj){
	i_im_$(obj+'_c').value='';
}

function timerSetHidden(obj,t_time){
	i_im_setHiddenPara(obj);
	i_im_timeout = setTimeout("i_im_setHidden('"+obj+"')",t_time);
}

function LengthValidator (obj,id){
	if(obj.value.length > 149) {
		obj.value=obj.value.substr(0,149);
	}
	i_im_$("txt_num"+id).value = 149-obj.value.length;
}
//追加、移除样式
function i_im_addClass (obj,newClass){
	var re = new RegExp(newClass,"gi");
	var r = obj.className.search(re);
	if(r==-1) {
		obj.className = obj.className + ' ' +newClass;
		return true;
	} else {
		return false;
	}
}
function i_im_removeClass(obj,newclass){
	var re = new RegExp(newclass,"gi");
	obj.className = obj.className.replace(re, "");
}

//改变样式
function i_im_changeClass (obj,name){
	if(obj.parentNode.className == name)
	{
		obj.parentNode.className = name + ' ' + name+'-on';
	}else{
		obj.parentNode.className = name;
	}
}
//弹出窗口
function i_im_popWrap (obj,name) {
	var t=obj.offsetTop;
    var l=obj.offsetLeft;
    var height=obj.offsetHeight;
    var width=obj.offsetWidth;
    while(obj=obj.offsetParent) {
        t+=obj.offsetTop;
        l+=obj.offsetLeft;
    }
	i_im_$(name).style.top = (t-30) + 'px';
	i_im_$(name).style.left = (l-198) + 'px';
}
//聊天窗口
var i_im_zindex = 100;
function i_im_talkWin (id,name) {
	i_im_clearNewMsg(id);
	// 是否已存在
	var parentnode = i_im_$('im_container');
	var divs = parentnode.childNodes;
	for(i=0;i<parentnode.childNodes.length;i++){
		if(parentnode.childNodes[i].id==name+'_'+id){
			i_im_$(name+'_'+id).style.display = '';
			return false;
		}
		parentnode.childNodes[i].className = 'inactive';	//
	}

	// 获取即将打开的好友的详情
	if(name == 'imWin'){
		var pals_obj = frendlistarrayobj[id];
	} else {
		var pals_obj = grouplistarrayobj[id];
		// 获取讨论组好友信息
		getGroupFrendList(id);
	}

	// 初始化窗口数据
	var verify_code = '';
	i_im_ajax(i_im_baseUrl+"ajax.php?act=initwin","POST","id="+id,function(data){
		verify_code = data;
	});

	// 创建窗口
	var imwin=document.createElement("div");
	imwin.id = name+'_'+id;
	imwin.style.top = 50+Math.random()*150+'px';
	imwin.style.left = 150+Math.random()*250+'px';
	if(!pals_obj.pals_intro) {
		pals_obj.pals_intro = '';
	}
	var str_1 = "<div class='window imWin'><div id='head_pnl"+imwin.id+"' class='head_pnl'><div class='linkBox'><img src='"+pals_obj.pals_ico+"' /><p><a class='nick' href='#'>"+pals_obj.pals_name+"：</a><br/><span class='msg'>"+pals_obj.pals_intro+"</span></p></div><div class='dlgLogoPnl'><div class='dlgBtns'><div class='dlgMinBtn' onclick=i_im_show('"+imwin.id+"')></div><div id='dlgCloseBtn"+imwin.id+"' class='dlgCloseBtn'></div>";
	var str_2 = "<div id='dlg_openbtn"+imwin.id+"' class='dlgOpenBtn'><div class='btncontent' onclick=i_im_show('talkList"+imwin.id+"');i_im_changeClass(this,'dlgOpenBtn');></div></div>	";
	var str_3 = "</div></div></div><div id='contentPnl"+imwin.id+"' class='contentPnl'><div class='msgHistory' id='msgHistoryid_"+id+"'><div class='msgItem oldMsg' id='message_content_"+id+"'></div></div><div class='dlgToolbar'><div class='toolBar'><a href='javascript:void(0);' onclick=i_im_show('face_list_menu"+imwin.id+"') class='face' hidefocus='true'></a></div><div id='face_list_menu"+imwin.id+"' class='emBg' style='display:none' ><div class='emItem' lang='1' title='微笑'></div><div class='emItem' lang='2' title='呲牙笑'></div><div class='emItem' lang='3' title='偷笑'></div><div class='emItem' lang='4' title='吐舌'></div><div class='emItem' lang='5' title='色迷迷'></div><div class='emItem' lang='6' title='害羞'></div><div class='emItem' lang='7' title='耍酷'></div><div class='emItem' lang='8' title='晕'></div><div class='emItem' lang='9' title='疑惑'></div><div class='emItem' lang='10' title='-_-|||'></div><div class='emItem' lang='11' title=':('></div><div class='emItem' lang='12' title='不满'></div><div class='emItem' lang='13' title='吃惊'></div><div class='emItem' lang='14' title='不明白'></div><div class='emItem' lang='15' title='生气'></div><div class='emItem' lang='16' title='暴怒'></div><div class='emItem' lang='17' title='睡觉'></div><div class='emItem' lang='18' title='闭嘴'></div><div class='emItem' lang='19' title='衰'></div><div class='emItem' lang='20' title='猪头'></div><div class='emItem' lang='21' title='红心'></div><div class='emItem' lang='22' title='心碎'></div><div class='emItem' lang='23' title='鲜花'></div><div class='emItem' lang='24' title='花谢'></div><div class='emItem' lang='25' title='晚安'></div><div class='emItem' lang='26' title='拍砖'></div><div class='emItem' lang='27' title='钱'></div><div class='emItem' lang='28' title='便便'></div><div class='emItem' lang='29' title='呕吐'></div><div class='emItem' lang='30' title='扁你'></div><div class='emItem' lang='31' title='好'></div><div class='emItem' lang='32' title='鼓掌'></div><div class='emItem' lang='33' title='支持你'></div><div class='emItem' lang='34' title='鄙视你'></div><div class='emItem' lang='35' title='服了'></div><div class='emItem' lang='36' title='服了'></div><div class='emItem' lang='37' title='ok'></div><div class='emItem' lang='38' title='握手'></div><div class='emItem' lang='39' title='抱抱'></div><div class='emItem' lang='40' title='抽你'></div><div class='emItem' lang='41' title='亲一个'></div><div class='emItem' lang='42' title='委屈'></div><div class='emItem' lang='43' title='痛哭'></div><div class='emItem' lang='44' title='惊叫'></div><div class='emItem' lang='45' title='抓狂'></div><div class='emItem' lang='46' title='烧香'></div><div class='emItem' lang='47' title='期待'></div><div class='emItem' lang='48' title='喊话'></div><div class='emItem' lang='49' title='爽歪歪'></div></div><div class='dlgStatusTxt'><a target='_self' href='javascript:void(0)' class='showHistory' hidefocus='true' onclick=\"getHistoryMessage('"+id+"','0',false)\">聊天记录</a></div></div><div class='msgEditor'><textarea id='msginput"+imwin.id+"' class='msgTextarea' maxlength='150'></textarea><div class='sendArea'><div class='btnPnl'><div class='msgSendBtn btn'><div class='btnL'></div><div class='btnC' id='sendmessage_"+id+"'>发送</div><div class='btnR'></div></div></div><div class='txtNum'>剩余字数：<input id='txt_num"+id+"' value='150' style='border: 0;color:#000; background-color:#fff;color:#999;' disabled /></div></div></div></div><div class='hisPnl' id='his_pnl"+id+"' style='display:none;'><div class='contentPnl'><div class='history' id='history_pal_"+id+"'></div><div class='hisControl'><div class='btn' style='width:208px;'><div class='btnL'></div><div class='btnC' style='width:200px;' id='hispageshow_"+id+"'>上一页 下一页 当前第<span>2</span>页 总共<span>10</span>页</div><div class='btnR'></div></div></div></div></div></div>";
	var str_4 = "<div id='talkList"+imwin.id+"' class='talklist'><div class='title'>讨论成员[<span id='gnum_"+id+"'>1/100</span>]</div><div class='content imGroupItem-on'><ul class='imGroupContent imBuddyList' id='glist_"+id+"'></ul></div></div>";
	if(name == 'imWin'){
		imwin.innerHTML = str_1 + str_3;
	} else {
		imwin.innerHTML = str_1 + str_2 + str_3 + str_4;
	}

	parentnode.appendChild(imwin);
	imwin.className = 'imwinInt';
	if(name == 'imWin'){
		imwin.style.width = 327 +'px';
	} else {
		imwin.style.width = 448 +'px';
	}
	imwin.style.zIndex = i_im_zindex;
	imwin.style.display = '';
	i_im_zindex = i_im_zindex + 2;

	addMinFriendList(id,name);	// 添加边上的小窗口

	// 表情处理。
	i_im_smileControl(imwin.id);

	//启动拖拽
	var drag = new i_im_Drag(imwin.id);
	i_im_$("head_pnl"+imwin.id).onmousemove = function(){ drag.Lock = false; }
	i_im_$("contentPnl"+imwin.id).onmousemove = function(){ drag.Lock = true; }
	if(name == 'imWin_talk') {
		i_im_$("talkList"+imwin.id).onmousemove = function(){ drag.Lock = true; }
	}

	//激活窗口
	var temp_win = '';
	i_im_$(imwin.id).onmousedown = function() {
		for(i=0;i<divs.length;i++) {
			divs[i].className = 'inactive';
		}
		if(temp_win) {//for FF
			temp_win.className = 'imwinInt';
			temp_win.style.zIndex = i_im_zindex;
			i_im_zindex = i_im_zindex + 2;
			temp_win = '';
		} else {
			imwin.className = 'imwinInt';
			imwin.style.zIndex = i_im_zindex;
			i_im_zindex = i_im_zindex + 2;
		}
	}

	// 发送消息
	f_sendMessage = function () {
		var v = i_im_$('msginput'+imwin.id).value;
		if(v) {
			i_im_ajax(i_im_baseUrl+"ajax.php?act=postnewmessage","POST","pals="+pals_obj.pals_id+"&v="+v+"&vc="+verify_code,function(data){
				if(data==1) {
					i_im_$('msginput'+imwin.id).value = '';
					i_im_getMessage();
				}
			});
		}
	}
	i_im_$('msginput'+imwin.id).onkeydown = function(evt) {
		var n_event = (evt) ? evt : ((window.event) ? window.event : "") //兼容IE和Firefox获得keyBoardEvent对象
		var key = n_event.keyCode ? n_event.keyCode : n_event.which;
		
		if (n_event.keyCode==13) {
			var v = i_im_$('msginput'+imwin.id).value;
			if(v) {
				i_im_ajax(i_im_baseUrl+"ajax.php?act=postnewmessage","POST","pals="+pals_obj.pals_id+"&v="+v+"&vc="+verify_code,function(data){
					if(data==1) {
						i_im_$('msginput'+imwin.id).value = '';
						i_im_getMessage();
					}
				});
			}
		}

		LengthValidator(this,id);
	}
	i_im_$("sendmessage_"+id).onclick = f_sendMessage;

	//关闭窗口
	i_im_$("dlgCloseBtn"+imwin.id).onclick = function(){
		var max_zindex = 0;
		parentnode.removeChild(i_im_$(imwin.id));
		removeMinFriendList(id);	// 删除边上的小窗口
		for(i=0;i<divs.length;i++){
			if(divs[i].nodeType == 1){
				if(divs[i].style.zIndex){
					max_zindex = divs[i].style.zIndex > max_zindex?divs[i].style.zIndex:max_zindex;
				}
			}
		}
		for(i=0;i<divs.length;i++){
			if(divs[i].nodeType == 1){
				if(divs[i].style.zIndex == max_zindex){
					temp_win = divs[i];//for FF
					divs[i].className = 'imwinInt';//for IE
				}
			}
		}
	}

	// 初始化好窗口后 取消息。
	i_im_getMessage();
}

// 鼠标移动到好友上时 显示详情
function i_im_friendlistmouseover(obj,id) {
	i_im_addClass(obj,'buddyItem-hover');
	i_im_$('imPopWrap_'+id).style.display = '';
	i_im_popWrap(obj,'imPopWrap_'+id);
}
function i_im_friendlistmouseout(obj,id) {
	i_im_removeClass(obj,'buddyItem-hover');
	i_im_$('imPopWrap_'+id).style.display = 'none';
}

//加入到好友最小化列表
function addMinFriendList(id,name) {
	// 如果不存在，并且有好友相关信息时 加入到最小化列表
	if(i_im_$("minfriendlist_"+id)==null) {
		var imminwin=document.createElement("li");
		imminwin.id = 'minfriendlist_'+id;
		imminwin.className = 'imTinyItem';

		if(name=='imWin') {
			if(!frendlistarrayobj[id]) {
				getFriendInfo(id);
			}
			imminwin.innerHTML = "<img onclick=\"i_im_talkWin('"+id+"','"+name+"')\" class='avatar-20' title='"+frendlistarrayobj[id].pals_name+"' src='"+frendlistarrayobj[id].pals_ico+"' /><b onclick=\"i_im_talkWin('"+id+"','"+name+"')\"></b>";
		} else {
			imminwin.innerHTML = "<img onclick=\"i_im_talkWin('"+id+"','"+name+"')\" class='avatar-20' title='"+grouplistarrayobj[id].pals_name+"' src='"+grouplistarrayobj[id].pals_ico+"' /><b onclick=\"i_im_talkWin('"+id+"','"+name+"')\"></b>";
		}
		i_im_$('imTinybarTalkList').appendChild(imminwin);
	}
}

//好友最小化列表中删除
function removeMinFriendList(id) {
	i_im_$('imTinybarTalkList').removeChild(i_im_$("minfriendlist_"+id));
}

// 获取某个用户信息
function getFriendInfo(id) {
	i_im_ajax(i_im_baseUrl+"ajax.php?act=getfriendinfo","POST","sid="+id,function(data){
		if(data!='-1') {
			frendlistarrayobj[data.pals_id] = data;
		}
	},'JSON');
}

// 获取讨论组好友信息
function getGroupFrendList(id) {
	i_im_ajax(i_im_baseUrl+"ajax.php?act=getfriendlist","POST","sid="+id,function(data){
		if(data!='-1') {
			var glist = i_im_$("glist_"+id);
			var gnum = i_im_$("gnum_"+id);
			var html_glist = "";
			var onlineNum = 0;
			var allListNum = 0;
			for(var i=0; i<data.length; i++) {
				html_glist = html_glist+"<li ondblclick=\"i_im_talkWin('"+data[i].pals_id+"','imWin');\" class='buddyItem buddyItem-"+line_status_tostyle(data[i].line_status)+"'><div class='buddyAvatar'><a href='javascript:void(0)' title='"+data[i].pals_name+"' hidefocus='true'><img class='avatar-20' src='"+data[i].pals_ico+"' alt='"+data[i].pals_name+"' /><em></em><\/a><\/div><div class='buddyInfo'><strong class='buddyName'><a href='javascript:void(0)' title='"+data[i].pals_name+"'  hidefocus='true'>"+data[i].pals_name+"<\/a><\/strong><\/div></li>";

				if(data[i].line_status>0 && data[i].line_status!=2) {
					onlineNum++;
				}
				allListNum++;

				frendlistarrayobj[data[i].pals_id] = data[i];
			}
			glist.innerHTML = html_glist;
			gnum.innerHTML = onlineNum+"/"+allListNum;
			grouplistarrayobj[id].num = allListNum;
		}
	},'JSON');
}

/* 获取好友列表 */
function i_im_getFriendList() {
	var friendlist = i_im_$("imfriendlist");
	var popFriendWrap = i_im_$("impopFriendWrap");
	var friendListNum = i_im_$("imfriendListNum");
	var onlinefriendListNum = i_im_$("imonlinefriendListNum");
	var onlinefriendlist = i_im_$("imonlinefriendlist");
	var showonlinenum = i_im_$("imonlinenum");
	var onlineNum = 0;
	var allListNum = 0;
	i_im_ajax(i_im_baseUrl+"ajax.php?act=getfriendlist","GET","",function(data){
		if(data=='-1') {
			//alert('好友列表加载失败！');
			//getFriendList(); // 再次加载
		} else {
			var htmlFriendList = "";
			var htmlOnlineFriendList = "";
			var htmlFriendPopWrap = "";
			for(var i=0; i<data.length; i++) {
				// 好友列表
				htmlFriendList += "<li id='friendlist_pals_"+data[i].pals_id+"' class='buddyItem buddyItem-"+line_status_tostyle(data[i].line_status)+"' onmouseover=\"i_im_friendlistmouseover(this,'"+data[i].pals_id+"');\" onmouseout=\"i_im_friendlistmouseout(this,'"+data[i].pals_id+"');\" ondblclick=\"i_im_talkWin('"+data[i].pals_id+"','imWin');\" >";
				htmlFriendList += "<div class='buddyAvatar'><a href='javascript:void(0)' title='"+data[i].pals_name+"' hidefocus='true'><img class='avatar-20' src='"+data[i].pals_ico+"' alt='"+data[i].pals_name+"'><em></em><b></b></a></div>";
				htmlFriendList += "<div class='buddyInfo'><strong class='buddyName'><a href='javascript:void(0)' title='"+data[i].pals_name+"'  hidefocus='true'>"+data[i].pals_name+"</a></strong></div></li>";

				// 鼠标移动显示详细信息
				htmlFriendPopWrap += "<div id='imPopWrap_"+data[i].pals_id+"' style='display:none;z-index:10000;position:relative;' onmouseover=\"javascript:this.style.display = ''\" onmouseout=\"javascript:this.style.display = 'none'\"><div class='imCard imCard-"+line_status_tostyle(data[i].line_status)+"'>";
				htmlFriendPopWrap += "<div class=\"imCardAvatar\" id=\"imPopWrapIntro\"><img class=\"avatar-48\" src='"+data[i].pals_ico+"' alt='"+data[i].pals_name+"'></div>";
				htmlFriendPopWrap += "<div class=\"imCardInfo\"><strong class=\"imCardName\">"+data[i].pals_name+"</strong><span class=\"imCardImStatus\">"+line_status_tochar(data[i].line_status)+"</span><span class=\"imCardUserStatus\"></span></div>";
				htmlFriendPopWrap += "</div></div>";

				// 加载在线好友列表
				if(data[i].line_status>0 && data[i].line_status!=2) {
					onlineNum++;
					htmlOnlineFriendList += "<li id='"+data[i].pals_id+"' class='buddyItem buddyItem-"+line_status_tostyle(data[i].line_status)+"' onmouseover=\"i_im_friendlistmouseover(this,'"+data[i].pals_id+"');\" onmouseout=\"i_im_friendlistmouseout(this,'"+data[i].pals_id+"');\" ondblclick=\"i_im_talkWin('"+data[i].pals_id+"','imWin');\" >";
					htmlOnlineFriendList += "<div class='buddyAvatar'><a href='javascript:void(0)' title='"+data[i].pals_name+"' hidefocus='true'><img class='avatar-20' src='"+data[i].pals_ico+"' alt='"+data[i].pals_name+"'><em></em></a></div>";
					htmlOnlineFriendList += "<div class='buddyInfo'><strong class='buddyName'><a href='javascript:void(0)' title='"+data[i].pals_name+"'  hidefocus='true'>"+data[i].pals_name+"</a></strong></div></li>";
				}
				allListNum++;
				frendlistarrayobj[data[i].pals_id] = data[i];
			}

			friendlist.innerHTML = htmlFriendList;	// 更新好友列表
			onlinefriendlist.innerHTML = htmlOnlineFriendList; // 更新好友在线列表
			popFriendWrap.innerHTML = htmlFriendPopWrap;	// 用户详细pop框
			friendListNum.innerHTML = '['+onlineNum+'/'+allListNum+']';
			onlinefriendListNum.innerHTML = '['+onlineNum+']';	// 显示在线好友数
			showonlinenum.innerHTML = onlineNum;	// 显示在线人数
		}
	},'JSON');
}

// 获取聊天信息
function i_im_getMessage() {
	var divs = i_im_$('im_container').childNodes;
	var pals = '';
	for(var i=0;i<divs.length;i++){
		if(divs[i].id) {
			pals += divs[i].id.replace(/imWin_(talk_)?/g,"")+'|';
		}
	}

	pals = '|'+pals;
	i_im_ajax(i_im_baseUrl+"ajax.php?act=getmessagelist","POST","pals="+pals,function(data){
		var message_content,temp,html,tempid;
		var reg_g = /g_/g;
		if(data!="-1") {
			for(var i=0; i<data.length; i++) {
				if(data[i].winopen==1) {
					html = '';
					message_content = i_im_$("message_content_"+data[i].pals_id);
					temp = data[i].message;
					for(var j=0; j<temp.length; j++) {
						if(temp[j].id=='0') {
							html = html+"<div class='msgPostA'>【系统提示】("+temp[j].time+"):</div><div class='msgGetH msgLimitD'><span class='msgLimitS'>"+temp[j].txt+"</span></div>";
						}else if(temp[j].id==i_im_my_uid) {
							html = html+"<div class='msgPostA'>"+i_im_my_uname+" ("+temp[j].time+"):</div><div class='msgGetH msgLimitD'><span class='msgLimitS'>"+temp[j].txt+"</span></div>";
						} else {
							if(!frendlistarrayobj[temp[j].id]) {
								getFriendInfo(temp[j].id);
							}
							html = html+"<div class='msgGetA'>"+frendlistarrayobj[temp[j].id].pals_name+" ("+temp[j].time+"):</div><div class='msgGetH msgLimitD'><span class='msgLimitS'>"+temp[j].txt+"</span></div>";
						}
					}
					message_content.innerHTML = message_content.innerHTML+html;
					i_im_$("msgHistoryid_"+data[i].pals_id).scrollTop = i_im_$("msgHistoryid_"+data[i].pals_id).scrollTop+1000;

					// 判断是否为缩小,如果是的话提示新消息.
					tempid = data[i].pals_id.search(reg_g);
					if(tempid=='-1') {
						if(i_im_$("imWin_"+data[i].pals_id).style.display == "none"){
							i_im_setNewMsg(data[i].pals_id);
						}
					} else {
						if(i_im_$("imWin_talk_"+data[i].pals_id).style.display == "none"){
							i_im_setNewMsg(data[i].pals_id);
						}
					}
				} else {
					i_im_setNewMsg(data[i].pals_id);
				}
			}
		}
	},'JSON');
}

// 获取聊天历史记录
function getHistoryMessage(id,page,s) {
	var hide = true;
	if(!s) {
		i_im_show("his_pnl"+id);
		if(i_im_$("his_pnl"+id).style.display == 'none'){ hide=false; }
	}
	var history_pal = i_im_$("history_pal_"+id);
	var hispageshow = i_im_$("hispageshow_"+id);
	var html = '';

	// 判断是否是要关闭，关闭就不再请求聊天记录。
	if(hide) {
		history_pal.innerHTML = '正在加载请稍候。。。';
		i_im_ajax(i_im_baseUrl+"ajax.php?act=gethistorymessage","POST","pals="+id+"&page="+page,function(data){
			if(data!='-1') {
				var temp = data.message;
				for(var j=0; j<temp.length; j++) {
					if(temp[j].id=='0') {
						html += "<div class='msgItem'><div class='msgPostA'><div class='user'>【系统提示】("+temp[j].time+"):</div></div><div class='msgPostH msgLimitD'><span class='msgLimitS'>"+temp[j].txt+"</span></div></div>";
					}else if(temp[j].id==i_im_my_uid) {
						html += "<div class='msgItem'><div class='msgPostA'><div class='user'>"+i_im_my_uname+" ("+temp[j].time+"):</div></div><div class='msgPostH msgLimitD'><span class='msgLimitS'>"+temp[j].txt+"</span></div></div>";
					} else {
						if(!frendlistarrayobj[temp[j].id]) {
							getFriendInfo(temp[j].id);
						}
						html += "<div class='msgItem'><div class='msgGetA'><div class='user'>"+frendlistarrayobj[temp[j].id].pals_name+" ("+temp[j].time+"):</div></div><div class='msgGetH msgLimitD'><span class='msgLimitS'>"+temp[j].txt+"</span></div></div>";
					}
				}
				if(html!=''){
					history_pal.innerHTML = html;
				}
				var prepage = (data.page>1) ? data.page-1 : 1;
				var nextpage = (data.page<data.countpage) ? data.page+1 : data.countpage;
				hispageshow.innerHTML = "<span onclick=\"getHistoryMessage('"+id+"','"+prepage+"',true)\">上一页</span> <span onclick=\"getHistoryMessage('"+id+"','"+nextpage+"',true)\">下一页</span> 当前第<span>"+data.page+"</span>页 总共<span>"+data.countpage+"</span>页";
				history_pal.scrollTop = history_pal.scrollTop+1000;
			} else {
				history_pal.innerHTML = '加载失败请重试！';
			}
		},'JSON');
	}
}

// 新消息 状态处理
function i_im_setNewMsg(id) {
	if(!isNaN(id)) {
		var pals_id = i_im_$("friendlist_pals_"+id);
		if(pals_id!=null) {
			i_im_addClass(pals_id,'buddyItem-newmsg');
		}
		addMinFriendList(id,'imWin');
	} else {
		addMinFriendList(id,'imWin_talk');
	}
	var minfriendid = i_im_$('minfriendlist_'+id);
	if(minfriendid!=null) {
		if(i_im_addClass(minfriendid,'imTinyItem-msg')) {
			i_im_play_msg();
		}
	}
}
function i_im_clearNewMsg(id) {
	if(!isNaN(id)) {
		var pals_id = i_im_$("friendlist_pals_"+id);
		if(pals_id!=null) {
			i_im_removeClass(pals_id,'buddyItem-newmsg');
		}
	}
	var minfriendid = i_im_$('minfriendlist_'+id);
	if(minfriendid!=null) {
		i_im_removeClass(minfriendid,'imTinyItem-msg');
	}
}

// 显示我的信息状态
function i_im_showMyInfoAndStatus() {
	var imMyAvatar = i_im_$("imMyAvatar");
	var imMyName = i_im_$("imMyName");
	var online_myicon = i_im_$("imonline_myicon");
	imMyAvatar.src = i_im_my_ico;
	imMyName.innerHTML = i_im_my_uname;
	online_myicon.className = "imStatus im-"+line_status_tostyle(i_im_my_status);
	online_myicon.innerHTML = "imStatus im-"+line_status_tochar(i_im_my_status);
}

// 改变我的状态
function i_im_change_status(v) {
	var online_myicon = i_im_$("imonline_myicon");
	i_im_ajax(i_im_baseUrl+"ajax.php?act=changestatus","POST","s="+v,function(data){
		if(data=='1') {
			online_myicon.className = "imStatus im-"+line_status_tostyle(v);
			online_myicon.innerHTML = "imStatus im-"+line_status_tochar(v);
			i_im_my_status = v;
			i_im_show('immyOnlinePanel');
		}
	});
}

// 状态
function line_status_tostyle(v) {
	if(v=='1'){
		return 'available';
	} else if(v=='3'){
		return 'busy';
	} else if(v=='4'){
		return 'idle';
	} else {
		return 'offline';
	}
}
function line_status_tochar(v) {
	if(v=='1') {
		return '在线';
	} else if(v=='2') {
		return '隐身';
	} else if(v=='3') {
		return '忙碌';
	} else if(v=='4') {
		return '离开';
	} else {
		return '离线';
	}
}

// 表情处理
function i_im_smileControl(id) {
	var div = i_im_$("face_list_menu"+id).childNodes;
	for(var i=0; i<div.length; i++) {
		if(div[i].className=='emItem') {
			div[i].onmouseover = function() {
				i_im_addClass(this,'emAct');
			}
			div[i].onmouseout = function() {
				i_im_removeClass(this,'emAct');
			}
			div[i].onclick = function() {
				i_im_$("msginput"+id).value = i_im_$("msginput"+id).value + "{:"+this.lang+":}";
				i_im_show("face_list_menu"+id);
			}
		}
	}
}

// 搜索处理
function i_im_searchdo() {
	var search_dorpList = i_im_$("imsearch_dorpList");
	var searchBox = i_im_$("imSearchBox");
	searchBox.onkeyup = function(){
		var re = new RegExp(this.value,"ig");
		var r = '-1';
		var divs = i_im_$('imfriendlist').childNodes;
		var pals_id = '';
		var html = '';
		for(var i=0;i<divs.length;i++){
			if(divs[i].id) {
				pals_id = divs[i].id.replace(/friendlist_pals_/g,"");
				r = frendlistarrayobj[pals_id].pals_name.search(re);
				if(r!='-1') {
					html += "<li lang='"+pals_id+"'><span>"+frendlistarrayobj[pals_id].pals_name+"</span></li>";
				}
			}
		}

		if(html) {
			search_dorpList.innerHTML = html;
		} else {
			search_dorpList.innerHTML = "<li class='default'><span>没有找到匹配的好友</span></li>";
		}

		var lis = search_dorpList.childNodes;
		for(var j=0; j<lis.length; j++) {
			lis[j].onclick = function(){
				i_im_talkWin(this.lang,'imWin')
			}
			lis[j].onmouseover = function(){
				i_im_addClass(this,"on");
			}
			lis[j].onmouseout = function(){
				i_im_removeClass(this,"on");
			}
		}
	}
}

// 搜索框 blur的处理
function searchBoxBlur() {
	setTimeout("searchTips_list_hide()",200);
}
function searchTips_list_hide() {
	i_im_$('imsearchTips_list').style.display = 'none';
	i_im_readyBlur('imbar');
}

// 来信息提示处理
function i_im_mesageSoundWav() {
	var imMessageSound = i_im_$("immessageSound");
	imMessageSound.onclick = function(){
		if(i_im_msg_wav=='1') {
			this.className = '';
			i_im_msg_wav = '0';
			i_im_change_mesageSoundWav(0);
		} else {
			this.className = 'checked';
			i_im_msg_wav = '1';
			i_im_change_mesageSoundWav(1);
		}
		i_im_show('imSettingLayer');
	};
}

// 改变来信息提示
function i_im_change_mesageSoundWav(v) {
	i_im_ajax(i_im_baseUrl+"ajax.php?act=changemsgwav","POST","v="+v,function(data){
		if(data!='-1') {
			return true;
		} else {
			return false;
		}
	});
}

// 播放新消息声音
function i_im_play_msg() {
	if(i_im_msg_wav=='1') {
		var i_im_msg_wav_div = i_im_$("i_im_msg_wav_div");
		var html = '';
		html += '<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" codebase="http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=7,0,19,0" width="1" height="1">';
		html += '<param name="movie" value="'+i_im_baseUrl+'skin/default/flash/msg.swf" />';
		html += '<param name="quality" value="high" />';
		html += '<param name="wmode" value="transparent" />';
		html += '<param name="menu" value="false" />';
		html += '<embed src="'+i_im_baseUrl+'skin/default/flash/msg.swf" menu="false" wmode="transparent" quality="high" pluginspage="http://www.macromedia.com/go/getflashplayer" type="application/x-shockwave-flash" width="1" height="1"></embed>';
		html += '</object>';
		i_im_msg_wav_div.innerHTML = html;
	}
}

// 更新好友关系
function i_im_getApiUserPals(){
	i_im_ajax(i_im_baseUrl+"ajax.php?act=updatapals","POST","",function(data){});
}

//Manage IM

// 添加一新讨论组到列表
function i_im_grouplist_add(data) {
	var i_im_grouplist_id = i_im_$("i_im_grouplist_id");
	var html = "<li id='talk_"+data.pals_id+"' class='buddyItem' onmouseover=\"i_im_addClass(this,'buddyItem-hover');\" onmouseout=\"i_im_removeClass(this,'buddyItem-hover');\" ondblclick=\"i_im_talkWin('"+data.pals_id+"','imWin_talk');\" >";
	html += "<div class='buddyAvatar'><a href='javascript:void(0)' title='"+data.group_name+"' hidefocus='true'><img class='avatar-20' src='"+i_im_baseUrl+"skin/default/images/talk20.gif' alt='"+data.group_name+"'></a></div>";
	html += "<div class='buddyInfo'><strong class='buddyName'><a href='javascript:void(0)' title='"+data.group_name+"'  hidefocus='true'>"+data.group_name+"</a></strong></div></li>";
	i_im_grouplist_id.innerHTML = i_im_grouplist_id.innerHTML + html;
	grouplistarrayobj[data.pals_id] = data;
}

// 打开讨论组管理
var i_im_manage_is_create = false;
function i_im_manageInit(){
	// Create imManageWrap
	if(i_im_manage_is_create) { return ; } // 判断是否已创建
	var width = 350;
	var height = 215;
	var widthc = (width - 2) + 'px';
	var widthtc = (width - 8) + 'px';
	var heightc = height + 'px';
	var immWin = document.createElement('div');
	immWin.style.zIndex = 10001;
	immWin.style.position = 'absolute';
	immWin.style.width = width + 'px';
	immWin.style.top = 50 + Math.random()*150+'px';
	immWin.style.left = 150 + Math.random()*250+'px';
	immWin.id = 'imManageWrap';
	immWin.className = 'winbody';
	immWin.innerHTML = "<div id='i_im_wintoppanel' class='wintop'><div class='toplc'></div><div class='topcc' style='width:"+widthtc+"'><ul><li id='nav_1' class='now' onclick=i_im_changeStyle(1,2,'nav')><span>讨论组管理</span></li><li id='nav_2' onclick=i_im_changeStyle(2,2,'nav')><span>创建讨论组</span></li></ul><div id='im_mCloseBtn' class='dlgCloseBtn'></div></div><div class='toprc'></div></div><div id='nav_1_c' class='wincontent' style='width:"+widthc+";height:"+heightc+"'><ul><li id='i_im_menu_1' onclick=i_im_changeStyle(1,2,'i_im_menu') class='now'>我创建的讨论组</li><li id='i_im_menu_2' onclick=i_im_changeStyle(2,2,'i_im_menu')>我加入的讨论组</li></ul><div id='i_im_menu_1_c' class='talkgrouplist'></div><div id='i_im_menu_2_c' class='talkgrouplist' style='display:none'></div></div><div id='nav_2_c' class='wincontent' style='width:"+widthc+";height:"+heightc+";display:none'><p>讨论组名称：<input style='width:190px' id='i_im_c_groupname_id' onclick=this.value='';this.style.color='#666' class='text' type='text' value='请输入你要创建的讨论组的名称' /><input id='i_im_c_btn_id' class='submit' type='button' value='确定' /></p><p>&nbsp;</p><p><b>创建讨论组注意事项：</b></p><p>一个讨论组最多人数限制30人。</p><p>创建成功后的讨论组可以通过讨论组管理进行管理。</p><p>请不要创建重复的讨论组。</p></div><div class='winbottom'><div class='btlc'></div><div class='btcc' style='width:"+widthtc+"'></div><div class='btrc'></div></div>";
	i_im_$("imcss").appendChild(immWin);
	
	var drag = new i_im_Drag(immWin.id);
	for(var i=1;i<3;i++){
		i_im_$('nav_'+i+'_c').onmousemove = function(){drag.Lock = true;}
	}
	i_im_$('i_im_wintoppanel').onmousemove = function(){drag.Lock = false;}

	// 列出当前讨论组列表
	i_im_group_manage_list();

	// 记录当前讨论组管理已打开
	i_im_manage_is_create = true;

	i_im_$('im_mCloseBtn').onclick = function(){
		i_im_$("imcss").removeChild(immWin);
		i_im_manage_is_create = false;
	}
	i_im_$('im_mCloseBtn').onmouseover = function(){
		setTimeout("i_im_$('im_mCloseBtn').className = 'dlgCloseBtn2'",100);
	}
	i_im_$('im_mCloseBtn').onmouseout = function(){
		setTimeout("i_im_$('im_mCloseBtn').className = 'dlgCloseBtn'",100);
	}
	i_im_$('i_im_c_btn_id').onclick = function() {
		var groupname = i_im_$('i_im_c_groupname_id').value;
		if(groupname && groupname!='请输入你要创建的讨论组的名称') {
			// 创建新组
			i_im_ajax(i_im_baseUrl+"ajax.php?act=createnewgroup","POST","gname="+groupname,function(data){
				if(data!='-1') {
					alert("创建讨论组"+groupname+"成功！");
					i_im_$('i_im_c_groupname_id').value = '';
					i_im_grouplist_add(data);
				}
			},'JSON');
		}
	}
}

// 当前用户下的所有讨论组列表
function i_im_group_manage_list() {
	var i_im_menu_1_c = i_im_$("i_im_menu_1_c");
	var i_im_menu_2_c = i_im_$("i_im_menu_2_c");
	var i_im_grouplist_id = i_im_$("i_im_grouplist_id");
	var cnodes = i_im_grouplist_id.children;
	var k,html_num;
	var html_my='';
	var html_other='';
	for(var i=0; i<cnodes.length; i++) {
		k = cnodes[i].id.replace(/talk_/g,'');
		if(grouplistarrayobj[k].num==30) {
			html_num = '[讨论组满员]';
		} else {
			html_num = '';
		}
		if(grouplistarrayobj[k].group_mid==i_im_my_uid) {
			html_my += "<dl id='i_im_g_list_dl_id_"+grouplistarrayobj[k].pals_id+"'><dt><img src='"+grouplistarrayobj[k].pals_ico+"' width='40' height='40' /></dt><dd class='name'><span onclick=\"i_im_outgroup('"+grouplistarrayobj[k].pals_id+"')\">解散</span>"+grouplistarrayobj[k].group_name+"</dd><dd><span onclick=\"i_im_memberMag(this,'"+grouplistarrayobj[k].pals_id+"')\">管理</span>"+grouplistarrayobj[k].num+"人"+html_num+"</dd></dl>";
		} else {
			html_other += "<dl id='i_im_g_list_dl_id_"+grouplistarrayobj[k].pals_id+"'><dt><img src='"+grouplistarrayobj[k].pals_ico+"' width='40' height='40' /></dt><dd class='name'><span onclick=\"i_im_outgroup('"+grouplistarrayobj[k].pals_id+"')\">退出</span>"+grouplistarrayobj[k].group_name+"</dd><dd>"+grouplistarrayobj[k].num+"人"+html_num+"</dd></dl>";
		}
	}
	if(html_my=='') {
		html_my = '<dl>没有我创建的讨论组!</dl>';
	}
	if(html_other=='') {
		html_other = '<dl>没有我所加入的讨论组!</dl>';
	}
	i_im_menu_1_c.innerHTML = html_my;
	i_im_menu_2_c.innerHTML = html_other;
}

// 讨论组样式控制
function i_im_changeStyle(id,num,name){
	for(var i=1;i<num+1;i++){
		i_im_$(name+'_'+i).className = '';
		i_im_$(name+'_'+i+'_c').style.display = 'none';
	}
	i_im_$(name+'_'+id).className = 'now';
	i_im_$(name+'_'+id+'_c').style.display = '';
}

// 讨论组成员管理
function i_im_memberMag(obj,id){
	if(i_im_$('memberManage_'+id)) { return ;}
	var width = 180;
	var height = 300;
	var widthc = (width - 2) + 'px';
	var widthtc = (width - 8) + 'px';
	var heightc = height + 'px';
	var immWin = document.createElement('div');
	immWin.style.zIndex = 10002;
	immWin.style.position = 'absolute';
	immWin.style.width = width + 'px';
	var t=obj.offsetTop;   
    var l=obj.offsetLeft;   
    var height=obj.offsetHeight;   
    var width=obj.offsetWidth;   
    while(obj=obj.offsetParent){   
        t+=obj.offsetTop;   
        l+=obj.offsetLeft;   
    }   
	immWin.style.top = (t-50) + 'px';
	immWin.style.left = (l+30) + 'px';
	immWin.id = 'memberManage_'+id;
	immWin.className = 'winbody';
	immWin.innerHTML = "<div id='i_im_wintop_"+id+"' class='wintop'><div class='toplc'></div><div class='topcc' style='width:"+widthtc+"'><h2>成员管理</h2><div id='im_mCloseBtn"+id+"' class='dlgCloseBtn'></div></div><div class='toprc'></div></div><div id='i_im_wincontent_"+id+"' class='wincontent' style='width:"+widthc+";height:"+heightc+"'><div class='memberlist' id='i_im_memberlist_"+id+"'></div><input id='i_im_submit_"+id+"' class='submit' type='submit' value='确定' /></div><div class='winbottom'><div class='btlc'></div><div class='btcc' style='width:"+widthtc+"'></div><div class='btrc'></div></div>";
	i_im_$("imcss").appendChild(immWin);

	var drag = new i_im_Drag(immWin.id);
	i_im_$('i_im_wintop_'+id).onmouseover = function() {drag.Lock = false;}
	i_im_$('i_im_wincontent_'+id).onmouseover = function() {drag.Lock = true;}

	i_im_group_user_list(id);

	i_im_$('im_mCloseBtn'+id).onclick = function(){
		i_im_$("imcss").removeChild(immWin);
	}
	i_im_$('im_mCloseBtn'+id).onmouseover = function(){
		setTimeout("i_im_$('im_mCloseBtn"+id+"').className = 'dlgCloseBtn2'",100);
	}
	i_im_$('im_mCloseBtn'+id).onmouseout = function(){
		setTimeout("i_im_$('im_mCloseBtn"+id+"').className = 'dlgCloseBtn'",100);
	}
	i_im_$('i_im_submit_'+id).onclick = function(){
		var inputs = document.getElementsByName("group_user_check[]");
		var pals_ids = ',';
		for(var i=0; i<inputs.length; i++) {
			if(inputs[i].checked) {
				pals_ids += inputs[i].value+',';
			}
		}
		adduser_to_group(pals_ids,id);
	}
}

// 显示当前管理组的成员列表
function i_im_group_user_list(id) {
	var i_im_memberlist = i_im_$('i_im_memberlist_'+id);
	var imfriendlist = i_im_$('imfriendlist');
	var html = "<p><input type='checkbox' checked disabled />"+i_im_my_uname+"</p>";
	var cnodes = imfriendlist.children;
	var k;
	i_im_ajax(i_im_baseUrl+"ajax.php?act=getfriendlist","POST","sid="+id,function(data){
		if(data!='-1') {
			var temp = new Array;
			for(var i=0; i<data.length; i++) {
				temp[i] = data[i].pals_id;
			}

			for(var i=0; i<cnodes.length; i++) {
				k = cnodes[i].id.replace(/friendlist_pals_/g,'');
				if(temp.in_array(k)) {
					html += "<p><input name='group_user_check[]' type='checkbox' value='"+frendlistarrayobj[k].pals_id+"' checked />"+frendlistarrayobj[k].pals_name+"</p>";
				} else {
					html += "<p><input name='group_user_check[]' type='checkbox' value='"+frendlistarrayobj[k].pals_id+"' />"+frendlistarrayobj[k].pals_name+"</p>";
				}
			}

			i_im_memberlist.innerHTML = html;
		}
	},'JSON');
}

// 更新im讨论组
function i_im_update_group_list() {
	var imgroupnum = i_im_$("imGroupNum");
	var i_im_grouplist_id = i_im_$("i_im_grouplist_id");
	i_im_ajax(i_im_baseUrl+"ajax.php?act=getgrouplist","GET","",function(data){
		if(data=='-1') {
			//alert('好友列表加载失败！');
			//getFriendList(); // 再次加载
		} else {
			var htmlGroupList='';
			var allListNum = 0;
			for(var i=0; i<data.length; i++) {
				htmlGroupList += "<li id='talk_"+data[i].pals_id+"' class='buddyItem' onmouseover=\"i_im_addClass(this,'buddyItem-hover');\" onmouseout=\"i_im_removeClass(this,'buddyItem-hover');\" ondblclick=\"i_im_talkWin('"+data[i].pals_id+"','imWin_talk');\" ><div class='buddyAvatar'><a href='javascript:void(0)' title='"+data[i].group_name+"' hidefocus='true'><img class='avatar-20' src='"+i_im_baseUrl+"skin/default/images/talk.gif' alt='"+data[i].group_name+"'></a></div><div class='buddyInfo'><strong class='buddyName'><a href='javascript:void(0)' title='"+data[i].group_name+"'  hidefocus='true'>"+data[i].group_name+"</a></strong></div>";
				allListNum++;
				grouplistarrayobj[data[i].pals_id] = data[i];
			}
			i_im_grouplist_id.innerHTML = htmlGroupList;	// 更新好友列表
			imgroupnum.innerHTML = '['+allListNum+']';
		}
	},'JSON');
}

// 添加用户到该讨论组
function adduser_to_group(pals_id,g_id) {
	if(pals_id && g_id) {
		i_im_ajax(i_im_baseUrl+"ajax.php?act=addusertogroup","POST","pid="+pals_id+"&gid="+g_id,function(data){
			if(data=='2') {
				alert("添加成员不能超过30人");
			} else if(data!='-1') {
				alert("讨论组成员编辑成功！");
			}
		});
	}
}

// 退出讨论组
function i_im_outgroup(v) {
	i_im_ajax(i_im_baseUrl+"ajax.php?act=logoutgroup","POST","gid="+v,function(data){
		if(data!='-1') {
			var i_im_g_list_dl_id = i_im_$("i_im_g_list_dl_id_"+v);
			var talk_g = i_im_$("talk_"+v);
			alert("您已成功退出讨论组！");
			i_im_g_list_dl_id.style.display = 'none';
			i_im_$("i_im_grouplist_id").removeChild(talk_g);
		}
	});
}

// onload
function i_im_initIM() {
	// 更新好友列表信息
	i_im_getApiUserPals();
	// 搜索处理.
	i_im_searchdo();
	// 来信息提示处理选项处理
	i_im_mesageSoundWav();
	// 显示我的状态
	i_im_showMyInfoAndStatus();
	// 刷新好友列表
	i_im_getFriendList();
	setInterval("i_im_getFriendList()",59300);
	setInterval("i_im_update_group_list()",61300);
	// 获取聊天信息
	setInterval("i_im_getMessage()",4000);
}

window.onload = function() {
	i_im_initIM();
};