<?php
/**
 * Template Lite dreamcms compile plugin ADD iDreamSoft
 *
 * Type:	 compile
 * Name:	 DreamCMS_start
 */

function compile_dreamcms($arguments, &$object){
	$attrs = $object->_parse_arguments($arguments);
	$arg_list = array();
	$output = '<?php ';
	$hash=substr(uniqid(rand()), -4);
	$DreamCMS_props = "\$this->_DreamCMS['G{$hash}']";
	$DreamCMS_vars_tmp="\$this->_DreamCMS['_G{$hash}']";
	$output .= "if (isset($DreamCMS_props)) unset($DreamCMS_props);\n";	
	foreach ($attrs as $attr_name => $attr_value){
		switch ($attr_name){
			case 'loop':
				$output .= "{$DreamCMS_props}['loop'] = is_array($attr_value) ? count($attr_value) : max(0, (int)$attr_value);\n";
				$output .="{$DreamCMS_vars_tmp}={$attr_value};\nunset($attr_value);\n";
				break;
			case 'show':
				if (is_bool($attr_value)){
					$show_attr_value = $attr_value ? 'true' : 'false';
				}else{
					$show_attr_value = "(bool)$attr_value";
				}
				$output .= "{$DreamCMS_props}['show'] = $show_attr_value;\n";
				break;
			case 'name':
				$output .= "{$DreamCMS_props}['$attr_name'] = '$attr_value';\n";
				break;
			case 'max':
			case 'start':
				$output .= "{$DreamCMS_props}['$attr_name'] = (int)$attr_value;\n";
				break;
			case 'step':
				$output .= "{$DreamCMS_props}['$attr_name'] = ((int)$attr_value) == 0 ? 1 : (int)$attr_value;\n";
				break;
			default:
				$object->trigger_error("unknown section attribute - '$attr_name'", E_USER_ERROR, __FILE__, __LINE__);
				break;
		}
	}

	if (!isset($attrs['show'])){
		$output .= "{$DreamCMS_props}['show'] = true;\n";
	}

	if (!isset($attrs['loop'])){
		$output .= "{$DreamCMS_props}['loop'] = 1;\n";
	}

	if (!isset($attrs['max'])){
		$output .= "{$DreamCMS_props}['max'] = {$DreamCMS_props}['loop'];\n";
	}else{
		$output .= "if ({$DreamCMS_props}['max'] < 0)\n" .
					"	{$DreamCMS_props}['max'] = {$DreamCMS_props}['loop'];\n";
	}

	if (!isset($attrs['step'])){
		$output .= "{$DreamCMS_props}['step'] = 1;\n";
	}

	if (!isset($attrs['start'])){
		$output .= "{$DreamCMS_props}['start'] = {$DreamCMS_props}['step'] > 0 ? 0 : {$DreamCMS_props}['loop']-1;\n";
	}else{
		$output .= "if ({$DreamCMS_props}['start'] < 0){\n" .
				   "	{$DreamCMS_props}['start'] = max({$DreamCMS_props}['step'] > 0 ? 0 : -1, {$DreamCMS_props}['loop'] + {$DreamCMS_props}['start']);\n" .
				   "}else{\n" .
				   "	{$DreamCMS_props}['start'] = min({$DreamCMS_props}['start'], {$DreamCMS_props}['step'] > 0 ? {$DreamCMS_props}['loop'] : {$DreamCMS_props}['loop']-1);\n}";
	}

	$output .= "if ({$DreamCMS_props}['show']) {\n";
	if (!isset($attrs['start']) && !isset($attrs['step']) && !isset($attrs['max'])){
		$output .= "	{$DreamCMS_props}['total'] = {$DreamCMS_props}['loop'];\n";
	}else{
		$output .= "	{$DreamCMS_props}['total'] = min(ceil(({$DreamCMS_props}['step'] > 0 ? {$DreamCMS_props}['loop'] - {$DreamCMS_props}['start'] : {$DreamCMS_props}['start']+1)/abs({$DreamCMS_props}['step'])), {$DreamCMS_props}['max']);\n";
	}
	$output .= "	if ({$DreamCMS_props}['total'] == 0){\n" .
			   "		{$DreamCMS_props}['show'] = false;\n\t}\n" .
			   "} else{\n" .
			   "	{$DreamCMS_props}['total'] = 0;\n}\n";

	$output .= "if ({$DreamCMS_props}['show']){\n";
	$output .= "
		for ({$DreamCMS_props}['index'] = {$DreamCMS_props}['start'], {$DreamCMS_props}['iteration'] = 1;
			 {$DreamCMS_props}['iteration'] <= {$DreamCMS_props}['total'];
			 {$DreamCMS_props}['index'] += {$DreamCMS_props}['step'], {$DreamCMS_props}['iteration']++){\n";
	$output .= "{$DreamCMS_props}['rownum'] = {$DreamCMS_props}['iteration'];\n";
	$output .= "{$DreamCMS_props}['index_prev'] = {$DreamCMS_props}['index'] - {$DreamCMS_props}['step'];\n";
	$output .= "{$DreamCMS_props}['index_next'] = {$DreamCMS_props}['index'] + {$DreamCMS_props}['step'];\n";
	$output .= "{$DreamCMS_props}['first']	  = ({$DreamCMS_props}['iteration'] == 1);\n";
	$output .= "{$DreamCMS_props}['last']	   = ({$DreamCMS_props}['iteration'] == {$DreamCMS_props}['total']);\n";
	$output .= "{$attrs['loop']}= array_merge({$DreamCMS_vars_tmp}[{$DreamCMS_props}['index']],{$DreamCMS_props});\n";
	$output .= "?>";

	return $output;
}
?>