<!--
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2007 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 *
 * Test page for the "File Uploaders".
-->
<html>
	<head>
		<title>FCKeditor - Uploaders Tests</title>
		<script language="javascript">

function SendFile()
{
	var sUploaderUrl = cmbUploaderUrl.value ;

	if ( sUploaderUrl.length == 0 )
		sUploaderUrl = txtCustomUrl.value ;

	if ( sUploaderUrl.length == 0 )
	{
		alert( 'Please provide your custom URL or select a default one' ) ;
		return ;
	}

	eURL.innerHTML = sUploaderUrl ;
	txtUrl.value = '' ;

	frmUpload.action = sUploaderUrl ;
	frmUpload.submit() ;
}

function OnUploadCompleted( errorNumber, fileUrl, fileName, customMsg )
{
	switch ( errorNumber )
	{
		case 0 :	// No errors
			txtUrl.value = fileUrl ;
			alert( 'File uploaded with no errors' ) ;
			break ;
		case 1 :	// Custom error
			alert( customMsg ) ;
			break ;
		case 10 :	// Custom warning
			txtUrl.value = fileUrl ;
			alert( customMsg ) ;
			break ;
		case 201 :
			txtUrl.value = fileUrl ;
			alert( 'A file with the same name is already available. The uploaded file has been renamed to "' + fileName + '"' ) ;
			break ;
		case 202 :
			alert( 'Invalid file' ) ;
			break ;
		case 203 :
			alert( "Security error. You probably don't have enough permissions to upload. Please check your server." ) ;
			break ;
		default :
			alert( 'Error on file upload. Error number: ' + errorNumber ) ;
			break ;
	}
}

		</script>
	</head>
	<body>
		<table cellSpacing="0" cellPadding="0" width="100%" border="0" height="100%">
			<tr>
				<td>
					<table cellSpacing="0" cellPadding="0" width="100%" border="0">
						<tr>
							<td nowrap>
								Select the "File Uploader" to use:<br>
								<select id="cmbUploaderUrl">
									<option selected value="asp/upload.asp">ASP</option>
									<option value="aspx/upload.aspx">ASP.Net</option>
									<option value="cfm/upload.cfm">ColdFusion</option>
									<option value="lasso/upload.lasso">Lasso</option>
									<option value="php/upload.php">PHP</option>
									<option value="">(Custom)</option>
								</select>
							</td>
							<td nowrap>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
							<td width="100%">
								Custom Uploader URL:<BR>
								<input id="txtCustomUrl" style="WIDTH: 100%; BACKGROUND-COLOR: #dcdcdc" disabled type="text">
							</td>
						</tr>
					</table>
					<br>
					<table cellSpacing="0" cellPadding="0" width="100%" border="0">
						<tr>
							<td noWrap>
								<form id="frmUpload" target="UploadWindow" enctype="multipart/form-data" action="" method="post">
									Upload a new file:<br>
									<input type="file" name="NewFile"><br>
									<input type="button" value="Send it to the Server" onclick="SendFile();">
								</form>
							</td>
							<td style="WIDTH: 16px">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
							<td vAlign="top" width="100%">
								Uploaded File URL:<br>
								<INPUT id="txtUrl" style="WIDTH: 100%" readonly type="text">
							</td>
						</tr>
					</table>
					<br>
					Post URL: <span id="eURL">&nbsp;</span>
				</td>
			</tr>
			<tr>
				<td height="100%">
					<iframe name="UploadWindow" width="100%" height="100%" src="javascript:void(0)"></iframe>
				</td>
			</tr>
		</table>
	</body>
</html>
