--
-- Ľṹ bicq_class
--

DROP TABLE IF EXISTS bicq_class;
CREATE TABLE bicq_class (
  id smallint(6) unsigned NOT NULL auto_increment,
  parentid smallint(6) NOT NULL default '0',
  sequence smallint(6) NOT NULL default '0',
  name char(24) NOT NULL default '',
  ishidden tinyint(3) unsigned NOT NULL default '0',
  language char(42) NOT NULL default 'chinese',
  number int(10) NOT NULL default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

--
-- е bicq_class
--


-- --------------------------------------------------------

--
-- Ľṹ bicq_fast_reply
--

DROP TABLE IF EXISTS bicq_fast_reply;
CREATE TABLE bicq_fast_reply (
  id smallint(6) unsigned NOT NULL auto_increment,
  title varchar(252) NOT NULL default '',
  classid smallint(6) NOT NULL default '1',
  uploader int(10) NOT NULL default '0',
  dateline int(11) NOT NULL default '0',
  views int(8) NOT NULL default '0',
  content text NOT NULL,
  priority tinyint(1) NOT NULL default '0',
  type tinyint(1) NOT NULL default '0',
  downloadurl varchar(252) NOT NULL default '',
  PRIMARY KEY  (id)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

--
-- е bicq_fast_reply
--


-- --------------------------------------------------------

--
-- Ľṹ bicq_friends
--

DROP TABLE IF EXISTS bicq_friends;
CREATE TABLE bicq_friends (
  fid int(11) unsigned NOT NULL auto_increment,
  u_id int(10) NOT NULL default '0',
  f_id int(10) NOT NULL default '0',
  ftype tinyint(1) NOT NULL default '1',
  delchat int(11) NOT NULL default '0',
  chatfont char(252) NOT NULL default '',
  bz_name char(24) default NULL,
  bz_tel char(24) default NULL,
  bz_zipcode char(6) default NULL,
  bz_mobile char(24) default NULL,
  bz_email char(252) default NULL,
  bz_address char(252) default NULL,
  bz_remarks char(252) default NULL,
  PRIMARY KEY  (fid),
  KEY u_id (u_id),
  KEY f_id (f_id)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

--
-- е bicq_friends
--


-- --------------------------------------------------------

--
-- Ľṹ bicq_group_list
--

DROP TABLE IF EXISTS bicq_group_list;
CREATE TABLE bicq_group_list (
  id int(11) NOT NULL auto_increment,
  g_id int(10) NOT NULL default '0',
  u_id int(10) NOT NULL default '0',
  ifread int(1) NOT NULL default '0',
  tread int(20) NOT NULL default '0',
  addgrouptime int(20) NOT NULL default '0',
  delgroup int(20) NOT NULL default '0',
  groupfont char(252) NOT NULL default '',
  msgidentify int(1) NOT NULL default '1',
  admin int(1) NOT NULL default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

--
-- е bicq_group_list
--


-- --------------------------------------------------------

--
-- Ľṹ bicq_group_messages
--

DROP TABLE IF EXISTS bicq_group_messages;
CREATE TABLE bicq_group_messages (
  id int(11) NOT NULL auto_increment,
  sender int(10) NOT NULL default '0',
  receiver int(10) NOT NULL default '0',
  petname varchar(42) NOT NULL default '',
  gmessages text NOT NULL,
  gtime int(11) NOT NULL default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

--
-- е bicq_group_messages
--


-- --------------------------------------------------------

--
-- Ľṹ bicq_groups
--

DROP TABLE IF EXISTS bicq_groups;
CREATE TABLE bicq_groups (
  id smallint(6) NOT NULL auto_increment,
  group_id int(10) NOT NULL default '0',
  group_name char(42) NOT NULL default '',
  group_admin int(10) NOT NULL default '0',
  group_type char(24) NOT NULL default '0',
  group_identify tinyint(1) NOT NULL default '1',
  group_explain char(252) NOT NULL default '',
  group_public char(252) NOT NULL default '',
  PRIMARY KEY  (id)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

--
-- е bicq_groups
--


-- --------------------------------------------------------

--
-- Ľṹ bicq_icons
--

DROP TABLE IF EXISTS bicq_icons;
CREATE TABLE bicq_icons (
  id smallint(6) unsigned NOT NULL auto_increment,
  title varchar(24) NOT NULL default '',
  icon varchar(10) NOT NULL default '',
  link varchar(252) NOT NULL default '',
  sequence tinyint(3) unsigned NOT NULL default '0',
  popup tinyint(1) unsigned NOT NULL default '0',
  content text NOT NULL,
  width smallint(3) NOT NULL default '0',
  height smallint(3) NOT NULL default '0',
  logon tinyint(1) unsigned NOT NULL default '0',
  uid int(11) unsigned NOT NULL default '0',
  dateline int(11) NOT NULL default '0',
  PRIMARY KEY  (id),
  KEY uid (uid)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

--
-- е bicq_icons
--


-- --------------------------------------------------------

--
-- Ľṹ bicq_members
--

DROP TABLE IF EXISTS bicq_members;
CREATE TABLE bicq_members (
  id int(11) unsigned NOT NULL auto_increment,
  uid int(10) unsigned NOT NULL default '0',
  username char(48) NOT NULL default '',
  password char(32) NOT NULL default '',
  petname char(42) NOT NULL default '',
  head int(3) NOT NULL default '1',
  sex tinyint(1) NOT NULL default '1',
  age char(3) NOT NULL default '-',
  country char(42) NOT NULL default '',
  province char(42) NOT NULL default '',
  city char(42) NOT NULL default '',
  email char(252) NOT NULL default '',
  address char(252) NOT NULL default '',
  zipcode char(6) NOT NULL default '',
  tel char(42) NOT NULL default '',
  mobile char(42) NOT NULL default '',
  privacy tinyint(1) NOT NULL default '1',
  name char(24) NOT NULL default '',
  school char(42) NOT NULL default '',
  occupation char(42) NOT NULL default '',
  zodiac tinyint(2) NOT NULL default '0',
  blood tinyint(2) NOT NULL default '0',
  horoscope tinyint(2) NOT NULL default '0',
  website char(252) NOT NULL default '',
  mexplain char(252) NOT NULL default '',
  identify tinyint(1) NOT NULL default '1',
  mphoto char(252) NOT NULL default '',
  mshow char(252) NOT NULL default '',
  diskpath char(252) NOT NULL default '',
  regtime int(20) NOT NULL default '0',
  server tinyint(1) NOT NULL default '0',
  ip char(15) NOT NULL default '',
  online tinyint(1) NOT NULL default '0',
  temp tinyint(1) NOT NULL default '0',
  busymessages char(252) NOT NULL default '',
  totaltime int(10) NOT NULL default '0',
  lastactivity int(20) NOT NULL default '0',
  groupid tinyint(1) NOT NULL default '0',
  regip char(16) NOT NULL default '',
  newmsg smallint(6) NOT NULL default '0',
  pwdrecover char(32) NOT NULL default '',
  pwdrcvtime int(10) NOT NULL default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

--
-- е bicq_members
--


-- --------------------------------------------------------

--
-- Ľṹ bicq_messages
--

DROP TABLE IF EXISTS bicq_messages;
CREATE TABLE bicq_messages (
  mid int(11) unsigned NOT NULL auto_increment,
  sender int(10) NOT NULL default '0',
  receiver int(10) NOT NULL default '0',
  petname varchar(42) NOT NULL default '',
  messages text NOT NULL,
  addgroupid int(10) NOT NULL default '0',
  md5 varchar(32) NOT NULL default '0',
  ftype tinyint(1) NOT NULL default '0',
  mtime int(11) NOT NULL default '0',
  ifread tinyint(1) NOT NULL default '0',
  mtype tinyint(1) NOT NULL default '0',
  if_guest tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (mid),
  KEY sendnmb (sender),
  KEY recvnmb (receiver)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

--
-- е bicq_messages
--


-- --------------------------------------------------------

--
-- Ľṹ bicq_messagesid
--

DROP TABLE IF EXISTS bicq_messagesid;
CREATE TABLE bicq_messagesid (
  mid int(11) unsigned NOT NULL auto_increment,
  sender int(10) NOT NULL default '0',
  receiver int(10) NOT NULL default '0',
  mtype tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (mid),
  KEY sendnmb (sender),
  KEY recvnmb (receiver)
) TYPE=MyISAM;

--
-- е bicq_messagesid
--


-- --------------------------------------------------------

--
-- Ľṹ bicq_register_ip
--

DROP TABLE IF EXISTS bicq_register_ip;
CREATE TABLE bicq_register_ip (
  ip varchar(15) NOT NULL default '',
  dateline varchar(10) NOT NULL default '',
  PRIMARY KEY  (ip),
  UNIQUE KEY ip (ip)
) ENGINE=MyISAM;

--
-- е bicq_register_ip
--


-- --------------------------------------------------------

--
-- Ľṹ bicq_sessions
--

DROP TABLE IF EXISTS bicq_sessions;
CREATE TABLE bicq_sessions (
  sid char(6) binary NOT NULL default '',
  ip1 tinyint(3) unsigned NOT NULL default '0',
  ip2 tinyint(3) unsigned NOT NULL default '0',
  ip3 tinyint(3) unsigned NOT NULL default '0',
  ip4 tinyint(3) unsigned NOT NULL default '0',
  uid int(10) unsigned NOT NULL default '0',
  username char(48) NOT NULL default '',
  petname char(42) NOT NULL default '',
  busy_messages char(252) NOT NULL default '',
  sys_messages tinyint(1) NOT NULL default '0',
  groupid smallint(6) unsigned NOT NULL default '0',
  styleid smallint(6) unsigned NOT NULL default '0',
  lastactivity int(10) unsigned NOT NULL default '0',
  newmsg tinyint(3) unsigned NOT NULL default '0',
  online tinyint(1) NOT NULL default '1',
  lup char(10) NOT NULL default '0',
  PRIMARY KEY  (uid),
  UNIQUE KEY sid (sid)
) TYPE=HEAP;

--
-- е bicq_sessions
--


-- --------------------------------------------------------

--
-- Ľṹ bicq_settings
--

DROP TABLE IF EXISTS bicq_settings;
CREATE TABLE bicq_settings (
  id int(11) NOT NULL auto_increment,
  uid int(10) NOT NULL default '0',
  auto_focus int(1) NOT NULL default '0',
  auto_online_hint int(1) NOT NULL default '0',
  msg_sound int(1) NOT NULL default '0',
  read_hotkey int(1) NOT NULL default '0',
  send_hotkey int(1) NOT NULL default '4',
  my_folder_name1 char(21) NOT NULL default '',
  my_folder_name2 char(21) NOT NULL default '',
  my_folder_name3 char(21) NOT NULL default '',
  PRIMARY KEY  (id)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

--
-- е bicq_settings
--


-- --------------------------------------------------------

--
-- Ľṹ bicq_system
--

DROP TABLE IF EXISTS bicq_system;
CREATE TABLE bicq_system (
  ID smallint(6) unsigned NOT NULL auto_increment,
  db_name varchar(255) NOT NULL default '',
  db_value text NOT NULL,
  PRIMARY KEY  (ID)
) TYPE=MyISAM AUTO_INCREMENT=13 ;

--
-- е bicq_system
--
