///////////////////////////////////
//         ajax im 3.3           //
//    AJAX Instant Messenger     //
//   Copyright (c) 2006-2008     //
// unwieldy studios/Joshua Gross //
//  http://unwieldy.net/ajaxim/  //
//   Do not remove this notice   //
///////////////////////////////////

// IM Class
var IM = {
   windows: {},

   sendMessage: function(username, message, isBold, isItalic, isUnderline, fontName, fontSize, fontColor) {
      var xhConn = new XHConn();
   
      var result = null;
      
      xhConn.connect(pingTo, "POST", "call=send&recipient="+username+"&bold="+isBold+"&italic="+isItalic+"&underline="+isUnderline+"&font="+fontName+"&fontsize="+fontSize+"&fontcolor="+fontColor+"&message="+encodeURIComponent(message),
         function(xh) {
            if(xh.responseText == 'sent') {
               // do nothing!
            } else if(xh.responseText == 'not_online') {
               result = lang['errorNotLoggedIn'];
            } else if(xh.responseText == 'too_long') {
               result = lang['errorMsgTooLong'];
            } else if(xh.responseText == 'not_logged_in') {
               logout();
            } else {
               result = lang['errorUnknown'];
            }
         }
      );

      if(audioNotify == true) soundManager.play('msg_out', 1, true);
      
      return result;
   },

   emoteReplace: function(str, itemsList) {
      var r;
      for(var i=0; i<itemsList.length; i++) {
         r = itemsList[i].split('~');
         if(str.indexOf(r[0]) > -1)
            str = str.replace(new RegExp(self.opener.regExpEscape(r[0]), 'g'), '<img src="images/emoticons/' + r[1] + '" alt="' + r[1] + '" title="' + r[0] + '" />');
      }
      return str;
   },

   handleResize: function(e) {
      var rcvdBox = $(winName + '_rcvd');
      rcvdBox.style.height = (browserHeight() - 133) + 'px';
      rcvdBox.style.width = (browserWidth() - 15) + 'px';
      
      $(winName + '_toolbar').style.top = (browserHeight() - 93) + 'px';
      $(winName + '_toolbar').style.width = (browserWidth() - 10) + 'px';  
      $(winName + '_setFont').style.top = (browserHeight() - 85) + 'px';
      
      $(winName + '_setFontSize').style.top = (browserHeight() - 85) + 'px';
      
      $(winName + '_setFontColor').style.top = (browserHeight() - 85) + 'px';
   
      $(winName + '_insertEmoticon').style.top = (browserHeight() - 85) + 'px';
      
      $(winName + '_sendBox').style.top = (browserHeight() - 65) + 'px';
      $(winName + '_sendBox').style.width = (browserWidth() - 16) + 'px';
      
      rcvdBox.scrollTop = rcvdBox.scrollHeight - rcvdBox.clientHeight + 6;
   }
}

var IMWindow = Class.create();

Object.extend(IMWindow.prototype, Window.prototype);

Object.extend(IMWindow.prototype, {
   setUsername: function(username) {
      this.username = username;
   },

   send: function() {
      var winId = this.getId();
      var sendBox = $(winId + '_sendBox');
   
      var isBold      = (sendBox.style.fontWeight == '400' ? 'false' : 'true');
      var isItalic    = (sendBox.style.fontStyle == 'normal' ? 'false' : 'true');
      var isUnderline = (sendBox.style.textDecoration == 'none' ? 'false' : 'true');
      var fontName    = $(winId + '_setFont').innerHTML;
      var fontSize    = $(winId + '_setFontSize').innerHTML;
      var fontColor   = $(winId + '_setFontColorColor').style.backgroundColor;

      if(trim(sendBox.value).length > 0) {
         var message = sendBox.value;
         sendBox.value = '';
         var result = IM.sendMessage(this.username, message.replace(/</g, '&lt;').replace(/>/g, '&gt;').replace(/&/g, "<amp>"), isBold, isItalic, isUnderline, fontName, fontSize, fontColor);
         
         if(result != null) {
            var rcvdBox = $(winId + '_rcvd');
            rcvdBox.innerHTML = rcvdBox.innerHTML + '<span style="color:#FF0000"><b>' + result + '</b></span><br>';
         }
         
         message = message.replace(/</g, '&lt;').replace(/>/g, '&gt;').replace(/<([^>]+)>/ig, '').replace(/(\s|\n|>|^)(\w+:\/\/[^<\s\n]+)/, '$1<a href="$2" target="_blank">$2</a>');
         message = IM.emoteReplace(message, smilies);
         var rcvdBox = $(winId + '_rcvd');
         Stamp = new Date(); var h = String(Stamp.getHours()); var m = String(Stamp.getMinutes()); var s = String(Stamp.getSeconds());
         h = (h.length > 1) ? h : "0"+h; m = (m.length > 1) ? m : "0"+m;
         if(message.replace(/<([^>]+)>/ig, '').indexOf('/me') == 0)
            rcvdBox.innerHTML = rcvdBox.innerHTML + "<b class=\"userA\">[" + h + ":" + m + "] <i>" + user + ' ' + message.replace(/<([^>]+)>/ig, '').replace(/\/me/, '') + "</i></b><br>\n";
         else
            rcvdBox.innerHTML = rcvdBox.innerHTML + "<b class=\"userA\">[" + h + ":" + m + "] " + user + ":</b> <span style=\"font-family:" + fontName + ",sans-serif;font-size:" + fontSize + "px;color:" + fontColor + ";\">" + (isBold == 'true' ? "<b>" : "") + (isItalic == 'true' ? "<i>" : "") + (isUnderline == 'true' ? "<u>" : "") + message + (isBold == 'true' ? "</b>" : "") + (isItalic == 'true' ? "</i>" : "") + (isUnderline == 'true' ? "</u>" : "") + "</span><br>\n";
      }
      
      scrollToBottom(winId + '_rcvd');
      sendBox.focus();
   },
   
   toggleBold: function() {
      var winId = this.getId();
      var sendBox = $(winId + '_sendBox');
         
      sendBox.style.display = 'none'; // horrah weird Opera 9 input refresh!
      if(sendBox.style.fontWeight == '400') {
         $(winId + '_bold').src = 'images/' + windowCSS + '/bold_on.png';
         sendBox.style.fontWeight = '700';
      } else {
         sendBox.style.fontWeight = '400';
         $(winId + '_bold').src = 'images/' + windowCSS + '/bold_off.png';
      }
      sendBox.style.display = 'block'; // horrah weird Opera 9 input refresh!
      setTimeout("$('" + winId + "_sendBox').focus();", 125);
   },
      
   toggleItalic: function() {
      var winId = this.getId();
      var sendBox = $(winId + '_sendBox');
      
      sendBox.style.display = 'none'; // horrah weird Opera 9 input refresh!
      if(sendBox.style.fontStyle == 'normal') {
         sendBox.style.fontStyle = 'italic';
         $(winId + '_italic').src = 'images/' + windowCSS + '/italic_on.png';
      } else {
         sendBox.style.fontStyle = 'normal';
         $(winId + '_italic').src = 'images/' + windowCSS + '/italic_off.png';
      }
      sendBox.style.display = 'block'; // horrah weird Opera 9 input refresh!
      setTimeout("$('" + winId + "_sendBox').focus();", 125);
   },
   
   toggleUnderline: function() {
      var winId = this.getId();
      var sendBox = $(winId + '_sendBox');
      
      sendBox.style.display = 'none'; // horrah weird Opera 9 input refresh!
      if(sendBox.style.textDecoration == 'none') {
         sendBox.style.textDecoration = 'underline';
         $(winId + '_underline').src = 'images/' + windowCSS + '/underline_on.png';
      } else {
         sendBox.style.textDecoration = 'none';
         $(winId + '_underline').src = 'images/' + windowCSS + '/underline_off.png';
      }
      sendBox.style.display = 'block'; // horrah weird Opera 9 input refresh!
      setTimeout("$('" + winId + "_sendBox').focus();", 125);
   },

   toggleFontList: function() {
      var fL = $('fontsList');
      var fLBtn = $(this.getId() + '_setFont');
      
      $('emoticonList', 'fontSizeList', 'fontColorList').invoke('hide');

      if(fL.style.display == 'block') {
         fL.hide();
      } else {
         fL.setStyle({left:    Position.cumulativeOffset(fLBtn)[0] + 'px',
                      top:     (Position.cumulativeOffset(fLBtn)[1] - Element.getHeight(fL)) + 'px',
                      zIndex:  Windows.maxZIndex + 20,
                      display: 'block'});

         IM.active = this;
      }
   },
   
   toggleFontSizeList: function() {
      var fsL = $('fontSizeList');
      var fsLBtn = $(this.getId() + '_setFontSize');
      
      $('emoticonList', 'fontsList', 'fontColorList').invoke('hide');
      
      if(fsL.style.display == 'block') {
         fsL.hide();
      } else {
         fsL.setStyle({left:    Position.cumulativeOffset(fsLBtn)[0] + 'px',
                       top:     (Position.cumulativeOffset(fsLBtn)[1] - Element.getHeight(fsL)) + 'px',
                       zIndex:  Windows.maxZIndex + 20,
                       display: 'block'});

         IM.active = this;
      }
   },
   
   toggleEmoticonList: function() {
      var eL = $('emoticonList');
      var eLBtn = $(this.getId() + '_insertEmoticon');
      
      $('fontsList', 'fontSizeList', 'fontColorList').invoke('hide');
      
      if(eL.style.display == 'block') {
         eL.hide();
      } else {
         eL.setStyle({left:   (Position.cumulativeOffset(eLBtn)[0] - Element.getWidth(eL) + Element.getWidth(eLBtn)) + 'px',
                      top:    (Position.cumulativeOffset(eLBtn)[1] - Element.getHeight(eL)) + 'px',
                      zIndex: Windows.maxZIndex + 20,
                      display: 'block'});

         IM.active = this;
      }
   },
   
   toggleFontColorList: function() {
      var fcL = $('fontColorList');
      var fcLBtn = $(this.getId() + '_setFontColor');

      $('fontsList', 'fontSizeList', 'emoticonList').invoke('hide');
      
      if(fcL.style.display == 'block') {
         fcL.hide();
      } else {
         fcL.setStyle({left:   (Position.cumulativeOffset(fcLBtn)[0] - Element.getWidth(fcL) + Element.getWidth(fcLBtn)) + 'px',
                       top:    (Position.cumulativeOffset(fcLBtn)[1] - Element.getHeight(fcL)) + 'px',
                       zIndex: Windows.maxZIndex + 20,
                       display: 'block'});

         IM.active = this;
      }
   },

   setFont: function(fontname) {
      var winId = this.getId();
      var sendBox = $(winId + '_sendBox');

      sendBox.style.display = 'none';
      sendBox.style.fontFamily = fontname + ', sans-serif';
      $(winId + '_setFont').innerHTML = fontname;
      sendBox.style.display = 'block';
      setTimeout("$('" + winId + "_sendBox').focus();", 125);
      this.toggleFontList('');
   },
   
   setFontSize: function(size) {
      var winId = this.getId();
      var sendBox = $(winId + '_sendBox');
      
      sendBox.style.display = 'none';
      sendBox.style.fontSize = size + 'px';
      $(winId + '_setFontSize').innerHTML = size;
      sendBox.style.display = 'block';
      setTimeout("$('" + winId + "_sendBox').focus();", 125);
      this.toggleFontSizeList('');
   },
   
   setFontColor: function(color) {
      var winId = this.getId();
      var sendBox = $(winId + '_sendBox');
      
      sendBox.style.color = color;
      $(winId + '_setFontColorColor').style.backgroundColor = color;
      setTimeout("$('" + winId + "_sendBox').focus();", 125);
      this.toggleFontColorList('');
   },
   
   insertText: function(tti) {
      var winId = this.getId();
      var sendBox = $(winId + '_sendBox');
      
      sendBox.value += tti;
      setTimeout("$('" + winId + "_sendBox').focus();", 125);
      this.toggleEmoticonList();
      return false;
   },

   keyHandler: function(e) {
      var asc = document.all ? event.keyCode : e.which;
      
      if(asc == 13) {
         this.send();
         return false;
      }
      
      return true;
   }
});