/*
   SoundManager 2: Javascript Sound for the Web
   --------------------------------------------
   http://www.schillmania.com/projects/soundmanager2/

   Copyright (c) 2007, Scott Schiller. All rights reserved.
   Code licensed under the BSD License:
   http://www.schillmania.com/projects/soundmanager2/license.txt

   V2.0b.20070415
*/
function SoundManager(B,A){var C=this;this.version="V2.0b.20070415";this.url=(B||"soundmanager2.swf");this.debugMode=false;this.useConsole=true;this.consoleOnly=false;this.nullURL="data/null.mp3";this.defaultOptions={"autoLoad":false,"stream":true,"autoPlay":false,"onid3":null,"onload":null,"whileloading":null,"onplay":null,"whileplaying":null,"onstop":null,"onfinish":null,"onbeforefinish":null,"onbeforefinishtime":5000,"onbeforefinishcomplete":null,"onjustbeforefinish":null,"onjustbeforefinishtime":200,"multiShot":true,"pan":0,"volume":100};this.allowPolling=true;this.enabled=false;this.o=null;this.id=(A||"sm2movie");this.oMC=null;this.sounds=[];this.soundIDs=[];this.isIE=(navigator.userAgent.match(/MSIE/));this.isSafari=(navigator.userAgent.match(/safari/i));this.debugID="soundmanager-debug";this._debugOpen=true;this._didAppend=false;this._appendSuccess=false;this._didInit=false;this._disabled=false;this._hasConsole=(typeof console!="undefined"&&typeof console.log!="undefined");this._debugLevels=!C.isSafari?["debug","info","warn","error"]:["log","log","log","log"];this.getMovie=function(D){return C.isIE?window[D]:(C.isSafari?document[D+"-embed"]:document.getElementById(D+"-embed"))};this.loadFromXML=function(D){try{C.o._loadFromXML(D)}catch(E){C._failSafely();return true}};this.createSound=function(D){if(!C._didInit){throw new Error("soundManager.createSound(): Not loaded yet - wait for soundManager.onload() before calling sound-related methods")}if(arguments.length==2){D={"id":arguments[0],"url":arguments[1]}}var E=C._mergeObjects(D);C._writeDebug('soundManager.createSound(): "<a href="#" onclick="soundManager.play(\''+E.id+'\');return false" title="play this sound">'+E.id+'</a>" ('+E.url+")",1);if(C._idCheck(E.id,true)){C._writeDebug("sound "+E.id+" already defined - exiting",2);return false}C.sounds[E.id]=new SMSound(C,E);C.soundIDs[C.soundIDs.length]=E.id;try{C.o._createSound(E.id,E.onjustbeforefinishtime)}catch(F){C._failSafely();return true}if(E.autoLoad||E.autoPlay){C.sounds[E.id].load(E)}if(E.autoPlay){C.sounds[E.id].playState=1}};this.destroySound=function(D){if(!C._idCheck(D)){return false}for(var E=C.soundIDs.length;E--;){if(C.soundIDs[E]==D){delete C.soundIDs[E];continue}}C.sounds[D].unload();delete C.sounds[D]};this.load=function(D,E){if(!C._idCheck(D)){return false}C.sounds[D].load(E)};this.unload=function(D){if(!C._idCheck(D)){return false}C.sounds[D].unload()};this.play=function(D,E){if(!C._idCheck(D)){if(typeof E!="Object"){E={url:E}}if(E&&E.url){C._writeDebug('soundController.play(): attempting to create "'+D+'"',1);E.id=D;C.createSound(E)}else{return false}}C.sounds[D].play(E)};this.start=this.play;this.setPosition=function(D,E){if(!C._idCheck(D)){return false}C.sounds[D].setPosition(E)};this.stop=function(D){if(!C._idCheck(D)){return false}C._writeDebug("soundManager.stop("+D+")",1);C.sounds[D].stop()};this.stopAll=function(){C._writeDebug("soundManager.stopAll()",1);for(var D in C.sounds){if(C.sounds[D] instanceof SMSound){C.sounds[D].stop()}}};this.pause=function(D){if(!C._idCheck(D)){return false}C.sounds[D].pause()};this.resume=function(D){if(!C._idCheck(D)){return false}C.sounds[D].resume()};this.togglePause=function(D){if(!C._idCheck(D)){return false}C.sounds[D].togglePause()};this.setPan=function(D,E){if(!C._idCheck(D)){return false}C.sounds[D].setPan(E)};this.setVolume=function(E,D){if(!C._idCheck(E)){return false}C.sounds[E].setVolume(D)};this.setPolling=function(D){if(!C.o||!C.allowPolling){return false}C._writeDebug("soundManager.setPolling("+D+")");C.o._setPolling(D)};this.disable=function(){if(C._disabled){return false}C._disabled=true;C._writeDebug("soundManager.disable(): Disabling all functions - future calls will return false.",1);for(var D=C.soundIDs.length;D--;){C._disableObject(C.sounds[C.soundIDs[D]])}C.initComplete();C._disableObject(C)};this.getSoundById=function(E,F){if(!E){throw new Error("SoundManager.getSoundById(): sID is null/undefined")}var D=C.sounds[E];if(!D&&!F){C._writeDebug('"'+E+'" is an invalid sound ID.',2)}return D};this.onload=function(){soundManager._writeDebug("<em>Warning</em>: soundManager.onload() is undefined.",2)};this.onerror=function(){};this._idCheck=this.getSoundById;this._disableObject=function(E){for(var D in E){if(typeof E[D]=="function"&&typeof E[D]._protected=="undefined"){E[D]=function(){return false}}}D=null};this._failSafely=function(){var F="http://www.macromedia.com/support/documentation/en/flashplayer/help/settings_manager04.html";var G="You may need to whitelist this location/domain eg. file:///C:/ or C:/ or mysite.com, or set ALWAYS ALLOW under the Flash Player Global Security Settings page. Note that this seems to apply only to file system viewing.";var E='<a href="'+F+'" title="'+G+'">view/edit</a>';var D='<a href="'+F+'" title="Flash Player Global Security Settings">FPGSS</a>';if(!C._disabled){C._writeDebug("soundManager: JS-&gt;Flash communication failed. Possible causes: flash/browser security restrictions ("+E+"), insufficient browser/plugin support, or .swf not found",2);C._writeDebug("Verify that the movie path of <em>"+C.url+'</em> is correct (<a href="'+C.url+'" title="If you get a 404/not found, fix it!">test link</a>)',1);if(C._didAppend){if(!document.domain){C._writeDebug("Loading from local file system? (document.domain appears to be null, this URL path may need to be added to 'trusted locations' in "+D+")",1);C._writeDebug("Possible security/domain restrictions ("+E+"), should work when served by http on same domain",1)}}C.disable()}};this._createMovie=function(F,E){if(C._didAppend&&C._appendSuccess){return false}if(window.location.href.indexOf("debug=1")+1){C.debugMode=true}C._didAppend=true;var J=['<object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="http://fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="16" height="16" id="'+F+'"><param name="movie" value="'+E+'"><param name="quality" value="high"><param name="allowScriptAccess" value="always" /></object>','<embed name="'+F+'-embed" id="'+F+'-embed" src="'+E+'" width="1" height="1" quality="high" allowScriptAccess="always" pluginspage="http://www.macromedia.com/go/getflashplayer" type="application/x-shockwave-flash"></embed>'];var M='<div id="'+C.debugID+'-toggle" style="position:fixed;_position:absolute;right:0px;bottom:0px;_top:0px;width:1.2em;height:1.2em;line-height:1.2em;margin:2px;padding:0px;text-align:center;border:1px solid #999;cursor:pointer;background:#fff;color:#333;z-index:706" title="Toggle SM2 debug console" onclick="soundManager._toggleDebug()">-</div>';var K='<div id="'+C.debugID+'" style="display:'+(C.debugMode&&((!C._hasConsole||!C.useConsole)||(C.useConsole&&C._hasConsole&&!C.consoleOnly))?"block":"none")+';opacity:0.85"></div>';var I="soundManager._createMovie(): appendChild/innerHTML set failed. Serving application/xhtml+xml MIME type? Browser may be enforcing strict rules, not allowing write to innerHTML. (PS: If so, this means your commitment to XML validation is going to break stuff now, because this part isn't finished yet. ;))";var G='<div style="position:absolute;left:-256px;top:-256px;width:1px;height:1px" class="movieContainer">'+J[C.isIE?0:1]+"</div>"+(C.debugMode&&((!C._hasConsole||!C.useConsole)||(C.useConsole&&C._hasConsole&&!C.consoleOnly))&&!document.getElementById(C.debugID)?"x"+K+M:"");var D=(document.body?document.body:document.getElementsByTagName("div")[0]);if(D){C.oMC=document.createElement("div");C.oMC.className="movieContainer";C.oMC.style.position="absolute";C.oMC.style.left="-256px";C.oMC.style.width="1px";C.oMC.style.height="1px";try{D.appendChild(C.oMC);C.oMC.innerHTML=J[C.isIE?0:1];C._appendSuccess=true}catch(L){throw new Error(I)}if(!document.getElementById(C.debugID)&&((!C._hasConsole||!C.useConsole)||(C.useConsole&&C._hasConsole&&!C.consoleOnly))){var N=document.createElement("div");N.id=C.debugID;N.style.display=(C.debugMode?"block":"none");if(C.debugMode){try{var H=document.createElement("div");D.appendChild(H);H.innerHTML=M}catch(L){throw new Error(I)}}D.appendChild(N)}D=null}C._writeDebug("-- SoundManager 2 Version "+C.version.substr(1)+" --",1);C._writeDebug('soundManager._createMovie(): trying to load <a href="'+E+'" title="Test this link (404=bad)">'+E+"</a>",1)};this._writeDebug=function(D,I){if(!C.debugMode){return false}if(C._hasConsole&&C.useConsole){console[C._debugLevels[I]||"log"](D);if(C.useConsoleOnly){return true}}var H="soundmanager-debug";try{var G=document.getElementById(H);if(!G){return false}var F=document.createElement("div");F.innerHTML=D;G.insertBefore(F,G.firstChild)}catch(E){}G=null};this._writeDebug._protected=true;this._writeDebugAlert=function(D){alert(D)};if(window.location.href.indexOf("debug=alert")+1){C.debugMode=true;C._writeDebug=C._writeDebugAlert}this._toggleDebug=function(){var E=document.getElementById(C.debugID);var D=document.getElementById(C.debugID+"-toggle");if(!E){return false}if(C._debugOpen){D.innerHTML="+";E.style.display="none"}else{D.innerHTML="-";E.style.display="block"}C._debugOpen=!C._debugOpen};this._toggleDebug._protected=true;this._debug=function(){C._writeDebug("soundManager._debug(): sounds by id/url:",0);for(var E=0,D=C.soundIDs.length;E<D;E++){C._writeDebug(C.sounds[C.soundIDs[E]].sID+" | "+C.sounds[C.soundIDs[E]].url,0)}};this._mergeObjects=function(E,D){var G=E;var F=(typeof D=="undefined"?C.defaultOptions:D);for(var H in F){if(typeof G[H]=="undefined"){G[H]=F[H]}}return G};this.createMovie=function(D){if(D){C.url=D}C._initMovie()};this._initMovie=function(){if(C.o){return false}C.o=C.getMovie(C.id);if(!C.o){C._createMovie(C.id,C.url);C.o=C.getMovie(C.id)}if(C.o){C._writeDebug("soundManager._initMovie(): Got "+C.o.nodeName+" element ("+(C._didAppend?"created via JS":"static HTML")+")",1)}};this.initComplete=function(){if(C._didInit){return false}C._didInit=true;C._writeDebug("-- SoundManager 2 "+(C._disabled?"failed to load":"loaded")+" ("+(C._disabled?"security/load error":"OK")+") --",1);if(C._disabled){C._writeDebug("soundManager.initComplete(): calling soundManager.onerror()",1);C.onerror.apply(window);return false}C._writeDebug("soundManager.initComplete(): calling soundManager.onload()",1);try{C.onload.apply(window)}catch(D){C._writeDebug("soundManager.onload() threw an exception: "+D.message,2);throw D}C._writeDebug("soundManager.onload() complete",1)};this.init=function(){if(window.removeEventListener){window.removeEventListener("load",C.beginInit,false)}else{if(window.detachEvent){window.detachEvent("onload",C.beginInit)}}try{C.o._externalInterfaceTest();C._writeDebug("Flash ExternalInterface call (JS -&gt; Flash) succeeded.",1);if(!C.allowPolling){C._writeDebug("Polling (whileloading/whileplaying support) is disabled.",1)}C.setPolling(true);C.enabled=true}catch(D){C._failSafely();C.initComplete();return false}C.initComplete()};this.beginDelayedInit=function(){setTimeout(C.beginInit,200)};this.beginInit=function(){C.createMovie();C._initMovie();setTimeout(C.init,1000)};this.destruct=function(){if(C.isSafari){for(var D=C.soundIDs.length;D--;){if(C.sounds[C.soundIDs[D]].readyState==1){C.sounds[C.soundIDs[D]].unload()}}}C.disable()}}function SMSound(C,B){var A=this;var D=C;this.sID=B.id;this.url=B.url;this.options=D._mergeObjects(B);this.id3={};A.resetProperties=function(E){A.bytesLoaded=null;A.bytesTotal=null;A.position=null;A.duration=null;A.durationEstimate=null;A.loaded=false;A.loadSuccess=null;A.playState=0;A.paused=false;A.readyState=0;A.didBeforeFinish=false;A.didJustBeforeFinish=false};A.resetProperties();this.load=function(E){A.loaded=false;A.loadSuccess=null;A.readyState=1;A.playState=(E.autoPlay||false);var F=D._mergeObjects(E);if(typeof F.url=="undefined"){F.url=A.url}try{D._writeDebug("loading "+F.url,1);D.o._load(A.sID,F.url,F.stream,F.autoPlay,F.whileloading?1:0)}catch(G){D._writeDebug("SMSound().load(): JS-&gt;Flash communication failed.",2)}};this.unload=function(){D._writeDebug('SMSound().unload(): "'+A.sID+'"');A.setPosition(0);D.o._unload(A.sID,D.nullURL);A.resetProperties()};this.play=function(F){if(!F){F={}}if(F.onfinish){A.options.onfinish=F.onfinish}if(F.onbeforefinish){A.options.onbeforefinish=F.onbeforefinish}if(F.onjustbeforefinish){A.options.onjustbeforefinish=F.onjustbeforefinish}var G=D._mergeObjects(F);if(A.playState==1){var E=G.multiShot;if(!E){D._writeDebug('SMSound.play(): "'+A.sID+'" already playing? (one-shot)',1);return false}else{D._writeDebug('SMSound.play(): "'+A.sID+'" already playing (multi-shot)',1)}}if(!A.loaded){if(A.readyState==0){D._writeDebug('SMSound.play(): .play() before load request. Attempting to load "'+A.sID+'"',1);G.stream=true;G.autoPlay=true;A.load(G)}else{if(A.readyState==2){D._writeDebug('SMSound.play(): Could not load "'+A.sID+'" - exiting',2);return false}else{D._writeDebug('SMSound.play(): "'+A.sID+'" is loading - attempting to play..',1)}}}else{D._writeDebug('SMSound.play(): "'+A.sID+'"')}if(A.paused){A.resume()}else{A.playState=1;A.position=(G.offset||0);if(G.onplay){G.onplay.apply(A)}A.setVolume(G.volume);A.setPan(G.pan);if(!G.autoPlay){D.o._start(A.sID,G.loop||1,A.position)}}};this.start=this.play;this.stop=function(E){if(A.playState==1){A.playState=0;A.paused=false;if(D.defaultOptions.onstop){D.defaultOptions.onstop.apply(A)}D.o._stop(A.sID)}};this.setPosition=function(E){D.o._setPosition(A.sID,E/1000,A.paused||!A.playState)};this.pause=function(){if(A.paused){return false}D._writeDebug("SMSound.pause()");A.paused=true;D.o._pause(A.sID)};this.resume=function(){if(!A.paused){return false}D._writeDebug("SMSound.resume()");A.paused=false;D.o._pause(A.sID)};this.togglePause=function(){D._writeDebug("SMSound.togglePause()");if(!A.playState){A.play({offset:A.position/1000});return false}if(A.paused){D._writeDebug("SMSound.togglePause(): resuming..");A.resume()}else{D._writeDebug("SMSound.togglePause(): pausing..");A.pause()}};this.setPan=function(E){if(typeof E=="undefined"){E=0}D.o._setPan(A.sID,E);A.options.pan=E};this.setVolume=function(E){if(typeof E=="undefined"){E=100}D.o._setVolume(A.sID,E);A.options.volume=E};this._whileloading=function(E,F,G){A.bytesLoaded=E;A.bytesTotal=F;A.duration=G;A.durationEstimate=parseInt((A.bytesTotal/A.bytesLoaded)*A.duration);if(A.readyState!=3&&A.options.whileloading){A.options.whileloading.apply(A)}};this._onid3=function(H,E){D._writeDebug('SMSound()._onid3(): "'+this.sID+'" ID3 data received.');var I=[];for(var G=0,F=H.length;G<F;G++){I[H[G]]=E[G]}A.id3=D._mergeObjects(A.id3,I);if(A.options.onid3){A.options.onid3.apply(A)}};this._whileplaying=function(E){if(isNaN(E)||E==null){return false}A.position=E;if(A.playState==1){if(A.options.whileplaying){A.options.whileplaying.apply(A)}if(A.loaded&&A.options.onbeforefinish&&A.options.onbeforefinishtime&&!A.didBeforeFinish&&A.duration-A.position<=A.options.onbeforefinishtime){D._writeDebug("duration-position &lt;= onbeforefinishtime: "+A.duration+" - "+A.position+" &lt= "+A.options.onbeforefinishtime+" ("+(A.duration-A.position)+")");A._onbeforefinish()}}};this._onload=function(E){E=(E==1?true:false);D._writeDebug('SMSound._onload(): "'+A.sID+'"'+(E?" loaded.":' failed to load (or loaded from cache - weird bug) - [<a href="'+A.url+'">test URL</a>]'));A.loaded=E;A.loadSuccess=E;A.readyState=E?3:2;if(A.options.onload){A.options.onload.apply(A)}};this._onbeforefinish=function(){if(!A.didBeforeFinish){A.didBeforeFinish=true;if(A.options.onbeforefinish){A.options.onbeforefinish.apply(A)}}};this._onjustbeforefinish=function(E){if(!A.didJustBeforeFinish){A.didJustBeforeFinish=true;if(A.options.onjustbeforefinish){A.options.onjustbeforefinish.apply(A)}}};this._onfinish=function(){D._writeDebug('SMSound._onfinish(): "'+A.sID+'"');A.playState=0;A.paused=false;if(A.options.onfinish){A.options.onfinish.apply(A)}if(A.options.onbeforefinishcomplete){A.options.onbeforefinishcomplete.apply(A)}A.setPosition(0);A.didBeforeFinish=false;A.didJustBeforeFinish=false}}