/*
 * Decompiled with CFR 0.152.
 */
package com.sina.sae.kvdb;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public abstract class DBBase {
    protected static final String DB_DRIVER = "org.apache.derby.jdbc.EmbeddedDriver";
    protected static final String DB_URL = "jdbc:derby:kvdb;";
    protected static final String DB_USER = "db_user";
    protected static final String DB_PASSWORD = "db_password";
    protected static Properties props = new Properties();

    protected void initDB() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Class.forName(DB_DRIVER).newInstance();
        props.put("user", DB_USER);
        props.put("password", DB_PASSWORD);
        props.put("create", "true");
    }

    protected Connection getConnection() throws SQLException {
        return DriverManager.getConnection(DB_URL, props);
    }

    protected ResultSet executeQuery(Connection conn, String staticSql) throws SQLException {
        Statement stmt = conn.createStatement();
        return stmt.executeQuery(staticSql);
    }

    protected int executeUpdate(Connection conn, String staticSql) throws SQLException {
        Statement stmt = conn.createStatement();
        return stmt.executeUpdate(staticSql);
    }

    public boolean checkTableExist(String tableName) throws SQLException {
        Connection conn = this.getConnection();
        ResultSet rs = conn.getMetaData().getTables(null, null, tableName, null);
        return rs.next();
    }

    protected void closeConnection(Connection conn) {
        if (conn == null) {
            return;
        }
        try {
            if (!conn.isClosed()) {
                conn.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

