/*
 * Decompiled with CFR 0.152.
 */
package com.sina.sae.kvdb;

import com.sina.sae.exception.BanCallException;
import com.sina.sae.kvdb.SaeKVUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class TransformUtil {
    private static final int FLAG_BYTEARR = 0;
    private static final int FLAG_LONG = 1;
    private static final int FLAG_DOUBLE = 2;
    private static final int FLAG_BOOLEAN = 3;
    private static final int FLAG_COMPRESSED = 8;
    private static final byte[] TRUE = "1".getBytes();
    private static final byte[] FALSE = "".getBytes();

    private TransformUtil() {
        throw new BanCallException("can not invoke TransformUtil constructor.");
    }

    public static byte[] compress(byte[] value) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(value.length);
        GZIPOutputStream gos = new GZIPOutputStream(bos);
        gos.write(value, 0, value.length);
        gos.finish();
        gos.close();
        return bos.toByteArray();
    }

    public static byte[] deCompress(byte[] buf) throws IOException {
        int count;
        GZIPInputStream gzi = new GZIPInputStream(new ByteArrayInputStream(buf));
        ByteArrayOutputStream bos = new ByteArrayOutputStream(buf.length);
        byte[] tmp = new byte[2048];
        while ((count = gzi.read(tmp)) != -1) {
            bos.write(tmp, 0, count);
        }
        buf = bos.toByteArray();
        gzi.close();
        return buf;
    }

    public static String encodeKey(String key) throws UnsupportedEncodingException {
        return URLEncoder.encode(key, "UTF-8");
    }

    public static String decodeKey(String key) throws UnsupportedEncodingException {
        return URLDecoder.decode(key, "UTF-8");
    }

    public static int setCompressFlag(int flag) {
        return flag |= 8;
    }

    public static int setDeCompressFlag(int flag) {
        return flag &= 0xF7;
    }

    public static boolean isUseDecompress(int flag) {
        int compressFlag = flag;
        return (compressFlag &= 8) == 8;
    }

    public static int getFlag(Object value) {
        if (value instanceof Long) {
            return 1;
        }
        if (value instanceof Double) {
            return 2;
        }
        if (value instanceof Boolean) {
            return 3;
        }
        if (value instanceof byte[]) {
            return 0;
        }
        return -1;
    }

    public static byte[] toBytes(Object value) {
        if (value instanceof Long) {
            Long longObject = (Long)value;
            return longObject.toString().getBytes();
        }
        if (value instanceof Double) {
            Double doubleObject = (Double)value;
            return doubleObject.toString().getBytes();
        }
        if (value instanceof Boolean) {
            Boolean booleanObject = (Boolean)value;
            return TransformUtil.encodeBooleanToBytes(booleanObject);
        }
        if (value instanceof byte[]) {
            byte[] buf = (byte[])value;
            return buf;
        }
        return null;
    }

    public static byte[] encodeLongToBytes(long value) {
        return TransformUtil.getBytes(value);
    }

    public static byte[] encodeDoubleToBytes(double value) {
        return TransformUtil.getBytes(Double.doubleToLongBits(value));
    }

    public static byte[] encodeBooleanToBytes(boolean value) {
        if (value) {
            return TRUE;
        }
        return FALSE;
    }

    public static <T> T toConcreteType(byte[] value, int flag) throws IOException, ClassNotFoundException {
        return SaeKVUtil.deserializable(value);
    }

    public static long decodeBytesToLong(byte[] value) {
        return TransformUtil.toLong(value);
    }

    public static double decodeBytesToDouble(byte[] value) {
        long longVlaue = TransformUtil.toLong(value);
        return Double.longBitsToDouble(longVlaue);
    }

    public static boolean decodeBytesToBoolean(byte[] value) {
        return value != null && value.length == 1;
    }

    private static byte[] getBytes(long value) {
        byte[] b = new byte[]{(byte)(value >> 56 & 0xFFL), (byte)(value >> 48 & 0xFFL), (byte)(value >> 40 & 0xFFL), (byte)(value >> 32 & 0xFFL), (byte)(value >> 24 & 0xFFL), (byte)(value >> 16 & 0xFFL), (byte)(value >> 8 & 0xFFL), (byte)(value >> 0 & 0xFFL)};
        return b;
    }

    private static long toLong(byte[] b) {
        return ((long)b[7] & 0xFFL) + (((long)b[6] & 0xFFL) << 8) + (((long)b[5] & 0xFFL) << 16) + (((long)b[4] & 0xFFL) << 24) + (((long)b[3] & 0xFFL) << 32) + (((long)b[2] & 0xFFL) << 40) + (((long)b[1] & 0xFFL) << 48) + (((long)b[0] & 0xFFL) << 56);
    }
}

