/*
 * Decompiled with CFR 0.152.
 */
package com.sina.sae.mail;

import com.sina.sae.mail.SaeMail;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class MailEngine
extends Authenticator {
    private SaeMail saeMail;
    private String userName;
    private String password;

    public MailEngine(SaeMail saeMail) {
        this.saeMail = saeMail;
    }

    protected PasswordAuthentication getPasswordAuthentication() {
        return new PasswordAuthentication(this.userName, this.password);
    }

    public boolean sendMail() throws Exception {
        Properties p = new Properties();
        p.put("mail.smtp.host", this.saeMail.getSmtpHost());
        p.put("mail.smtp.port", this.saeMail.getSmtpPort());
        p.put("mail.smtp.auth", "true");
        if (this.saeMail.getSmtpHost().equals("smtp.gmail.com")) {
            p.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        }
        this.password = this.saeMail.getSmtpPassword();
        this.userName = this.saeMail.getSmtpUsername();
        Session sendMailSession = Session.getDefaultInstance((Properties)p, (Authenticator)this);
        MimeMessage mailMessage = new MimeMessage(sendMailSession);
        InternetAddress from = new InternetAddress(this.saeMail.getFrom());
        mailMessage.setFrom((Address)from);
        String[] to = this.saeMail.getTo();
        InternetAddress[] ta = new InternetAddress[to.length];
        for (int i = 0; i < to.length; ++i) {
            ta[i] = new InternetAddress(to[i]);
        }
        mailMessage.addRecipients(Message.RecipientType.TO, (Address[])ta);
        String[] cc = this.saeMail.getCc();
        if (null != cc) {
            InternetAddress[] tc = new InternetAddress[cc.length];
            for (int i = 0; i < cc.length; ++i) {
                tc[i] = new InternetAddress(cc[i]);
            }
            mailMessage.addRecipients(Message.RecipientType.CC, (Address[])tc);
        }
        MimeMultipart mp = new MimeMultipart();
        mailMessage.setSubject(this.saeMail.getSubject());
        MimeBodyPart mbp1 = new MimeBodyPart();
        if (this.saeMail.getContentType().equals("TEXT")) {
            mbp1.setText(this.saeMail.getContent());
        } else {
            mbp1.setContent((Object)this.saeMail.getContent(), "text/html; charset=utf-8");
        }
        mp.addBodyPart((BodyPart)mbp1);
        for (String fn : this.saeMail.getAttrList()) {
            MimeBodyPart mbp2 = new MimeBodyPart();
            mbp2.attachFile(fn);
            mp.addBodyPart((BodyPart)mbp2);
        }
        mailMessage.setContent((Multipart)mp);
        Transport.send((Message)mailMessage);
        return true;
    }
}

