/*
 * Decompiled with CFR 0.152.
 */
package com.sina.sae.mail;

import com.sina.sae.mail.MailEngine;
import com.sina.sae.mail.SaeMailUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SaeMail {
    private static Logger logger = Logger.getLogger((String)SaeMail.class.getName());
    protected static final String DEFAULT_CHARTSET = "utf8";
    protected static final String DEFAULT_CONTENTTYPE = "TEXT";
    private static final int DEFAULT_PORT = 25;
    private static final int TITLE_MAX_SIZE = 256;
    private static final int TOTAL_MAX_SIZE = 0x100000;
    private static final List<String> suffix = Arrays.asList("bmp", "css", "csv", "gif", "htm", "html", "jpeg", "jpg", "jpe", "pdf", "png", "rss", "text", "txt", "asc", "diff", "pot", "tiff", "tif", "wbmp", "ics", "vcf");
    private static Map<String, Object[]> mailMap;
    private Integer attachSize = 0;
    private String errno = "0";
    private String errmsg = "Success";
    public static final String SAE_ErrSuccess = "0";
    public static final String SAE_ErrParameter = "3";
    public static final String SAE_ErrServer = "500";
    public static final String SAE_ErrUnknown = "999";
    public static final String SAE_ErrAuthority = "403";
    private String from;
    private String[] to;
    private String[] cc;
    private String smtpHost;
    private Integer smtpPort = 25;
    private String smtpUsername;
    private String smtpPassword;
    private String subject;
    private String content;
    private String contentType = "TEXT";
    private String chartset = "utf8";
    private boolean tls = false;
    private String compress;
    private String callbackUrl;
    private List<String> attrList = new ArrayList<String>();
    private String accesskey;
    private String secretkey;
    private String appName;

    public SaeMail() {
        this.init();
    }

    private void init() {
    }

    public boolean quickSend(String from, String[] to, String subject, String msgbody, String smtp_user, String smtp_pass, String smtp_host, Integer smtp_port, boolean smtp_tls) {
        this.setContent(msgbody);
        this.setFrom(from);
        this.setSmtpHost(smtp_host);
        this.setSmtpPassword(smtp_pass);
        this.setSmtpPort(smtp_port);
        this.setSmtpUsername(smtp_user);
        this.setSubject(subject);
        this.setTls(smtp_tls);
        this.setTo(to);
        return this.send();
    }

    private boolean validateSize() {
        int titleSize = this.subject.getBytes().length;
        if (titleSize > 256) {
            this.errno = SAE_ErrParameter;
            this.errmsg = "subject cannot larger than 256 bytes!";
            return false;
        }
        if (this.attachSize + this.content.getBytes().length > 0x100000) {
            this.errno = SAE_ErrParameter;
            this.errmsg = "mail cannot larger than 1048576 bytes!";
            return false;
        }
        return true;
    }

    private boolean validateParameter() {
        if (!SaeMailUtil.checkNull(this.from)) {
            this.errno = SAE_ErrParameter;
            this.errmsg = "parameters  from can not be empty!";
            return false;
        }
        if (!SaeMailUtil.checkNull(this.smtpPassword)) {
            this.errno = SAE_ErrParameter;
            this.errmsg = "parameters  smtpPassword can not be empty!";
            return false;
        }
        if (!SaeMailUtil.checkNull(this.content)) {
            this.errno = SAE_ErrParameter;
            this.errmsg = "parameters mail content can not be empty!";
            return false;
        }
        if (!SaeMailUtil.checkNull(this.smtpHost) && !this.genSmtpHost()) {
            this.errno = SAE_ErrParameter;
            this.errmsg = "parameters smtpHost can not be empty!";
            return false;
        }
        if (!SaeMailUtil.checkNull(this.smtpUsername)) {
            this.errno = SAE_ErrParameter;
            this.errmsg = "parameters smtpUsername can not be empty!";
            return false;
        }
        if (!SaeMailUtil.checkNull(this.subject)) {
            this.errno = SAE_ErrParameter;
            this.errmsg = "parameters mail subject can not be empty!";
            return false;
        }
        if (null == this.to || this.to.length == 0) {
            this.errno = SAE_ErrParameter;
            this.errmsg = "parameters to  can not be empty!";
            return false;
        }
        for (int i = 0; i < this.to.length; ++i) {
            if (SaeMailUtil.isMail(this.to[i])) continue;
            this.errno = SAE_ErrParameter;
            this.errmsg = "parameters to must be mail-address array!";
            return false;
        }
        return this.errno.equals(SAE_ErrSuccess);
    }

    private boolean genSmtpHost() {
        String key;
        String[] s;
        if (null != this.from && SaeMailUtil.isMail(this.from) && null != (s = this.from.split("@")) && s.length > 1 && mailMap.containsKey(key = s[s.length - 1])) {
            Object[] objs = mailMap.get(key);
            if (this.smtpHost == null) {
                this.setSmtpHost((String)objs[0]);
                if ("gmail.com".equals(key)) {
                    this.setSmtpPort((Integer)objs[1]);
                }
                return true;
            }
        }
        return false;
    }

    public boolean quickSend(String from, String[] to, String subject, String msgbody, String smtp_user, String smtp_pass) {
        return this.quickSend(from, to, subject, msgbody, smtp_user, smtp_pass, null, this.getSmtpPort(), this.getTls());
    }

    public synchronized boolean send() {
        if (!this.validateParameter() || !this.validateSize()) {
            logger.error((Object)this.getErrmsg());
            return false;
        }
        try {
            return new MailEngine(this).sendMail();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.callback();
            if (this.errno == SAE_ErrSuccess) {
                this.errno = SAE_ErrParameter;
                this.errmsg = "error parameter!";
            }
            logger.error((Object)("#ERROR:Send mail fail,mail subject is: " + this.subject + " !"));
            return false;
        }
    }

    private void callback() {
        if (null != this.callbackUrl) {
            StringBuilder param = new StringBuilder();
            param.append("timestamp=").append(SaeMailUtil.getCurrentTimestamp()).append("&from=").append(this.from).append("&to=");
            for (int i = 0; i < this.to.length; ++i) {
                param.append(this.to[i]).append(",");
            }
            param.substring(0, param.length() - 1);
            logger.error((Object)SaeMailUtil.sendPost(this.callbackUrl, param.toString()));
        }
    }

    public boolean setAttach(String[] file) {
        if (null != file && file.length > 0) {
            for (int i = 0; i < file.length; ++i) {
                try {
                    String fn = file[i];
                    String[] suf = fn.split("\\.");
                    if (suf == null || suf.length < 2 || !suffix.contains(suf[suf.length - 1])) {
                        this.errno = SAE_ErrParameter;
                        this.errmsg = "attach file suffix " + suf[suf.length - 1] + " is not allowed!";
                        logger.error((Object)this.getErrmsg());
                        return false;
                    }
                    byte[] b = SaeMailUtil.getFileContent(fn);
                    if (b == null) {
                        this.errno = SAE_ErrParameter;
                        this.errmsg = "attach file parameter is lawless!";
                        logger.error((Object)this.getErrmsg());
                        return false;
                    }
                    this.attachSize = this.attachSize + b.length;
                    this.attrList.add(fn);
                    continue;
                }
                catch (Exception e) {
                    this.errno = SAE_ErrParameter;
                    this.errmsg = "attach file parameter is lawless!";
                    logger.error((Object)("attach file parameter is lawless :" + e.getMessage()));
                    return false;
                }
            }
            return true;
        }
        this.errno = SAE_ErrParameter;
        this.errmsg = "attach file parameter is lawless!";
        logger.error((Object)"attach file parameter is lawless ");
        return false;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setTo(String[] to) {
        this.to = to;
    }

    public void setCc(String[] cc) {
        this.cc = cc;
    }

    public void setSmtpHost(String smtpHost) {
        this.smtpHost = smtpHost;
    }

    public void setSmtpPort(Integer smtpPort) {
        this.smtpPort = smtpPort;
    }

    public void setSmtpUsername(String smtpUsername) {
        this.smtpUsername = smtpUsername;
    }

    public void setSmtpPassword(String smtpPassword) {
        this.smtpPassword = smtpPassword;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType.equalsIgnoreCase("HTML") ? "HTML" : DEFAULT_CONTENTTYPE;
    }

    public SaeMail clean() {
        this.setCc(null);
        this.setChartset(DEFAULT_CHARTSET);
        this.setCompress(null);
        this.setContent(null);
        this.setContentType(DEFAULT_CONTENTTYPE);
        this.setFrom(null);
        this.setSmtpHost(null);
        this.setSmtpPassword(null);
        this.setSmtpPort(25);
        this.setSmtpUsername(null);
        this.setSubject(null);
        this.setTls(false);
        this.setTo(null);
        this.setCallbackUrl(null);
        this.attachSize = 0;
        this.errno = SAE_ErrSuccess;
        this.errmsg = "Success";
        this.attrList.clear();
        return this;
    }

    public void setChartset(String chartset) {
        this.chartset = chartset;
    }

    public void setTls(boolean tls) {
        this.tls = tls;
    }

    public void setCompress(String compress) {
        this.compress = compress;
    }

    protected String getAccesskey() {
        return this.accesskey;
    }

    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    protected String getSecretkey() {
        return this.secretkey;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getFrom() {
        return this.from;
    }

    public String[] getTo() {
        return this.to;
    }

    public String[] getCc() {
        return this.cc;
    }

    public String getSmtpHost() {
        return this.smtpHost;
    }

    public Integer getSmtpPort() {
        return this.smtpPort;
    }

    public String getSmtpUsername() {
        return this.smtpUsername;
    }

    public String getSmtpPassword() {
        return this.smtpPassword;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getContent() {
        return this.content;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getChartset() {
        return this.chartset;
    }

    public boolean getTls() {
        return this.tls;
    }

    public String getCompress() {
        return this.compress;
    }

    protected List<String> getAttrList() {
        return this.attrList;
    }

    public String getErrno() {
        return this.errno;
    }

    public String getErrmsg() {
        return this.errmsg;
    }

    static {
        if (null == mailMap) {
            mailMap = new HashMap<String, Object[]>();
            mailMap.put("sina.com", new Object[]{"smtp.sina.com", 25, 0});
            mailMap.put("sina.cn", new Object[]{"smtp.sina.cn", 25, 0});
            mailMap.put("163.com", new Object[]{"smtp.163.com", 25, 0});
            mailMap.put("263.com", new Object[]{"smtp.263.com", 25, 0});
            mailMap.put("gmail.com", new Object[]{"smtp.gmail.com", 465, 1});
            mailMap.put("sohu.com", new Object[]{"smtp.sohu.com", 25, 0});
            mailMap.put("qq.com", new Object[]{"smtp.qq.com", 25, 0});
            mailMap.put("vip.qq.com", new Object[]{"smtp.qq.com", 25, 0});
            mailMap.put("126.com", new Object[]{"smtp.126.com", 25, 0});
        }
    }
}

