/*
 * Decompiled with CFR 0.152.
 */
package com.sina.sae.memcached;

import com.sina.sae.memcached.ConsistentHash;
import com.sina.sae.memcached.CreateConnectorException;
import com.sina.sae.memcached.GetConnectorException;
import com.sina.sae.memcached.RecoveryConnectorException;
import com.sina.sae.memcached.TransformUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public class ConnectorPool {
    private static final Logger logger = Logger.getLogger((String)ConnectorPool.class.getName());
    private static final ConnectorPool INSTANCE = new ConnectorPool();
    private static final String FLUSH_ALL = "flush_all\r\n";
    private static final String OK = "OK";
    private static final String END = "END";
    private static final String VALUE = "VALUE";
    private static final String ERROR = "ERROR";
    private static final String STATS_CRLF = "stats\r\n";
    private static final String STAT = "STAT";
    static final int MAX_SLOT_NUM = 4;
    private ConsistentHash consistentHash;
    private Slot[] slots;
    private boolean initialized = false;

    private ConnectorPool() {
    }

    public static final ConnectorPool getInstance() {
        return INSTANCE;
    }

    public synchronized void initialize(String[] ips) {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.slots = new Slot[ips.length];
        for (int i = 0; i < this.slots.length; ++i) {
            this.slots[i] = new Slot(i);
        }
        for (int ipNum = 0; ipNum < ips.length; ++ipNum) {
            String[] nodes = ips[ipNum].split(":");
            String remoteIp = nodes[0];
            String remotePort = nodes[1];
            for (int i = 0; i < 4; ++i) {
                Connector conn = new Connector(remoteIp, remotePort, ipNum);
                try {
                    this.slots[ipNum].put(conn);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    logger.error((Object)"interrput", (Throwable)e);
                }
            }
        }
        ArrayList<Slot> slotList = new ArrayList<Slot>();
        for (Slot s : this.slots) {
            slotList.add(s);
        }
        this.consistentHash = new ConsistentHash(slotList);
    }

    public Connector getConnector(String key) {
        Slot slot = this.consistentHash.getPrimary(key);
        Connector conn = null;
        try {
            conn = slot.take();
        }
        catch (InterruptedException e) {
            logger.error((Object)"interrupt", (Throwable)e);
            Thread.currentThread().interrupt();
            throw new GetConnectorException(e.getMessage());
        }
        return conn;
    }

    public Connector[] getAllConnector() {
        int len = this.slots.length;
        Connector[] connectors = new Connector[len];
        for (int i = 0; i < len; ++i) {
            try {
                connectors[i] = this.slots[i].take();
                continue;
            }
            catch (InterruptedException e) {
                logger.error((Object)"interrupt", (Throwable)e);
                Thread.currentThread().interrupt();
                throw new GetConnectorException(e.getMessage());
            }
        }
        return connectors;
    }

    public boolean RecoveryConnector(Connector conn) {
        if (conn == null) {
            return false;
        }
        int index = conn.getRelationSlot();
        try {
            this.slots[index].put(conn);
        }
        catch (InterruptedException e) {
            logger.error((Object)"interrput", (Throwable)e);
            Thread.currentThread().interrupt();
            throw new RecoveryConnectorException(e.getMessage());
        }
        return true;
    }

    public static class FlushFuture
    implements Callable<Boolean> {
        private final Connector connector;

        FlushFuture(Connector connector) {
            this.connector = connector;
        }

        @Override
        public Boolean call() throws Exception {
            this.connector.send(ConnectorPool.FLUSH_ALL.getBytes());
            String line = this.connector.readLine();
            if (ConnectorPool.OK.equals(line)) {
                return Boolean.TRUE;
            }
            this.connector.close();
            return Boolean.FALSE;
        }
    }

    public static class StatsFuture
    implements Callable<Map<String, Object>> {
        private final Connector connector;

        StatsFuture(Connector connector) {
            this.connector = connector;
        }

        @Override
        public Map<String, Object> call() throws Exception {
            this.connector.send(ConnectorPool.STATS_CRLF.getBytes());
            HashMap<String, Object> map = new HashMap<String, Object>();
            while (true) {
                String line;
                if ((line = this.connector.readLine()).startsWith(ConnectorPool.STAT)) {
                    String[] info = line.split(" ");
                    String key = info[1];
                    String value = info[2];
                    Object obj = null;
                    try {
                        obj = new Long(value);
                    }
                    catch (NumberFormatException e) {
                        try {
                            obj = new Double(value);
                        }
                        catch (NumberFormatException ex) {
                            obj = value;
                        }
                    }
                    map.put(key, obj);
                    continue;
                }
                if (ConnectorPool.END.equals(line)) break;
            }
            this.connector.close();
            return map;
        }
    }

    public static final class ConnectorFuture
    implements Callable<Map<String, Object>> {
        private final Connector connector;
        private final String keys;

        ConnectorFuture(Connector connector, String keys) {
            this.connector = connector;
            this.keys = keys;
        }

        @Override
        public Map<String, Object> call() throws Exception {
            HashMap<String, Object> map;
            block5: {
                map = new HashMap<String, Object>();
                this.connector.send(this.keys.getBytes());
                while (true) {
                    String line;
                    if ((line = this.connector.readLine()).startsWith(ConnectorPool.VALUE)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("receive line:" + line));
                        }
                        String[] info = line.split(" ");
                        String key = info[1];
                        int flag = Integer.parseInt(info[2]);
                        int length = Integer.parseInt(info[3]);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("flag:" + flag));
                            logger.debug((Object)("data length:" + length));
                        }
                        byte[] buf = new byte[length];
                        this.connector.read(buf);
                        this.connector.readEOF();
                        if (TransformUtil.isUseDecompress(flag)) {
                            flag = TransformUtil.setDeCompressFlag(flag);
                            buf = TransformUtil.deCompress(buf);
                        }
                        Object value = TransformUtil.toConcreteType(buf, flag);
                        map.put(key, value);
                        continue;
                    }
                    if (ConnectorPool.END.equals(line)) break block5;
                    if (ConnectorPool.ERROR.equals(line)) break;
                }
                logger.error((Object)"get multi error,");
            }
            this.connector.close();
            return map;
        }
    }

    public static class Connector {
        private int index;
        private Socket socket;
        private OutputStream output;
        private InputStream input;

        public Connector(String ip, String port, int index) {
            this.index = index;
            try {
                this.socket = new Socket(ip, Integer.parseInt(port));
                this.socket.setTcpNoDelay(true);
                this.output = this.socket.getOutputStream();
                this.input = this.socket.getInputStream();
            }
            catch (UnknownHostException e) {
                logger.error((Object)"unknown host.", (Throwable)e);
                throw new CreateConnectorException(e.getMessage());
            }
            catch (IOException e) {
                logger.error((Object)"execute create connector failure.", (Throwable)e);
                throw new CreateConnectorException(e.getMessage());
            }
        }

        public Connector(String ip, String port) {
            try {
                this.socket = new Socket(ip, Integer.parseInt(port));
                this.socket.setTcpNoDelay(true);
                this.output = this.socket.getOutputStream();
                this.input = this.socket.getInputStream();
            }
            catch (UnknownHostException e) {
                logger.error((Object)"unknown host.", (Throwable)e);
                throw new CreateConnectorException(e.getMessage());
            }
            catch (IOException e) {
                logger.error((Object)"execute create connector failure.", (Throwable)e);
                throw new CreateConnectorException(e.getMessage());
            }
        }

        public void send(byte[] buf) {
            try {
                this.output.write(buf);
            }
            catch (IOException e) {
                logger.error((Object)"send data failure.", (Throwable)e);
            }
        }

        public String readLine() throws IOException {
            byte[] b = new byte[1];
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            boolean eol = false;
            while (this.input.read(b) != -1) {
                if (b[0] == 13) {
                    eol = true;
                } else if (eol) {
                    if (b[0] == 10) break;
                    eol = false;
                }
                bos.write(b, 0, 1);
            }
            if (bos == null || bos.size() <= 0) {
                throw new IOException("++++ Stream appears to be dead, so closing it down");
            }
            return bos.toString().trim();
        }

        public void read(byte[] buf) throws IOException {
            this.input.read(buf);
        }

        public void readEOF() throws IOException {
            byte[] b = new byte[1];
            boolean eol = false;
            while (this.input.read(b) != -1) {
                if (b[0] == 13) {
                    eol = true;
                    continue;
                }
                if (!eol) continue;
                if (b[0] == 10) break;
                eol = false;
            }
        }

        public int getRelationSlot() {
            return this.index;
        }

        public int getRemotePort() {
            return this.socket.getPort();
        }

        public String getRemoteIp() {
            InetSocketAddress ia = (InetSocketAddress)this.socket.getRemoteSocketAddress();
            return ia.getHostName();
        }

        public void close() throws IOException {
            this.output.write("quit\r\n".getBytes());
            this.socket.close();
        }

        public String toString() {
            return "local:" + this.socket.getLocalAddress() + ":" + this.socket.getLocalPort() + "\tremote:" + this.socket.getRemoteSocketAddress();
        }

        protected void finalize() throws Throwable {
            if (!this.socket.isClosed()) {
                this.socket.close();
            }
        }
    }

    public static class Slot {
        private Connector[] slot = new Connector[4];
        private int index = 0;
        private final Lock LOCK = new ReentrantLock();
        private final Condition EMPTY = this.LOCK.newCondition();
        private final Condition FULL = this.LOCK.newCondition();
        private int bufferNumber = 0;
        private int pos = 0;

        public Slot(int index) {
            this.index = index;
        }

        public String getName() {
            return "slot-" + this.index;
        }

        public int getSlotNumber() {
            return this.index;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void put(Connector x) throws InterruptedException {
            try {
                this.LOCK.lock();
                ++this.bufferNumber;
                if (this.bufferNumber <= 4 || this.pos <= 3) ** GOTO lbl11
                try {
                    x.close();
                    return;
                }
                catch (IOException e) {
                    ConnectorPool.access$000().error((Object)"connector is full,close current connector.", (Throwable)e);
lbl11:
                    // 2 sources

                    if (this.bufferNumber > 4) {
                        this.FULL.await();
                    }
                    this.doInsert(x);
                    this.EMPTY.signalAll();
                }
            }
            finally {
                this.LOCK.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Connector take() throws InterruptedException {
            try {
                Connector item;
                this.LOCK.lock();
                --this.bufferNumber;
                if (this.bufferNumber < 0) {
                    while (this.pos <= 0) {
                        this.EMPTY.await();
                    }
                }
                Connector connector = item = this.doExtract();
                return connector;
            }
            finally {
                this.LOCK.unlock();
            }
        }

        private synchronized void doInsert(Connector x) {
            this.slot[this.pos++] = x;
        }

        private synchronized Connector doExtract() {
            Connector x = this.slot[--this.pos];
            this.slot[this.pos] = null;
            return x;
        }

        public String toString() {
            return "slot-" + this.index;
        }
    }
}

