/*
 * Decompiled with CFR 0.152.
 */
package com.sina.sae.memcached;

import com.sina.sae.exception.BanCallException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class TransformUtil {
    private static final int FLAG_BOOLEAN = 1;
    private static final int FLAG_BYTE = 2;
    private static final int FLAG_SHORT = 3;
    private static final int FLAG_CHAR = 4;
    private static final int FLAG_INT = 5;
    private static final int FLAG_LONG = 6;
    private static final int FLAG_FLOAT = 7;
    private static final int FLAG_DOUBLE = 8;
    private static final int FLAG_STRING = 9;
    private static final int FLAG_BYTEARR = 10;
    private static final int FLAG_OBJ = 11;
    private static final int FLAG_COMPRESSED = 16;

    private TransformUtil() {
        throw new BanCallException("can not invoke TransformUtil constructor.");
    }

    public static byte[] compress(byte[] value) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(value.length);
        GZIPOutputStream gos = new GZIPOutputStream(bos);
        gos.write(value, 0, value.length);
        gos.finish();
        gos.close();
        return bos.toByteArray();
    }

    public static byte[] deCompress(byte[] buf) throws IOException {
        int count;
        GZIPInputStream gzi = new GZIPInputStream(new ByteArrayInputStream(buf));
        ByteArrayOutputStream bos = new ByteArrayOutputStream(buf.length);
        byte[] tmp = new byte[2048];
        while ((count = gzi.read(tmp)) != -1) {
            bos.write(tmp, 0, count);
        }
        buf = bos.toByteArray();
        gzi.close();
        return buf;
    }

    public static String encodeKey(String key) throws UnsupportedEncodingException {
        return URLEncoder.encode(key, "UTF-8");
    }

    public static int setCompressFlag(int flag) {
        return flag |= 0x10;
    }

    public static int setDeCompressFlag(int flag) {
        return flag &= 0xEF;
    }

    public static boolean isUseDecompress(int flag) {
        int compressFlag = flag;
        return (compressFlag &= 0x10) == 16;
    }

    public static int getFlag(Object value) {
        if (value instanceof Boolean) {
            return 1;
        }
        if (value instanceof Byte) {
            return 2;
        }
        if (value instanceof Short) {
            return 3;
        }
        if (value instanceof Character) {
            return 4;
        }
        if (value instanceof Integer) {
            return 5;
        }
        if (value instanceof Long) {
            return 6;
        }
        if (value instanceof Float) {
            return 7;
        }
        if (value instanceof Double) {
            return 8;
        }
        if (value instanceof String) {
            return 9;
        }
        if (value instanceof byte[]) {
            return 10;
        }
        if (value instanceof Object) {
            return 11;
        }
        return -1;
    }

    public static byte[] toBytes(Object value) throws IOException {
        if (value instanceof Boolean) {
            Boolean booleanObject = (Boolean)value;
            return booleanObject.toString().getBytes();
        }
        if (value instanceof Byte) {
            Byte byteObject = (Byte)value;
            return byteObject.toString().getBytes();
        }
        if (value instanceof Short) {
            Short shortObject = (Short)value;
            return shortObject.toString().getBytes();
        }
        if (value instanceof Character) {
            Character charObject = (Character)value;
            char i = charObject.charValue();
            Integer intObject = i;
            return intObject.toString().getBytes();
        }
        if (value instanceof Integer) {
            Integer intObject = (Integer)value;
            return intObject.toString().getBytes();
        }
        if (value instanceof Long) {
            Long longObject = (Long)value;
            return longObject.toString().getBytes();
        }
        if (value instanceof Float) {
            Float floatObject = (Float)value;
            return floatObject.toString().getBytes();
        }
        if (value instanceof Double) {
            Double doubleObject = (Double)value;
            return doubleObject.toString().getBytes();
        }
        if (value instanceof String) {
            String str = (String)value;
            return str.getBytes();
        }
        if (value instanceof byte[]) {
            byte[] buf = (byte[])value;
            return buf;
        }
        if (value instanceof Object) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            new ObjectOutputStream(bos).writeObject(value);
            return bos.toByteArray();
        }
        return null;
    }

    public static <T> T toConcreteType(byte[] value, int flag) throws IOException, ClassNotFoundException {
        if (1 == flag) {
            return (T)Boolean.valueOf(new String(value));
        }
        if (2 == flag) {
            return (T)Byte.valueOf(new String(value));
        }
        if (3 == flag) {
            return (T)Short.valueOf(new String(value));
        }
        if (4 == flag) {
            int i = Integer.valueOf(new String(value));
            char c = (char)i;
            return (T)Character.valueOf(c);
        }
        if (5 == flag) {
            try {
                return (T)Integer.valueOf(new String(value));
            }
            catch (Exception e) {
                return (T)Integer.valueOf(0);
            }
        }
        if (6 == flag) {
            return (T)Long.valueOf(new String(value));
        }
        if (7 == flag) {
            return (T)Float.valueOf(new String(value));
        }
        if (8 == flag) {
            return (T)Double.valueOf(new String(value));
        }
        if (9 == flag) {
            return (T)new String(value);
        }
        if (10 == flag) {
            return (T)value;
        }
        if (11 == flag) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            DeserializableObject ois = new DeserializableObject(new ByteArrayInputStream(value), loader);
            return (T)ois.readObject();
        }
        return null;
    }

    private static class DeserializableObject
    extends ObjectInputStream {
        private ClassLoader loader;

        DeserializableObject(InputStream in, ClassLoader loader) throws IOException {
            super(in);
            this.loader = loader;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            return Class.forName(desc.getName(), true, this.loader);
        }
    }
}

