/*
 * Decompiled with CFR 0.152.
 */
package com.sina.sae.storage;

import com.sina.sae.storage.DataInfo;
import com.sina.sae.storage.DirRowInfo;
import com.sina.sae.storage.DomainAttribute;
import com.sina.sae.storage.FileAttribute;
import com.sina.sae.storage.FileRowInfo;
import com.sina.sae.storage.StorageUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SaeStorage {
    private static final String ERROR_MSG_101 = "the value of parameter (domain,filename) can not be empty!";
    private static final int ERROR_NUM_101 = -101;
    private static final String ERROR_MSG_102 = "bad request";
    private static final int ERROR_NUM_102 = -102;
    private static Logger logger = Logger.getLogger((String)SaeStorage.class.getName());
    private String accessKey;
    private String secretKey;
    private String saeTempPath;
    private String appName;
    private String errMsg = "success!";
    private int errNo = 0;
    private String fileSep = System.getProperty("file.separator");

    public SaeStorage() {
        this.saeTempPath = System.getProperty("java.io.tmpdir") + this.fileSep + "SaeStoageDir" + this.fileSep;
    }

    public SaeStorage(String accessKey, String secretKey, String appName, String saeTempPath) {
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.appName = appName;
        this.saeTempPath = saeTempPath;
    }

    public SaeStorage(String accessKey, String secretKey, String appName) {
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.appName = appName;
        this.saeTempPath = System.getProperty("java.io.tmpdir") + this.fileSep + "SaeStoageDir" + this.fileSep;
    }

    private boolean checkParameter(String parm1, String parm2) {
        if (parm1 == null | parm2 == null) {
            this.errMsg = ERROR_MSG_101;
            this.errNo = -101;
            return false;
        }
        return true;
    }

    private boolean checkParameter(String parm) {
        if (parm == null) {
            this.errMsg = ERROR_MSG_101;
            this.errNo = -101;
            return false;
        }
        return true;
    }

    public boolean delete(String domain, String fileName) {
        if (!this.checkParameter(domain, fileName)) {
            return false;
        }
        String name = StorageUtil.formatFileName(fileName);
        String filename = this.saeTempPath + this.fileSep + this.appName + this.fileSep + domain + this.fileSep + name;
        File myfile = new File(filename);
        return myfile.delete();
    }

    private boolean myDeleteDirectory(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    this.myDeleteDirectory(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        return path.delete();
    }

    @Deprecated
    public boolean deleteFolder(String domain, String path) {
        throw new UnsupportedOperationException("please invoke delete() method.");
    }

    public String getErrmsg() {
        return this.errMsg;
    }

    public int getErrno() {
        return this.errNo;
    }

    public boolean fileExists(String domain, String fileName) {
        if (!this.checkParameter(domain, fileName)) {
            return false;
        }
        String name = StorageUtil.formatFileName(fileName);
        String filename = this.saeTempPath + this.fileSep + this.appName + this.fileSep + domain + this.fileSep + name;
        File myfile = new File(filename);
        return myfile.exists();
    }

    public FileAttribute getAttr(String domain, String fileName) {
        return this.getAttr(domain, fileName, null);
    }

    public FileAttribute getAttr(String domain, String fileName, List<String> list) {
        if (!this.checkParameter(domain, fileName)) {
            new HashMap(0);
        }
        String name = StorageUtil.formatFileName(fileName);
        String domainName = this.saeTempPath + this.fileSep + this.appName + this.fileSep + domain + this.fileSep + name;
        return new FileAttribute();
    }

    private int myGetDirectorySize(String directory) {
        int size = 0;
        File f = new File(directory);
        if (!f.isDirectory()) {
            return Integer.parseInt(f.length() + "");
        }
        File[] subf = f.listFiles();
        for (int i = 0; i < subf.length; ++i) {
            if (subf[i].isDirectory()) {
                size += this.myGetDirectorySize(subf[i].toString());
                continue;
            }
            size = (int)((long)size + subf[i].length());
        }
        return size;
    }

    private int myGetDirectoryFileNumber(String directory) {
        int number = 0;
        File f = new File(directory);
        if (!f.isDirectory()) {
            if (f.exists()) {
                return 1;
            }
            return 0;
        }
        File[] subf = f.listFiles();
        for (int i = 0; i < subf.length; ++i) {
            if (subf[i].isDirectory()) {
                number += this.myGetDirectoryFileNumber(subf[i].toString());
                continue;
            }
            ++number;
        }
        return number;
    }

    public int getDomainCapacity(String domain) {
        if (!this.checkParameter(domain)) {
            return -1;
        }
        domain = domain.trim();
        String domainName = this.saeTempPath + this.fileSep + this.appName + this.fileSep + domain;
        return this.myGetDirectorySize(domainName);
    }

    public int getFilesNum(String domain, String path) {
        if (!this.checkParameter(domain, path)) {
            return -1;
        }
        domain = domain.trim();
        String domainName = this.saeTempPath + this.fileSep + this.appName + this.fileSep + domain + this.fileSep + path;
        return this.myGetDirectoryFileNumber(domainName);
    }

    public List<String> getList(String domain) {
        return this.getList(domain, "*", 10, 0);
    }

    private void myGetList(String directory, FileFilter wfl, int limit, int skip, boolean onlyFile, int levelLimit, int level, List<String> list, MyInt skippedNumber) {
        if (list.size() > limit) {
            return;
        }
        if (level >= levelLimit) {
            return;
        }
        boolean number = false;
        File f = new File(directory);
        if (!f.isDirectory()) {
            return;
        }
        File[] subf = f.listFiles(wfl);
        for (int i = 0; i < subf.length; ++i) {
            if (subf[i].isDirectory()) {
                if (!onlyFile) {
                    if (skip > 0 && skippedNumber.number < skip) {
                        ++skippedNumber.number;
                    } else {
                        list.add(subf[i].toString());
                        if (list.size() > limit) {
                            return;
                        }
                    }
                }
                this.myGetList(subf[i].toString(), wfl, limit, skip, onlyFile, levelLimit, level + 1, list, skippedNumber);
                continue;
            }
            if (skip > 0 && skippedNumber.number < skip) {
                ++skippedNumber.number;
                continue;
            }
            list.add(subf[i].toString());
            if (list.size() <= limit) continue;
            return;
        }
    }

    public List<String> getList(String domain, String prefix, int limit, int skip) {
        if (!this.checkParameter(domain)) {
            return new ArrayList<String>(0);
        }
        domain = domain.trim();
        String pathname = this.saeTempPath + this.fileSep + this.appName + this.fileSep + domain;
        StorageFileFilter wfl = new StorageFileFilter(prefix);
        ArrayList<String> list = new ArrayList<String>();
        MyInt myint = new MyInt();
        myint.number = 0;
        this.myGetList(pathname, wfl, limit, skip, true, 65536, 0, list, myint);
        return list;
    }

    public DataInfo getListByPath(String domain) {
        return this.getListByPath(domain, null, 100, 0, true);
    }

    public DataInfo getListByPath(String domain, String path, int limit, int skip, boolean folder) {
        if (!this.checkParameter(domain)) {
            return new DataInfo();
        }
        domain = domain.trim();
        String pathname = this.saeTempPath + this.fileSep + this.appName + this.fileSep + domain + this.fileSep + path + this.fileSep;
        int levelLimit = 65536;
        if (!folder) {
            levelLimit = 1;
        }
        StorageFileFilter wfl = new StorageFileFilter("*");
        ArrayList<String> list = new ArrayList<String>();
        MyInt myint = new MyInt();
        myint.number = 0;
        boolean onlyFile = !folder;
        this.myGetList(pathname, wfl, limit, skip, onlyFile, levelLimit, 0, list, myint);
        DataInfo result = new DataInfo();
        for (int i = 0; i < list.size(); ++i) {
            File file = new File(list.get(i));
            if (file.isDirectory()) {
                DirRowInfo dri = new DirRowInfo();
                dri.setName(file.getName());
                dri.setFullName(list.get(i));
                result.getDir().add(dri);
                continue;
            }
            FileRowInfo fri = new FileRowInfo();
            fri.setName(file.getName());
            fri.setFullName(list.get(i));
            fri.setLength((int)file.length());
            fri.setUploadTime((int)file.lastModified());
            result.getFile().add(fri);
        }
        result.setDirNum(result.getDir().size());
        result.setFileNum(result.getFile().size());
        return result;
    }

    public byte[] read(String domain, String fileName) {
        if (!this.checkParameter(domain, fileName)) {
            return new byte[0];
        }
        domain = domain.trim();
        String name = StorageUtil.formatFileName(fileName);
        String filename = this.saeTempPath + this.fileSep + this.appName + this.fileSep + domain + this.fileSep + name;
        File file = new File(filename);
        try {
            int offset;
            FileInputStream is = new FileInputStream(file);
            long length = file.length();
            byte[] bytes = new byte[(int)file.length()];
            int numRead = 0;
            for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
            if (offset < bytes.length) {
                throw new IOException("Could not completely read file " + file.getName());
            }
            ((InputStream)is).close();
            return bytes;
        }
        catch (FileNotFoundException e) {
            logger.error((Object)e.toString());
        }
        catch (IOException ioe) {
            logger.error((Object)ioe.toString());
        }
        return new byte[0];
    }

    public boolean setDomainAttr(String domain) {
        return this.setDomainAttr(domain, null);
    }

    public boolean setDomainAttr(String domain, DomainAttribute attr) {
        return this.checkParameter(domain);
    }

    public boolean setFileAttr(String domain, String fileName) {
        return this.setFileAttr(domain, fileName, null);
    }

    public boolean setFileAttr(String domain, String fileName, Map<String, String> map) {
        return this.checkParameter(domain);
    }

    public void upload(String domain, String srcFile, String destFile) {
        this.upload(domain, srcFile, destFile, null, false);
    }

    public boolean upload(String domain, String srcFile, String destFile, Map<String, String> map, boolean compress) {
        if (!this.checkParameter(domain, destFile)) {
            return false;
        }
        domain = domain.trim();
        destFile = this.saeTempPath + this.fileSep + this.appName + this.fileSep + domain + this.fileSep + StorageUtil.formatFileName(destFile);
        StorageUtil.uploadFile(srcFile, destFile, compress);
        return true;
    }

    public boolean write(String domain, String fileName, String content) {
        return this.write(domain, fileName, content, -1, null, false);
    }

    public boolean write(String domain, String fileName, byte[] content) {
        return this.write(domain, fileName, content, -1, null, false);
    }

    public boolean write(String domain, String fileName, String content, int size, Map<String, String> map, boolean compress) {
        return this.write(domain, fileName, content.getBytes(), -1, null, false);
    }

    public boolean write(String domain, String fileName, byte[] content, int size, Map<String, String> map, boolean compress) {
        if (!this.checkParameter(domain, fileName)) {
            return false;
        }
        System.out.println("domain:" + domain + " filename:" + fileName + "\n");
        fileName = StorageUtil.formatFileName(fileName);
        String writeFileName = this.saeTempPath + this.fileSep + this.appName + this.fileSep + domain + this.fileSep + fileName;
        String filePath = null;
        filePath = compress ? StorageUtil.writeFileWithCompress(writeFileName, content, size) : StorageUtil.writeFile(writeFileName, content, size);
        return true;
    }

    public String getUrl(String domain, String fileName) {
        return "http://" + this.appName + "-" + domain + ".stor.sinaapp.com/" + fileName;
    }

    private class MyInt {
        public int number;

        private MyInt() {
        }
    }

    private class StorageFileFilter
    implements FileFilter {
        private final String path;

        StorageFileFilter(String path) {
            this.path = path;
        }

        @Override
        public boolean accept(File pathname) {
            if ("*".equals(this.path)) {
                return true;
            }
            String name = pathname.getName();
            return name.indexOf(this.path) != -1;
        }
    }
}

