/*
 * Decompiled with CFR 0.152.
 */
package com.sina.sae.taskqueue;

import com.sina.sae.taskqueue.SaeTaskQueue;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;
import sun.misc.BASE64Encoder;

public class TaskQueueUtil {
    public static final String DATE_FORMAT = "yyyy-MM-dd kk:mm:ss";
    public static final String DEFAULT_URL_ENCODE = "UTF-8";
    public static final int MAX_DELAY = 60;
    private static Logger logger = Logger.getLogger((String)SaeTaskQueue.class.getName());

    private TaskQueueUtil() {
    }

    public static String getTimeStamp() {
        long time = System.currentTimeMillis();
        Date date = new Date(time);
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        return sdf.format(date);
    }

    public static String calcSignature(String content, String secretKey) {
        return TaskQueueUtil.calcSignature("HmacSHA256", content, secretKey);
    }

    public static String calcSignature(String cryptoType, String content, String secretKey) {
        try {
            Mac mac = Mac.getInstance(cryptoType);
            SecretKeySpec secret = new SecretKeySpec(secretKey.getBytes(), cryptoType);
            mac.init(secret);
            byte[] digest = mac.doFinal(content.getBytes());
            BASE64Encoder encode = new BASE64Encoder();
            return encode.encode(digest);
        }
        catch (Exception e) {
            logger.error((Object)"calc signautre failure.", (Throwable)e);
            return "";
        }
    }

    public static String encodeBase64(String encodeContent) {
        BASE64Encoder encode = new BASE64Encoder();
        return encode.encode(encodeContent.getBytes());
    }

    public static String encodeBase64(byte[] encodeContent) {
        BASE64Encoder encode = new BASE64Encoder();
        return encode.encode(encodeContent);
    }

    public static String jsonEncode(Map<String, Object> map) {
        JSONObject json = JSONObject.fromObject(map);
        return json.toString();
    }

    public static String jsonEncode(List<String> list) {
        JSONObject json = JSONObject.fromObject(list);
        return json.toString();
    }

    public static String jsonEncodeforMap(Map<String, String> map) {
        JSONObject json = JSONObject.fromObject(map);
        return json.toString();
    }

    public static String urlEncode(String url) {
        try {
            return URLEncoder.encode(url, DEFAULT_URL_ENCODE);
        }
        catch (Exception e) {
            logger.error((Object)"url encode failure!", (Throwable)e);
            return "";
        }
    }

    public static int fixMaxDelay(int delay) {
        if (delay > 60) {
            delay = 60;
        } else if (delay < 0) {
            delay = 0;
        }
        return delay;
    }

    public static String changeToJsonArray(String queueName, String url, Map<String, String> postData, byte[] postBinaryData, boolean prior, int delay, boolean useStrPost) {
        if (useStrPost) {
            return TaskQueueUtil.changeStringToJsonArray(queueName, url, postData, prior, delay);
        }
        return TaskQueueUtil.changeBinaryToJsonArray(queueName, url, postBinaryData, prior, delay);
    }

    public static String changeStringToJsonArray(String queueName, String url, Map<String, String> postData, boolean prior, int delay) {
        LinkedHashMap<String, Object> parms = new LinkedHashMap<String, Object>(2);
        LinkedHashMap<String, Object> queue = new LinkedHashMap<String, Object>(4);
        ArrayList<LinkedHashMap<String, Object>> listQueue = new ArrayList<LinkedHashMap<String, Object>>(1);
        parms.put("name", queueName);
        queue.put("url", url);
        if (null != postData) {
            Set<Map.Entry<String, String>> entry = postData.entrySet();
            Iterator<Map.Entry<String, String>> iter = entry.iterator();
            StringBuilder postStr = new StringBuilder();
            while (iter.hasNext()) {
                Map.Entry<String, String> entryValue = iter.next();
                String name = entryValue.getKey();
                String value = entryValue.getValue();
                postStr.append(name).append("=").append(value).append("&");
            }
            if (postStr.length() > 0) {
                postStr.deleteCharAt(postStr.length() - 1);
            }
            queue.put("postdata", TaskQueueUtil.encodeBase64(postStr.toString()));
        }
        if (prior) {
            queue.put("prior", Boolean.toString(prior));
        }
        if (delay != -1) {
            queue.put("delay", TaskQueueUtil.fixMaxDelay(delay));
        }
        listQueue.add(queue);
        parms.put("queue", listQueue);
        String format = TaskQueueUtil.jsonEncode(parms);
        format = format.replaceAll("/", "\\\\/");
        try {
            String encode = TaskQueueUtil.urlEncode(format);
            return "taskqueue=" + encode;
        }
        catch (Exception e) {
            logger.error((Object)"changeStringToJsonArray error!", (Throwable)e);
            return "";
        }
    }

    public static String changeBinaryToJsonArray(String queueName, String url, byte[] postData, boolean prior, int delay) {
        LinkedHashMap<String, Object> parms = new LinkedHashMap<String, Object>(2);
        LinkedHashMap<String, Object> queue = new LinkedHashMap<String, Object>(4);
        ArrayList<LinkedHashMap<String, Object>> listQueue = new ArrayList<LinkedHashMap<String, Object>>(1);
        parms.put("name", queueName);
        queue.put("url", url);
        if (null != postData) {
            queue.put("postdata", TaskQueueUtil.encodeBase64(postData));
        }
        if (prior) {
            queue.put("prior", Boolean.toString(prior));
        }
        if (delay != -1) {
            queue.put("delay", TaskQueueUtil.fixMaxDelay(delay));
        }
        listQueue.add(queue);
        parms.put("queue", listQueue);
        String format = TaskQueueUtil.jsonEncode(parms);
        format = format.replaceAll("/", "\\\\/");
        try {
            String encode = TaskQueueUtil.urlEncode(format);
            return "taskqueue=" + encode;
        }
        catch (Exception e) {
            logger.error((Object)"changeBinaryToJsonArray error!", (Throwable)e);
            return "";
        }
    }
}

