<?php
// +----------------------------------------------------------------------
// | ThinkPHP [ WE CAN DO IT JUST THINK ]
// +----------------------------------------------------------------------
// | Copyright (c) 2006-2016 http://thinkphp.cn All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 流年 <liu21st@gmail.com>
// +----------------------------------------------------------------------

// 应用公共文件
function MyDate($format='Y-m-d H:i:s', $timest=0)
{

    $addtime = 8 * 3600;
    if(empty($format))
    {
        $format = 'Y-m-d H:i:s';
    }
    return gmdate ($format, $timest+$addtime);
}

function FormatDate($timest)
{

    $addtime = 8 * 3600;

    $format = 'Y-m-d H:i:s';

    return gmdate ($format, $timest+$addtime);
}



/**
 *  utf-8中文截取，单字节截取模式
 *
 * @access    public
 * @param     string  $str  需要截取的字符串
 * @param     int  $slen  截取的长度
 * @param     int  $startdd  开始标记处
 * @return    string
 */
if ( ! function_exists('cn_substr_utf8'))
{
    function cn_substr_utf8($str, $length, $start=0)
    {
        if(strlen($str) < $start+1)
        {
            return '';
        }
        preg_match_all("/./su", $str, $ar);
        $str = '';
        $tstr = '';

        //为了兼容mysql4.1以下版本,与数据库varchar一致,这里使用按字节截取
        for($i=0; isset($ar[0][$i]); $i++)
        {
            if(strlen($tstr) < $start)
            {
                $tstr .= $ar[0][$i];
            }
            else
            {
                if(strlen($str) < $length + strlen($ar[0][$i]) )
                {
                    $str .= $ar[0][$i];
                }
                else
                {
                    break;
                }
            }
        }
        return $str;
    }
}

//通过文章id获取文章链接地址
function getArcUrl($aid)
{
    $row = db('mufeng_archives')->field('id,typeid')->where('id',$aid)->find();

    $row2 = db('mufeng_arctype')->field('id,typename,typedir')->where('id',$row["typeid"])->find();

    $catdomain = str_replace("{cmspath}","",$row2["typedir"]);

    return $catdomain.$aid.".html";
    //return "/".$row2["typedir"]."/".$aid.".html";

}

//获取子栏目列表，递归，后台栏目列表用
function getSonCatList($fuid)
{


    $arrs = Db::table('mufeng_arctype')
        ->field('cat.id as tid,cat.reid,cat.topid,cat.typename as tname,cat.channeltype,cat.sortrank,ch.id as chid,ch.typename as chname')
        ->alias('cat')
        ->join('mufeng_channeltype ch','cat.channeltype=ch.id','LEFT')
        ->where("reid = ".$fuid."")->order('cat.id', 'asc')->select();


    if(empty($arrs))
    {

        echo "";
    }
    else{

        foreach ($arrs as $k => $val)
        {


            echo "<li class='field_title soncat ' dataset_fu='".$fuid."' dataset_self='".$val["tid"]."'><span><i class='iconfont icon-menu' style='cursor:pointer' id='img1' onclick='showsontype(this,".$val["tid"].");'></i></span><span><input
                        type='text' name='sortrank1' value='".$val["sortrank"]."' class='layui-input'
                        style='text-align:center;padding-left:0;'></span><span>".$val["tid"]."</span><span class='catname'>".$val["tname"]."</span><span>".$val["chname"]."</span><span class='caozuo'><a href='/index.php/admin/lanmu/xiugai/tid/".$val["tid"]."' class='layui-btn layui-btn-normal layui-btn-small'><i class='layui-icon layui-icon-edit'></i>编辑</a> 
                        <a href='/index.php/admin/lanmu/yulan/tid/".$val["tid"]."' class='layui-btn layui-btn-small' target='_blank'><i class='layui-icon layui-icon-release'></i>预览</a>
                        <a href='/index.php/admin/lanmu/wdlist/tid/".$val["tid"]."' class='layui-btn layui-btn-small'><i class='layui-icon'>&#xe61d;</i>内容</a>
                        <a href='/index.php/admin/lanmu/xinzeng?reid=".$val["tid"]."' class='layui-btn layui-btn-small'><i class='layui-icon layui-icon-add-circle-fine'></i>增加子类</a>
                                                            <a href='/index.php/admin/lanmu/shanchu/tid/".$val["tid"]."' class='layui-btn layui-btn-small layui-btn-danger catalog_del'><i class='layui-icon layui-icon-delete'></i>删除</a>
                                                            </span></li>";
            getSonCatList($val["tid"]);


        }

    }

}


//获取子栏目列表，递归，生成静态文件时用
function getSonCatList2($fuid)
{

    $arrs = db('mufeng_arctype')->field('id,reid,topid,typename')->where("reid = ".$fuid."")->select();



    if(empty($arrs))
    {

        echo "";
    }
    else{

        foreach ($arrs as $k => $val)
        {

            echo "<option value=".$val['id']." class='soncat' dataset_fu='".$fuid."' dataset_self='".$val["id"]."'>".$val['typename']."</option>";
            getSonCatList2($val["id"]);


        }

    }

}


//获取子栏目id，递归，
function getSonCatList3($fuid)
{
 
    $soncats = "";
    $arrs = db('mufeng_arctype')->field('id,reid,topid,typename')->where("reid = ".$fuid."")->select();



    if(empty($arrs))
    {

        $soncats .= "";
    }
    else{

        foreach ($arrs as $k20 => $val20)
        {

            $soncats .= $val20['id'].",";
            getSonCatList3($val20["id"]);


        }

    }
    return $soncats;


}

//循环目录下的所有文件

function delDirAndFile($path, $delDir = false)
{
    if (is_array($path)) {
        foreach ($path as $subPath) {
            delDirAndFile($subPath, $delDir);
        }
    }
    if (is_dir($path)) {
        $handle = opendir($path);
        if ($handle) {
            while (false !== ($item = readdir($handle))) {
                if ($item != "." && $item != "..") {
                    is_dir("$path/$item") ? delDirAndFile("$path/$item", $delDir) : unlink("$path/$item");
                }
            }
            closedir($handle);
            if ($delDir) {
                return rmdir($path);
            }
        }
    } else {
        if (file_exists($path)) {
            return unlink($path);
        } else {
            return false;
        }
    }
}

/**
 *  utf-8中文截取，单字节截取模式
 *
 * @access    public
 * @param     string  $str  需要截取的字符串
 * @param     int  $slen  截取的长度
 * @param     int  $startdd  开始标记处
 * @return    string
 */
function cn_substr($str, $length, $start=0)
{
    if(strlen($str) < $start+1)
    {
        return '';
    }
    preg_match_all("/./su", $str, $ar);
    $str = '';
    $tstr = '';

    //为了兼容mysql4.1以下版本,与数据库varchar一致,这里使用按字节截取
    for($i=0; isset($ar[0][$i]); $i++)
    {
        if(strlen($tstr) < $start)
        {
            $tstr .= $ar[0][$i];
        }
        else
        {
            if(strlen($str) < $length + strlen($ar[0][$i]) )
            {
                $str .= $ar[0][$i];
            }
            else
            {
                break;
            }
        }
    }
    return $str;
}
