<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2020/1/11
 * Time: 16:20
 */

namespace app\common\taglib;
use think\template\TagLib;
class Mufeng extends TagLib{
    /**
     * 定义标签列表
     */
    protected $tags   =  [
        // 标签定义： attr 属性列表 close 是否闭合（0 或者1 默认1） alias 标签别名 level 嵌套层次
        'tfir'     => ['attr' => 'time','close' => 1], //闭合标签，默认为不闭合
        'tsec'      => ['attr' => 'name,type', 'close' => 1],
        'wdlist'      => ['attr' => 'type,curcatid,pagesize,flag,name,id,offset,length,key,mod', 'alias' => 'iterate', 'close' => 1],
        'fenye'      => ['attr' => '', 'close' => 0],
        'arclist'      => ['attr' => 'typeid,row,flag,name,id,offset,length,key,mod', 'alias' => 'iterate', 'close' => 1],
        'channel'      => ['attr' => 'reid,row,name,id,offset,length,key,mod', 'alias' => 'iterate', 'close' => 1],
        'global'      => ['attr' => 'name', 'close' => 0],
        'flink'      => ['attr' => 'row', 'close' => 0]

    ];


    public function tagTfir($tag,$content)
    {



        return '网站关键词：'.$tag['time'].$content;

    }

    /**
     * 这是一个非闭合标签的简单演示
     */
    public function tagTsec($tag, $content)
    {
        $type = empty($tag['type']) ? 0 : 1; // 这个type目的是为了区分类型，一般来源是数据库
        $name = $tag['name']; // name是必填项，这里不做判断了
        $parse = '<?php ';
        $parse .= '$test_arr=[[1,3,5,7,9],[2,4,6,8,10]];'; // 这里是模拟数据
        $parse .= '$__LIST__ = $test_arr[' . $type . '];';
        $parse .= ' ?>';
        $parse .= '{volist name="__LIST__" id="' . $name . '"}';
        $parse .= $content;
        $parse .= '{/volist}';
        return $parse;
    }

    public function tagWdlist($tag, $content)
    {



        $parseStr = '<?php ';

        $parseStr .= 'global $pagesize; ';
        $parseStr .= 'global $yema; ';
        $parseStr .= 'global $curtid; ';
        $parseStr .= ' $typeid = $curtid; ';

        $parseStr .= '$pagesize = '.$tag["pagesize"].';';


        $id     = $tag['id'];



        $empty  = isset($tag['empty']) ? $tag['empty'] : '';
        $key    = !empty($tag['key']) ? $tag['key'] : 'i';
        $mod    = isset($tag['mod']) ? $tag['mod'] : '2';
        $offset = !empty($tag['offset']) && is_numeric($tag['offset']) ? intval($tag['offset']) : 0;
        $length = !empty($tag['length']) && is_numeric($tag['length']) ? intval($tag['length']) : 'null';
        // 允许使用函数设定数据集 <volist name=":fun('arg')" id="vo">{$vo.name}</volist>



        $name = "$"."rearr";





        $parseStr .= 'if(is_array(' . $name . ') || ' . $name . ' instanceof \think\Collection || ' . $name . ' instanceof \think\Paginator): $' . $key . ' = 0;';

        // 设置了输出数组长度
        if (0 != $offset || 'null' != $length) {
            $parseStr .= '$__LIST__ = is_array(' . $name . ') ? array_slice(' . $name . ',' . $offset . ',' . $length . ', true) : ' . $name . '->slice(' . $offset . ',' . $length . ', true); ';
        } else {
            $parseStr .= ' $__LIST__ = ' . $name . ';';
        }

        $parseStr .= 'if( count($__LIST__)==0 ) : echo "' . $empty . '" ;';
        $parseStr .= 'else: ';
        $parseStr .= 'foreach($__LIST__ as $key=>$' . $id . '): ';
        $parseStr .= '$mod = ($' . $key . ' % ' . $mod . ' );';
        $parseStr .= '++$' . $key . ';?>';
        $parseStr .= $content;
        $parseStr .= '<?php endforeach; endif; else: echo "' . $empty . '" ;endif; ?>';

        if (!empty($parseStr)) {
            return $parseStr;
        }

        return;

    }

    public function tagFenye($tag)
    {

        $parse = '<?php ';
        $parse .= 'global $fenye; ';
        $parse .= 'echo $fenye;';
        $parse .= ' ?>';


        return $parse;
    }

    public function tagArclist($tag, $content)
    {

        $parseStr = '<?php ';
        $parseStr .= '$typeid = "'.$tag["typeid"].'";';
        $parseStr .= '$tiaoshu = '.$tag["row"].';';


        $name = "$"."arclists";
        $id     = $tag['id'];




        $empty  = isset($tag['empty']) ? $tag['empty'] : '';
        $key    = !empty($tag['key']) ? $tag['key'] : 'i';
        $mod    = isset($tag['mod']) ? $tag['mod'] : '2';
        $offset = !empty($tag['offset']) && is_numeric($tag['offset']) ? intval($tag['offset']) : 0;
        $length = !empty($tag['length']) && is_numeric($tag['length']) ? intval($tag['length']) : 'null';
        // 允许使用函数设定数据集 <volist name=":fun('arg')" id="vo">{$vo.name}</volist>

        $parseStr .= '$sql_cat = " (";';


        $parseStr .= '$stid = 0;';

        $parseStr .= '$soncatarr = explode(",",$typeid);';
        $parseStr .= ' foreach ($soncatarr as $k => $val)
                    {
                        if($k == 0)
                        {
                        $stid = $val;
                        }
                        $sql_cat .= " wd.typeid = $val OR ";
                    }

                    $pos1 = strrpos($sql_cat,"OR");
                    $sql_cat = substr($sql_cat,0,$pos1);

                    $sql_cat .= " ) ";';



        if(empty($tag['flag']))
        {
            $tag['flag'] = " ";
            $parseStr .= ' $arrcat = Db::table(\'mufeng_arctype\')->field(\'id,typename,channeltype\')->where("id = $stid")->find(); ';
            $parseStr .= ' $row = Db::table(\'mufeng_channeltype\')->field(\'id,nid,typename,maintable,addtable,fieldset\')->where("id = " . $arrcat[\'channeltype\'] . "")->find();
';
            $parseStr .= '$fubiao = $row["addtable"];';
            $parseStr .= '$arclists =  db("mufeng_archives")->alias(\'wd\')
		->join("$fubiao fb",\'wd.id=fb.aid\',\'LEFT\')->where("$sql_cat and wd.arcrank >= 0 ")->limit(0,$tiaoshu)->order("id", \'desc\')->select();';

        }
        else{
            $parseStr .= '$flag = "'.$tag["flag"].'";';
            $parseStr .= ' $arrcat = Db::table(\'mufeng_arctype\')->field(\'id,typename,channeltype\')->where("id = $stid")->find(); ';
            $parseStr .= ' $row = Db::table(\'mufeng_channeltype\')->field(\'id,nid,typename,maintable,addtable,fieldset\')->where("id = " . $arrcat[\'channeltype\'] . "")->find();
';

            $parseStr .= '$fubiao = $row["addtable"];';
            $parseStr .= '$arclists =  db("mufeng_archives")->alias(\'wd\')
		->join("$fubiao fb",\'wd.id=fb.aid\',\'LEFT\')->where("$sql_cat and wd.arcrank >= 0 and FIND_IN_SET(\'".$flag."\',flag) ")->limit(0,$tiaoshu)->select();';

        }


        $parseStr .= ' $arrArcs = [];
        foreach($arclists as $k => $val)
        {
            $arcurl = getArcUrl($val["id"]);
                            $arrT = ["arcurl"=>$arcurl];
                            $val = array_merge($val,$arrT);
                            $arrArcs[$k] = $val;
        }
        $arclists = $arrArcs;';


        $parseStr .= 'if(is_array(' . $name . ') || ' . $name . ' instanceof \think\Collection || ' . $name . ' instanceof \think\Paginator): $' . $key . ' = 0;';

        // 设置了输出数组长度
        if (0 != $offset || 'null' != $length) {
            $parseStr .= '$__LIST__ = is_array(' . $name . ') ? array_slice(' . $name . ',' . $offset . ',' . $length . ', true) : ' . $name . '->slice(' . $offset . ',' . $length . ', true); ';
        } else {
            $parseStr .= ' $__LIST__ = ' . $name . ';';
        }

        $parseStr .= 'if( count($__LIST__)==0 ) : echo "' . $empty . '" ;';
        $parseStr .= 'else: ';
        $parseStr .= 'foreach($__LIST__ as $key=>$' . $id . '): ';
        $parseStr .= '$mod = ($' . $key . ' % ' . $mod . ' );';
        $parseStr .= '++$' . $key . ';?>';
        $parseStr .= $content;
        $parseStr .= '<?php endforeach; endif; else: echo "' . $empty . '" ;endif; ?>';

        if (!empty($parseStr)) {
            return $parseStr;
        }

        return;

    }


    public function tagChannel($tag, $content)
    {

        $parseStr = '<?php ';
        $parseStr .= '$reid = '.$tag["reid"].';';
        $parseStr .= '$tiaoshu = '.$tag["row"].';';


        $name = "$"."arrch";
        $id     = $tag['id'];


        $empty  = isset($tag['empty']) ? $tag['empty'] : '';
        $key    = !empty($tag['key']) ? $tag['key'] : 'i';
        $mod    = isset($tag['mod']) ? $tag['mod'] : '2';
        $offset = !empty($tag['offset']) && is_numeric($tag['offset']) ? intval($tag['offset']) : 0;
        $length = !empty($tag['length']) && is_numeric($tag['length']) ? intval($tag['length']) : 'null';
        // 允许使用函数设定数据集 <volist name=":fun('arg')" id="vo">{$vo.name}</volist>



        $parseStr .= '$arrch =  db("mufeng_arctype")->where(" reid = $reid and ishidden = 0 ")->limit(0,$tiaoshu)->order(\'id\', \'asc\')->select();';

        $parseStr .= '$arrTypes = [];';
        $parseStr .= ' foreach ($arrch as $k => $val) {
                            
                            $typedir = str_replace("{cmspath}","",$val["typedir"]);
                            $arrT = ["typedir" => $typedir];
                            $val = array_merge($val, $arrT);
                            $arrTypes[$k] = $val;
                        }
                        ';
        $parseStr .= '$arrch = $arrTypes;';







        $parseStr .= 'if(is_array(' . $name . ') || ' . $name . ' instanceof \think\Collection || ' . $name . ' instanceof \think\Paginator): $' . $key . ' = 0;';

        // 设置了输出数组长度
        if (0 != $offset || 'null' != $length) {
            $parseStr .= '$__LIST__ = is_array(' . $name . ') ? array_slice(' . $name . ',' . $offset . ',' . $length . ', true) : ' . $name . '->slice(' . $offset . ',' . $length . ', true); ';
        } else {
            $parseStr .= ' $__LIST__ = ' . $name . ';';
        }

        $parseStr .= 'if( count($__LIST__)==0 ) : echo "' . $empty . '" ;';
        $parseStr .= 'else: ';
        $parseStr .= 'foreach($__LIST__ as $key=>$' . $id . '): ';
        $parseStr .= '$mod = ($' . $key . ' % ' . $mod . ' );';
        $parseStr .= '++$' . $key . ';?>';
        $parseStr .= $content;
        $parseStr .= '<?php endforeach; endif; else: echo "' . $empty . '" ;endif; ?>';

        if (!empty($parseStr)) {
            return $parseStr;
        }

        return;

    }

    public function tagGlobal($tag)
    {
        $parse = '<?php ';
        $parse .= '$name = "'.$tag["name"].'";';
        $parse .= '$row = Db::table(\'mufeng_sysconfig\')->field(\'aid,varname,value\')->where("varname = \'$name\'")->find(); ';

        $parse .= '$reval = $row["value"]; ';
        $parse .= 'echo $reval;';
        $parse .= ' ?>';


        return $parse;
    }

    public function tagFlink($tag)
    {
        $parse = '<?php ';
        $parse .= '$row = "'.$tag["row"].'";';
        $parse .= '$arrs = Db::table(\'mufeng_flink\')->field(\'id,url,webname\')->where("id > 0")->limit(0,$row)->select(); ';


        $parse .= 'foreach($arrs as $i => $val ){echo "<li><a href=".$val["url"].">".$val["webname"]."</a></li>";}';
        $parse .= ' ?>';


        return $parse;
    }

}