# NewStarBlog

NewStarBlog is an open source Java blog platform. NewStarBlog 是开源 Java 博客平台。

## Technologies 涉及技术

NewStarBlog covers Spring Framework 5, Spring Boot 2, Thymeleaf, Elasticsearch, Spring Data, and so on. The following is a list of technologies inlcuded in NewStarBlog:

* JDK 8
* Gradle 4.5.1
* Spring Boot 2.0.1
* Spring 5.0.5
* Thymeleaf 3.0.6.RELEASE
* Thymeleaf Layout Dialect 2.2.2
* MySQL Community Server 5.7.17
* MySQL Workbench 6.3.9
* Spring Data JPA 2.0.1
* Hibernate 5.2.10.Final
* MySQL Connector/J 6.0.5
* H2 Database 1.4.196
* Elasticsearch 5.5.0
* Spring Data Elasticsearch 3.0.6
* Tether 1.4.0 :<http://tether.io/>
* Bootstrap v4.0.0-alpha.6 : <https://v4-alpha.getbootstrap.com/>
* jQuery 3.1.1 : <http://jquery.com/download/>
* Font Awesome 4.7.0 :<http://fontawesome.io>
* NProgress 0.2.0 :<http://ricostacruz.com/nprogress/>
* Thinker-md :<http://git.oschina.net/benhail/thinker-md>
* jQuery Tags Input 1.3.6 : <http://xoxco.com/projects/code/tagsinput/>
* Bootstrap Chosen 1.0.3 :<https://github.com/haubek/bootstrap4c-chosen>
* toastr 2.1.1 :<http://www.toastrjs.com/> 
* Spring Security 5.0.4
* Thymeleaf Spring Security 3.0.9
* Apache Commons Lang 3.6
* Markdown parser for the JVM 0.16  
* MongoDB 3.4.6
* Spring Data Mongodb 2.0.0.M4
* Embedded MongoDB 2.0.0
* IK Analysis for Elasticsearch 5.5.0

## Features 特性

* Multi-user blog platform. (多用户博客平台)
* Markdown. (Markdown 编写)
* Emoji. (表情，头像)
* Aggregate classification/tag
* Big Data search.（大数据分析）
* Easy to use.（易于使用）
* RESTful API.
* Good look. (界面友好)
* Chinese characters friendly.（中文友好）
* ...

![](new-star-blog.png)

## How to 如何运行

It's so easy to start up NewStarBlog with 2 steps.

只需要两步。

### 1. Get source（获取源码）

```
$ git clone https://github.com/waylau/new-star-blog.git
```

### 2. Run（运行）

```
$ gradlew bootRun
```


then, you can visit the application at <http://localhost:8080>.

More details can be found on my [blog](https://waylau.com).

## Who use

If you have successfully deployed NewStarBlog online, just let me know. Here are the users:

* <http://www.lovebugs.cn>

## Related projects 相关的项目

* MongoDB File Server is a file server system based on MongoDB. 基于 MongoDB 的文件服务器。see <https://github.com/waylau/mongodb-file-server>

## Tutorial 手把手教你实现

* Vedio: [基于Spring Boot的博客系统实战](https://coding.imooc.com/class/125.html)
* Book: [《Spring Boot 企业级应用开发实战》](https://github.com/waylau/spring-boot-enterprise-application-development)

## Issue 意见、建议

如有勘误、意见或建议欢迎拍砖 <https://github.com/waylau/new-star-blog/issues>

## Host（托管）

* GitHub：https://github.com/waylau/new-star-blog
* 码云：https://gitee.com/waylau/new-star-blog

## Contact 联系作者:

* Blog: [waylau.com](https://waylau.com)
* Gmail: [waylau521(at)gmail.com](mailto:waylau521@gmail.com)
* Weibo: [waylau521](http://weibo.com/waylau521)
* Twitter: [waylau521](https://twitter.com/waylau521)
* Github : [waylau](https://github.com/waylau)

## Donate 捐赠

Support me!

感谢您对老卫开源工作的支持!

![开源捐赠](https://waylau.com/images/showmethemoney-sm.jpg)

捐赠所得所有款项将用于开源事业！